<div style="margin: 0 auto; width: 100%;">
	<?php
	if (isset($tpl['arr']))
	{
		$name_titles = __('personal_titles', true, false);
		$payment_methods = __('payment_methods', true, false);
		
		$option_arr = $tpl['option_arr'];
		
		$product_arr = array();
		foreach($tpl['order_product_arr'] as $k => $v)
		{
			if(!empty($v['price_name']))
			{
				$product_arr[] = $v['product_name'] . ' ('. $v['price_name'] . ' ' .pjUtil::formatCurrencySign($v['unit_price'], $option_arr['o_currency']).') x ' . $v['qty'] . ' = ' . pjUtil::formatCurrencySign($v['price'], $option_arr['o_currency']);
			}else{
				$product_arr[] = $v['product_name'] . ' ('.pjUtil::formatCurrencySign($v['unit_price'], $option_arr['o_currency']).') x ' . $v['qty'] . ' = ' . pjUtil::formatCurrencySign($v['price'], $option_arr['o_currency']);
			}
		}
		foreach($tpl['order_package_arr'] as $k => $v)
		{
			$product_arr[] = $v['package_name'] . ' ('.pjUtil::formatCurrencySign($v['unit_price'], $option_arr['o_currency']).') x ' . $v['qty'] . ' = ' . pjUtil::formatCurrencySign($v['price'], $option_arr['o_currency']);
		}
		?>
		<table class="table" cellspacing="2" cellpadding="5" style="width: 100%">
			<thead>
				<tr>
					<th colspan="2" style="text-transform: uppercase; text-align: left"><?php __('front_order_details'); ?></th>
				</tr>
			</thead>
			<tbody>	
				<tr>
					<td><?php __('front_cancel_booking_id'); ?></td>
					<td><?php echo $tpl['arr']['uuid']; ?></td>
				</tr>
				<tr>
					<td><?php __('front_products'); ?></td>
					<td><?php echo join("<br/>", $product_arr);?></td>
				</tr>
				<tr>
					<td><?php __('front_delivery_date'); ?></td>
					<td><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['delivery_dt'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['delivery_dt'])); ?></td>
				</tr>
				
				<tr>
					<td><?php __('front_payment_medthod');?></td>
					<td><?php echo !empty($tpl['arr']['payment_method']) ? $payment_methods[$tpl['arr']['payment_method']] : '&nbsp;'; ?></td>
				</tr>
				<tr style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
					<td><?php __('front_cc_type'); ?></td>
					<td><?php $cc_types = __('cc_types', true, false); echo $cc_types[$tpl['arr']['cc_type']]; ?></td>
				</tr>
				<tr style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
					<td><?php __('front_cc_num'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['cc_num']); ?></td>
				</tr>
				<tr style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : NULL; ?>">
					<td><?php __('front_cc_exp'); ?></td>
					<td><?php echo $tpl['arr']['cc_exp_month'] . '/' . $tpl['arr']['cc_exp_year']; ?></td>
				</tr>
				<tr>
					<td><?php __('front_subtotal'); ?></td>
					<td><?php echo pjUtil::formatCurrencySign(number_format(floatval($tpl['arr']['subtotal']), 2), $tpl['option_arr']['o_currency'], " "); ?></td>
				</tr>
				<tr>
					<td><?php __('front_tax'); ?></td>
					<td><?php echo pjUtil::formatCurrencySign(number_format(floatval($tpl['arr']['tax']), 2), $tpl['option_arr']['o_currency'], " "); ?></td>
				</tr>
				<tr>
					<td><?php __('front_total'); ?></td>
					<td><?php echo pjUtil::formatCurrencySign(number_format(floatval($tpl['arr']['total']), 2), $tpl['option_arr']['o_currency'], " "); ?></td>
				</tr>
				<tr>
					<td><?php __('front_deposit'); ?></td>
					<td><?php echo pjUtil::formatCurrencySign(number_format(floatval($tpl['arr']['deposit']), 2), $tpl['option_arr']['o_currency'], " "); ?></td>
				</tr>
				<?php
				if($tpl['arr']['payment_method'] == 'paypal')
				{ 
					?>
					<tr>
						<td><?php __('front_label_txn_id'); ?></td>
						<td><?php echo stripslashes($tpl['arr']['txn_id']); ?></td>
					</tr>
					<tr>
						<td><?php __('front_processed_on'); ?></td>
						<td><?php echo !empty($tpl['arr']['processed_on']) ? date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['processed_on'])) . ' ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['processed_on'])) : null; ?></td>
					</tr>
					<?php
				} 
				?>
				<tr>
					<th colspan="2" style="text-transform: uppercase; text-align: left"><?php __('front_your_details'); ?></td>
				</tr>
				<tr>
					<td><?php __('front_title'); ?></td>
					<td><?php echo !empty($tpl['arr']['c_title']) ? $name_titles[$tpl['arr']['c_title']] : null; ?></td>
				</tr>
				<tr>
					<td><?php __('front_name'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['c_name']); ?></td>
				</tr>
				<tr>
					<td><?php __('front_phone'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['c_phone']); ?></td>
				</tr>
				<tr>
					<td><?php __('front_email'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['c_email']); ?></td>
				</tr>
				<tr>
					<td><?php __('front_company'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['c_company']); ?></td>
				</tr>
				<tr>
					<td><?php __('front_notes'); ?></td>
					<td><?php echo isset($tpl['arr']['c_notes']) ? nl2br(pjSanitize::clean($tpl['arr']['c_notes'])) : null;?></td>
				</tr>
				<tr>
					<td><?php __('front_address'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['c_address']); ?></td>
				</tr>
				<tr>
					<td><?php __('front_city'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['c_city']); ?></td>
				</tr>
				<tr>
					<td><?php __('front_state'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['c_state']); ?></td>
				</tr>
				<tr>
					<td><?php __('front_zip'); ?></td>
					<td><?php echo stripslashes($tpl['arr']['c_zip']); ?></td>
				</tr>
				<tr>
					<td><?php __('front_country'); ?></td>
					<td><?php echo stripslashes($tpl['country']); ?></td>
				</tr>
			</tbody>
		</table>
		<?php
	}else{
		__('lblNoOrderWithSuchID');
	}
	?>
</div>
	