<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionUpdate" method="post" class="form pj-form" id="frmUpdateOrder">
		<input type="hidden" name="order_update" value="1"/>
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>"/>
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabOrderDetails');?></a></li>
				<li><a href="#tabs-2"><?php __('tabClientDetails');?></a></li>
			</ul>
			<div id="tabs-1" class="pj-loader-outer">
				<?php pjUtil::printNotice(__('infoOrderDetailsTitle', true, false), __('infoOrderDetailsDesc', true, false)); ?>
				<div class="pj-loader"></div>
				
				<fieldset class="fieldset white">
					<legend><?php __('legendOrderDetails'); ?></legend>
					<div class="w350 float_left">
						<p>
							<label class="title"><?php __('lblIpAddress'); ?></label>
							<span class="inline_block t5">
								<span id="textCapacity"><?php echo $tpl['arr']['ip'];?></span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblDeliveryDateTime'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-after">
								<input type="text" name="delivery_dt" class="pj-form-field pointer w140 required datetimepick" value="<?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['delivery_dt'])) . ' ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['delivery_dt']));?>" readonly="readonly" data-date="" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
								<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblStatus'); ?></label>
							<span class="inline_block">
								<select name="status" id="status" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
									<option value="">-- <?php __('lblChoose'); ?> --</option>
									<?php
									foreach (__('order_statuses', true) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblPaymentMethod');?></label>
							<span class="inline-block">
								<select name="payment_method" id="payment_method" class="pj-form-field w150 required" data-msg-required="<?php __('pj_field_required');?>">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach (__('payment_methods', true, false) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['payment_method'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p class="boxCC" style="display: none;">
							<label class="title"><?php __('lblCCType'); ?></label>
							<span class="inline-block">
								<select name="cc_type" class="pj-form-field w150" data-msg-required="<?php __('pj_field_required');?>">
									<option value="">---</option>
									<?php
									foreach (__('cc_types', true, false) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['cc_type'] == $k ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p class="boxCC" style="display: none;">
							<label class="title"><?php __('lblCCNum'); ?></label>
							<span class="inline-block">
								<input type="text" name="cc_num" id="cc_num" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['cc_num'])); ?>" class="pj-form-field w136" data-msg-required="<?php __('pj_field_required');?>"/>
							</span>
						</p>
						<p class="boxCC" style="display: none;">
							<label class="title"><?php __('lblCCExp'); ?></label>
							<span class="inline-block">
								<select name="cc_exp_month" class="pj-form-field" data-msg-required="<?php __('pj_field_required');?>">
									<?php
									$month_arr = __('months', true, false);
									ksort($month_arr);
									foreach ($month_arr as $key => $val)
									{
										?><option value="<?php echo $key;?>"<?php echo $tpl['arr']['cc_exp_month'] == $key ? ' selected="selected"' : NULL;?>><?php echo $val;?></option><?php
									}
									?>
								</select>
								<select name="cc_exp_year" class="pj-form-field" data-msg-required="<?php __('pj_field_required');?>">
									<?php
									$y = (int) date('Y');
									for ($i = $y; $i <= $y + 10; $i++)
									{
										?><option value="<?php echo $i; ?>" <?php echo $tpl['arr']['cc_exp_year'] == $i ? ' selected="selected"' : NULL;?>><?php echo $i; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p class="boxCC" style="display: none">
							<label class="title"><?php __('lblCCCode'); ?></label>
							<span class="inline-block">
								<input type="text" name="cc_code" id="cc_code" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['cc_code'])); ?>" class="pj-form-field w100" data-msg-required="<?php __('pj_field_required');?>"/>
							</span>
						</p>
						
						<p>
							<label class="title">&nbsp;</label>
							<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
							<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
						</p>
						
					</div>
					<div class="w300 float_right">
						<p>
							<span class="block float_left t5"><a href="#" class="pjMrbSendConfirm" data-id="<?php echo $tpl['arr']['id']?>"><?php __('lblSendEmailConfirmation'); ?></a></span>
							<span class="block float_right t5 r20"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOrders&amp;action=pjActionPrint&amp;id=<?php echo $tpl['arr']['id'];?>" target="_blank"><?php __('lblPrintOrder'); ?></a></span>
						</p>
						<p>
							<label class="title"><?php __('lblSubTotal'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" id="subtotal" name="subtotal" class="pj-form-field required w80" value="<?php echo $tpl['arr']['subtotal']; ?>" readonly="readonly"/>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblTax'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" id="tax" name="tax" class="pj-form-field w80" value="<?php echo $tpl['arr']['tax']; ?>" data-tax="<?php echo $tpl['option_arr']['o_tax_payment'];?>" readonly="readonly"/>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblTotal'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" id="total" name="total" class="pj-form-field w80" value="<?php echo $tpl['arr']['total']; ?>" readonly="readonly"/>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblDeposit'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" id="deposit" name="deposit" class="pj-form-field w80" value="<?php echo $tpl['arr']['deposit']; ?>" data-deposit="<?php echo $tpl['option_arr']['o_deposit_payment'];?>" readonly="readonly"/>
							</span>
						</p>
					</div>	
				</fieldset>
				<?php
				if(count($tpl['product_arr']) > 0)
				{
					?>
					<fieldset class="fieldset white">
						<legend><?php __('legendProducts'); ?></legend>
						<table class="pj-table" id="pjCsProductList">
							<thead>
								<tr>
									<th width="250"><?php __('lblProduct');?></th>
									<th width="180"><?php __('lblSizePrice');?></th>
									<th width="100"><?php __('lblQty');?></th>
									<th width="100"><?php __('lblTotal');?></th>
									<th width="50">&nbsp;</th>
								</tr>
							</thead>
							<tbody class="main-body">
								<?php
								foreach($tpl['order_product_arr'] as $k => $op)
								{
									$index = "new_" . mt_rand(0, 999999);
									$selected_product = null;
									?>
									<tr data-index="<?php echo $index ?>" data-type="product">
										<td>
											<select id="product_id_<?php echo $index ?>" name="product_id[<?php echo $index ?>]" class="pj-form-field w240 pjCsProductSelector" data-index="<?php echo $index ?>">
												<option value="">-- <?php __('lblSelectProduct');?> --</option>
												<?php
												foreach ($tpl['product_arr'] as $arr)
												{
													foreach($arr as $v )
													{
														$name_arr = array();
														if(!empty($v['parent_category']))
														{
															$name_arr[] = $v['parent_category'];
														}
														if(!empty($v['category']))
														{
															$name_arr[] = $v['category'];
														}
														$name_arr[] = $v['name'];
														if($op['product_id'] == $v['id'])
														{
															$selected_product = $v;
														}
														?><option value="<?php echo $v['id']; ?>"<?php echo $op['product_id'] == $v['id'] ? ' selected="selected"' : NULL;?> data-price="<?php echo $v['set_different_sizes'] == 'F' ? $v['price'] : NULL;?>" data-price_format="<?php echo $v['set_different_sizes'] == 'F' ? pjUtil::formatCurrencySign($v['price'], $tpl['option_arr']['o_currency']) : NULL;?>" data-size="<?php echo $v['set_different_sizes']?>"><?php echo join(", ", $name_arr); ?></option><?php
													}
												}
												?>
											</select>
										</td>
										<td id="pjCsSizePrice_<?php echo $index ?>">
											<?php
											if($selected_product['set_different_sizes'] == 'F')
											{
												echo pjUtil::formatCurrencySign($selected_product['price'], $tpl['option_arr']['o_currency']); 
											} else {
												if(!empty($op['size_id']))
												{
													if(isset($tpl['size_arr'][$op['product_id']]))
													{
														?>
														<select id="size_id_<?php echo $index?>" name="size_id[<?php echo $index;?>]" class="pj-form-field w150 pjCsSizeSelector" data-index="<?php echo $index;?>">
															<?php
															foreach($tpl['size_arr'][$op['product_id']] as $size)
															{
																?><option value="<?php echo $size['id']?>"<?php echo $size['id'] == $size_id ? ' selected="selected"' : null; ?> data-price="<?php echo $size['price'];?>"><?php echo $size['size'];?> - <?php echo pjUtil::formatCurrencySign($size['price'], $tpl['option_arr']['o_currency'])?></option><?php
															} 
															?>
														</select>
														<?php
													}
												}
											}
											?>
										</td>
										<td><input type="text" id="qty_<?php echo $index ?>" name="qty[<?php echo $index ?>]" value="<?php echo $op['qty'];?>" class="pj-form-field field-int w70"  readonly="readonly"/></td>
										<td><span id="pjCsProductPrice_<?php echo $index ?>"><?php echo pjUtil::formatCurrencySign($op['price'], $tpl['option_arr']['o_currency']);?></span><input type="hidden" id="product_unit_price_<?php echo $index ?>" name="product_unit_price[<?php echo $index ?>]" value="<?php echo $op['unit_price'];?>"/><input type="hidden" id="product_price_<?php echo $index ?>" name="product_price[<?php echo $index ?>]" value="<?php echo $op['price'];?>" class="pjCsHiddenPrice"/></td>
										<td><a href="#" class="pj-remove-product"></a></td>
									</tr>
									<?php
								} 
								?>
							</tbody>
						</table>
						<em class="pjCsProductError"><label class="pjCsError" style="display: inline;"><?php __('lblSelectProductHint');?></label></em>
						<div class="overflow t10">
							<input type="button" id="btnAddProduct" value="<?php __('btnAddProduct');?>" class="pj-button" />
							<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						</div>
					</fieldset>
					<?php
				} 
				?>
				
				<?php
				if(count($tpl['package_arr']) > 0)
				{
					?>
					<fieldset class="fieldset white">
						<legend><?php __('legendPackages'); ?></legend>
						<table class="pj-table" id="pjCsPackageList">
							<thead>
								<tr>
									<th width="250"><?php __('lblPackage');?></th>
									<th width="180"><?php __('lblPrice');?></th>
									<th width="100"><?php __('lblQty');?></th>
									<th width="100"><?php __('lblTotal');?></th>
									<th width="50">&nbsp;</th>
								</tr>
							</thead>
							<tbody class="main-body">
								<?php
								foreach($tpl['order_package_arr'] as $k => $op)
								{
									$index = "new_" . mt_rand(0, 999999);
									?>
									<tr data-index="<?php echo $index;?>" data-type="package">
										<td>
											<select id="package_id_<?php echo $index;?>" name="package_id[<?php echo $index;?>]" class="pj-form-field w240 pjCsPackageSelector" data-index="<?php echo $index;?>">
												<option value="">-- <?php __('lblSelectPackage');?> --</option>
												<?php
												foreach ($tpl['package_arr'] as $v)
												{
													?><option value="<?php echo $v['id']; ?>"<?php echo $op['package_id'] == $v['id'] ? ' selected="selected"' : NULL;?> data-price="<?php echo $v['price'];?>" data-price_format="<?php echo pjUtil::formatCurrencySign($v['price'], $tpl['option_arr']['o_currency']) ;?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
												}
												?>
											</select>
										</td>
										<td id="pjCsSizePrice_<?php echo $index;?>"><?php echo pjUtil::formatCurrencySign($op['unit_price'], $tpl['option_arr']['o_currency']);?></td>
										<td><input type="text" id="qty_<?php echo $index;?>" name="qty[<?php echo $index;?>]" value="<?php echo $op['qty'];?>" class="pj-form-field field-int w70" readonly="readonly"/></td>
										<td><span id="pjCsPackagePrice_<?php echo $index;?>"><?php echo pjUtil::formatCurrencySign($op['price'], $tpl['option_arr']['o_currency']);?></span><input type="hidden" id="package_unit_price_<?php echo $index;?>" name="package_unit_price[<?php echo $index;?>]" value="<?php echo $op['unit_price'];?>"/><input type="hidden" id="package_price_<?php echo $index;?>" name="package_price[<?php echo $index;?>]" value="<?php echo $op['price'];?>" class="pjCsHiddenPrice"/></td>
										<td><a href="#" class="pj-remove-product"></a></td>
									</tr>
									<?php
								} 
								?>
							</tbody>
						</table>
						<em class="pjCsPackageError"><label class="pjCsError" style="display: inline;"><?php __('lblSelectPackageHint');?></label></em>
						<div class="overflow t10">
							<input type="button" id="btnAddPackage" value="<?php __('btnAddPackage');?>" class="pj-button" />
							<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						</div>
					</fieldset>
					<?php
				} 
				?>
			</div><!-- #tabs-1 -->
			<div id="tabs-2">
				<?php pjUtil::printNotice(__('infoClientDetailsTitle', true, false), __('infoClientDetailsDesc', true, false)); ?>
				
				<?php
				if (in_array((int) $tpl['option_arr']['o_bf_include_title'], array(2,3)))
				{
					?>
					<p>
						<label class="title"><?php __('lblResvTitle'); ?></label>
						<span class="inline-block">
							<select name="c_title" id="c_title" class="pj-form-field w150<?php echo $tpl['option_arr']['o_bf_include_title'] == 3 ? ' required' : NULL; ?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ( __('personal_titles', true, false) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['c_title'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_name'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvName'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_name" id="c_name" value="<?php echo pjSanitize::html(stripslashes($tpl['arr']['c_name']), array('remove' => true)); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_name'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_email'], array(2,3)))
				{
					?>
					<p>
						<label class="title"><?php __('lblResvEmail'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_email" id="c_email" value="<?php echo pjSanitize::html(stripslashes($tpl['arr']['c_email']), array('remove' => true)); ?>" class="pj-form-field email w400<?php echo $tpl['option_arr']['o_bf_include_email'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>" data-msg-email="<?php __('pj_email_validation');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_phone'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvPhone'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_phone" id="c_phone" value="<?php echo pjSanitize::html(stripslashes($tpl['arr']['c_phone']), array('remove' => true)); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_phone'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_company'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvCompany'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_company" id="c_company" value="<?php echo pjSanitize::html(stripslashes($tpl['arr']['c_company']), array('remove' => true)); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_company'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_address'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvAddress'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_address" id="c_address" value="<?php echo pjSanitize::html(stripslashes($tpl['arr']['c_address']), array('remove' => true)); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_address'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_city'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvCity'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_city" id="c_city" value="<?php echo pjSanitize::html(stripslashes($tpl['arr']['c_city']), array('remove' => true)); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_city'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_state'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvState'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_state" id="c_state" value="<?php echo pjSanitize::html(stripslashes($tpl['arr']['c_state']), array('remove' => true)); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_state'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_zip'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvZip'); ?></label>
						<span class="inline-block">
							<input type="text" name="c_zip" id="c_zip" value="<?php echo pjSanitize::html(stripslashes($tpl['arr']['c_zip']), array('remove' => true)); ?>" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_zip'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_country'], array(2,3)))
				{ 
					?>
					<p>
						<label class="title"><?php __('lblResvCountry'); ?></label>
						<span class="inline-block">
							<select name="c_country" id="c_country" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_country'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['country_arr'] as $v)
								{
									?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] == $tpl['arr']['c_country'] ? ' selected="selected"' : NULL;?>><?php echo stripslashes($v['country_title']); ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<?php
				}
				if (in_array((int) $tpl['option_arr']['o_bf_include_notes'], array(2,3)))
				{
					?>
					<p>
						<label class="title"><?php __('lblResvNotes'); ?></label>
						<span class="inline-block">
							<textarea name="c_notes" id="c_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_bf_include_notes'] == 3 ? ' required' : NULL; ?>" data-msg-required="<?php __('pj_field_required');?>"><?php echo pjSanitize::html(stripslashes($tpl['arr']['c_notes']), array('remove' => true) ); ?></textarea>
						</span>
					</p>
					<?php
				}
				?>
				
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
				</p>
			</div><!-- #tabs-2 -->
		</div>
		
	</form>
	
	<table style="display: none" id="boxProductClone">
		<tbody>
		<?php
		include PJ_VIEWS_PATH . 'pjAdminOrders/elements/product_clone.php'; 
		?>
		</tbody>
	</table>
	<table style="display: none" id="boxPackageClone">
		<tbody>
		<?php
		include PJ_VIEWS_PATH . 'pjAdminOrders/elements/package_clone.php'; 
		?>
		</tbody>
	</table>
	
	<div id="dialogConfirmation" title="<?php __('booking_confirmation_title'); ?>" style="display: none"></div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.currency = "<?php echo $tpl['option_arr']['o_currency'];?>";
	myLabel.choose = "-- <?php echo __('lblChoose', true);?> --";
	</script>
	<?php
}
?>