<?php
$STORE = $_SESSION[$controller->defaultStore];
$product_in_cart = isset($STORE['products']) ? $STORE['products'] : array();
$package_in_cart = isset($STORE['packages']) ? $STORE['packages'] : array();
?>
<div class="pjCsCartContent">
	<div class="pjCartHeader">
		<div class="row">
			<div class="col-sm-4"><strong><?php __('front_product');?></strong></div>
			<div class="col-sm-3"><strong><?php __('front_size_price');?></strong></div>
			<div class="col-sm-2"><strong><?php __('front_quantity');?></strong></div>
			<div class="col-sm-2"><strong><?php __('front_total_price');?></strong></div>
			<div class="col-sm-1">&nbsp;</div>
		</div>
	</div>
	<div class="pjCartBody">
		<?php
		foreach($tpl['cart_arr']['product_arr'] as $k => $product)
		{
			if($product['set_different_sizes'] == 'T')
			{
				if(is_array($product['prices']))
				{
					foreach($product['prices'] as $price)
					{
						list($pid, $p, $p_name) = explode("~|~", $price);
						if(isset($product_in_cart[$product['id']][$pid]) && (int) $product_in_cart[$product['id']][$pid] > 0)
						{
							$total_price = $product_in_cart[$product['id']][$pid] * $p;
							?>
							<div class="pjCartRow">
								<div class="row">
									<div class="col-lg-4 col-md-4 col-sm-4"><?php echo pjSanitize::html($product['name']);?></div>
									<div class="col-lg-3 col-md-3 col-sm-3">
										<?php echo pjSanitize::html($p_name);?> <?php echo pjUtil::formatCurrencySign($p, $tpl['option_arr']['o_currency'])?>
									</div>
									<div class="col-lg-2 col-md-2 col-sm-2">
										<div class="pjCsSpinner">
											<input type="text" name="qty[<?php echo $product['id'];?>][<?php echo $pid;?>]" class="form-control pjCsCartQty" readonly="readonly" autocomplete="off" value="<?php echo isset($product_in_cart[$product['id']][$pid]) ? $product_in_cart[$product['id']][$pid] : NULL; ?>" data-type="products" data-id="<?php echo $product['id']?>" data-size_id="<?php echo $pid;?>" data-min="1" />
											
											<?php
											if(in_array($_GET['action'], array('pjActionCheckout', 'pjActionUpdateCart', 'pjActionRemoveCart')))
											{ 
												?>
												<a href="#" class="pjCsSpinnerBtn pjCsSpinnerBtnUp">
													<span class="caret"></span>
												</a>
						
												<a href="#" class="pjCsSpinnerBtn pjCsSpinnerBtnDown">
													<span class="caret"></span>
												</a>
												<?php
											} 
											?>
										</div><!-- /.pjCsSpinner -->
									</div>
									<div class="col-lg-2 col-md-2 col-sm-2"><?php echo pjUtil::formatCurrencySign(number_format($total_price, 2), $tpl['option_arr']['o_currency'])?></div>
									<?php
									if(in_array($_GET['action'], array('pjActionCheckout', 'pjActionUpdateCart', 'pjActionRemoveCart')))
									{ 
										?>
										<div class="col-lg-1 col-md-1 col-sm-1"><a href="#" class="pjCsCartRemove" data-type="products" data-id="<?php echo $product['id']?>" data-size_id="<?php echo $pid;?>" ><i class="fa fa-times"></i></a></div>
										<?php
									} 
									?>
								</div>
							</div><!-- /.pjCartRow -->
							<?php
						}
					}
				}
			}else{
				$total_price = $product_in_cart[$product['id']] * $product['price'];
				?>
				<div class="pjCartRow">
					<div class="row">
						<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4"><?php echo pjSanitize::html($product['name']);?></div>
						<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3">
							<?php echo pjUtil::formatCurrencySign($product['price'], $tpl['option_arr']['o_currency'])?>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-2 col-xs-2">
							<div class="pjCsSpinner">
								<input type="text" name="qty[<?php echo $product['id'];?>]" class="form-control pjCsCartQty" readonly="readonly"  autocomplete="off" value="<?php echo isset($product_in_cart[$product['id']]) ? $product_in_cart[$product['id']] : NULL; ?>" data-type="products" data-id="<?php echo $product['id']?>" data-min="1" />
								
								<?php
								if(in_array($_GET['action'], array('pjActionCheckout', 'pjActionUpdateCart', 'pjActionRemoveCart')))
								{ 
									?>
									<a href="#" class="pjCsSpinnerBtn pjCsSpinnerBtnUp">
										<span class="caret"></span>
									</a>
			
									<a href="#" class="pjCsSpinnerBtn pjCsSpinnerBtnDown">
										<span class="caret"></span>
									</a>
									<?php
								} 
								?>
							</div><!-- /.pjCsSpinner -->
						</div>
						<div class="col-lg-2 col-md-2 col-sm-2 col-xs-2"><?php echo pjUtil::formatCurrencySign(number_format($total_price, 2), $tpl['option_arr']['o_currency'])?></div>
						<?php
						if(in_array($_GET['action'], array('pjActionCheckout', 'pjActionUpdateCart', 'pjActionRemoveCart')))
						{ 
							?>
							<div class="col-lg-1 col-md-1 col-sm-1 col-xs-2"><a href="#" class="pjCsCartRemove" data-type="products" data-id="<?php echo $product['id']?>"><i class="fa fa-times"></i></a></div>
							<?php
						} 
						?>
					</div>
				</div><!-- /.pjCartRow -->
				<?php
			}
		}
		foreach($tpl['cart_arr']['package_arr'] as $k => $package)
		{
			$total_price = $package_in_cart[$package['id']] * $package['price'];
			?>
			<div class="pjCartRow">
				<div class="row">
					<div class="col-lg-4 col-md-4 col-sm-4 col-xs-4"><?php echo pjSanitize::html($package['name']);?></div>
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3">
						<?php echo pjUtil::formatCurrencySign($package['price'], $tpl['option_arr']['o_currency'])?>
					</div>
					<div class="col-lg-2 col-md-2 col-sm-2 col-xs-2">
						<div class="pjCsSpinner">
							<input type="text" name="qty[<?php echo $package['id'];?>]" class="form-control pjCsCartQty" readonly="readonly" autocomplete="off" value="<?php echo isset($package_in_cart[$package['id']]) ? $package_in_cart[$package['id']] : NULL; ?>" data-type="packages" data-id="<?php echo $package['id']?>" data-min="1" />
							
							<?php
							if(in_array($_GET['action'], array('pjActionCheckout', 'pjActionUpdateCart', 'pjActionRemoveCart')))
							{ 
								?>
								<a href="#" class="pjCsSpinnerBtn pjCsSpinnerBtnUp">
									<span class="caret"></span>
								</a>
			
								<a href="#" class="pjCsSpinnerBtn pjCsSpinnerBtnDown">
									<span class="caret"></span>
								</a>
								<?php
							} 
							?>
						</div><!-- /.pjCsSpinner -->
					</div>
					<div class="col-lg-2 col-md-2 col-sm-2 col-xs-2"><?php echo pjUtil::formatCurrencySign(number_format($total_price, 2), $tpl['option_arr']['o_currency'])?></div>
					<?php
					if(in_array($_GET['action'], array('pjActionCheckout', 'pjActionUpdateCart', 'pjActionRemoveCart')))
					{ 
						?>
						<div class="col-lg-1 col-md-1 col-sm-1 col-xs-2"><a href="#" class="pjCsCartRemove" data-type="packages" data-id="<?php echo $package['id']?>" ><i class="fa fa-times"></i></a></div>
						<?php
					} 
					?>
				</div>
			</div><!-- /.pjCartRow -->
			<?php
		}
		?>
		
		<div class="pjCartRow">
			<div class="row">
				<div class="col-lg-2 col-lg-offset-7 col-sm-3 col-sm-offset-6 col-xs-6"><div class="text-right"><strong><?php __('front_subtotal');?></strong></div></div>
				<div class="col-lg-2 col-md-2 col-sm-2 col-xs-6"><strong id="pjCsSubtotal"><?php echo pjUtil::formatCurrencySign(number_format($tpl['cart_arr']['subtotal'], 2), $tpl['option_arr']['o_currency'])?></strong></div>
			</div>
		</div><!-- /.pjCartRow -->

		<div class="pjCartRow">
			<div class="row">
				<div class="col-lg-2 col-lg-offset-7 col-sm-3 col-sm-offset-6 col-xs-6"><div class="text-right"><strong><?php __('front_tax');?> (<?php echo number_format($tpl['option_arr']['o_tax_payment'], 2) ?>%)</strong></div></div>
				<div class="col-lg-2 col-md-2 col-sm-2 col-xs-6"><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['cart_arr']['tax'], 2), $tpl['option_arr']['o_currency'])?></strong></div>
			</div>
		</div><!-- /.pjCartRow -->

		<div class="pjCartRow">
			<div class="row">
				<div class="col-lg-2 col-lg-offset-7 col-sm-3 col-sm-offset-6 col-xs-6"><div class="text-right"><strong><?php __('front_total');?></strong></div></div>
				<div class="col-lg-2 col-md-2 col-sm-2 col-xs-6"><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['cart_arr']['total'], 2), $tpl['option_arr']['o_currency'])?></strong></div>
			</div>
		</div><!-- /.pjCartRow -->

		<div class="pjCartRow">
			<div class="row">
				<div class="col-lg-2 col-lg-offset-7 col-sm-3 col-sm-offset-6 col-xs-6"><div class="text-right"><strong><?php __('front_deposit');?> (<?php echo number_format($tpl['option_arr']['o_deposit_payment'], 2) ?>%)</strong></div></div>
				<div class="col-lg-2 col-md-2 col-sm-2 col-xs-6"><strong><?php echo pjUtil::formatCurrencySign(number_format($tpl['cart_arr']['deposit'], 2), $tpl['option_arr']['o_currency'])?></strong></div>
			</div>
		</div><!-- /.pjCartRow -->
	</div>
</div>