DROP TABLE IF EXISTS `equipment_availability`;
CREATE TABLE IF NOT EXISTS `equipment_availability` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(10) unsigned DEFAULT NULL,
  `dt` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_id` (`item_id`,`dt`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_bookings`;
CREATE TABLE IF NOT EXISTS `equipment_bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `uuid` varchar(12) DEFAULT NULL,
  `dt_from` datetime DEFAULT NULL,
  `dt_to` datetime DEFAULT NULL,
  `forth` enum('pickup','delivery') DEFAULT NULL,
  `back` enum('return','collection') DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(9,2) unsigned DEFAULT NULL,
  `security` decimal(9,2) unsigned DEFAULT NULL,
  `deposit` decimal(9,2) unsigned DEFAULT NULL,
  `delivery` decimal(9,2) unsigned DEFAULT NULL,
  `collection` decimal(9,2) unsigned DEFAULT NULL,
  `total` decimal(9,2) unsigned DEFAULT NULL,
  `payment_method` enum('paypal','authorize','bank','creditcard','cod') DEFAULT NULL,
  `status` enum('confirmed','cancelled','pending') DEFAULT 'pending',
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `locale_id` int(10) unsigned DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `cc_type` varchar(255) DEFAULT NULL,
  `cc_num` varchar(255) DEFAULT NULL,
  `cc_code` varchar(255) DEFAULT NULL,
  `cc_exp_year` year(4) DEFAULT NULL,
  `cc_exp_month` varchar(2) DEFAULT NULL,
  `c_name` varchar(255) DEFAULT NULL,
  `c_email` varchar(255) DEFAULT NULL,
  `c_phone` varchar(255) DEFAULT NULL,
  `c_city` varchar(255) DEFAULT NULL,
  `c_state` varchar(255) DEFAULT NULL,
  `c_zip` varchar(255) DEFAULT NULL,
  `c_address_1` varchar(255) DEFAULT NULL,
  `c_address_2` varchar(255) DEFAULT NULL,
  `c_country_id` int(10) unsigned DEFAULT NULL,
  `c_notes` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_bookings_items`;
CREATE TABLE IF NOT EXISTS `equipment_bookings_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `type` enum('item','package') DEFAULT NULL,
  `qty` smallint(5) unsigned DEFAULT NULL,
  `unit_price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `booking_id` (`booking_id`,`foreign_id`,`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_calendars`;
CREATE TABLE IF NOT EXISTS `equipment_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `monday_from` time DEFAULT NULL,
  `monday_to` time DEFAULT NULL,
  `monday_dayoff` enum('T','F') DEFAULT 'F',
  `tuesday_from` time DEFAULT NULL,
  `tuesday_to` time DEFAULT NULL,
  `tuesday_dayoff` enum('T','F') DEFAULT 'F',
  `wednesday_from` time DEFAULT NULL,
  `wednesday_to` time DEFAULT NULL,
  `wednesday_dayoff` enum('T','F') DEFAULT 'F',
  `thursday_from` time DEFAULT NULL,
  `thursday_to` time DEFAULT NULL,
  `thursday_dayoff` enum('T','F') DEFAULT 'F',
  `friday_from` time DEFAULT NULL,
  `friday_to` time DEFAULT NULL,
  `friday_dayoff` enum('T','F') DEFAULT 'F',
  `saturday_from` time DEFAULT NULL,
  `saturday_to` time DEFAULT NULL,
  `saturday_dayoff` enum('T','F') DEFAULT 'F',
  `sunday_from` time DEFAULT NULL,
  `sunday_to` time DEFAULT NULL,
  `sunday_dayoff` enum('T','F') DEFAULT 'F',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_categories`;
CREATE TABLE IF NOT EXISTS `equipment_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `is_active` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_dates`;
CREATE TABLE IF NOT EXISTS `equipment_dates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `is_dayoff` enum('T','F') DEFAULT 'F',
  PRIMARY KEY (`id`),
  UNIQUE KEY `calendar_id` (`calendar_id`,`date`),
  KEY `is_dayoff` (`is_dayoff`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_fields`;
CREATE TABLE IF NOT EXISTS `equipment_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_items`;
CREATE TABLE IF NOT EXISTS `equipment_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `rent_by_hour` tinyint(1) unsigned DEFAULT '0',
  `rent_by_day` tinyint(1) unsigned DEFAULT '0',
  `price_per_hour` decimal(9,2) unsigned DEFAULT NULL,
  `price_per_day` decimal(9,2) unsigned DEFAULT NULL,
  `cnt` smallint(5) unsigned DEFAULT NULL,
  `is_active` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `calendar_id` (`calendar_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_multi_lang`;
CREATE TABLE IF NOT EXISTS `equipment_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(100) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_options`;
CREATE TABLE IF NOT EXISTS `equipment_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_packages`;
CREATE TABLE IF NOT EXISTS `equipment_packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `rent_by_hour` tinyint(1) unsigned DEFAULT '0',
  `rent_by_day` tinyint(1) unsigned DEFAULT '0',
  `price_per_hour` decimal(9,2) unsigned DEFAULT NULL,
  `price_per_day` decimal(9,2) unsigned DEFAULT NULL,
  `is_active` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_packages_items`;
CREATE TABLE IF NOT EXISTS `equipment_packages_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `package_id` int(10) unsigned NOT NULL DEFAULT '0',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `package_id` (`package_id`,`item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_prices`;
CREATE TABLE IF NOT EXISTS `equipment_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `type` enum('item','package') DEFAULT NULL,
  `period` enum('hour','day') DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `length_from` smallint(5) unsigned DEFAULT NULL,
  `length_to` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `foreign_id` (`foreign_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_roles`;
CREATE TABLE IF NOT EXISTS `equipment_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `equipment_users`;
CREATE TABLE IF NOT EXISTS `equipment_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `equipment_packages_availability`;

INSERT INTO `equipment_calendars` (`id`, `monday_from`, `monday_to`, `monday_dayoff`, `tuesday_from`, `tuesday_to`, `tuesday_dayoff`, `wednesday_from`, `wednesday_to`, `wednesday_dayoff`, `thursday_from`, `thursday_to`, `thursday_dayoff`, `friday_from`, `friday_to`, `friday_dayoff`, `saturday_from`, `saturday_to`, `saturday_dayoff`, `sunday_from`, `sunday_to`, `sunday_dayoff`) VALUES
(1, '04:10:00', '03:30:00', 'F', '00:00:00', '00:00:00', 'F', '03:35:00', '17:25:00', 'F', '00:00:00', '00:00:00', 'F', NULL, NULL, 'T', NULL, NULL, 'T', '00:00:00', '00:00:00', 'T');

INSERT INTO `equipment_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_accept_bookings', 3, '1|0::1', NULL, 'bool', 1, 1, NULL),
(1, 'o_allow_authorize', 7, '1|0::1', NULL, 'bool', 18, 1, NULL),
(1, 'o_allow_bank', 7, '1|0::1', NULL, 'bool', 24, 1, NULL),
(1, 'o_allow_cod', 7, '1|0::1', NULL, 'bool', 26, 1, NULL),
(1, 'o_allow_creditcard', 7, '1|0::1', NULL, 'bool', 23, 1, NULL),
(1, 'o_allow_paypal', 7, '1|0::1', NULL, 'bool', 16, 1, NULL),
(1, 'o_authorize_hash', 7, 'abcd', NULL, 'string', 21, 1, NULL),
(1, 'o_authorize_key', 7, '9x6kQ948YUss263y', NULL, 'string', 20, 1, NULL),
(1, 'o_authorize_mid', 7, '3D66fj6UN', NULL, 'string', 19, 1, NULL),
(1, 'o_authorize_tz', 7, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 22, 1, NULL),
(1, 'o_bank_account', 7, 'Bank of America', NULL, 'text', 25, 1, NULL),
(1, 'o_bf_address_1', 4, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 6, 1, NULL),
(1, 'o_bf_address_2', 4, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 7, 1, NULL),
(1, 'o_bf_captcha', 4, '1|3::3', 'No|Yes (Required)', 'enum', 16, 1, NULL),
(1, 'o_bf_city', 4, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 12, 1, NULL),
(1, 'o_bf_country', 4, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 15, 1, NULL),
(1, 'o_bf_email', 4, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 4, 1, NULL),
(1, 'o_bf_name', 4, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 3, 1, NULL),
(1, 'o_bf_notes', 4, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 8, 1, NULL),
(1, 'o_bf_phone', 4, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 5, 1, NULL),
(1, 'o_bf_state', 4, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 13, 1, NULL),
(1, 'o_bf_terms', 4, '1|3::3', 'No|Yes (Required)', 'enum', 17, 1, NULL),
(1, 'o_bf_zip', 4, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 14, 1, NULL),
(1, 'o_currency', 7, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 6, 1, NULL),
(1, 'o_datetime_format', 1, 'd.m.Y, H:i|d.m.Y, H:i:s|m.d.Y, H:i|m.d.Y, H:i:s|Y.m.d, H:i|Y.m.d, H:i:s|j.n.Y, H:i|j.n.Y, H:i:s|n.j.Y, H:i|n.j.Y, H:i:s|Y.n.j, H:i|Y.n.j, H:i:s|d/m/Y, H:i|d/m/Y, H:i:s|m/d/Y, H:i|m/d/Y, H:i:s|Y/m/d, H:i|Y/m/d, H:i:s|j/n/Y, H:i|j/n/Y, H:i:s|n/j/Y, H:i|n/j/Y, H:i:s|Y/n/j, H:i|Y/n/j, H:i:s|d-m-Y, H:i|d-m-Y, H:i:s|m-d-Y, H:i|m-d-Y, H:i:s|Y-m-d, H:i|Y-m-d, H:i:s|j-n-Y, H:i|j-n-Y, H:i:s|n-j-Y, H:i|n-j-Y, H:i:s|Y-n-j, H:i|Y-n-j, H:i:s::j/n/Y, H:i', 'd.m.Y, H:i (25.09.2010, 09:51)|d.m.Y, H:i:s (25.09.2010, 09:51:47)|m.d.Y, H:i (09.25.2010, 09:51)|m.d.Y, H:i:s (09.25.2010, 09:51:47)|Y.m.d, H:i (2010.09.25, 09:51)|Y.m.d, H:i:s (2010.09.25, 09:51:47)|j.n.Y, H:i (25.9.2010, 09:51)|j.n.Y, H:i:s (25.9.2010, 09:51:47)|n.j.Y, H:i (9.25.2010, 09:51)|n.j.Y, H:i:s (9.25.2010, 09:51:47)|Y.n.j, H:i (2010.9.25, 09:51)|Y.n.j, H:i:s (2010.9.25, 09:51:47)|d/m/Y, H:i (25/09/2010, 09:51)|d/m/Y, H:i:s (25/09/2010, 09:51:47)|m/d/Y, H:i (09/25/2010, 09:51)|m/d/Y, H:i:s (09/25/2010, 09:51:47)|Y/m/d, H:i (2010/09/25, 09:51)|Y/m/d, H:i:s (2010/09/25, 09:51:47)|j/n/Y, H:i (25/9/2010, 09:51)|j/n/Y, H:i:s (25/9/2010, 09:51:47)|n/j/Y, H:i (9/25/2010, 09:51)|n/j/Y, H:i:s (9/25/2010, 09:51:47)|Y/n/j, H:i (2010/9/25, 09:51)|Y/n/j, H:i:s (2010/9/25, 09:51:47)|d-m-Y, H:i (25-09-2010, 09:51)|d-m-Y, H:i:s (25-09-2010, 09:51:47)|m-d-Y, H:i (09-25-2010, 09:51)|m-d-Y, H:i:s (09-25-2010, 09:51:47)|Y-m-d, H:i (2010-09-25, 09:51)|Y-m-d, H:i:s (2010-09-25, 09:51:47)|j-n-Y, H:i (25-9-2010, 09:51)|j-n-Y, H:i:s (25-9-2010, 09:51:47)|n-j-Y, H:i (9-25-2010, 09:51)|n-j-Y, H:i:s (9-25-2010, 09:51:47)|Y-n-j, H:i (2010-9-25, 09:51)|Y-n-j, H:i:s (2010-9-25, 09:51:47)', 'enum', 8, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::j/n/Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 8, 1, NULL),
(1, 'o_delivery', 7, '50', NULL, 'float', 8, 1, NULL),
(1, 'o_collection', 7, '40', NULL, 'float', 8, 1, NULL),
(1, 'o_deposit', 7, '20', NULL, 'float', 12, 1, NULL),
(1, 'o_deposit_type', 7, 'amount|percent::percent', 'Amount|Percent', 'enum', NULL, 0, NULL),
(1, 'o_disable_payments', 7, '1|0::0', NULL, 'bool', 4, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_paypal_address', 7, 'paypal_seller@example.com', NULL, 'string', 17, 1, NULL),
(1, 'o_require_all_within', 7, '0', NULL, 'int', 15, 1, NULL),
(1, 'o_security', 7, '40', NULL, 'float', 13, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 11, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 15, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 13, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 14, 1, NULL),
(1, 'o_status_if_not_paid', 3, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 10, 1, NULL),
(1, 'o_status_if_paid', 3, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 9, 1, NULL),
(1, 'o_tax', 7, '10', NULL, 'float', 14, 1, NULL),
(1, 'o_thankyou_page', 7, 'https://www.phpjabbers.com/', NULL, 'string', 27, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 10, 1, NULL),
(1, 'o_use_category', 1, '1|0::1', 'Yes|No', 'enum', 16, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 9, 1, NULL);

INSERT INTO `equipment_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T');









INSERT INTO `equipment_fields` VALUES
('5', 'user', 'backend', 'Username', 'script', NULL),
('6', 'pass', 'backend', 'Password', 'script', NULL),
('7', 'email', 'backend', 'E-Mail', 'script', NULL),
('8', 'url', 'backend', 'URL', 'script', NULL),
('13', 'created', 'backend', 'Created', 'script', NULL),
('16', 'btnSave', 'backend', 'Save', 'script', NULL),
('17', 'btnReset', 'backend', 'Reset', 'script', NULL),
('18', 'addLocale', 'backend', 'Add language', 'script', NULL),
('22', 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
('23', 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
('24', 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
('25', 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
('26', 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
('31', 'btnUpdate', 'backend', 'Update', 'script', NULL),
('36', 'lblChoose', 'backend', 'Choose', 'script', NULL),
('37', 'btnSearch', 'backend', 'Search', 'script', NULL),
('40', 'backend', 'backend', 'Backend titles', 'script', NULL),
('41', 'frontend', 'backend', 'Front-end titles', 'script', NULL),
('42', 'locales', 'backend', 'Languages', 'script', NULL),
('44', 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
('45', 'btnLogin', 'backend', 'Login', 'script', NULL),
('47', 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
('57', 'lblOptionList', 'backend', 'Option list', 'script', NULL),
('58', 'btnAdd', 'backend', 'Button Add', 'script', NULL),
('62', 'lblDelete', 'backend', 'Delete', 'script', NULL),
('65', 'lblType', 'backend', 'Type', 'script', NULL),
('66', 'lblName', 'backend', 'Name', 'script', NULL),
('67', 'lblRole', 'backend', 'Role', 'script', NULL),
('68', 'lblStatus', 'backend', 'Status', 'script', NULL),
('69', 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
('70', 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
('71', 'lblAddUser', 'backend', 'Add user', 'script', NULL),
('72', 'lblValue', 'backend', 'Value', 'script', NULL),
('73', 'lblOption', 'backend', 'Option', 'script', NULL),
('74', 'lblDays', 'backend', 'Days', 'script', NULL),
('115', 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
('116', 'lblYes', 'backend', 'Yes', 'script', NULL),
('117', 'lblNo', 'backend', 'No', 'script', NULL),
('338', 'lblError', 'backend', 'Error', 'script', NULL),
('347', 'btnBack', 'backend', 'Button Back', 'script', NULL),
('355', 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
('356', 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
('357', 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
('358', 'btnSend', 'backend', 'Button Send', 'script', NULL),
('359', 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
('360', 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
('365', 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
('380', 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
('381', 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
('382', 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
('383', 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
('384', 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
('385', 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
('386', 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
('387', 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
('388', 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
('389', 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
('390', 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
('391', 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
('392', 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
('393', 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
('395', 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
('396', 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
('408', 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
('409', 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
('410', 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
('411', 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
('412', 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
('413', 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
('414', 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
('415', 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
('416', 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
('417', 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
('418', 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
('419', 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
('420', 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
('421', 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
('422', 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
('423', 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
('424', 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
('425', 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
('426', 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
('433', 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
('434', 'lblIp', 'backend', 'IP address', 'script', NULL),
('435', 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
('441', 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
('442', 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
('451', 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
('452', 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
('455', 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
('456', 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
('457', 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
('458', 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
('471', '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
('472', '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
('476', 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
('477', 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
('478', 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
('479', 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
('480', 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
('481', 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
('482', 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
('483', 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
('496', 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
('497', 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
('498', 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
('499', 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
('500', 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
('501', 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
('502', 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
('503', 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
('504', 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
('505', 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
('506', 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
('507', 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
('508', 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
('509', 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
('510', 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
('511', 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
('512', 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
('513', 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
('514', 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
('515', 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
('516', 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
('517', 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
('518', 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
('519', 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
('520', 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
('521', 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
('540', 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
('541', 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
('542', 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
('543', 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
('544', 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
('552', 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
('553', 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
('554', 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
('555', 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
('556', 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
('557', 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
('558', 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
('559', 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
('578', 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
('579', 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
('580', 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
('581', 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
('582', 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
('589', 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
('590', 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
('591', 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
('592', 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
('593', 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
('594', 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
('595', 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
('596', 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
('597', 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
('627', 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
('628', 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
('629', 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
('630', 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
('631', 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
('632', 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
('633', 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
('634', 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
('635', 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
('636', 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
('637', 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
('638', 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
('639', 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
('640', 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
('641', 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
('642', 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
('643', 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
('644', 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
('645', 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
('646', 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
('647', 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
('648', 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
('649', 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
('650', 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
('651', 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
('652', 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
('653', 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
('654', 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
('655', 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
('656', 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
('657', 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
('658', 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
('659', 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
('660', 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
('661', 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
('662', 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
('663', 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
('664', 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
('665', 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
('666', 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
('667', 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
('668', 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
('669', 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
('670', 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
('671', 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
('672', 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
('673', 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
('674', 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
('675', 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
('676', 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
('677', 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
('678', 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
('679', 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
('907', 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
('908', 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
('909', 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
('910', 'lnkBack', 'backend', 'Link Back', 'script', NULL),
('982', 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
('983', 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
('984', 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
('985', 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
('986', 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
('990', 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
('992', 'vr_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
('993', 'revert_status', 'backend', 'Revert status', 'script', NULL),
('994', 'lblExport', 'backend', 'Export', 'script', NULL),
('995', 'opt_o_send_email', 'backend', 'Options / Email transport', 'script', '2013-08-22 11:13:13'),
('996', 'opt_o_smtp_host', 'backend', 'Options / SMTP Hostname', 'script', '2013-08-22 11:12:18'),
('997', 'opt_o_smtp_port', 'backend', 'Options / SMTP Port', 'script', '2013-08-22 11:12:29'),
('998', 'opt_o_smtp_user', 'backend', 'Options / SMTP Username', 'script', '2013-08-22 11:12:35'),
('999', 'opt_o_smtp_pass', 'backend', 'Options / SMTP Password', 'script', '2013-08-22 11:12:40'),
('1069', 'menuItems', 'backend', 'Menu Items', 'script', '2014-02-03 06:57:54'),
('1070', 'items_cnt', 'backend', 'Items / Count', 'script', '2013-07-26 06:10:39'),
('1071', 'items_rent_by', 'backend', 'Items / Rent by', 'script', '2013-07-26 06:10:55'),
('1072', 'items_title', 'backend', 'Items / Name', 'script', '2013-07-26 06:11:20'),
('1073', 'items_desc', 'backend', 'Items / Description', 'script', '2013-07-26 06:11:31'),
('1074', 'items_rent_by_opts_ARRAY_hour', 'arrays', 'Items / Rent by hour', 'script', '2013-07-29 13:35:05'),
('1075', 'items_rent_by_opts_ARRAY_day', 'arrays', 'Items / Rent by day', 'script', '2013-07-29 13:34:44'),
('1077', 'items_category', 'backend', 'Items / Category', 'script', '2013-07-26 06:45:46'),
('1078', 'menuCategories', 'backend', 'Menu Categories', 'script', '2013-07-26 07:06:09'),
('1079', 'category_title', 'backend', 'Categories / Title', 'script', '2013-07-26 07:20:43'),
('1080', 'category_add', 'backend', 'Categories / Add category', 'script', '2013-07-26 07:28:01'),
('1081', 'category_update', 'backend', 'Categories / Update category', 'script', '2013-07-26 07:33:14'),
('1082', 'delete_selected', 'backend', 'Delete selected', 'script', '2013-07-26 07:38:53'),
('1083', 'delete_confirmation', 'backend', 'Delete confirmation', 'script', '2013-07-26 07:39:28'),
('1084', 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', '2013-07-26 07:40:51'),
('1085', 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', '2013-07-26 07:41:01'),
('1086', 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', '2013-07-26 07:41:13'),
('1087', 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', '2013-07-26 07:41:24'),
('1088', 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', '2013-07-26 07:42:12'),
('1089', 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', '2013-07-26 07:42:22'),
('1090', 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', '2013-07-26 07:42:33'),
('1091', 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', '2013-07-26 07:42:48'),
('1092', 'items_add', 'backend', 'Items / Add item', 'script', '2013-07-26 08:00:52'),
('1093', 'items_update', 'backend', 'Items / Update item', 'script', '2013-07-26 08:00:57'),
('1094', 'error_bodies_ARRAY_AI08', 'arrays', 'error_bodies_ARRAY_AI08', 'script', '2013-07-26 07:47:56'),
('1095', 'error_bodies_ARRAY_AI04', 'arrays', 'error_bodies_ARRAY_AI04', 'script', '2013-07-26 07:48:14'),
('1096', 'error_bodies_ARRAY_AI03', 'arrays', 'error_bodies_ARRAY_AI03', 'script', '2013-07-26 07:48:27'),
('1097', 'error_bodies_ARRAY_AI01', 'arrays', 'error_bodies_ARRAY_AI01', 'script', '2013-07-26 07:48:39'),
('1098', 'error_titles_ARRAY_AI08', 'arrays', 'error_titles_ARRAY_AI08', 'script', '2013-07-26 07:48:49'),
('1099', 'error_titles_ARRAY_AI04', 'arrays', 'error_titles_ARRAY_AI04', 'script', '2013-07-26 07:48:57'),
('1100', 'error_titles_ARRAY_AI03', 'arrays', 'error_titles_ARRAY_AI03', 'script', '2013-07-26 07:49:04'),
('1101', 'error_titles_ARRAY_AI01', 'arrays', 'error_titles_ARRAY_AI01', 'script', '2013-07-26 07:49:12'),
('1102', 'error_titles_ARRAY_AI06', 'arrays', 'error_titles_ARRAY_AI06', 'script', '2014-02-03 06:59:39'),
('1103', 'error_bodies_ARRAY_AI06', 'arrays', 'error_bodies_ARRAY_AI06', 'script', '2014-02-03 07:00:30'),
('1104', 'error_titles_ARRAY_AI07', 'arrays', 'error_titles_ARRAY_AI07', 'script', '2014-02-03 06:59:54'),
('1105', 'error_bodies_ARRAY_AI07', 'arrays', 'error_bodies_ARRAY_AI07', 'script', '2013-07-26 08:49:26'),
('1106', 'menuWorkingTime', 'backend', 'Menu Working time', 'script', '2013-07-26 08:52:27'),
('1107', 'menuInstall', 'backend', 'Menu Install', 'script', '2013-07-26 08:55:45'),
('1108', 'menuPreview', 'backend', 'Menu Preview', 'script', '2013-07-26 08:55:57'),
('1109', 'menuGeneral', 'backend', 'Menu General', 'script', '2013-07-26 09:01:03'),
('1110', 'menuBookings', 'backend', 'Menu Bookings', 'script', '2014-02-03 06:49:30'),
('1111', 'menuPayments', 'backend', 'Menu Payments', 'script', '2013-07-26 09:02:16'),
('1112', 'menuBookingForm', 'backend', 'Menu Booking form', 'script', '2013-07-26 09:02:34'),
('1113', 'menuConfirmation', 'backend', 'Menu Confirmation', 'script', '2013-07-26 09:02:49'),
('1114', 'menuTerms', 'backend', 'Menu Terms', 'script', '2013-07-26 09:03:06'),
('1124', 'opt_o_bf_address_1', 'backend', 'Options / Address 1', 'script', '2013-08-28 10:46:04'),
('1125', 'opt_o_bf_captcha', 'backend', 'Options / Captcha', 'script', NULL),
('1386', 'opt_o_bf_city', 'backend', 'Options / City', 'script', NULL),
('1387', 'opt_o_bf_email', 'backend', 'Options / Email', 'script', NULL),
('1388', 'opt_o_bf_name', 'backend', 'Options / Name', 'script', '2013-08-28 10:46:31'),
('1389', 'opt_o_bf_notes', 'backend', 'Options / Notes', 'script', NULL),
('1390', 'opt_o_bf_phone', 'backend', 'Options / Phone', 'script', NULL),
('1391', 'opt_o_bf_state', 'backend', 'Options / State', 'script', NULL),
('1392', 'opt_o_bf_terms', 'backend', 'Options / Terms', 'script', NULL),
('1393', 'opt_o_bf_zip', 'backend', 'Options / Zip', 'script', NULL),
('1394', 'opt_o_bf_country', 'backend', 'Options / Country', 'script', NULL),
('1395', 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
('1396', 'opt_o_accept_bookings', 'backend', 'Options / Accept Bookings', 'script', '2014-02-03 06:49:30'),
('1397', 'opt_o_allow_authorize', 'backend', 'Options / Allow Authorize.net', 'script', NULL),
('1398', 'opt_o_allow_bank', 'backend', 'Options / Allow Bank', 'script', NULL),
('1399', 'opt_o_allow_creditcard', 'backend', 'Options / Allow Credit Card', 'script', NULL),
('1400', 'opt_o_allow_paypal', 'backend', 'Options / Allow Paypal', 'script', NULL),
('1401', 'opt_o_authorize_key', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
('1402', 'opt_o_authorize_mid', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
('1403', 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
('1404', 'opt_o_deposit', 'backend', 'Options / Deposit', 'script', NULL),
('1405', 'opt_o_disable_payments', 'backend', 'Options / Disable payments', 'script', NULL),
('1407', 'opt_o_require_all_within', 'backend', 'Options / Require 100% if the reservations is within X days', 'script', NULL),
('1408', 'opt_o_security', 'backend', 'Options / Security deposit payment', 'script', NULL),
('1409', 'opt_o_status_if_not_paid', 'backend', 'Options / Default status for booked dates if not paid', 'script', NULL),
('1410', 'opt_o_status_if_paid', 'backend', 'Options / Default status for booked dates if paid', 'script', NULL),
('1411', 'opt_o_tax', 'backend', 'Options / Tax payment', 'script', NULL),
('1412', 'opt_o_thankyou_page', 'backend', 'Options / "Thank you" page location', 'script', NULL),
('1413', 'opt_o_authorize_tz', 'backend', 'Options / Authorize.net Time zone', 'script', NULL),
('1414', 'opt_o_email_new_reservation', 'backend', 'Options / New booking received', 'script', NULL),
('1415', 'opt_o_email_reservation_cancelled', 'backend', 'Options / Booking cancelled', 'script', NULL),
('1416', 'opt_o_email_password_reminder', 'backend', 'Notifications / Password reminder', 'script', NULL),
('1417', 'lblOptionsTermsURL', 'backend', 'Options / Booking terms URL', 'script', NULL),
('1418', 'lblOptionsTermsContent', 'backend', 'Options / Booking terms content', 'script', NULL),
('1419', 'error_titles_ARRAY_AO24', 'arrays', 'error_titles_ARRAY_AO24', 'script', NULL),
('1420', 'error_titles_ARRAY_AO25', 'arrays', 'error_titles_ARRAY_AO25', 'script', NULL),
('1421', 'error_titles_ARRAY_AO26', 'arrays', 'error_titles_ARRAY_AO26', 'script', NULL),
('1422', 'error_bodies_ARRAY_AO24', 'arrays', 'error_bodies_ARRAY_AO24', 'script', NULL),
('1423', 'error_bodies_ARRAY_AO25', 'arrays', 'error_bodies_ARRAY_AO25', 'script', NULL),
('1424', 'error_bodies_ARRAY_AO26', 'arrays', 'error_bodies_ARRAY_AO26', 'script', NULL),
('1426', 'lblListingConfirmEmail', 'backend', 'Listing / Confirm email', 'script', NULL),
('1427', 'lblListingPaymentEmail', 'backend', 'Listing / Payment email', 'script', NULL),
('1428', 'lblListingConfirmTokens', 'backend', 'Listing / Confirm Tokens', 'script', NULL),
('1429', 'lblListingPaymentTokens', 'backend', 'Listing / Payment Tokens', 'script', NULL),
('1486', 'opt_o_bf_address_2', 'backend', 'Options / Address 2', 'script', '2013-08-28 10:45:38'),
('1488', 'error_titles_ARRAY_AO28', 'arrays', 'error_titles_ARRAY_AO28', 'script', '2013-07-26 09:38:05'),
('1489', 'error_bodies_ARRAY_AO28', 'arrays', 'error_bodies_ARRAY_AO28', 'script', '2013-07-26 09:39:14'),
('1490', 'time_default', 'backend', 'Working Time / Default', 'script', '2013-07-29 08:44:03'),
('1491', 'time_custom', 'backend', 'Working Time / Custom', 'script', '2013-07-29 08:44:14'),
('1492', 'time_day', 'backend', 'Working Time / Day of week', 'script', '2013-07-29 09:13:26'),
('1493', 'time_from', 'backend', 'Working Time / Start Time', 'script', '2013-07-29 09:13:48'),
('1494', 'time_to', 'backend', 'Working Time / End Time', 'script', '2013-07-29 09:14:00'),
('1495', 'time_is', 'backend', 'Working Time / Is Day off', 'script', '2013-07-29 09:14:14'),
('1496', 'time_date', 'backend', 'Working Time / Date', 'script', '2013-07-29 09:27:15'),
('1497', 'lblAll', 'backend', 'All', 'script', '2013-07-29 11:41:26'),
('1498', 'time_update_custom', 'backend', 'Working Time / Update custom', 'script', '2013-07-29 12:14:22'),
('1499', 'items_prices', 'backend', 'Items / Prices', 'script', '2013-07-29 12:45:26'),
('1500', 'items_details', 'backend', 'Items / Details', 'script', '2013-07-29 12:45:40'),
('1501', 'items_photos', 'backend', 'Items / Photos', 'script', '2013-07-29 12:45:51'),
('1502', 'items_periods_ARRAY_hour', 'arrays', 'Items / Rent period ''hour''', 'script', '2013-07-29 12:51:17'),
('1503', 'items_period', 'backend', 'Items / Rent period', 'script', '2013-07-29 12:50:35'),
('1504', 'items_periods_ARRAY_day', 'arrays', 'Items / Rent period ''day', 'script', '2013-07-29 13:14:44'),
('1505', 'items_from', 'backend', 'Items / From', 'script', '2013-07-29 13:04:31'),
('1506', 'items_to', 'backend', 'Items / To', 'script', '2013-07-29 13:04:41'),
('1507', 'items_length', 'backend', 'Items / Length', 'script', '2013-07-29 13:05:05'),
('1508', 'items_price', 'backend', 'Items / Price', 'script', '2013-07-29 13:05:16'),
('1509', 'items_price_per_ARRAY_hour', 'arrays', 'Items / Per hour', 'script', '2013-07-29 13:13:06'),
('1510', 'items_price_per_ARRAY_day', 'arrays', 'Items / Per day', 'script', '2013-07-29 13:22:11'),
('1511', 'items_hour_plural', 'backend', 'Items / Hours', 'script', '2013-07-29 13:16:20'),
('1512', 'items_day_plural', 'backend', 'Items / Days', 'script', '2013-07-29 13:16:30'),
('1513', 'items_price_del_title', 'backend', 'Items / Delete confirmation', 'script', '2013-07-30 14:15:46'),
('1514', 'items_price_del_body', 'backend', 'Items / Delete question', 'script', '2013-07-30 14:16:27'),
('1515', 'items_availability', 'backend', 'Items / Availability', 'script', '2013-07-30 14:51:42'),
('1516', 'availability_title', 'backend', 'Availability / Add availability', 'script', '2013-07-30 14:55:22'),
('1517', 'items_availabilities_ARRAY_active', 'arrays', 'Availability / Available', 'script', '2013-08-12 12:56:36'),
('1518', 'items_availabilities_ARRAY_inactive', 'arrays', 'Availability / Not available', 'script', '2013-08-12 12:56:31'),
('1519', 'legend_available', 'backend', 'Legend / Available', 'script', '2013-08-12 12:58:40'),
('1520', 'legend_booked', 'backend', 'Legend / Not available', 'script', '2013-08-12 12:58:54'),
('1521', 'legend_past', 'backend', 'Legend / Past day', 'script', '2013-08-12 12:59:10'),
('1522', 'menuPackages', 'backend', 'Menu Packages', 'script', '2013-08-12 14:11:12'),
('1523', 'packages_add', 'backend', 'Packages / Add package', 'script', '2013-08-12 14:25:13'),
('1524', 'packages_update', 'backend', 'Packages / Update package', 'script', '2013-08-12 14:26:28'),
('1525', 'packages_prices', 'backend', 'Packages / Prices', 'script', '2013-08-12 14:26:45'),
('1526', 'packages_title', 'backend', 'Packages / Name', 'script', '2013-08-12 14:28:33'),
('1527', 'packages_details', 'backend', 'Packages / Details', 'script', '2013-08-12 14:29:21'),
('1528', 'packages_items', 'backend', 'Packages / Items', 'script', '2013-08-12 15:02:52'),
('1529', 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', '2013-08-13 06:12:18'),
('1530', 'error_titles_ARRAY_AP03', 'arrays', 'error_titles_ARRAY_AP03', 'script', '2013-08-13 06:12:32'),
('1531', 'error_titles_ARRAY_AP04', 'arrays', 'error_titles_ARRAY_AP04', 'script', '2013-08-13 06:12:46'),
('1532', 'error_titles_ARRAY_AP08', 'arrays', 'error_titles_ARRAY_AP08', 'script', '2013-08-13 06:12:56'),
('1533', 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', '2013-08-13 06:13:09'),
('1534', 'error_bodies_ARRAY_AP03', 'arrays', 'error_bodies_ARRAY_AP03', 'script', '2013-08-13 06:13:20'),
('1535', 'error_bodies_ARRAY_AP04', 'arrays', 'error_bodies_ARRAY_AP04', 'script', '2013-08-13 06:13:33'),
('1536', 'error_bodies_ARRAY_AP08', 'arrays', 'error_bodies_ARRAY_AP08', 'script', '2013-08-13 06:13:49'),
('1537', 'error_titles_ARRAY_AP06', 'arrays', 'error_titles_ARRAY_AP06', 'script', '2014-02-03 12:23:32'),
('1538', 'error_bodies_ARRAY_AP06', 'arrays', 'error_bodies_ARRAY_AP06', 'script', '2014-02-03 12:24:06'),
('1539', 'booking_add', 'backend', 'Bookings / Add booking', 'script', '2014-02-03 06:49:30'),
('1540', 'booking_statuses_ARRAY_confirmed', 'arrays', 'Bookings / Status: confirmed', 'script', '2013-08-20 12:58:15'),
('1541', 'booking_statuses_ARRAY_pending', 'arrays', 'Bookings / Status: pending', 'script', '2013-08-20 12:58:28'),
('1542', 'booking_statuses_ARRAY_cancelled', 'arrays', 'Bookings / Status: cancelled', 'script', '2013-08-20 12:58:42'),
('1543', 'booking_uuid', 'backend', 'Bookings / Unique ID', 'script', '2013-08-20 13:11:41'),
('1544', 'booking_from', 'backend', 'Bookings / DateTime from', 'script', '2013-08-20 13:14:41'),
('1545', 'booking_to', 'backend', 'Bookings / DateTime to', 'script', '2013-08-20 13:14:50'),
('1546', 'booking_status', 'backend', 'Bookings / Status', 'script', '2013-08-20 13:15:06'),
('1547', 'booking_items', 'backend', 'Bookings / Items', 'script', '2013-08-20 13:51:05'),
('1548', 'booking_update', 'backend', 'Bookings / Update booking', 'script', '2014-02-03 06:49:30'),
('1549', 'opt_o_datetime_format', 'backend', 'Options / Datetime format', 'script', '2013-08-20 14:14:42'),
('1550', 'booking_created', 'backend', 'Bookings / Created', 'script', '2013-08-20 14:18:40'),
('1551', 'booking_total', 'backend', 'Bookings / Total', 'script', '2013-08-20 14:19:39'),
('1552', 'booking_deposit', 'backend', 'Bookings / Deposit', 'script', '2013-08-20 14:19:53'),
('1553', 'booking_tax', 'backend', 'Bookings / Tax', 'script', '2013-08-20 14:20:02'),
('1554', 'booking_security', 'backend', 'Bookings / Security', 'script', '2013-08-20 14:20:21'),
('1555', 'booking_price', 'backend', 'Bookings / Price', 'script', '2013-08-20 14:23:06'),
('1556', 'booking_payment_method', 'backend', 'Bookings / Payment method', 'script', '2013-08-20 14:24:44'),
('1557', 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', '2013-08-20 14:25:36'),
('1558', 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', '2013-08-20 14:25:54'),
('1559', 'payment_methods_ARRAY_cod', 'arrays', 'payment_methods_ARRAY_cod', 'script', '2013-08-20 14:26:31'),
('1560', 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', '2013-08-20 14:26:45'),
('1561', 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', '2013-08-20 14:27:01'),
('1562', 'booking_choose', 'backend', 'Bookings / Choose', 'script', '2013-08-20 14:27:46'),
('1563', 'booking_general', 'backend', 'Bookings / Details', 'script', '2013-08-20 14:28:43'),
('1564', 'booking_tab_details', 'backend', 'Bookings / Booking', 'script', '2014-02-03 06:51:55'),
('1565', 'booking_tab_client', 'backend', 'Bookings / Client', 'script', '2013-08-20 14:30:16'),
('1566', 'booking_country', 'backend', 'Bookings / Country', 'script', '2013-08-20 14:33:12'),
('1567', 'booking_state', 'backend', 'Bookings / State', 'script', '2013-08-20 14:33:26'),
('1568', 'booking_city', 'backend', 'Bookings / City', 'script', '2013-08-20 14:33:36'),
('1569', 'booking_zip', 'backend', 'Bookings / Zip', 'script', '2013-08-20 14:33:45'),
('1570', 'booking_name', 'backend', 'Bookings / Name', 'script', '2013-08-20 14:34:02'),
('1571', 'booking_address_1', 'backend', 'Bookings / Address Line 1', 'script', '2013-08-20 14:35:40'),
('1572', 'booking_address_2', 'backend', 'Bookings / Address Line 2', 'script', '2013-08-20 14:35:46'),
('1573', 'booking_notes', 'backend', 'Bookings / Notes', 'script', '2013-08-20 14:45:24'),
('1574', 'booking_customer', 'backend', 'Bookings / Customer details', 'script', '2013-08-20 14:45:57'),
('1575', 'menuCountries', 'backend', 'Menu Countries', 'script', '2013-08-20 14:52:14'),
('1576', 'lblCountry', 'backend', 'lblCountry', 'script', '2013-08-20 14:56:39'),
('1829', 'booking_create_invoice', 'backend', 'Bookings / Create Invoice', 'script', '2013-08-21 06:56:04'),
('1830', 'booking_i_name', 'backend', 'Bookings / Item', 'script', '2013-08-21 07:49:07'),
('1831', 'booking_i_qty', 'backend', 'Bookings / Qty', 'script', '2013-08-21 07:49:19'),
('1832', 'booking_i_price', 'backend', 'Bookings / Price', 'script', '2013-08-21 07:49:36'),
('1833', 'booking_i_subtotal', 'backend', 'Bookings / Subtotal', 'script', '2013-08-21 07:49:48'),
('1834', 'booking_i_empty', 'backend', 'Bookings / No items found', 'script', '2013-08-21 07:50:01'),
('1835', 'booking_invoice_details', 'backend', 'Bookings / Invoice details', 'script', '2013-08-21 09:40:21'),
('1837', 'booking_email', 'backend', 'Bookings / Email', 'script', '2013-08-21 09:43:49'),
('1838', 'booking_phone', 'backend', 'Bookings / Phone', 'script', '2013-08-21 09:43:59'),
('1840', 'booking_cc_types_ARRAY_visa_ARRAY_visa', 'arrays', 'booking_cc_types_ARRAY_visa', 'script', '2013-08-21 10:04:23'),
('1841', 'booking_cc_types_ARRAY_mastercard', 'arrays', 'booking_cc_types_ARRAY_mastercard', 'script', '2013-08-21 10:04:49'),
('1842', 'booking_cc_types_ARRAY_amex', 'arrays', 'booking_cc_types_ARRAY_amex', 'script', '2013-08-21 10:05:15'),
('1843', 'booking_cc_types_ARRAY_maestro', 'arrays', 'booking_cc_types_ARRAY_maestro', 'script', '2013-08-21 10:05:30'),
('1844', 'booking_cc_type', 'backend', 'Bookings / CC Type', 'script', '2013-08-21 10:06:19'),
('1845', 'booking_cc_num', 'backend', 'Bookings / CC Number', 'script', '2013-08-21 10:06:35'),
('1846', 'booking_cc_code', 'backend', 'Bookings / CC Code', 'script', '2013-08-21 10:06:46'),
('1847', 'booking_cc_exp', 'backend', 'Bookings / CC Exp.date', 'script', '2013-08-21 10:06:58'),
('1848', 'error_titles_ARRAY_ABK03', 'arrays', 'error_titles_ARRAY_ABK03', 'script', '2013-08-21 11:26:20'),
('1849', 'error_titles_ARRAY_ABK04', 'arrays', 'error_titles_ARRAY_ABK04', 'script', '2013-08-21 11:26:44'),
('1850', 'error_titles_ARRAY_ABK01', 'arrays', 'error_titles_ARRAY_ABK01', 'script', '2013-08-21 11:27:06'),
('1851', 'error_titles_ARRAY_ABK08', 'arrays', 'error_titles_ARRAY_ABK08', 'script', '2013-08-21 11:27:17'),
('1852', 'error_bodies_ARRAY_ABK03', 'arrays', 'error_bodies_ARRAY_ABK03', 'script', '2013-08-21 11:27:49'),
('1853', 'error_bodies_ARRAY_ABK04', 'arrays', 'error_bodies_ARRAY_ABK04', 'script', '2013-08-21 11:28:31'),
('1854', 'error_bodies_ARRAY_ABK01', 'arrays', 'error_bodies_ARRAY_ABK01', 'script', '2013-08-21 11:29:10'),
('1855', 'error_bodies_ARRAY_ABK08', 'arrays', 'error_bodies_ARRAY_ABK08', 'script', '2013-08-21 11:29:34'),
('1856', 'error_titles_ARRAY_ABK10', 'arrays', 'error_titles_ARRAY_ABK10', 'script', '2014-02-03 06:47:47'),
('1857', 'error_bodies_ARRAY_ABK10', 'arrays', 'error_bodies_ARRAY_ABK10', 'script', '2014-02-03 06:54:04'),
('1858', 'error_titles_ARRAY_ABK11', 'arrays', 'error_titles_ARRAY_ABK11', 'script', '2014-02-03 06:54:14'),
('1859', 'error_bodies_ARRAY_ABK11', 'arrays', 'error_bodies_ARRAY_ABK11', 'script', '2014-02-03 06:54:28'),
('1861', 'error_titles_ARRAY_ABK12', 'arrays', 'error_titles_ARRAY_ABK12', 'script', '2014-02-03 06:54:52'),
('1862', 'error_bodies_ARRAY_ABK12', 'arrays', 'error_bodies_ARRAY_ABK12', 'script', '2014-02-03 06:55:38'),
('1863', 'error_titles_ARRAY_ABK13', 'arrays', 'error_titles_ARRAY_ABK13', 'script', '2014-02-03 06:55:52'),
('1864', 'error_bodies_ARRAY_ABK13', 'arrays', 'error_bodies_ARRAY_ABK13', 'script', '2014-02-03 06:56:09'),
('1893', 'opt_o_daily_prices', 'backend', 'Options / Daily prices', 'script', '2013-08-22 11:16:32'),
('1894', 'opt_o_authorize_hash', 'backend', 'Options / Authorize.net hash value', 'script', '2013-08-23 09:25:20'),
('1896', 'front_select_payment', 'frontend', 'Frontend / Select Payment method', 'script', '2013-08-28 13:53:36'),
('1897', 'front_select_cc_type', 'frontend', 'Bookings / Select CC Type', 'script', '2013-08-28 14:03:34'),
('1898', 'opt_o_delivery', 'backend', 'Options / Delivery tax', 'script', '2013-08-29 07:03:01'),
('1899', 'booking_forth', 'backend', 'Bookings / How do you get the equipment?', 'script', '2013-08-29 14:45:32'),
('1900', 'booking_back', 'backend', 'Bookings / How will you return the equipment?', 'script', '2013-08-29 14:45:48'),
('1901', 'booking_forths_ARRAY_pickup', 'arrays', 'booking_forths_ARRAY_pickup', 'script', '2013-08-29 14:47:22'),
('1902', 'booking_forths_ARRAY_delivery', 'arrays', 'booking_forths_ARRAY_delivery', 'script', '2013-08-29 14:47:33'),
('1903', 'booking_backs_ARRAY_return', 'arrays', 'booking_backs_ARRAY_return', 'script', '2013-08-29 14:47:50'),
('1904', 'booking_backs_ARRAY_collection', 'arrays', 'booking_backs_ARRAY_collection', 'script', '2013-08-29 14:48:06'),
('1905', 'system_109', 'frontend', 'System / Booking / Missing parameters', 'script', '2013-08-30 08:33:19'),
('1906', 'system_110', 'frontend', 'System / Booking / Missing or wrong captcha', 'script', '2013-08-30 08:33:39'),
('1907', 'system_114', 'frontend', 'System / Booking / Invalid data', 'script', '2013-08-30 08:34:03'),
('1908', 'system_119', 'frontend', 'System / Booking / Booking not stored', 'script', '2013-08-30 08:34:29'),
('1909', 'system_210', 'frontend', 'System / Booking / Booking stored', 'script', '2013-08-30 08:35:11'),
('1910', 'system_211', 'frontend', 'System / Booking / Checkout submitted', 'script', '2013-08-30 08:35:27'),
('1911', 'system_212', 'frontend', 'System / Booking / Cart submitted', 'script', '2013-08-30 08:36:49'),
('1912', 'system_206', 'frontend', 'System / Cart / Equipment added', 'script', '2013-08-30 08:40:55'),
('1913', 'system_105', 'frontend', 'System / Cart / Equipment not added', 'script', '2013-08-30 08:41:26'),
('1914', 'system_207', 'frontend', 'System / Cart / Equipment removed', 'script', '2013-08-30 08:42:41'),
('1915', 'system_106', 'frontend', 'System / Cart / Equipment not removed', 'script', '2013-08-30 08:42:59'),
('1916', 'system_107', 'frontend', 'System / Cart / Cart not emptied', 'script', '2013-08-30 08:44:07'),
('1917', 'system_208', 'frontend', 'System / Cart / Cart emptied', 'script', '2013-08-30 08:44:24'),
('1918', 'system_108', 'frontend', 'System / Cart / Cart not updated', 'script', '2013-08-30 08:45:59'),
('1919', 'system_209', 'frontend', 'System / Cart / Cart updated', 'script', '2013-08-30 08:45:52'),
('1920', 'rental_start', 'frontend', 'Search / Rental start', 'script', '2013-08-30 09:10:40'),
('1921', 'rental_end', 'frontend', 'Search / Rental end', 'script', '2013-08-30 09:10:58'),
('1922', 'button_check_availability', 'frontend', 'Button / Check Availability and Price', 'script', '2013-08-30 09:12:40'),
('1923', 'number_items', 'frontend', 'Number of items', 'script', '2013-08-30 09:14:26'),
('1924', 'total_price', 'frontend', 'Total price', 'script', '2013-08-30 09:15:08'),
('1925', 'button_continue', 'frontend', 'Button / Continue', 'script', '2013-08-30 09:15:37'),
('1926', 'change_dates', 'frontend', 'Change dates', 'script', '2013-08-30 09:16:10'),
('1927', 'not_available', 'frontend', 'Not available', 'script', '2013-08-30 09:16:45'),
('1928', 'number_packages', 'frontend', 'Number of packages', 'script', '2013-08-30 09:17:46'),
('1929', 'front_booking_status_ARRAY_1', 'arrays', 'front_booking_status_ARRAY_1', 'script', '2013-08-30 09:20:28'),
('1930', 'front_booking_status_ARRAY_11', 'arrays', 'front_booking_status_ARRAY_11', 'script', '2013-08-30 09:20:40'),
('1931', 'fmenu_items', 'frontend', 'Front Menu / Items', 'script', '2013-08-30 09:23:54'),
('1932', 'fmenu_packages', 'frontend', 'Front Menu / Packages', 'script', '2013-08-30 09:23:31'),
('1933', 'fmenu_cart', 'frontend', 'Front Menu / Basket', 'script', '2013-08-30 09:23:42'),
('1934', 'delivery_notes', 'frontend', 'Cart / Delivery notes', 'script', '2013-08-30 09:31:07'),
('1935', 'button_remove', 'frontend', 'Button / Remove', 'script', '2013-08-30 09:31:02'),
('1936', 'button_checkout', 'frontend', 'Button / Checkout', 'script', '2013-08-30 09:30:57'),
('1937', 'delivery_price', 'frontend', 'Cart / Delivery Price', 'script', '2013-08-30 09:30:51'),
('1938', 'cart_empty_notice', 'frontend', 'Cart / Empty notice', 'script', '2013-08-30 09:32:07'),
('1939', 'button_back', 'frontend', 'Button / Back', 'script', '2013-08-30 09:33:28'),
('1940', 'co_empty_notice', 'frontend', 'Checkout / Empty notice', 'script', '2013-08-30 09:36:03'),
('1941', 'button_preview', 'frontend', 'Button / Preview Booking', 'script', '2013-08-30 09:44:51'),
('1942', 'co_captcha', 'frontend', 'Checkout / Captcha', 'script', '2013-08-30 09:40:04'),
('1943', 'co_terms', 'frontend', 'Checkout / Terms', 'script', '2013-08-30 09:44:44'),
('1944', 'e_item_not_found', 'frontend', 'Equipment Item / Not found', 'script', '2013-08-30 09:59:12'),
('1945', 'co_select_country', 'frontend', 'Checkout / Select Country', 'script', '2013-08-30 09:46:35'),
('1946', 'item_select_category', 'frontend', 'Category', 'script', '2013-08-30 09:48:18'),
('1947', 'e_items_not_found', 'frontend', 'Equipment Items / Not found', 'script', '2013-08-30 09:58:50'),
('1948', 'front_prev', 'frontend', 'Paginator / Previous', 'script', '2013-08-30 09:49:47'),
('1949', 'front_next', 'frontend', 'Paginator / Next', 'script', '2013-08-30 09:50:00'),
('1950', 'equipment_price', 'frontend', 'Equipment / Price', 'script', '2013-08-30 09:52:41'),
('1951', 'equipment_na', 'frontend', 'Equipment / N/A', 'script', '2013-08-30 09:52:37'),
('1952', 'e_package_not_found', 'frontend', 'Equipment Package / Not found', 'script', '2013-08-30 09:54:40'),
('1953', 'e_packages_not_found', 'frontend', 'Equipment Package / Not found', 'script', '2013-08-30 09:59:32'),
('1954', 'button_confirm', 'frontend', 'Button / Confirm Booking', 'script', '2013-08-30 10:32:38'),
('1955', 'preview_empty_notice', 'frontend', 'Preview / Empty notice', 'script', '2013-08-30 10:33:56'),
('1956', 'payment_paypal_submit', 'frontend', 'Payment / Paypal submit', 'script', '2013-08-30 11:04:00'),
('1957', 'payment_authorize_submit', 'frontend', 'Payment / Authorize.NET submit', 'script', '2013-08-30 11:04:59'),
('1958', 'payment_authorize_title', 'frontend', 'Payment / Authorize.NET title', 'script', '2013-08-30 11:05:34'),
('1959', 'payment_paypal_title', 'frontend', 'Payment / Paypal title', 'script', '2013-08-30 11:05:47'),
('1960', 'lblInstallJs1_title', 'backend', 'Install / Title', 'script', '2013-08-30 13:14:47'),
('1961', 'lblInstallJs1_body', 'backend', 'Install / Body', 'script', '2013-08-30 13:15:04'),
('1965', 'lblDashLastLogin', 'backend', 'Dashboard / Last login', 'script', '2013-08-30 13:18:33'),
('1966', 'lblDashBookings', 'backend', 'Dashboard / Bookings today', 'script', '2013-08-30 13:19:33'),
('1967', 'e_item_other_items', 'frontend', 'Equipment Item / Other available items', 'script', '2013-09-02 08:08:56'),
('1968', 'booking_i_unit_price', 'backend', 'Bookings / Unit Price', 'script', '2013-09-02 08:44:26'),
('1969', 'error_titles_ARRAY_AO07', 'arrays', 'error_titles_ARRAY_AO07', 'script', '2013-09-03 09:03:52'),
('1970', 'error_bodies_ARRAY_AO07', 'arrays', 'error_bodies_ARRAY_AO07', 'script', '2013-09-03 09:03:47'),
('1971', 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', '2013-09-03 09:07:08'),
('1972', 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', '2013-09-03 09:07:01'),
('1973', 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', '2013-09-03 09:04:58'),
('1974', 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', '2013-09-03 09:05:06'),
('1975', 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', '2013-09-03 09:06:00'),
('1976', 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', '2013-09-03 09:05:55'),
('1977', 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', '2013-09-03 09:06:30'),
('1978', 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', '2013-09-03 09:06:39'),
('1979', 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', '2013-09-03 09:09:02'),
('1980', 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', '2013-09-03 09:09:08'),
('1981', 'error_titles_ARRAY_AT02', 'arrays', 'error_titles_ARRAY_AT02', 'script', '2013-09-03 09:09:36'),
('1982', 'error_bodies_ARRAY_AT02', 'arrays', 'error_bodies_ARRAY_AT02', 'script', '2013-09-03 09:09:54'),
('1983', 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', '2013-09-03 09:10:13'),
('1984', 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', '2013-09-03 09:10:18'),
('1985', 'error_titles_ARRAY_AO21', 'arrays', 'error_titles_ARRAY_AO21', 'script', '2013-09-03 11:24:52'),
('1986', 'error_bodies_ARRAY_AO21', 'arrays', 'error_bodies_ARRAY_AO21', 'script', '2013-09-03 11:26:27'),
('1987', 'error_titles_ARRAY_AO23', 'arrays', 'error_titles_ARRAY_AO23', 'script', '2013-09-03 11:27:35'),
('1988', 'error_bodies_ARRAY_AO23', 'arrays', 'error_bodies_ARRAY_AO23', 'script', '2013-09-03 11:27:54'),
('1989', 'error_titles_ARRAY_AO27', 'arrays', 'error_titles_ARRAY_AO27', 'script', '2013-09-03 11:28:20'),
('1990', 'error_bodies_ARRAY_AO27', 'arrays', 'error_bodies_ARRAY_AO27', 'script', '2013-09-03 11:28:26'),
('1991', 'error_titles_ARRAY_AC09', 'arrays', 'error_titles_ARRAY_AC09', 'script', '2013-09-03 11:36:10'),
('1992', 'error_bodies_ARRAY_AC09', 'arrays', 'error_bodies_ARRAY_AC09', 'script', '2014-02-03 12:28:11'),
('1993', 'error_titles_ARRAY_AC10', 'arrays', 'error_titles_ARRAY_AC10', 'script', '2013-09-03 11:37:17'),
('1994', 'error_bodies_ARRAY_AC10', 'arrays', 'error_bodies_ARRAY_AC10', 'script', '2013-09-03 11:37:31'),
('1996', 'error_titles_ARRAY_AU09', 'arrays', 'error_titles_ARRAY_AU09', 'script', '2013-09-03 11:39:59'),
('1997', 'error_bodies_ARRAY_AU09', 'arrays', 'error_bodies_ARRAY_AU09', 'script', '2013-09-03 11:40:19'),
('1998', 'error_titles_ARRAY_AU10', 'arrays', 'error_titles_ARRAY_AU10', 'script', '2013-09-03 11:40:36'),
('1999', 'error_bodies_ARRAY_AU10', 'arrays', 'error_bodies_ARRAY_AU10', 'script', '2013-09-03 11:40:47'),
('2000', 'selected_from', 'frontend', 'Selected DateTime / From', 'script', '2013-09-09 12:38:16'),
('2001', 'selected_to', 'frontend', 'Selected DateTime / To', 'script', '2013-09-09 12:38:26'),
('2002', 'selected_clear', 'frontend', 'Selected DateTime / Clear datetime', 'script', '2013-09-09 12:38:49'),
('2003', 'items_image', 'backend', 'Items / Image', 'script', '2013-09-12 06:12:02'),
('2004', 'opt_o_collection', 'backend', 'Options / Collection tax', 'script', '2013-09-12 06:24:07'),
('2006', 'front_app_ARRAY_clear_body', 'arrays', 'Front App / Dialog content', 'script', '2013-09-12 08:36:31'),
('2007', 'front_app_ARRAY_btn_ok', 'arrays', 'Front App / Button OK', 'script', '2013-09-12 06:56:59'),
('2008', 'front_app_ARRAY_btn_cancel', 'arrays', 'Front App / Button Cancel', 'script', '2013-09-12 06:57:13'),
('2009', 'front_app_ARRAY_clear_title', 'arrays', 'Front App / Clear title', 'script', '2013-09-12 08:33:41'),
('2011', 'front_app_ARRAY_check_title', 'arrays', 'Front App / Check title', 'script', '2013-09-12 08:35:25'),
('2012', 'front_tax', 'frontend', 'Frontend / Tax', 'script', '2013-09-12 11:03:59'),
('2013', 'front_security', 'frontend', 'Frontend / Security deposit', 'script', '2013-09-12 11:04:13'),
('2015', 'front_deposit', 'frontend', 'Frontend / Deposit payment', 'script', '2013-09-12 11:04:36'),
('2016', 'front_total', 'frontend', 'Frontend / Total price', 'script', '2013-09-12 11:04:57'),
('2017', 'front_items_price', 'frontend', 'Frontend / Items price', 'script', '2013-09-12 11:05:26'),
('2018', 'front_dc', 'frontend', 'Frontend / Delivery & Collection', 'script', '2013-09-12 11:05:49'),
('2019', 'system_111', 'frontend', 'System / Booking / Item not available', 'script', '2013-09-12 13:20:08'),
('2020', 'front_cart_na', 'frontend', 'Frontend / Item not available', 'script', '2013-09-12 13:32:58'),
('2021', 'opt_o_use_category', 'backend', 'Options / Use categories', 'script', '2013-10-03 06:20:38'),
('2022', 'error_bodies_ARRAY_AI10', 'arrays', 'error_bodies_ARRAY_AI10', 'script', '2014-02-03 12:17:57'),
('2023', 'error_titles_ARRAY_AI10', 'arrays', 'error_titles_ARRAY_AI10', 'script', '2014-02-03 12:17:23'),
('2024', 'error_titles_ARRAY_AI11', 'arrays', 'error_titles_ARRAY_AI11', 'script', '2014-02-03 07:01:47'),
('2025', 'error_bodies_ARRAY_AI11', 'arrays', 'error_bodies_ARRAY_AI11', 'script', '2014-02-03 07:03:36'),
('2026', 'error_titles_ARRAY_AI12', 'arrays', 'error_titles_ARRAY_AI12', 'script', '2014-02-03 12:18:22'),
('2027', 'error_bodies_ARRAY_AI12', 'arrays', 'error_bodies_ARRAY_AI12', 'script', '2014-02-03 12:19:39'),
('2028', 'error_titles_ARRAY_AP10', 'arrays', 'error_titles_ARRAY_AP10', 'script', '2013-10-03 06:46:04'),
('2029', 'error_bodies_ARRAY_AP10', 'arrays', 'error_bodies_ARRAY_AP10', 'script', '2014-02-03 12:24:47'),
('2030', 'error_titles_ARRAY_AP11', 'arrays', 'error_titles_ARRAY_AP11', 'script', '2014-02-03 12:25:16'),
('2031', 'error_bodies_ARRAY_AP11', 'arrays', 'error_bodies_ARRAY_AP11', 'script', '2014-02-03 12:25:42'),
('2032', 'items_price_per_opts_ARRAY_hour', 'arrays', 'Items / Price per hour', 'script', '2013-10-03 07:19:51'),
('2033', 'items_price_per_opts_ARRAY_day', 'arrays', 'Items / Price per day', 'script', '2013-10-03 07:20:06'),
('2034', 'items_default_price', 'backend', 'Items / Default prices', 'script', '2013-10-03 07:22:05'),
('2035', 'items_special_price', 'backend', 'Items / Special prices', 'script', '2013-10-03 07:22:00'),
('2036', 'confirmation_client_confirmation', 'backend', 'Confirmation / Client confirmation title', 'script', '2013-10-03 07:49:51'),
('2037', 'confirmation_client_payment', 'backend', 'Confirmation / Client payment title', 'script', '2013-10-03 07:50:17'),
('2038', 'confirmation_admin_confirmation', 'backend', 'Confirmation / Admin confirmation title', 'script', '2013-10-03 07:50:37'),
('2039', 'confirmation_admin_payment', 'backend', 'Confirmation / Admin payment title', 'script', '2013-10-03 07:50:56'),
('2040', 'confirmation_subject', 'backend', 'Confirmation / Email subject', 'script', '2013-10-03 07:51:19'),
('2041', 'confirmation_body', 'backend', 'Confirmation / Email body', 'script', '2013-10-03 07:51:38'),
('2042', 'menuSeo', 'backend', 'Menu SEO', 'script', '2014-01-22 13:05:07'),
('2043', 'lblInstallSeo_1', 'backend', 'Install / SEO Step 1', 'script', '2014-01-22 13:12:05'),
('2044', 'lblInstallSeo_2', 'backend', 'Install / SEO Step 2', 'script', '2014-01-22 13:12:17'),
('2045', 'lblInstallSeo_3', 'backend', 'Install / SEO Step 3', 'script', '2014-01-22 13:12:27'),
('2046', 'error_titles_ARRAY_AO30', 'arrays', 'error_titles_ARRAY_AO30', 'script', '2014-01-22 13:13:00'),
('2047', 'error_bodies_ARRAY_AO30', 'arrays', 'error_titles_ARRAY_AO30', 'script', '2014-01-22 13:13:32'),
('2048', 'error_titles_ARRAY_AI13', 'arrays', 'error_titles_ARRAY_AI13', 'script', '2014-02-03 06:58:48'),
('2049', 'error_bodies_ARRAY_AI13', 'arrays', 'error_bodies_ARRAY_AI13', 'script', '2014-02-03 06:57:14'),
('2050', 'error_titles_ARRAY_AP12', 'arrays', 'error_titles_ARRAY_AP12', 'script', '2014-01-22 13:24:12'),
('2051', 'error_bodies_ARRAY_AP12', 'arrays', 'error_bodies_ARRAY_AP12', 'script', '2014-02-03 12:22:14'),
('2052', 'error_titles_ARRAY_AC11', 'arrays', 'error_titles_ARRAY_AC11', 'script', '2014-02-03 12:27:03'),
('2053', 'error_bodies_ARRAY_AC11', 'arrays', 'error_bodies_ARRAY_AC11', 'script', '2014-02-03 12:27:53'),
('2054', 'error_titles_ARRAY_AU11', 'arrays', 'error_titles_ARRAY_AU11', 'script', '2014-01-22 13:28:29'),
('2055', 'error_bodies_ARRAY_AU11', 'arrays', 'error_bodies_ARRAY_AU11', 'script', '2014-01-22 13:28:46'),
('2056', 'front_terms', 'frontend', 'Frontend / Terms and Conditions', 'script', '2014-01-22 13:31:34'),
('2057', 'front_terms_note', 'frontend', 'Frontend / Terms note', 'script', '2014-01-22 13:31:50'),
('2058', 'front_terms_link', 'frontend', 'Frontend / Terms link', 'script', '2014-01-22 13:32:06'),
('2059', 'dashboard_latest_booked', 'backend', 'Dashboard / Latest booked items', 'script', '2014-01-22 13:59:00'),
('2060', 'dashboard_latest_bookings', 'backend', 'Dashboard / Latest Bookings', 'script', '2014-01-22 13:59:23'),
('2061', 'dashboard_last_logged', 'backend', 'Dashboard / Last logged', 'script', '2014-01-22 13:59:48'),
('2062', 'dashboard_users_plural', 'backend', 'Dashboard / Users (plural)', 'script', '2014-01-22 14:01:23'),
('2063', 'dashboard_users_singular', 'backend', 'Dashboard / Users (singular)', 'script', '2014-01-22 14:01:31'),
('2064', 'dashboard_bookings_plural', 'backend', 'Dashboard / Bookings (plural)', 'script', '2014-01-22 14:02:21'),
('2065', 'dashboard_bookings_singular', 'backend', 'Dashboard / Bookings (singular)', 'script', '2014-01-22 14:02:31'),
('2066', 'dashboard_items_plural', 'backend', 'Dashboard / Items (plural)', 'script', '2014-01-22 14:10:00'),
('2067', 'dashboard_items_singular', 'backend', 'Dashboard / Items (singular)', 'script', '2014-01-22 14:09:56'),
('2068', 'booking_category', 'backend', 'Bookings / Category', 'script', '2014-02-24 14:34:06'),
('2069', 'booking_query', 'backend', 'Bookings / Query', 'script', '2014-02-24 14:36:46'),
('2070', 'booking_packages', 'backend', 'Bookings / Packages', 'script', '2014-02-24 15:00:35'),
('2071', 'front_start_over', 'frontend', 'Frontend / Start Over', 'script', '2014-02-25 11:56:36'),
('2072', 'booking_add_item', 'backend', 'Bookings / Add item', 'script', '2014-02-24 15:35:24'),
('2073', 'booking_recalc', 'backend', 'Bookings / Recalculate price', 'script', '2014-02-24 15:36:47'),
('2074', 'booking_bank_account', 'frontend', 'Bookings / Bank account', 'script', '2014-02-25 07:53:04'),
('2075', 'front_booking_na', 'frontend', 'Frontend / Booking not available', 'script', '2014-02-25 12:00:19'),
('2076', 'front_return_back', 'frontend', 'Frontend / Return back', 'script', '2014-02-25 12:00:45'),
('2077', 'lblInstall_doctype', 'backend', 'Install / Doctype', 'script', '2014-02-25 12:32:07'),
('2078', 'lblInstall_viewport', 'backend', 'Install / Viewport', 'script', '2014-02-25 12:32:30'),
('2079', 'opt_o_allow_cod', 'backend', 'Options / Allow Cash on Delivery', 'script', '2014-02-25 12:35:17'),
('2080', 'error_bodies_ARRAY_ABK09', 'arrays', 'error_bodies_ARRAY_ABK09', 'script', '2014-04-23 06:33:33'),
('2081', 'error_titles_ARRAY_ABK09', 'arrays', 'error_titles_ARRAY_ABK09', 'script', '2014-04-23 06:33:53'),
('2082', 'delete_item_with_bookings', 'backend', 'Delete item with bookings', 'script', '2014-04-23 09:18:34'),
('2083', 'delete_package_with_bookings', 'backend', 'Delete package with bookings', 'script', '2014-04-23 09:18:59'),
('2084', 'booking_uuid_duplicate', 'backend', 'Bookings / Duplicate Unique ID', 'script', '2014-04-24 14:54:24');

INSERT INTO `equipment_multi_lang` VALUES
('1', '5', 'pjField', '1', 'title', 'Username', 'script'),
('2', '6', 'pjField', '1', 'title', 'Password', 'script'),
('3', '7', 'pjField', '1', 'title', 'Email', 'script'),
('4', '8', 'pjField', '1', 'title', 'URL', 'script'),
('5', '13', 'pjField', '1', 'title', 'DateTime', 'script'),
('6', '16', 'pjField', '1', 'title', 'Save', 'script'),
('7', '17', 'pjField', '1', 'title', 'Reset', 'script'),
('8', '18', 'pjField', '1', 'title', 'Add language', 'script'),
('9', '22', 'pjField', '1', 'title', 'Multi Lang', 'script'),
('10', '23', 'pjField', '1', 'title', 'Plugins', 'script'),
('11', '24', 'pjField', '1', 'title', 'Users', 'script'),
('12', '25', 'pjField', '1', 'title', 'Options', 'script'),
('13', '26', 'pjField', '1', 'title', 'Logout', 'script'),
('14', '31', 'pjField', '1', 'title', 'Update', 'script'),
('15', '36', 'pjField', '1', 'title', 'Choose', 'script'),
('16', '37', 'pjField', '1', 'title', 'Search', 'script'),
('17', '40', 'pjField', '1', 'title', 'Back-end titles', 'script'),
('18', '41', 'pjField', '1', 'title', 'Front-end titles', 'script'),
('19', '42', 'pjField', '1', 'title', 'Languages', 'script'),
('20', '44', 'pjField', '1', 'title', 'Admin Login', 'script'),
('21', '45', 'pjField', '1', 'title', 'Login', 'script'),
('22', '47', 'pjField', '1', 'title', 'Dashboard', 'script'),
('23', '57', 'pjField', '1', 'title', 'Option list', 'script'),
('24', '58', 'pjField', '1', 'title', 'Add +', 'script'),
('25', '62', 'pjField', '1', 'title', 'Delete', 'script'),
('26', '65', 'pjField', '1', 'title', 'Type', 'script'),
('27', '66', 'pjField', '1', 'title', 'Name', 'script'),
('28', '67', 'pjField', '1', 'title', 'Role', 'script'),
('29', '68', 'pjField', '1', 'title', 'Status', 'script'),
('30', '69', 'pjField', '1', 'title', 'Is confirmed', 'script'),
('31', '70', 'pjField', '1', 'title', 'Update user', 'script'),
('32', '71', 'pjField', '1', 'title', 'Add user', 'script'),
('33', '72', 'pjField', '1', 'title', 'Value', 'script'),
('34', '73', 'pjField', '1', 'title', 'Option', 'script'),
('35', '74', 'pjField', '1', 'title', 'days', 'script'),
('36', '115', 'pjField', '1', 'title', 'Languages', 'script'),
('73', '116', 'pjField', '1', 'title', 'Yes', 'script'),
('75', '117', 'pjField', '1', 'title', 'No', 'script'),
('77', '338', 'pjField', '1', 'title', 'Error', 'script'),
('79', '347', 'pjField', '1', 'title', '&laquo; Back', 'script'),
('81', '355', 'pjField', '1', 'title', 'Cancel', 'script'),
('83', '356', 'pjField', '1', 'title', 'Forgot password', 'script'),
('85', '357', 'pjField', '1', 'title', 'Password reminder', 'script'),
('87', '358', 'pjField', '1', 'title', 'Send', 'script'),
('89', '359', 'pjField', '1', 'title', 'Password reminder', 'script'),
('91', '360', 'pjField', '1', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('93', '365', 'pjField', '1', 'title', 'Profile', 'script'),
('95', '380', 'pjField', '1', 'title', 'Languages Title', 'script'),
('97', '381', 'pjField', '1', 'title', 'Languages Body', 'script'),
('99', '382', 'pjField', '1', 'title', 'Languages Backend Title', 'script'),
('101', '383', 'pjField', '1', 'title', 'Languages Backend Body', 'script'),
('103', '384', 'pjField', '1', 'title', 'Languages Frontend Title', 'script'),
('105', '385', 'pjField', '1', 'title', 'Languages Frontend Body', 'script'),
('107', '386', 'pjField', '1', 'title', 'Listing Prices Title', 'script'),
('109', '387', 'pjField', '1', 'title', 'Listing Prices Body', 'script'),
('111', '388', 'pjField', '1', 'title', 'Listing Bookings Title', 'script'),
('113', '389', 'pjField', '1', 'title', 'Listing Bookings Body', 'script'),
('115', '390', 'pjField', '1', 'title', 'Listing Contact Title', 'script'),
('117', '391', 'pjField', '1', 'title', 'Listing Contact Body', 'script'),
('119', '392', 'pjField', '1', 'title', 'Listing Address Title', 'script'),
('121', '393', 'pjField', '1', 'title', 'Listing Address Body', 'script'),
('123', '395', 'pjField', '1', 'title', 'Extend exp.date Title', 'script'),
('125', '396', 'pjField', '1', 'title', 'Extend exp.date Body', 'script'),
('127', '408', 'pjField', '1', 'title', 'Backup', 'script'),
('129', '409', 'pjField', '1', 'title', 'Backup', 'script'),
('131', '410', 'pjField', '1', 'title', 'Backup database', 'script'),
('133', '411', 'pjField', '1', 'title', 'Backup files', 'script'),
('135', '412', 'pjField', '1', 'title', 'Choose Action', 'script'),
('137', '413', 'pjField', '1', 'title', 'Go to page:', 'script'),
('139', '414', 'pjField', '1', 'title', 'Total items:', 'script'),
('141', '415', 'pjField', '1', 'title', 'Items per page', 'script'),
('143', '416', 'pjField', '1', 'title', 'Prev page', 'script'),
('145', '417', 'pjField', '1', 'title', '&laquo; Prev', 'script'),
('147', '418', 'pjField', '1', 'title', 'Next page', 'script'),
('149', '419', 'pjField', '1', 'title', 'Next &raquo;', 'script'),
('151', '420', 'pjField', '1', 'title', 'Delete confirmation', 'script'),
('153', '421', 'pjField', '1', 'title', 'Are you sure you want to delete selected record?', 'script'),
('155', '422', 'pjField', '1', 'title', 'Action confirmation', 'script'),
('157', '423', 'pjField', '1', 'title', 'OK', 'script'),
('159', '424', 'pjField', '1', 'title', 'Cancel', 'script'),
('161', '425', 'pjField', '1', 'title', 'Delete', 'script'),
('163', '426', 'pjField', '1', 'title', 'No records found', 'script'),
('165', '433', 'pjField', '1', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
('167', '434', 'pjField', '1', 'title', 'IP address', 'script'),
('169', '435', 'pjField', '1', 'title', 'Registration date/time', 'script'),
('171', '441', 'pjField', '1', 'title', 'Currency', 'script'),
('173', '442', 'pjField', '1', 'title', 'Date format', 'script'),
('175', '451', 'pjField', '1', 'title', 'Timezone', 'script'),
('177', '452', 'pjField', '1', 'title', 'First day of the week', 'script'),
('179', '455', 'pjField', '1', 'title', 'Active', 'script'),
('180', '456', 'pjField', '1', 'title', 'Inactive', 'script'),
('181', '457', 'pjField', '1', 'title', 'Active', 'script'),
('182', '458', 'pjField', '1', 'title', 'Inactive', 'script'),
('183', '471', 'pjField', '1', 'title', 'Yes', 'script'),
('184', '472', 'pjField', '1', 'title', 'No', 'script'),
('185', '476', 'pjField', '1', 'title', 'Mr.', 'script'),
('186', '477', 'pjField', '1', 'title', 'Mrs.', 'script'),
('187', '478', 'pjField', '1', 'title', 'Miss', 'script'),
('188', '479', 'pjField', '1', 'title', 'Ms.', 'script'),
('189', '480', 'pjField', '1', 'title', 'Dr.', 'script'),
('190', '481', 'pjField', '1', 'title', 'Prof.', 'script'),
('191', '482', 'pjField', '1', 'title', 'Rev.', 'script'),
('192', '483', 'pjField', '1', 'title', 'Other', 'script'),
('193', '496', 'pjField', '1', 'title', 'GMT-12:00', 'script'),
('194', '497', 'pjField', '1', 'title', 'GMT-11:00', 'script'),
('195', '498', 'pjField', '1', 'title', 'GMT-10:00', 'script'),
('196', '499', 'pjField', '1', 'title', 'GMT-09:00', 'script'),
('197', '500', 'pjField', '1', 'title', 'GMT-08:00', 'script'),
('198', '501', 'pjField', '1', 'title', 'GMT-07:00', 'script'),
('199', '502', 'pjField', '1', 'title', 'GMT-06:00', 'script'),
('200', '503', 'pjField', '1', 'title', 'GMT-05:00', 'script'),
('201', '504', 'pjField', '1', 'title', 'GMT-04:00', 'script'),
('202', '505', 'pjField', '1', 'title', 'GMT-03:00', 'script'),
('203', '506', 'pjField', '1', 'title', 'GMT-02:00', 'script'),
('204', '507', 'pjField', '1', 'title', 'GMT-01:00', 'script'),
('205', '508', 'pjField', '1', 'title', 'GMT', 'script'),
('206', '509', 'pjField', '1', 'title', 'GMT+01:00', 'script'),
('207', '510', 'pjField', '1', 'title', 'GMT+02:00', 'script'),
('208', '511', 'pjField', '1', 'title', 'GMT+03:00', 'script'),
('209', '512', 'pjField', '1', 'title', 'GMT+04:00', 'script'),
('210', '513', 'pjField', '1', 'title', 'GMT+05:00', 'script'),
('211', '514', 'pjField', '1', 'title', 'GMT+06:00', 'script'),
('212', '515', 'pjField', '1', 'title', 'GMT+07:00', 'script'),
('213', '516', 'pjField', '1', 'title', 'GMT+08:00', 'script'),
('214', '517', 'pjField', '1', 'title', 'GMT+09:00', 'script'),
('215', '518', 'pjField', '1', 'title', 'GMT+10:00', 'script'),
('216', '519', 'pjField', '1', 'title', 'GMT+11:00', 'script'),
('217', '520', 'pjField', '1', 'title', 'GMT+12:00', 'script'),
('218', '521', 'pjField', '1', 'title', 'GMT+13:00', 'script'),
('219', '540', 'pjField', '1', 'title', 'User updated!', 'script'),
('220', '541', 'pjField', '1', 'title', 'User added!', 'script'),
('221', '542', 'pjField', '1', 'title', 'User failed to add.', 'script'),
('222', '543', 'pjField', '1', 'title', 'User not found.', 'script'),
('223', '544', 'pjField', '1', 'title', 'Options updated!', 'script'),
('224', '552', 'pjField', '1', 'title', 'Backup', 'script'),
('225', '553', 'pjField', '1', 'title', 'Backup complete!', 'script'),
('226', '554', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('227', '555', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('228', '556', 'pjField', '1', 'title', 'Account not found!', 'script'),
('229', '557', 'pjField', '1', 'title', 'Password send!', 'script'),
('230', '558', 'pjField', '1', 'title', 'Password not send!', 'script'),
('231', '559', 'pjField', '1', 'title', 'Profile updated!', 'script'),
('232', '578', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('233', '579', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('234', '580', 'pjField', '1', 'title', 'We are sorry, but the user has not been added.', 'script'),
('235', '581', 'pjField', '1', 'title', 'User your looking for is missing.', 'script'),
('236', '582', 'pjField', '1', 'title', 'All the changes made to options have been saved.', 'script'),
('237', '589', 'pjField', '1', 'title', 'All the changes made to titles have been saved.', 'script'),
('238', '590', 'pjField', '1', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
('239', '591', 'pjField', '1', 'title', 'All backup files have been saved.', 'script'),
('240', '592', 'pjField', '1', 'title', 'No option was selected.', 'script'),
('241', '593', 'pjField', '1', 'title', 'Backup not performed.', 'script'),
('242', '594', 'pjField', '1', 'title', 'Given email address is not associated with any account.', 'script'),
('243', '595', 'pjField', '1', 'title', 'For further instructions please check your mailbox.', 'script'),
('244', '596', 'pjField', '1', 'title', 'We''re sorry, please try again later.', 'script'),
('245', '597', 'pjField', '1', 'title', 'All the changes made to your profile have been saved.', 'script'),
('246', '627', 'pjField', '1', 'title', 'January', 'script'),
('247', '628', 'pjField', '1', 'title', 'February', 'script'),
('248', '629', 'pjField', '1', 'title', 'March', 'script'),
('249', '630', 'pjField', '1', 'title', 'April', 'script'),
('250', '631', 'pjField', '1', 'title', 'May', 'script'),
('251', '632', 'pjField', '1', 'title', 'June', 'script'),
('252', '633', 'pjField', '1', 'title', 'July', 'script'),
('253', '634', 'pjField', '1', 'title', 'August', 'script'),
('254', '635', 'pjField', '1', 'title', 'September', 'script'),
('255', '636', 'pjField', '1', 'title', 'October', 'script'),
('256', '637', 'pjField', '1', 'title', 'November', 'script'),
('257', '638', 'pjField', '1', 'title', 'December', 'script'),
('258', '639', 'pjField', '1', 'title', 'Sunday', 'script'),
('259', '640', 'pjField', '1', 'title', 'Monday', 'script'),
('260', '641', 'pjField', '1', 'title', 'Tuesday', 'script'),
('261', '642', 'pjField', '1', 'title', 'Wednesday', 'script'),
('262', '643', 'pjField', '1', 'title', 'Thursday', 'script'),
('263', '644', 'pjField', '1', 'title', 'Friday', 'script'),
('264', '645', 'pjField', '1', 'title', 'Saturday', 'script'),
('265', '646', 'pjField', '1', 'title', 'S', 'script'),
('266', '647', 'pjField', '1', 'title', 'M', 'script'),
('267', '648', 'pjField', '1', 'title', 'T', 'script'),
('268', '649', 'pjField', '1', 'title', 'W', 'script'),
('269', '650', 'pjField', '1', 'title', 'T', 'script'),
('270', '651', 'pjField', '1', 'title', 'F', 'script'),
('271', '652', 'pjField', '1', 'title', 'S', 'script'),
('272', '653', 'pjField', '1', 'title', 'Jan', 'script'),
('273', '654', 'pjField', '1', 'title', 'Feb', 'script'),
('274', '655', 'pjField', '1', 'title', 'Mar', 'script'),
('275', '656', 'pjField', '1', 'title', 'Apr', 'script'),
('276', '657', 'pjField', '1', 'title', 'May', 'script'),
('277', '658', 'pjField', '1', 'title', 'Jun', 'script'),
('278', '659', 'pjField', '1', 'title', 'Jul', 'script'),
('279', '660', 'pjField', '1', 'title', 'Aug', 'script'),
('280', '661', 'pjField', '1', 'title', 'Sep', 'script'),
('281', '662', 'pjField', '1', 'title', 'Oct', 'script'),
('282', '663', 'pjField', '1', 'title', 'Nov', 'script'),
('283', '664', 'pjField', '1', 'title', 'Dec', 'script'),
('284', '665', 'pjField', '1', 'title', 'You are not loged in.', 'script'),
('285', '666', 'pjField', '1', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('286', '667', 'pjField', '1', 'title', 'Empty resultset.', 'script'),
('287', '668', 'pjField', '1', 'title', 'The operation is not allowed in demo mode.', 'script'),
('288', '669', 'pjField', '1', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('289', '670', 'pjField', '1', 'title', 'No permisions to edit the property', 'script'),
('290', '671', 'pjField', '1', 'title', 'No permisions to edit the reservation', 'script'),
('291', '672', 'pjField', '1', 'title', 'No reservation found', 'script'),
('292', '673', 'pjField', '1', 'title', 'No property for the reservation found', 'script'),
('293', '674', 'pjField', '1', 'title', 'Your registration was successfull.', 'script'),
('294', '675', 'pjField', '1', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('295', '676', 'pjField', '1', 'title', 'E-Mail address already exist', 'script'),
('296', '677', 'pjField', '1', 'title', 'Wrong username or password', 'script'),
('297', '678', 'pjField', '1', 'title', 'Access denied', 'script'),
('298', '679', 'pjField', '1', 'title', 'Account is disabled', 'script'),
('419', '907', 'pjField', '1', 'title', 'Arrays titles', 'script'),
('421', '908', 'pjField', '1', 'title', 'Languages Arrays Title', 'script'),
('423', '909', 'pjField', '1', 'title', 'Languages Array Body', 'script'),
('425', '910', 'pjField', '1', 'title', 'Back', 'script'),
('427', '982', 'pjField', '1', 'title', 'Order', 'script'),
('429', '983', 'pjField', '1', 'title', 'Is default', 'script'),
('431', '984', 'pjField', '1', 'title', 'Flag', 'script'),
('433', '985', 'pjField', '1', 'title', 'Title', 'script'),
('435', '986', 'pjField', '1', 'title', 'Delete', 'script'),
('437', '990', 'pjField', '1', 'title', 'Continue', 'script'),
('439', '992', 'pjField', '1', 'title', 'Email address is already in use', 'script'),
('441', '993', 'pjField', '1', 'title', 'Revert status', 'script'),
('443', '994', 'pjField', '1', 'title', 'Export', 'script'),
('667', '995', 'pjField', '1', 'title', 'Send email', 'script'),
('670', '996', 'pjField', '1', 'title', 'SMTP Host', 'script'),
('673', '997', 'pjField', '1', 'title', 'SMTP Port', 'script'),
('676', '998', 'pjField', '1', 'title', 'SMTP Username', 'script'),
('679', '999', 'pjField', '1', 'title', 'SMTP Password', 'script'),
('889', '1069', 'pjField', '1', 'title', 'Equipment', 'script'),
('892', '1070', 'pjField', '1', 'title', 'Count', 'script'),
('895', '1071', 'pjField', '1', 'title', 'Rent by', 'script'),
('898', '1072', 'pjField', '1', 'title', 'Name', 'script'),
('901', '1073', 'pjField', '1', 'title', 'Description', 'script'),
('904', '1074', 'pjField', '1', 'title', 'Rent by hour', 'script'),
('907', '1075', 'pjField', '1', 'title', 'Rent by day', 'script'),
('913', '1077', 'pjField', '1', 'title', 'Category', 'script'),
('916', '1078', 'pjField', '1', 'title', 'Categories', 'script'),
('919', '1079', 'pjField', '1', 'title', 'Title', 'script'),
('922', '1080', 'pjField', '1', 'title', 'Add category', 'script'),
('928', '1081', 'pjField', '1', 'title', 'Update category', 'script'),
('941', '1082', 'pjField', '1', 'title', 'Delete selected', 'script'),
('942', '1083', 'pjField', '1', 'title', 'Are you sure you want to delete selected records?', 'script'),
('943', '1084', 'pjField', '1', 'title', 'Category updated!', 'script'),
('944', '1085', 'pjField', '1', 'title', 'Category added!', 'script'),
('945', '1086', 'pjField', '1', 'title', 'Category failed to add.', 'script'),
('946', '1087', 'pjField', '1', 'title', 'Category not found.', 'script'),
('949', '1088', 'pjField', '1', 'title', 'All the changes made to this category have been saved.', 'script'),
('950', '1089', 'pjField', '1', 'title', 'All the changes made to this category have been saved.', 'script'),
('951', '1090', 'pjField', '1', 'title', 'We are sorry, but the category has not been added.', 'script'),
('952', '1091', 'pjField', '1', 'title', 'Category your looking for is missing.', 'script'),
('954', '1092', 'pjField', '1', 'title', 'Add item', 'script'),
('955', '1093', 'pjField', '1', 'title', 'Update item', 'script'),
('956', '1094', 'pjField', '1', 'title', 'Equipment item your looking for is missing.', 'script'),
('957', '1095', 'pjField', '1', 'title', 'We are sorry, but the equipment item has not been added.', 'script'),
('958', '1096', 'pjField', '1', 'title', 'All the changes made to this equipment item have been saved.', 'script'),
('959', '1097', 'pjField', '1', 'title', 'All the changes made to this equipment item have been saved.', 'script'),
('960', '1098', 'pjField', '1', 'title', 'Equipment item not found.', 'script'),
('961', '1099', 'pjField', '1', 'title', 'Equipment item failed to add.', 'script'),
('962', '1100', 'pjField', '1', 'title', 'Equipment item added!', 'script'),
('963', '1101', 'pjField', '1', 'title', 'Equipment item updated!', 'script'),
('992', '1102', 'pjField', '1', 'title', 'Add equipment', 'script'),
('993', '1103', 'pjField', '1', 'title', 'Fill in the form below to add a new equipment item. You can enter the number of items that you have available for renting. On the next step you can add price and additional information about it.', 'script'),
('994', '1104', 'pjField', '1', 'title', 'Add photos', 'script'),
('995', '1105', 'pjField', '1', 'title', 'Use upload button to upload photos', 'script'),
('996', '1106', 'pjField', '1', 'title', 'Working Time', 'script'),
('997', '1107', 'pjField', '1', 'title', 'Install', 'script'),
('998', '1108', 'pjField', '1', 'title', 'Preview', 'script'),
('999', '1109', 'pjField', '1', 'title', 'General', 'script'),
('1000', '1110', 'pjField', '1', 'title', 'Reservations', 'script'),
('1001', '1111', 'pjField', '1', 'title', 'Payments', 'script'),
('1002', '1112', 'pjField', '1', 'title', 'Booking form', 'script'),
('1003', '1113', 'pjField', '1', 'title', 'Confirmation', 'script'),
('1004', '1114', 'pjField', '1', 'title', 'Terms', 'script'),
('1005', '1124', 'pjField', '1', 'title', 'Address 1', 'script'),
('1008', '1125', 'pjField', '1', 'title', 'Captcha', 'script'),
('1011', '1386', 'pjField', '1', 'title', 'City', 'script'),
('1014', '1387', 'pjField', '1', 'title', 'Email', 'script'),
('1017', '1388', 'pjField', '1', 'title', 'Name', 'script'),
('1020', '1389', 'pjField', '1', 'title', 'Notes', 'script'),
('1023', '1390', 'pjField', '1', 'title', 'Phone', 'script'),
('1026', '1391', 'pjField', '1', 'title', 'State', 'script'),
('1029', '1392', 'pjField', '1', 'title', 'Terms', 'script'),
('1032', '1393', 'pjField', '1', 'title', 'Zip', 'script'),
('1035', '1394', 'pjField', '1', 'title', 'Country', 'script'),
('1038', '1395', 'pjField', '1', 'title', 'Paypal address', 'script'),
('1041', '1396', 'pjField', '1', 'title', 'Accept Reservations', 'script'),
('1044', '1397', 'pjField', '1', 'title', 'Allow payments with Authorize.net', 'script'),
('1047', '1398', 'pjField', '1', 'title', 'Allow payments with Bank account', 'script'),
('1050', '1399', 'pjField', '1', 'title', 'Allow payments with Credit Card', 'script'),
('1053', '1400', 'pjField', '1', 'title', 'Allow payments with PayPal', 'script'),
('1056', '1401', 'pjField', '1', 'title', 'Authorize.net transaction key', 'script'),
('1059', '1402', 'pjField', '1', 'title', 'Authorize.net merchant ID', 'script'),
('1062', '1403', 'pjField', '1', 'title', 'Bank account', 'script'),
('1065', '1404', 'pjField', '1', 'title', 'Deposit', 'script'),
('1068', '1405', 'pjField', '1', 'title', 'Disable payments', 'script'),
('1074', '1407', 'pjField', '1', 'title', 'Require 100% if the reservations is within X days', 'script'),
('1077', '1408', 'pjField', '1', 'title', 'Security deposit payment', 'script'),
('1080', '1409', 'pjField', '1', 'title', 'Default status for booked dates if not paid', 'script'),
('1083', '1410', 'pjField', '1', 'title', 'Default status for booked dates if paid', 'script'),
('1086', '1411', 'pjField', '1', 'title', 'Tax payment', 'script'),
('1089', '1412', 'pjField', '1', 'title', '"Thank you" page location', 'script'),
('1092', '1413', 'pjField', '1', 'title', 'Authorize.net time zone', 'script'),
('1095', '1414', 'pjField', '1', 'title', 'New reservation received', 'script'),
('1098', '1415', 'pjField', '1', 'title', 'Reservation cancelled', 'script'),
('1101', '1416', 'pjField', '1', 'title', 'Password reminder', 'script'),
('1110', '1486', 'pjField', '1', 'title', 'Address 2', 'script'),
('2071', '1417', 'pjField', '1', 'title', 'Booking terms URL', 'script'),
('2074', '1418', 'pjField', '1', 'title', 'Booking terms content', 'script'),
('2077', '1419', 'pjField', '1', 'title', 'Booking form', 'script'),
('2080', '1420', 'pjField', '1', 'title', 'Confirmation', 'script'),
('2083', '1421', 'pjField', '1', 'title', 'Terms and Confirmations', 'script'),
('2086', '1422', 'pjField', '1', 'title', 'Choose the fields that should be available on the booking form.', 'script'),
('2089', '1423', 'pjField', '1', 'title', 'Email notifications will be sent to people who make a reservation after reservation form is completed or/and payment is made. Suppored tokens to be used in the email are: {Name} - The customer''s name; {Phone} - The customer''s phone number; {Email} - The customer''s e-mail; {Notes} - Any additional notes; {Address1} - The provided address 1; {Address2} - The provided address 2; {City} - The provided city; {State} - The provided state; {Zip} - The provided zip code; {Country} - The provided country; {Back} - How will you return the equipment?; {Forth} - How do you get the equipment?; {CCType} - The provided CC type; {CCNum} - The provided CC number; {CCExpMonth} - The provided CC exp.month; {CCExpYear} - The provided CC exp.year; {CCSec} - The provided CC sec. code; {PaymentMethod} - The payment method; {Deposit} - Deposit; {Tax} - Tax; {Security} - Security; {Total} - Total amount; {DtFrom} - Booking''s start date/time; {DtTo} - Booking''s end date/time; {BookingID} - Booking''s ID; {BookingUUID} - Booking''s UUID', 'script'),
('2092', '1424', 'pjField', '1', 'title', 'Enter booking terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
('2101', '1427', 'pjField', '1', 'title', 'Payment email', 'script'),
('2107', '1429', 'pjField', '1', 'title', 'Supported tokens are:\r\n{Name} - The customer''s name\r\n{Phone} - The customer''s phone number\r\n{Email} - The customer''s e-mail\r\n{Notes} - Any additional notes\r\n{Address1} - The provided address 1\r\n{Address2} - The provided address 2\r\n{City} - The provided city\r\n{State} - The provided state\r\n{Zip} - The provided zip code\r\n{Country} - The provided country\r\n{Back} - How will you return the equipment?\r\n{Forth} - How do you get the equipment?\r\n{CCType} - The provided CC type\r\n{CCNum} - The provided CC number\r\n{CCExpMonth} - The provided CC exp.month\r\n{CCExpYear} - The provided CC exp.year\r\n{CCSec} - The provided CC sec. code\r\n{PaymentMethod} - The payment method\r\n{Deposit} - Deposit\r\n{Security} - Security\r\n{Tax} - Tax\r\n{Total} - Total amount\r\n{DtFrom} - Booking''s start date/time\r\n{DtTo} - Booking''s end date/time\r\n{BookingID} - Booking''s ID\r\n{BookingUUID} - Booking''s UUID', 'script'),
('2110', '1426', 'pjField', '1', 'title', 'Confirmation email', 'script'),
('2113', '1428', 'pjField', '1', 'title', 'Supported tokens are:\r\n{Name} - The customer''s name\r\n{Phone} - The customer''s phone number\r\n{Email} - The customer''s e-mail\r\n{Notes} - Any additional notes\r\n{Address1} - The provided address 1\r\n{Address2} - The provided address 2\r\n{City} - The provided city\r\n{State} - The provided state\r\n{Zip} - The provided zip code\r\n{Country} - The provided country\r\n{Back} - How will you return the equipment?\r\n{Forth} - How do you get the equipment?\r\n{CCType} - The provided CC type\r\n{CCNum} - The provided CC number\r\n{CCExpMonth} - The provided CC exp.month\r\n{CCExpYear} - The provided CC exp.year\r\n{CCSec} - The provided CC sec. code\r\n{PaymentMethod} - The payment method\r\n{Deposit} - Deposit\r\n{Security} - Security\r\n{Tax} - Tax\r\n{Total} - Total amount\r\n{DtFrom} - Booking''s start date/time\r\n{DtTo} - Booking''s end date/time\r\n{BookingID} - Booking''s ID\r\n{BookingUUID} - Booking''s UUID', 'script'),
('2116', '1488', 'pjField', '1', 'title', 'Working Time', 'script'),
('2117', '1489', 'pjField', '1', 'title', 'Set up working time used for Pick-up/Delivery & Return/Collection\r\n', 'script'),
('2118', '1490', 'pjField', '1', 'title', 'Default', 'script'),
('2119', '1491', 'pjField', '1', 'title', 'Custom', 'script'),
('2120', '1492', 'pjField', '1', 'title', 'Day of week', 'script'),
('2121', '1493', 'pjField', '1', 'title', 'Start Time', 'script'),
('2122', '1494', 'pjField', '1', 'title', 'End Time', 'script'),
('2123', '1495', 'pjField', '1', 'title', 'Is Day off', 'script'),
('2124', '1496', 'pjField', '1', 'title', 'Date', 'script'),
('2125', '1497', 'pjField', '1', 'title', 'All', 'script'),
('2126', '1498', 'pjField', '1', 'title', 'Update custom', 'script'),
('2127', '1499', 'pjField', '1', 'title', 'Prices', 'script'),
('2128', '1500', 'pjField', '1', 'title', 'Details', 'script'),
('2129', '1501', 'pjField', '1', 'title', 'Photos', 'script'),
('2130', '1502', 'pjField', '1', 'title', 'hour', 'script'),
('2131', '1503', 'pjField', '1', 'title', 'Rent period', 'script'),
('2133', '1504', 'pjField', '1', 'title', 'day', 'script'),
('2134', '1505', 'pjField', '1', 'title', 'From', 'script'),
('2135', '1506', 'pjField', '1', 'title', 'To', 'script'),
('2136', '1507', 'pjField', '1', 'title', 'Length', 'script'),
('2137', '1508', 'pjField', '1', 'title', 'Price', 'script'),
('2138', '1509', 'pjField', '1', 'title', 'per hour', 'script'),
('2139', '1510', 'pjField', '1', 'title', 'per day', 'script'),
('2140', '1511', 'pjField', '1', 'title', 'hours', 'script'),
('2141', '1512', 'pjField', '1', 'title', 'days', 'script'),
('2152', '1513', 'pjField', '1', 'title', 'Delete confirmation', 'script'),
('2153', '1514', 'pjField', '1', 'title', 'Are you sure you want to delete selected price?', 'script'),
('2158', '1515', 'pjField', '1', 'title', 'Availability', 'script'),
('2159', '1516', 'pjField', '1', 'title', 'Add availability', 'script'),
('2194', '1517', 'pjField', '1', 'title', 'Available', 'script'),
('2196', '1518', 'pjField', '1', 'title', 'Not available', 'script'),
('2201', '1519', 'pjField', '1', 'title', 'Available', 'script'),
('2202', '1520', 'pjField', '1', 'title', 'Not available', 'script'),
('2203', '1521', 'pjField', '1', 'title', 'Past day', 'script'),
('2204', '1522', 'pjField', '1', 'title', 'Packages', 'script'),
('2205', '1523', 'pjField', '1', 'title', 'Add package', 'script'),
('2206', '1524', 'pjField', '1', 'title', 'Update package', 'script'),
('2207', '1525', 'pjField', '1', 'title', 'Prices', 'script'),
('2208', '1526', 'pjField', '1', 'title', 'Name', 'script'),
('2209', '1527', 'pjField', '1', 'title', 'Details', 'script'),
('2215', '1528', 'pjField', '1', 'title', 'Items', 'script'),
('2224', '1529', 'pjField', '1', 'title', 'Package updated!', 'script'),
('2225', '1530', 'pjField', '1', 'title', 'Package added!', 'script'),
('2226', '1531', 'pjField', '1', 'title', 'Package failed to add.', 'script'),
('2227', '1532', 'pjField', '1', 'title', 'Package not found.', 'script'),
('2228', '1533', 'pjField', '1', 'title', 'All the changes made to this package have been saved.', 'script'),
('2229', '1534', 'pjField', '1', 'title', 'All the changes made to this package have been saved.', 'script'),
('2230', '1535', 'pjField', '1', 'title', 'We are sorry, but the package has not been added.', 'script'),
('2231', '1536', 'pjField', '1', 'title', 'Package your looking for is missing.', 'script'),
('2232', '1537', 'pjField', '1', 'title', 'Create a package', 'script'),
('2233', '1538', 'pjField', '1', 'title', 'Enter package name and select the equipment that will be included. On next step you will be able to set up price for the package.', 'script'),
('2267', '1539', 'pjField', '1', 'title', 'Add reservation', 'script'),
('2268', '1540', 'pjField', '1', 'title', 'Confirmed', 'script'),
('2269', '1541', 'pjField', '1', 'title', 'Pending', 'script'),
('2270', '1542', 'pjField', '1', 'title', 'Cancelled', 'script'),
('2271', '1543', 'pjField', '1', 'title', 'Unique ID', 'script'),
('2272', '1544', 'pjField', '1', 'title', 'Date/Time from', 'script'),
('2273', '1545', 'pjField', '1', 'title', 'Date/Time to', 'script'),
('2274', '1546', 'pjField', '1', 'title', 'Status', 'script'),
('2275', '1547', 'pjField', '1', 'title', 'Items', 'script'),
('2276', '1548', 'pjField', '1', 'title', 'Update reservation', 'script'),
('2277', '1549', 'pjField', '1', 'title', 'Date/Time format', 'script'),
('2278', '1550', 'pjField', '1', 'title', 'Created', 'script'),
('2279', '1551', 'pjField', '1', 'title', 'Total', 'script'),
('2280', '1552', 'pjField', '1', 'title', 'Deposit', 'script'),
('2281', '1553', 'pjField', '1', 'title', 'Tax', 'script'),
('2282', '1554', 'pjField', '1', 'title', 'Security', 'script'),
('2283', '1555', 'pjField', '1', 'title', 'Price', 'script'),
('2284', '1556', 'pjField', '1', 'title', 'Payment method', 'script'),
('2285', '1557', 'pjField', '1', 'title', 'Authorize.net', 'script'),
('2286', '1558', 'pjField', '1', 'title', 'Bank account', 'script'),
('2287', '1559', 'pjField', '1', 'title', 'Cash on delivery', 'script'),
('2288', '1560', 'pjField', '1', 'title', 'Credit card', 'script'),
('2289', '1561', 'pjField', '1', 'title', 'Paypal', 'script'),
('2290', '1562', 'pjField', '1', 'title', '-- Choose --', 'script'),
('2292', '1563', 'pjField', '1', 'title', 'Booking details', 'script'),
('2293', '1564', 'pjField', '1', 'title', 'Details', 'script'),
('2294', '1565', 'pjField', '1', 'title', 'Client', 'script'),
('2295', '1566', 'pjField', '1', 'title', 'Country', 'script'),
('2296', '1567', 'pjField', '1', 'title', 'State', 'script'),
('2297', '1568', 'pjField', '1', 'title', 'City', 'script'),
('2298', '1569', 'pjField', '1', 'title', 'Zip', 'script'),
('2299', '1570', 'pjField', '1', 'title', 'Name', 'script'),
('2300', '1571', 'pjField', '1', 'title', 'Address Line 1', 'script'),
('2301', '1572', 'pjField', '1', 'title', 'Address Line 2', 'script'),
('2302', '1573', 'pjField', '1', 'title', 'Notes', 'script'),
('2303', '1574', 'pjField', '1', 'title', 'Customer details', 'script'),
('2577', '1575', 'pjField', '1', 'title', 'Countries', 'script'),
('2578', '1576', 'pjField', '1', 'title', 'Country', 'script'),
('2831', '1829', 'pjField', '1', 'title', 'Create Invoice', 'script'),
('2832', '1830', 'pjField', '1', 'title', 'Item', 'script'),
('2833', '1831', 'pjField', '1', 'title', 'Qty', 'script'),
('2834', '1832', 'pjField', '1', 'title', 'Price', 'script'),
('2835', '1833', 'pjField', '1', 'title', 'Subtotal', 'script'),
('2836', '1834', 'pjField', '1', 'title', 'No items found', 'script'),
('2837', '1835', 'pjField', '1', 'title', 'Invoice details', 'script'),
('2838', '1837', 'pjField', '1', 'title', 'Email', 'script'),
('2839', '1838', 'pjField', '1', 'title', 'Phone', 'script'),
('2841', '1840', 'pjField', '1', 'title', 'Visa', 'script'),
('2842', '1841', 'pjField', '1', 'title', 'MasterCard', 'script'),
('2843', '1842', 'pjField', '1', 'title', 'AmericanExpress', 'script'),
('2844', '1843', 'pjField', '1', 'title', 'Maestro', 'script'),
('2845', '1844', 'pjField', '1', 'title', 'CC Type', 'script'),
('2846', '1845', 'pjField', '1', 'title', 'CC Number', 'script'),
('2847', '1846', 'pjField', '1', 'title', 'CC Code', 'script'),
('2848', '1847', 'pjField', '1', 'title', 'CC Exp.date', 'script'),
('2849', '1848', 'pjField', '1', 'title', 'Booking added', 'script'),
('2850', '1849', 'pjField', '1', 'title', 'Booking failed to add', 'script'),
('2851', '1850', 'pjField', '1', 'title', 'Booking updated', 'script'),
('2852', '1851', 'pjField', '1', 'title', 'Booking not found', 'script'),
('2853', '1852', 'pjField', '1', 'title', 'Booking has been added successfully.', 'script'),
('2854', '1853', 'pjField', '1', 'title', 'Booking has not been added for some reason. Please try again.', 'script'),
('2855', '1854', 'pjField', '1', 'title', 'Booking has been updated successfully.', 'script'),
('2856', '1855', 'pjField', '1', 'title', 'Booking you''re looking for has not been found.', 'script'),
('2857', '1856', 'pjField', '1', 'title', 'New reservation', 'script'),
('2858', '1857', 'pjField', '1', 'title', 'Use the form below to add details about the reservation. Under the Clients tab you can add information about the customer.', 'script'),
('2861', '1858', 'pjField', '1', 'title', 'Customer details', 'script'),
('2862', '1859', 'pjField', '1', 'title', 'Add information about your customer.', 'script'),
('2863', '1861', 'pjField', '1', 'title', 'Update reservation', 'script'),
('2864', '1862', 'pjField', '1', 'title', 'Update reservation details using the form below. Under the Client tab you can view and update customer''s details.', 'script'),
('2866', '1863', 'pjField', '1', 'title', 'Customer details', 'script'),
('2867', '1864', 'pjField', '1', 'title', 'Update information about your customer.', 'script'),
('4168', '1894', 'pjField', '1', 'title', 'Authorize.net hash value', 'script'),
('4188', '1896', 'pjField', '1', 'title', 'Select Payment method', 'script'),
('4189', '1897', 'pjField', '1', 'title', 'Select CC Type', 'script'),
('4190', '1898', 'pjField', '1', 'title', 'Delivery tax', 'script'),
('4192', '1899', 'pjField', '1', 'title', 'How do you get the equipment?', 'script'),
('4193', '1900', 'pjField', '1', 'title', 'How will you return the equipment?', 'script'),
('4194', '1901', 'pjField', '1', 'title', 'Pick-up', 'script'),
('4195', '1902', 'pjField', '1', 'title', 'Delivery', 'script'),
('4196', '1903', 'pjField', '1', 'title', 'Return', 'script'),
('4197', '1904', 'pjField', '1', 'title', 'Collection', 'script'),
('4198', '1905', 'pjField', '1', 'title', 'Missing parameters.', 'script'),
('4199', '1906', 'pjField', '1', 'title', 'Missing or wrong captcha.', 'script'),
('4200', '1907', 'pjField', '1', 'title', 'Booking contains invalid data.', 'script'),
('4201', '1908', 'pjField', '1', 'title', 'Booking has not been stored.', 'script'),
('4202', '1909', 'pjField', '1', 'title', 'Booking has been stored.', 'script'),
('4203', '1910', 'pjField', '1', 'title', 'Checkout form has been submitted.', 'script'),
('4204', '1911', 'pjField', '1', 'title', 'Cart form has been submitted.', 'script'),
('4205', '1912', 'pjField', '1', 'title', 'Equipment has been added to the cart.', 'script'),
('4206', '1913', 'pjField', '1', 'title', 'Equipment has not been added to the cart.', 'script'),
('4207', '1914', 'pjField', '1', 'title', 'Equipment has been removed from the cart.', 'script'),
('4208', '1915', 'pjField', '1', 'title', 'Equipment has not been removed from the cart.', 'script'),
('4209', '1916', 'pjField', '1', 'title', 'Cart has not been emptied.', 'script'),
('4210', '1917', 'pjField', '1', 'title', 'Cart has been emptied.', 'script'),
('4211', '1918', 'pjField', '1', 'title', 'Cart has not been updated.', 'script'),
('4212', '1919', 'pjField', '1', 'title', 'Cart has been updated.', 'script'),
('4214', '1920', 'pjField', '1', 'title', 'Rental Start Date/Time', 'script'),
('4215', '1921', 'pjField', '1', 'title', 'Rental End Date/Time', 'script'),
('4216', '1922', 'pjField', '1', 'title', 'Check Availability and Price', 'script'),
('4217', '1923', 'pjField', '1', 'title', 'Number of items', 'script'),
('4218', '1924', 'pjField', '1', 'title', 'Total price', 'script'),
('4219', '1925', 'pjField', '1', 'title', 'Continue', 'script'),
('4220', '1926', 'pjField', '1', 'title', 'change dates', 'script'),
('4221', '1927', 'pjField', '1', 'title', 'Not available', 'script'),
('4222', '1928', 'pjField', '1', 'title', 'Number of packages', 'script'),
('4223', '1929', 'pjField', '1', 'title', 'Your request has been sent successfully. Thank you.', 'script'),
('4224', '1930', 'pjField', '1', 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
('4225', '1931', 'pjField', '1', 'title', 'Items', 'script'),
('4226', '1932', 'pjField', '1', 'title', 'Packages', 'script'),
('4227', '1933', 'pjField', '1', 'title', 'Basket', 'script'),
('4232', '1934', 'pjField', '1', 'title', 'Curabitur imperdiet blandit arcu eu imperdiet. Suspendisse justo lectus, convallis at arcu in, elementum luctus ligula.\r\n\r\nAenean facilisis ac justo ut cursus. Phasellus nulla leo, interdum in suscipit id, convallis id turpis.', 'script'),
('4233', '1935', 'pjField', '1', 'title', 'Remove', 'script'),
('4234', '1936', 'pjField', '1', 'title', 'Checkout', 'script'),
('4235', '1937', 'pjField', '1', 'title', 'Price', 'script'),
('4239', '1938', 'pjField', '1', 'title', 'You have not any equipment in your basket yet.', 'script'),
('4240', '1939', 'pjField', '1', 'title', 'Back', 'script'),
('4241', '1940', 'pjField', '1', 'title', 'Please go back to your basket.', 'script'),
('4242', '1941', 'pjField', '1', 'title', 'Preview Booking', 'script'),
('4243', '1942', 'pjField', '1', 'title', 'Captcha', 'script'),
('4244', '1943', 'pjField', '1', 'title', 'I agree with terms and conditions', 'script'),
('4245', '1944', 'pjField', '1', 'title', 'Equipment item not found', 'script'),
('4248', '1945', 'pjField', '1', 'title', 'Select Country', 'script'),
('4249', '1946', 'pjField', '1', 'title', 'Category', 'script'),
('4250', '1947', 'pjField', '1', 'title', 'No equipment items found', 'script'),
('4251', '1948', 'pjField', '1', 'title', 'Prev', 'script'),
('4252', '1949', 'pjField', '1', 'title', 'Next', 'script'),
('4253', '1950', 'pjField', '1', 'title', 'Price', 'script'),
('4254', '1951', 'pjField', '1', 'title', 'N/A', 'script'),
('4256', '1952', 'pjField', '1', 'title', 'Equipment package not found', 'script'),
('4257', '1953', 'pjField', '1', 'title', 'No equipment packages found', 'script'),
('4258', '1954', 'pjField', '1', 'title', 'Confirm Booking', 'script'),
('4259', '1955', 'pjField', '1', 'title', 'Please go back and fill out the checkout form.', 'script'),
('4260', '1956', 'pjField', '1', 'title', 'Go to PayPal Secure page', 'script'),
('4261', '1957', 'pjField', '1', 'title', 'Go to Authorize.NET Secure page', 'script'),
('4262', '1958', 'pjField', '1', 'title', 'Equipment Rent', 'script'),
('4263', '1959', 'pjField', '1', 'title', 'Equipment Rent', 'script'),
('4264', '1960', 'pjField', '1', 'title', 'Install instructions', 'script'),
('4265', '1961', 'pjField', '1', 'title', 'Copy the code below and put it on the web page where you want equipment rent script to appear. If you have a multi language equipment rent script you can select the default language and to hide the language selector.', 'script'),
('4269', '1965', 'pjField', '1', 'title', 'Last login', 'script'),
('4270', '1966', 'pjField', '1', 'title', 'bookings today', 'script'),
('4271', '1967', 'pjField', '1', 'title', 'Items available on this date', 'script'),
('4272', '1968', 'pjField', '1', 'title', 'Unit price', 'script'),
('4273', '1969', 'pjField', '1', 'title', 'Payment options updated!', 'script'),
('4274', '1970', 'pjField', '1', 'title', 'All the changes made to payment options have been saved.', 'script'),
('4275', '1971', 'pjField', '1', 'title', 'All the changes made to booking options have been saved.', 'script'),
('4276', '1972', 'pjField', '1', 'title', 'Booking options updated!', 'script'),
('4277', '1973', 'pjField', '1', 'title', 'Booking form options updated!', 'script'),
('4278', '1974', 'pjField', '1', 'title', 'All the changes made to booking form options have been saved.', 'script'),
('4279', '1975', 'pjField', '1', 'title', 'All the changes made to confirmation have been saved.', 'script'),
('4280', '1976', 'pjField', '1', 'title', 'Confirmation updated!', 'script'),
('4281', '1977', 'pjField', '1', 'title', 'All the changes made to terms have been saved.', 'script'),
('4282', '1978', 'pjField', '1', 'title', 'Terms updated!', 'script'),
('4283', '1979', 'pjField', '1', 'title', 'Working Time updated!', 'script'),
('4284', '1980', 'pjField', '1', 'title', 'All the changes made to working time have been saved.', 'script'),
('4285', '1981', 'pjField', '1', 'title', 'Custom Working Time saved!', 'script'),
('4286', '1982', 'pjField', '1', 'title', 'All the changes made to custom working time have been saved.', 'script'),
('4287', '1983', 'pjField', '1', 'title', 'Custom Working Time updated!', 'script'),
('4288', '1984', 'pjField', '1', 'title', 'All the changes made to custom working time have been saved.', 'script'),
('4289', '1985', 'pjField', '1', 'title', 'General options', 'script'),
('4290', '1986', 'pjField', '1', 'title', 'Set-up general settings', 'script'),
('4291', '1987', 'pjField', '1', 'title', 'Booking options', 'script'),
('4292', '1988', 'pjField', '1', 'title', 'Set-up booking options.', 'script'),
('4293', '1989', 'pjField', '1', 'title', 'Booking payment options', 'script'),
('4294', '1990', 'pjField', '1', 'title', 'Set-up booking payment options.', 'script'),
('4295', '1991', 'pjField', '1', 'title', 'Add category', 'script'),
('4296', '1992', 'pjField', '1', 'title', 'Use form below to add a new category.', 'script'),
('4297', '1993', 'pjField', '1', 'title', 'Update category', 'script'),
('4298', '1994', 'pjField', '1', 'title', 'Use form below to update custom category.', 'script'),
('4299', '1996', 'pjField', '1', 'title', 'Add user', 'script'),
('4300', '1997', 'pjField', '1', 'title', 'Use form below to add an user.', 'script'),
('4301', '1998', 'pjField', '1', 'title', 'Update user', 'script'),
('4302', '1999', 'pjField', '1', 'title', 'Use form below to update an user.', 'script'),
('4303', '2000', 'pjField', '1', 'title', 'from', 'script'),
('4304', '2001', 'pjField', '1', 'title', 'to', 'script'),
('4305', '2002', 'pjField', '1', 'title', 'clear date/time', 'script'),
('4306', '2003', 'pjField', '1', 'title', 'Image', 'script'),
('4307', '2004', 'pjField', '1', 'title', 'Collection tax', 'script'),
('4308', '2006', 'pjField', '1', 'title', 'The items in your basket will be removed!', 'script'),
('4309', '2007', 'pjField', '1', 'title', 'OK', 'script'),
('4310', '2008', 'pjField', '1', 'title', 'CANCEL', 'script'),
('4311', '2009', 'pjField', '1', 'title', 'Clear date & time', 'script'),
('4312', '2011', 'pjField', '1', 'title', 'Check availability & title', 'script'),
('4313', '2012', 'pjField', '1', 'title', 'Tax', 'script'),
('4314', '2013', 'pjField', '1', 'title', 'Security deposit', 'script'),
('4315', '2015', 'pjField', '1', 'title', 'Deposit payment', 'script'),
('4316', '2016', 'pjField', '1', 'title', 'Total price', 'script'),
('4317', '2017', 'pjField', '1', 'title', 'Item(s) price', 'script'),
('4318', '2018', 'pjField', '1', 'title', 'Delivery & Collection', 'script'),
('4319', '2019', 'pjField', '1', 'title', 'Some of the items in your basket is no longer available.', 'script'),
('4320', '2020', 'pjField', '1', 'title', 'Item is no longer available', 'script'),
('4321', '2021', 'pjField', '1', 'title', 'Use categories', 'script'),
('4322', '2022', 'pjField', '1', 'title', 'Change the details for your equipment. You can enter the number of items that you have available for renting.', 'script'),
('4323', '2023', 'pjField', '1', 'title', 'Edit equipment', 'script'),
('4324', '2024', 'pjField', '1', 'title', 'Set price', 'script'),
('4325', '2025', 'pjField', '1', 'title', 'You can allow daily or hourly booking for your equipment. Set a default hourly and/or daily price and under the ''Special prices'' section set discounts based on date range or length of reservation.', 'script'),
('4326', '2026', 'pjField', '1', 'title', 'Change availability', 'script'),
('4327', '2027', 'pjField', '1', 'title', 'Use the form below to set the equipment as unavailable for specific dates. Clients will not be able to book it.', 'script'),
('4328', '2028', 'pjField', '1', 'title', 'Package details', 'script'),
('4329', '2029', 'pjField', '1', 'title', 'Enter package name and select the equipment that will be included. ', 'script'),
('4330', '2030', 'pjField', '1', 'title', 'Set price', 'script'),
('4331', '2031', 'pjField', '1', 'title', 'You can allow daily or hourly booking for your equipment. Set a default hourly and/or daily price and under the ''Special prices'' section set discounts based on date range or length of reservation.', 'script'),
('4332', '2032', 'pjField', '1', 'title', 'Price per hour', 'script'),
('4333', '2033', 'pjField', '1', 'title', 'Price per day', 'script'),
('4334', '2034', 'pjField', '1', 'title', 'Default prices', 'script'),
('4335', '2035', 'pjField', '1', 'title', 'Special prices', 'script'),
('4336', '2036', 'pjField', '1', 'title', 'Client - booking confirmation email', 'script'),
('4337', '2037', 'pjField', '1', 'title', 'Client - payment confirmation email', 'script'),
('4338', '2038', 'pjField', '1', 'title', 'Admin - booking confirmation email', 'script'),
('4339', '2039', 'pjField', '1', 'title', 'Admin - payment confirmation email', 'script'),
('4340', '2040', 'pjField', '1', 'title', 'Subject', 'script'),
('4341', '2041', 'pjField', '1', 'title', 'Email body', 'script'),
('4342', '2042', 'pjField', '1', 'title', 'SEO', 'script'),
('4343', '2043', 'pjField', '1', 'title', 'Step 1. Webpage where your front end shopping cart is', 'script'),
('4344', '2044', 'pjField', '1', 'title', 'Step 2. Put the meta tag below between <head> and </head> tags on your web page', 'script'),
('4345', '2045', 'pjField', '1', 'title', 'Step 3. Create .htaccess file (or update existing one) in the folder where your web page is and put the data below in it', 'script'),
('4346', '2046', 'pjField', '1', 'title', 'SEO Optimization', 'script'),
('4347', '2047', 'pjField', '1', 'title', 'To better optimize your time slots calendar please follow the steps below', 'script'),
('4348', '2048', 'pjField', '1', 'title', 'Items', 'script'),
('4349', '2049', 'pjField', '1', 'title', 'Below you can find a list with all items that your clients can book.', 'script'),
('4350', '2050', 'pjField', '1', 'title', 'Equipment packages', 'script'),
('4351', '2051', 'pjField', '1', 'title', 'You can create packages with your equipment. This way you can offer a special price for booking multiple items. ', 'script'),
('4352', '2052', 'pjField', '1', 'title', 'Categories', 'script'),
('4353', '2053', 'pjField', '1', 'title', 'You can create different categories for your equipment  and organize all items.', 'script'),
('4354', '2054', 'pjField', '1', 'title', 'Users list', 'script'),
('4355', '2055', 'pjField', '1', 'title', 'Search with ease through your users list.', 'script'),
('4356', '2056', 'pjField', '1', 'title', 'Terms and Conditions', 'script'),
('4357', '2057', 'pjField', '1', 'title', 'I have read and agree to the Booking Conditions', 'script'),
('4358', '2058', 'pjField', '1', 'title', 'Read terms and conditions', 'script'),
('4359', '2059', 'pjField', '1', 'title', 'Latest booked items', 'script'),
('4360', '2060', 'pjField', '1', 'title', 'Latest Bookings', 'script'),
('4361', '2061', 'pjField', '1', 'title', 'Last logged', 'script'),
('4362', '2062', 'pjField', '1', 'title', 'users', 'script'),
('4363', '2063', 'pjField', '1', 'title', 'user', 'script'),
('4364', '2064', 'pjField', '1', 'title', 'bookings', 'script'),
('4365', '2065', 'pjField', '1', 'title', 'booking', 'script'),
('4366', '2066', 'pjField', '1', 'title', 'items', 'script'),
('4367', '2067', 'pjField', '1', 'title', 'item', 'script'),
('4368', '2068', 'pjField', '1', 'title', 'Category', 'script'),
('4369', '2069', 'pjField', '1', 'title', 'Query', 'script'),
('4370', '2070', 'pjField', '1', 'title', 'Packages', 'script'),
('4371', '2071', 'pjField', '1', 'title', 'Start Over', 'script'),
('4372', '2072', 'pjField', '1', 'title', '+ Add item', 'script'),
('4373', '2073', 'pjField', '1', 'title', 'Recalculate the price', 'script'),
('4374', '2074', 'pjField', '1', 'title', 'Bank account', 'script'),
('4375', '2075', 'pjField', '1', 'title', 'Booking not available', 'script'),
('4376', '2076', 'pjField', '1', 'title', 'Return back', 'script'),
('4377', '2077', 'pjField', '1', 'title', 'If your web page hasn''t yet a valid doctype, copy and paste next line at the very top of your web page.', 'script'),
('4378', '2078', 'pjField', '1', 'title', 'If your web page hasn''t yet a viewport meta tag, copy and paste next line in the HEAD part on your web page.', 'script'),
('4379', '2079', 'pjField', '1', 'title', 'Allow payments with Cash on Delivery', 'script'),
('4380', '2080', 'pjField', '1', 'title', 'Unique ID you''re trying to use is already in use.', 'script'),
('4381', '2081', 'pjField', '1', 'title', 'Duplicate Unique ID', 'script'),
('4382', '2082', 'pjField', '1', 'title', 'There are bookings for the item that you want to delete. Instead of deleting it, its status will be changed to Inactive.', 'script'),
('4383', '2083', 'pjField', '1', 'title', 'There are bookings for the package that you want to delete. Instead of deleting it, its status will be changed to Inactive.', 'script'),
('4384', '2084', 'pjField', '1', 'title', 'Duplicated Unique ID. Please change it.', 'script');