<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjBookingItemModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'bookings_items';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'booking_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'foreign_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'type', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'qty', 'type' => 'smallint', 'default' => ':NULL'),
		array('name' => 'unit_price', 'type' => 'decimal', 'default' => ':NULL')
	);
	
	protected $validate = array(
		'rules' => array(
			'booking_id' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			),
			'foreign_id' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			),
			'type' => array(
				'pjActionCustom' => array('/item|package/'),
				'pjActionNotEmpty' => true,
				'pjActionRequired' => true
			),
			'qty' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			),
			'unit_price' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			)
		)
	);
	
	public static function factory($attr=array())
	{
		return new pjBookingItemModel($attr);
	}
}
?>