<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat reservations">
				<div class="info">
					<abbr><?php echo (int) @$tpl['cnt_today_bookings']; ?> <span><?php __('lblDashNew');?></span></abbr>
					<?php (int) @$tpl['cnt_today_bookings'] !== 1 ? __('lblReservationsToday') : __('lblReservationToday'); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat items">
				<div class="info">
					<abbr><?php echo (int) @$tpl['cnt_ongoing']; ?> <span><?php echo mb_strtolower(__('lblDashOngoing', true), 'UTF-8');?></span></abbr>
					<?php (int) @$tpl['cnt_ongoing'] !== 1 ? __('lblDashReservationsToday') : __('lblDashReservationToday'); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat items">
				<div class="info">
					<abbr><?php echo (int) @$tpl['cnt_items_avail_today']; ?></abbr>
					<?php (int) @$tpl['cnt_items_avail_today'] !== 1 ? __('lblItemsAvailableToday') : __('lblItemAvailableToday'); ?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblDashLatestBookings');?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionIndex"><?php __('lblDashViewAll'); ?></a>)</div>
			<div class="dashboard_column_top"><?php __('lblDashOngoingReservations');?> (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionIndex&status=ongoing"><?php __('lblDashViewAll'); ?></a>)</div>
			<div class="dashboard_column_top"><?php __('lblDashAvailableItems');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_booking_arr']) > 0)
					{
						foreach($tpl['latest_booking_arr'] as $v)
						{
							$seconds = abs(strtotime($v['dt_to']) - strtotime($v['dt_from']));
							$rental_days = floor($seconds / 86400);
							$rental_hours = ceil($seconds / 3600);
							$rental_duration = '';
							if($rental_days > 0)
							{
								$rental_duration = $rental_days . ' ' . ($rental_days != 1 ? __('lblDashDays', true) : __('lblDashDay', true));
							}else{
								$rental_duration = $rental_hours . ' ' . ($rental_hours != 1 ? __('lblDashHours', true) : __('lblDashHour', true));
							}
							?>
							<div class="dashboard_row">
								<label><span><?php __('lblDashID');?></span>: <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']?>"><?php echo pjSanitize::clean($v['uuid']);?></a></label>
								<label><span><?php __('lblDashCustomer');?>:</span> <?php echo pjSanitize::clean($v['c_name']);?></label>
								<label><span><?php __('lblDashTotalPrice'); ?>:</span> <span class="bold"><?php echo pjUtil::formatCurrencySign($v['total'], $tpl['option_arr']['o_currency']); ?></span></label>
								<label><span><?php __('lblDashPickup'); ?>:</span> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['dt_from'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['dt_from'])); ?></label>
								<label><span><?php __('lblDashReturn');?>:</span> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['dt_to'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['dt_to'])); ?></label>
								<label><span><?php __('lblRentalDuration');?>:</span> <span class="bold"><?php echo $rental_duration; ?></span></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><span><?php __('lblDashNoReservationsFound');?></span></label>
						</div>
						<?php
					}
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['ongoing_arr']) > 0)
					{
						foreach($tpl['ongoing_arr'] as $v)
						{
							$status = __('lblDashOngoing', true);
							$today = date('Y-m-d');
							$pickup_date = date('Y-m-d', strtotime($v['dt_from']));
							$return_date = date('Y-m-d', strtotime($v['dt_to']));
							if($today == $pickup_date)
							{
								if($v['forth'] == 'pickup')
								{
									$status = __('lblDashTodayPickup', true);
								}else{
									$status = __('lblDashTodayDeliver', true);
								}
							}
							if($today == $return_date)
							{
								if($v['forth'] == 'return')
								{
									$status = __('lblDashTodayReturn', true);
								}else{
									$status = __('lblDashTodayCollection', true);
								}
							}
							?>
							<div class="dashboard_row">
								<label><span><?php __('lblDashID');?></span>: <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']?>"><?php echo pjSanitize::clean($v['uuid']);?></a></label>
								<label><span><?php __('lblDashCustomer');?>:</span> <?php echo pjSanitize::clean($v['c_name']);?></label>
								<label class="red"><?php echo $status;?></label>
								<label><span><?php __('lblDashPickup'); ?>:</span> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['dt_from'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['dt_from'])); ?></label>
								<label><span><?php __('lblDashReturn');?>:</span> <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['dt_to'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['dt_to'])); ?></label>
								<label><?php echo $v['products'];?> <?php echo $v['products'] != 1 ? __('lblDashProducts', true) : __('lblDashProduct', true)?> / <?php echo $v['items'];?> <?php echo $v['items'] != 1 ? __('lblDashItems', true) : __('lblDashItem', true)?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><span><?php __('lblDashNoReservationsFound');?></span></label>
						</div>
						<?php
					}
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['avail_today_arr']) > 0)
					{
						$periods = __('items_periods', true);
						foreach($tpl['avail_today_arr'] as $item)
						{
							?>
							<div class="dashboard_row">
								<label><?php echo pjSanitize::clean($item['title']);?></label>
								<label><?php echo $item['ongoing']['products'];?> <?php echo $item['ongoing']['products'] != 1 ? __('lblDashProducts', true) : __('lblDashProduct', true)?> / <?php echo $item['ongoing']['items'];?> <?php echo $item['ongoing']['items'] != 1 ? __('lblDashItems', true) : __('lblDashItem', true)?></label>
							</div>
							<?php
						}
						?>
						<br/>
						<div class="dashboard_row">
							<?php
							foreach($tpl['package_arr'] as $package)
							{
								?>
								<label><?php echo pjSanitize::clean($package['title']);?></label>
								<label><?php echo $package['cnt_items'] . ' ' . ($package['cnt_items'] != 1 ? __('lblDashItems', true) : __('lblDashItem', true)) ?> / <?php echo $package['cnt'] . ' ' . ($package['cnt'] != 1 ? __('lblDashPackagesAvail', true) : __('lblDashPackageAvail', true)) ?></label>
								<br/>
								<?php
							}
							?>
						</div>
						<?php
					}else{
						?>
						<div class="dashboard_row">
							<label><span><?php __('lblDashNoItemsFound');?></span></label>
						</div>
						<?php
					}
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	<?php
	$months = __('months', true);
	$days = __('days', true);
	?>
	<div class="clear_left t20 overflow">
		<div class="float_left black pt15">
			<span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span>
			<?php
			list($month_index, $other) = explode("_", date("n_d, Y H:i", strtotime($_SESSION[$controller->defaultUser]['last_login'])));
			printf("%s %s", $months[$month_index], $other);
			?>
		</div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $month_index, $other) = explode("_", date("H:i_w_n_d, Y"));
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[$day]; ?></abbr>
				<?php printf("%s %s", $months[$month_index], $other); ?>
			</div>
			<div class="dashboard_hour"><?php echo $hour; ?></div>
		</div>
	</div>
	<?php
}
?>