<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$pjTime = pjTime::factory();
	$hash = md5(uniqid(rand(), true));
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionIndex"><?php __('menuBookings'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjInvoice&amp;action=pjActionInvoices"><?php __('plugin_invoice_menu_invoices'); ?></a></li>
		</ul>
	</div>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionCreate" method="post" id="frmCreateBooking" class="form pj-form frmBooking">
		<input type="hidden" name="booking_create" value="1" />
		<input type="hidden" name="hash" value="<?php echo $hash; ?>" />
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('booking_tab_details'); ?></a></li>
				<li><a href="#tabs-2"><?php __('booking_tab_client'); ?></a></li>
			</ul>
			
			<div id="tabs-1">
				<?php pjUtil::printNotice(@$titles['ABK10'], @$bodies['ABK10']); ?>
				<fieldset class="fieldset white">
					<legend><?php __('booking_general'); ?></legend>
					<div class="float_left">
						<p>
							<label class="title"><?php __('booking_uuid'); ?>:</label>
							<input type="text" name="uuid" id="uuid" class="pj-form-field w100 required" value="<?php echo pjUtil::uuid(); ?>" data-msg-remote="<?php __('booking_uuid_duplicate', false, true); ?>" />
						</p>
						<p>
							<label class="title"><?php __('booking_from'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
								<input type="text" name="date_from" id="date_from" class="pj-form-field w80 datepick pointer required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate(date("Y-m-d"), "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" />
								<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							</span>
							<span class="float_left">
							<?php
							echo $pjTime
								->reset()
								->attr('name', 'hour_from')
								->attr('id', 'hour_from')
								->attr('class', 'pj-form-field')
								->prop('selected', 10)
								->hour();
							?>
							<?php
							echo $pjTime
								->reset()
								->attr('name', 'minute_from')
								->attr('id', 'minute_from')
								->attr('class', 'pj-form-field')
								->prop('step', 5)
								->minute();
							?>
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_to'); ?></label>
							<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
								<input type="text" name="date_to" id="date_to" class="pj-form-field w80 datepick pointer required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate(date("Y-m-d"), "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" />
								<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
							</span>
							<span class="float_left">
							<?php
							echo $pjTime
								->reset()
								->attr('name', 'hour_to')
								->attr('id', 'hour_to')
								->attr('class', 'pj-form-field')
								->prop('selected', 12)
								->hour();
							?>
							<?php
							echo $pjTime
								->reset()
								->attr('name', 'minute_to')
								->attr('id', 'minute_to')
								->attr('class', 'pj-form-field')
								->prop('step', 5)
								->minute();
							?>
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_status'); ?>:</label>
							<select name="status" id="status" class="pj-form-field required">
								<option value=""><?php __('booking_choose'); ?></option>
								<?php
								foreach (__('booking_statuses', true) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</p>
						<p>
							<label class="title200"><?php __('booking_forth'); ?>:</label>
							<span class="left padding150">
							<?php
							foreach (__('booking_forths', true) as $k => $v)
							{
								?><label><input type="radio" name="forth" value="<?php echo $k; ?>"<?php echo 'pickup' == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
								<?php
							}
							?>
							</span>
						</p>
						<p>
							<label class="title200"><?php __('booking_back'); ?>:</label>
							<span class="left padding150">
							<?php
							foreach (__('booking_backs', true) as $k => $v)
							{
								?><label><input type="radio" name="back" value="<?php echo $k; ?>"<?php echo 'return' == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
								<?php
							}
							?>
							</span>
						</p>
						<br/><br/>
						<div id="boxBookingItems"></div>
					</div>
					<div class="float_right">
						<p>
							<label class="title"><?php __('booking_payment_method'); ?>:</label>
							<select name="payment_method" id="payment_method" class="pj-form-field<?php echo (int) $tpl['option_arr']['o_disable_payments'] === 1 ? NULL : ' required'; ?>">
								<option value=""><?php __('booking_choose'); ?></option>
								<?php
								foreach (__('payment_methods', true) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</p>
						<p class="erCC" style="display: none">
							<label class="title"><?php __('booking_cc_type'); ?></label>
							<span class="inline_block">
								<select name="cc_type" class="pj-form-field w140">
									<option value="">---</option>
									<?php
									foreach (__('booking_cc_types', true) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<p class="erCC" style="display: none">
							<label class="title"><?php __('booking_cc_num'); ?></label>
							<span class="inline_block">
								<input type="text" name="cc_num" id="cc_num" class="pj-form-field w120 digits" />
							</span>
						</p>
						<p class="erCC" style="display: none">
							<label class="title"><?php __('booking_cc_code'); ?></label>
							<span class="inline_block">
								<input type="text" name="cc_code" id="cc_code" class="pj-form-field w120 digits" />
							</span>
						</p>
						<p class="erCC" style="display: none">
							<label class="title"><?php __('booking_cc_exp'); ?></label>
							<span class="inline_block">
								<?php
								echo pjTime::factory()
									->attr('name', 'cc_exp_month')
									->attr('id', 'cc_exp_month')
									->attr('class', 'pj-form-field')
									->prop('format', 'M')
									->month();
								?>
								<?php
								echo pjTime::factory()
									->attr('name', 'cc_exp_year')
									->attr('id', 'cc_exp_year')
									->attr('class', 'pj-form-field')
									->prop('left', 0)
									->prop('right', 10)
									->year();
								?>
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_price'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="price" id="price" class="pj-form-field number w80" />
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_security'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="security" id="security" class="pj-form-field number w80" />
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_deposit'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="deposit" id="deposit" class="pj-form-field number w80" />
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_tax'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="tax" id="tax" class="pj-form-field number w80" />
							</span>
						</p>
						<p>
							<label class="title"><?php __('booking_total'); ?>:</label>
							<span class="pj-form-field-custom pj-form-field-custom-before">
								<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
								<input type="text" name="total" id="total" class="pj-form-field number w80" />
							</span>
						</p>
					</div>
					<br class="clear_both" /><br/>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
						<input type="button" value="<?php __('booking_add_item', false, true); ?>" class="pj-button item-add" />
						<input type="button" value="<?php __('booking_recalc', false, true); ?>" class="pj-button order-calc" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
					</p>
					<div class="p">
						<div id="dialogItemDelete" title="Delete confirmation" style="display: none">Are you sure you want to delete selected item?</div>
						<div id="dialogItemEdit" title="Edit Item" style="display: none"></div>
						<div id="dialogItemAdd" title="Add Item" style="display: none"></div>
					</div>
				</fieldset>
			</div>
			<div id="tabs-2">
				<?php pjUtil::printNotice(@$titles['ABK11'], @$bodies['ABK11']); ?>
				<fieldset class="fieldset white">
					<legend><?php __('booking_customer'); ?></legend>
					
					<div class="float_left w360">
						<p>
							<label class="title"><?php __('booking_country'); ?>:</label>
							<select name="c_country_id" id="c_country_id" class="pj-form-field w180 custom-chosen">
								<option value=""><?php __('booking_choose'); ?></option>
								<?php
								foreach ($tpl['country_arr'] as $country)
								{
									?><option value="<?php echo $country['id']; ?>"><?php echo pjSanitize::html($country['name']); ?></option><?php
								}
								?>
							</select>
						</p>
						<p>
							<label class="title"><?php __('booking_state'); ?>:</label>
							<input type="text" name="c_state" id="c_state" class="pj-form-field w180" />
						</p>
					</div>
					<div class="float_right w350">
						<p>
							<label class="title"><?php __('booking_city'); ?>:</label>
							<input type="text" name="c_city" id="c_city" class="pj-form-field w160" />
						</p>
						<p>
							<label class="title"><?php __('booking_zip'); ?>:</label>
							<input type="text" name="c_zip" id="c_zip" class="pj-form-field w80" />
						</p>
					</div>
					<br class="clear_both" />
					<p>
						<label class="title"><?php __('booking_name'); ?>:</label>
						<input type="text" name="c_name" id="c_name" class="pj-form-field w300" />
					</p>
					<p>
						<label class="title"><?php __('booking_email'); ?>:</label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
							<input type="text" name="c_email" id="c_email" class="pj-form-field email w250" />
						</span>
					</p>
					<p>
						<label class="title"><?php __('booking_phone'); ?>:</label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
							<input type="text" name="c_phone" id="c_phone" class="pj-form-field w250" />
						</span>
					</p>
					<p>
						<label class="title"><?php __('booking_address_1'); ?>:</label>
						<input type="text" name="c_address_1" id="c_address_1" class="pj-form-field w500" />
					</p>
					<p>
						<label class="title"><?php __('booking_address_2'); ?>:</label>
						<input type="text" name="c_address_2" id="c_address_2" class="pj-form-field w500" />
					</p>
					<p>
						<label class="title"><?php __('booking_notes'); ?>:</label>
						<textarea name="c_notes" id="c_notes" class="pj-form-field w500 h100"></textarea>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
					</p>
				</fieldset>
				
			</div>
		</div>
	</form>
	
	<?php
}
?>