<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminItems&amp;action=pjActionUpdate" method="post" id="frmUpdateItem" class="form pj-form">
		<input type="hidden" name="item_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab" value="<?php echo isset($_GET['tab']) && !empty($_GET['tab']) ? (int) $_GET['tab'] : '0'; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('items_details'); ?></a></li>
				<li><a href="#tabs-2"><?php __('items_photos'); ?></a></li>
				<li><a href="#tabs-3"><?php __('items_prices'); ?></a></li>
				<li><a href="#tabs-4"><?php __('items_availability'); ?></a></li>
			</ul>
			
			<div id="tabs-1">
				<?php pjUtil::printNotice(@$titles['AI10'], @$bodies['AI10']); ?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang"></div>
				<?php endif; ?>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
					?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('items_title'); ?>:</label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w400<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" value="<?php echo pjSanitize::html($tpl['arr']['i18n'][$v['id']]['title']); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
					?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('items_desc'); ?>:</label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h150"><?php echo pjSanitize::html($tpl['arr']['i18n'][$v['id']]['description']); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title"><?php __('items_category'); ?></label>
						<span class="inline_block">
							<select name="category_id" id="category_id" class="pj-form-field">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach ($tpl['category_arr'] as $v)
								{
									?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] != $tpl['arr']['category_id'] ? NULL : ' selected="selected"'; ?>><?php echo stripslashes($v['title']); ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title"><?php __('items_cnt'); ?></label>
						<span class="inline_block">
							<input type="text" name="cnt" class="pj-form-field w80 spinner" value="<?php echo (int) $tpl['arr']['cnt']; ?>" />
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminItems&action=pjActionIndex';" />
					</p>
				</div>
			</div>
			<div id="tabs-2">
				<?php pjUtil::printNotice(@$titles['AI07'], @$bodies['AI07']); ?>
				<div id="gallery"></div>
			</div>
			<div id="tabs-3">
				<?php
				pjUtil::printNotice(@$titles['AI11'], @$bodies['AI11']);
				$rent_by = __('items_rent_by_opts', true);
				$price_per = __('items_price_per_opts', true);
				?>
				<fieldset class="fieldset white">
					<legend><?php __('items_default_price'); ?></legend>
					<p>
						<label class="title"><?php echo $rent_by['day']; ?>:</label>
						<span class="left"><input type="checkbox" name="rent_by_day" value="1" class="rent_by"<?php echo (int) $tpl['arr']['rent_by_day'] === 1 ? ' checked="checked"' : NULL; ?> /></span>
					</p>
					<p style="display: <?php echo (int) $tpl['arr']['rent_by_day'] === 1 ? NULL : 'none'; ?>">
						<label class="title"><?php echo $price_per['day']; ?>:</label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" name="price_per_day" value="<?php echo (int) $tpl['arr']['rent_by_day'] === 1 ? $tpl['arr']['price_per_day'] : NULL; ?>" class="pj-form-field align_right w60 number" />
						</span>
					</p>
					<p>
						<label class="title"><?php echo $rent_by['hour']; ?>:</label>
						<span class="left"><input type="checkbox" name="rent_by_hour" value="1" class="rent_by"<?php echo (int) $tpl['arr']['rent_by_hour'] === 1 ? ' checked="checked"' : NULL; ?> /></span>
					</p>
					<p style="display: <?php echo (int) $tpl['arr']['rent_by_hour'] === 1 ? NULL : 'none'; ?>">
						<label class="title"><?php echo $price_per['hour']; ?>:</label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" name="price_per_hour" value="<?php echo (int) $tpl['arr']['rent_by_hour'] === 1 ? $tpl['arr']['price_per_hour'] : NULL; ?>" class="pj-form-field align_right w60 number" />
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminItems&action=pjActionIndex';" />
					</p>
				</fieldset>
			
				<fieldset class="fieldset white">
					<legend><?php __('items_special_price'); ?></legend>
				
					<table class="pj-table b10" cellpadding="0" cellspacing="0" style="width: 100%" id="tblPrices">
						<thead>
							<tr>
								<th class="w130"><?php __('items_from'); ?></th>
								<th class="w130"><?php __('items_to'); ?></th>
								<th class="w210"><?php __('items_length'); ?></th>
								<th><?php __('items_price'); ?></th>
								<th style="width: 3%">&nbsp;</th>
							</tr>
						</thead>
						<tbody>
						<?php
						$items_price_per = __('items_price_per', true);
						$by_day = (int) $tpl['arr']['rent_by_day'] === 1;
						$by_hour = (int) $tpl['arr']['rent_by_hour'] === 1;
						$by_both = $by_day && $by_hour;
						if (!isset($tpl['price_arr']) || empty($tpl['price_arr']))
						{
							include dirname(__FILE__) . '/elements/prices_row.php';
						} else {
							foreach ($tpl['price_arr'] as $price)
							{
								?>
								<tr>
									<td>
										<span class="pj-form-field-custom pj-form-field-custom-after">
											<input type="text" name="date_from[<?php echo $price['id']; ?>]" class="pj-form-field w80 datepick pointer" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($price['date_from'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" />
											<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
										</span>
									</td>
									<td>
										<span class="pj-form-field-custom pj-form-field-custom-after">
											<input type="text" name="date_to[<?php echo $price['id']; ?>]" class="pj-form-field w80 datepick pointer" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($price['date_to'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" />
											<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
										</span>
									</td>
									<td>
										<input type="text" name="length_from[<?php echo $price['id']; ?>]" class="pj-form-field w50 spinner" value="<?php echo (int) $price['length_from']; ?>" />
										<input type="text" name="length_to[<?php echo $price['id']; ?>]" class="pj-form-field w50 spinner" value="<?php echo (int) $price['length_to']; ?>" />
										<select name="period[<?php echo $price['id']; ?>]" class="pj-form-field pPeriod" style="display: <?php echo $by_both ? NULL : 'none'; ?>">
											<option value="hour"<?php echo $price['period'] != 'hour' ? NULL : ' selected="selected"'; ?>><?php __('items_hour_plural'); ?></option>
											<option value="day"<?php echo $price['period'] != 'day' ? NULL : ' selected="selected"'; ?>><?php __('items_day_plural'); ?></option>
										</select>
										<span class="pHours" style="display: <?php echo !$by_both && $by_hour ? NULL : 'none'; ?>"><?php __('items_hour_plural'); ?></span>
										<span class="pDays" style="display: <?php echo !$by_both && $by_day ? NULL : 'none'; ?>"><?php __('items_day_plural'); ?></span>
									</td>
									<td>
										<span class="pj-form-field-custom pj-form-field-custom-before float_left r5">
											<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
											<input type="text" name="price[<?php echo $price['id']; ?>]" class="pj-form-field align_right w60 number" value="<?php echo number_format((float) $price['price'], 2, '.', ''); ?>" />
										</span>
										<span class="pHour" style="display: <?php echo $price['period'] == 'hour' ? NULL : 'none'; ?>"><?php echo $items_price_per['hour']; ?></span>
										<span class="pDay" style="display: <?php echo  $price['period'] == 'day' ? NULL : 'none'; ?>"><?php echo $items_price_per['day']; ?></span>
									</td>
									<td><a href="#" class="pj-table-icon-delete btnDeletePrice" data-id="<?php echo $price['id']; ?>"></a></td>
								</tr>
								<?php
							}
						}
						?>
						</tbody>
					</table>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnAdd'); ?>" class="pj-button btnAddPrice" />
				</fieldset>
			
			</div>
			<div id="tabs-4">
				<?php pjUtil::printNotice(@$titles['AI12'], @$bodies['AI12']); ?>
				<table class="pj-table b10" cellpadding="0" cellspacing="0" style="width: 500px;" id="tblAvailability">
					<thead>
						<tr>
							<th class="w150"><?php __('items_from'); ?></th>
							<th class="w150"><?php __('items_to'); ?></th>	
							<th><?php __('items_cnt'); ?></th>
							<th style="width: 3%">&nbsp;</th>
						</tr>
					</thead>
					<tbody>
						<?php
						if (!isset($tpl['avail_arr']) || empty($tpl['avail_arr']))
						{
							include dirname(__FILE__) . '/elements/avail_row.php';
						} else {
							foreach ($tpl['avail_arr'] as $avail)
							{
								?>
								<tr>
									<td>
										<span class="pj-form-field-custom pj-form-field-custom-after">
											<input type="text" name="avail_date_from[<?php echo $avail['id']; ?>]" class="pj-form-field w100 datepick pointer" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($avail['date_from'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" />
											<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
										</span>
									</td>
									<td>
										<span class="pj-form-field-custom pj-form-field-custom-after">
											<input type="text" name="avail_date_to[<?php echo $avail['id']; ?>]" class="pj-form-field w80 datepick pointer" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo pjUtil::formatDate($avail['date_to'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" />
											<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
										</span>
									</td>
									<td>
										<input type="text" name="avail_cnt[<?php echo $avail['id']; ?>]" class="pj-form-field w80 spinner" value="<?php echo (int) $avail['cnt']; ?>" />
									</td>
									<td><a href="#" class="pj-table-icon-delete btnRemoveAvail" data-id="<?php echo $avail['id']; ?>"></a></td>
								</tr>
								<?php
							}
						} 
						?>
					</tbody>
				</table>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnAdd'); ?>" class="pj-button btnAddAvail" />		
			</div>
		</div>
	</form>
	
	<div id="dialogDeletePrice" style="display: none" title="<?php echo pjSanitize::html(__('items_price_del_title', true)); ?>"><?php echo pjSanitize::html(__('items_price_del_body', true)); ?></div>
	
	<?php 
	include dirname(__FILE__) . '/elements/prices_tpl.php';
	include dirname(__FILE__) . '/elements/avail_tpl.php';
	?>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1) : ?>
	var pjLocale = pjLocale || {};
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim.",
				select: function (event, ui) {
					// Callback, e.g. ajax requests or whatever
				}
			});
		});
	})(jQuery_1_8_2);
	<?php endif; ?>
	</script>
	<?php
	if (isset($_GET['tab']) && (int) $_GET['tab'] > 0)
	{
		$tab_id = (int) $_GET['tab'];
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "active", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>