<?php
$acceptBookings = (int) $tpl['option_arr']['o_accept_bookings'] === 1;
$numberOfItemsInBasket = $controller->cart->getCount();

include PJ_VIEWS_PATH . 'pjFrontEnd/elements/locale.php'; 
?>
<div class="col-sm-6 col-xs-12 pjErHeaderUtilities">
	<div class="row">
		<?php
		if ((int) $tpl['option_arr']['o_use_category'] === 1 && isset($tpl['category_arr']) && !empty($tpl['category_arr']))
		{ 
			?>
			<div class="col-sm-6 col-xs-12">
				<select name="category_id" class="form-control pjErCategorySort erCategory erSelectorCategoryId">
					<option value="">-- <?php __('item_select_category'); ?> --</option>
					<?php
					foreach ($tpl['category_arr'] as $category)
					{
						?><option value="<?php echo $category['id']; ?>"<?php echo !isset($_GET['category_id']) || $_GET['category_id'] != $category['id'] ? NULL : ' selected="selected"'; ?>><?php echo pjSanitize::html($category['title']); ?></option><?php
					}
					?>
				</select>
			</div><!-- /.col-sm-6 col-xs-12 -->
			<?php
		}
		$FORM = &$_SESSION[$controller->defaultForm];
		
		$isSearchReady = !empty($FORM['date_from']) && !empty($FORM['date_to']);
		if ($isSearchReady)
		{
			list($year_from, $month_from, $day_from) = explode("-", $FORM['date_from']);
			list($year_to, $month_to, $day_to) = explode("-", $FORM['date_to']);
			$short_months = __('short_months', true);
			?>
			<div class="col-sm-6 col-xs-12">
				<button class="btn btn-default btn-block pjErBtn pjErBtnToggle" role="button" data-toggle="collapse" data-target="#pjErFormAvailability" aria-expanded="false" aria-controls="collapseExample">
					<span>
						<?php printf("%s %s %s, %s %s:%s %s %s %s, %s %s:%s",
							__('selected_from', true),
							$short_months[(int) $month_from],
							(int) $day_from,
							$year_from,
							$FORM['hour_from'],
							$FORM['minute_from'],
							__('selected_to', true),
							$short_months[(int) $month_to],
							(int) $day_to,
							$year_to,
							$FORM['hour_to'],
							$FORM['minute_to'])
						?>
					</span>
				</button>
			</div><!-- /.col-sm-6 col-xs-12 -->
			<?php
		} 
		?>
	</div><!-- /.row -->
</div><!-- /.col-sm-6 col-xs-12 pjErHeaderUtilities -->

<div class="col-sm-6 col-xs-12 pjErNav">
	<div class="btn-group" role="group" aria-label="navigation">
	
		<a href="<?php echo pjUtil::getReferer(); ?>#!/Items" class="btn btn-default pjErBtn erSelectorItems<?php echo in_array($_GET['action'], array('pjActionItems')) ? ' pjErBtnActive' : NULL; ?>"><?php __('fmenu_items'); ?></a>
		<a href="<?php echo pjUtil::getReferer(); ?>#!/Packages" class="btn btn-default pjErBtn erSelectorPackages<?php echo in_array($_GET['action'], array('pjActionPackages')) ? ' pjErBtnActive' : NULL; ?>"><?php __('fmenu_packages'); ?></a>
		<?php
		if ($acceptBookings)
		{
			?>
			<a href="<?php echo pjUtil::getReferer(); ?>#!/Cart" class="btn btn-default pjErBtn erSelectorCart<?php echo in_array($_GET['action'], array('pjActionCart')) ? ' pjErBtnActive' : NULL; ?>"><?php __('fmenu_cart'); ?><?php echo $numberOfItemsInBasket > 0 ? sprintf(" (%u)", $numberOfItemsInBasket) : NULL; ?></a>
			<?php
		} 
		?>
		
	</div><!-- /.btn-group -->
</div><!-- /.col-sm-6 col-xs-12 pjErNav -->	