<?php
if (isset($tpl['summary']) && !empty($tpl['summary']))
{ 
	$forths = __('booking_forths', true);
	$backs = __('booking_backs', true);

	?>
	<header class="pjErCheckoutHead">
		<dl class="dl-horizontal">
			<dt><?php __('rental_start'); ?>:</dt>
			<dd><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['summary']['dt_from'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['summary']['dt_from'])); ?></dd>
		</dl><!-- /.dl-horizontal -->
	
		<dl class="dl-horizontal">
			<dt><?php __('rental_end'); ?>:</dt>
			<dd><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['summary']['dt_to'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['summary']['dt_to'])); ?></dd>
		</dl><!-- /.dl-horizontal -->
	
		<dl class="dl-horizontal">
			<dt><?php __('booking_forth'); ?>:</dt>
			<dd><?php echo @$forths[$tpl['summary']['forth']]; ?></dd>
		</dl><!-- /.dl-horizontal -->
	
		<dl class="dl-horizontal">
			<dt><?php __('booking_back'); ?>:</dt>
			<dd><?php echo @$backs[$tpl['summary']['back']]; ?></dd>
		</dl><!-- /.dl-horizontal -->
		<?php
		foreach ($tpl['summary']['items'] as $item)
		{
			$key = sprintf("%s_%u", $item['type'], $item['id']);
			?>
			<dl class="dl-horizontal">
				<?php
				if($tpl['option_arr']['o_disable_payments'] == 0 || $tpl['option_arr']['o_hide_prices'] == 0)
				{
					$selector = $item['type'] == 'item' ? 'erSelectorItem' : 'erSelectorPackage';
					$href = sprintf("%s#!/%s/%u", pjUtil::getReferer(), ($item['type'] == 'item' ? 'Item' : 'Package'), $item['id']);
					printf('<dt><a href="%s" data-id="%u" class="%s">%s</a>:</dt><dd>%u x %s</dd>',
						$href,
						$item['id'],
						$selector,
						pjSanitize::html($item['title']),
						$tpl['summary']['cart'][$key],
						pjUtil::formatCurrencySign(number_format($item['price'], 2), $tpl['option_arr']['o_currency'])
					);
				}else{
					$selector = $item['type'] == 'item' ? 'erSelectorItem' : 'erSelectorPackage';
					$href = sprintf("%s#!/%s/%u", pjUtil::getReferer(), ($item['type'] == 'item' ? 'Item' : 'Package'), $item['id']);
					printf('<dt><a href="%s" data-id="%u" class="%s">%s</a>:</dt><dd>%u</dd>',
						$href,
						$item['id'],
						$selector,
						pjSanitize::html($item['title']),
						$tpl['summary']['cart'][$key]
					);
				}
				?>
			</dl>
			<?php
		}
		if($tpl['option_arr']['o_disable_payments'] == 0 || $tpl['option_arr']['o_hide_prices'] == 0)
		{ 
			?>
			<dl class="dl-horizontal">
				<dt><?php __('front_total'); ?>:</dt>
				<dd><?php echo pjUtil::formatCurrencySign(number_format($tpl['summary']['total'], 2), $tpl['option_arr']['o_currency']); ?></dd>
			</dl><!-- /.dl-horizontal -->
		
			<dl class="dl-horizontal">
				<dt><?php __('front_deposit'); ?>:</dt>
				<dd><?php echo pjUtil::formatCurrencySign(number_format($tpl['summary']['deposit'], 2), $tpl['option_arr']['o_currency']); ?></dd>
			</dl><!-- /.dl-horizontal -->
			<?php
		} 
		?>
	</header><!-- /.pjErCheckoutHead -->
	<?php
} 
?>