<div style="margin: 0 auto; width: 100%;">
	<?php
	$cancel_err = __('cancel_err', true, false);
	$payment_methods = __('payment_methods', true, false);
	if (isset($tpl['status']))
	{
		switch ($tpl['status'])
		{
			case 1:
				?><p><?php echo $cancel_err[1]; ?></p><?php
				break;
			case 2:
				?><p><?php echo $cancel_err[2]; ?></p><?php
				break;
			case 3:
				?><p><?php echo $cancel_err[3]; ?></p><?php
				break;
			case 4:
				?><p><?php echo $cancel_err[4]; ?></p><?php
				break;
		}
	} else {
		
		if (isset($_GET['err']))
		{
			switch ((int) $_GET['err'])
			{
				case 200:
					?><p><?php echo $cancel_err[200]; ?></p><?php
					break;
			}
		}
		
		if (isset($tpl['arr']))
		{
			$name_titles = __('personal_titles', true, false);
			$bi_arr = $tpl['bi_arr'];
			$items = '';
			$item_arr = array();
			if (!empty($bi_arr))
			{
				foreach ($bi_arr as $item)
				{
					$item_arr[] = $item['title'] . ' ('.pjUtil::formatCurrencySign($item['unit_price'], $tpl['option_arr']['o_currency']).') x ' . $item['qty'] . ' = ' . pjUtil::formatCurrencySign(number_format($item['unit_price'] * $item['qty'], 2), $tpl['option_arr']['o_currency']) ;
				}
			}
			$items = implode("<br/>", $item_arr);
			?>
			<table class="table" cellspacing="2" cellpadding="5" style="width: 100%">
				<thead>
					<tr>
						<th colspan="2" style="text-transform: uppercase; text-align: left"><?php __('front_booking_details'); ?></th>
					</tr>
				</thead>
				<tbody>	
					<tr>
						<td><?php __('front_items'); ?></td>
						<td><?php echo $items; ?></td>
					</tr>
					<tr>
						<td><?php __('rental_start'); ?></td>
						<td><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['dt_from'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['dt_from'])); ?></td>
					</tr>
					<tr>
						<td><?php __('rental_end'); ?></td>
						<td><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['dt_to'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['dt_to'])); ?></td>
					</tr>
					<tr>
						<td><?php __('front_payment_method');?></td>
						<td><?php $payment_methods = __('payment_methods', true, false); echo $payment_methods[$tpl['arr']['payment_method']]; ?></td>
					</tr>
					<tr>
						<td><?php __('front_price'); ?></td>
						<td><?php echo pjUtil::formatCurrencySign(number_format(floatval($tpl['arr']['price']), 2), $tpl['option_arr']['o_currency'], " "); ?></td>
					</tr>
					<tr>
						<td><?php __('front_tax'); ?></td>
						<td><?php echo pjUtil::formatCurrencySign(number_format(floatval($tpl['arr']['tax']), 2), $tpl['option_arr']['o_currency'], " "); ?></td>
					</tr>
					<tr>
						<td><?php __('front_total'); ?></td>
						<td><?php echo pjUtil::formatCurrencySign(number_format(floatval($tpl['arr']['total']), 2), $tpl['option_arr']['o_currency'], " "); ?></td>
					</tr>
					<tr>
						<td><?php __('front_deposit'); ?></td>
						<td><?php echo pjUtil::formatCurrencySign(number_format(floatval($tpl['arr']['deposit']), 2), $tpl['option_arr']['o_currency'], " "); ?></td>
					</tr>
					
					<tr>
						<th colspan="2" style="text-transform: uppercase; text-align: left"><?php __('front_your_details'); ?></td>
					</tr>
					
					<tr>
						<td><?php __('booking_name'); ?></td>
						<td><?php echo pjSanitize::html($tpl['arr']['c_name']); ?></td>
					</tr>
					<tr>
						<td><?php __('booking_email'); ?></td>
						<td><?php echo pjSanitize::html($tpl['arr']['c_email']); ?></td>
					</tr>
					<tr>
						<td><?php __('booking_phone'); ?></td>
						<td><?php echo pjSanitize::html($tpl['arr']['c_phone']); ?></td>
					</tr>
					<tr>
						<td><?php __('booking_address_1'); ?></td>
						<td><?php echo stripslashes($tpl['arr']['c_address_1']); ?></td>
					</tr>
					<tr>
						<td><?php __('booking_address_2'); ?></td>
						<td><?php echo pjSanitize::html($tpl['arr']['c_address_2']); ?></td>
					</tr>
					<tr>
						<td><?php __('booking_notes'); ?></td>
						<td><?php echo isset($tpl['arr']['c_notes']) ? nl2br(pjSanitize::clean($tpl['arr']['c_notes'])) : null;?></td>
					</tr>
					<tr>
						<td><?php __('booking_city'); ?></td>
						<td><?php echo pjSanitize::html($tpl['arr']['c_city']); ?></td>
					</tr>
					<tr>
						<td><?php __('booking_state'); ?></td>
						<td><?php echo pjSanitize::html($tpl['arr']['c_state']); ?></td>
					</tr>
					<tr>
						<td><?php __('booking_zip'); ?></td>
						<td><?php echo pjSanitize::html($tpl['arr']['c_zip']); ?></td>
					</tr>
					<tr>
						<td><?php __('booking_country'); ?></td>
						<td><?php echo pjSanitize::html($tpl['arr']['country']); ?></td>
					</tr>
				</tbody>
				<tfoot>
					<tr>
						<td>&nbsp;</td>
						<td>
							<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjFrontEnd&amp;action=pjActionCancel" method="post">
								<input type="hidden" name="booking_cancel" value="1" />
								<input type="hidden" name="id" value="<?php echo $_GET['id']; ?>" />
								<input type="hidden" name="hash" value="<?php echo $_GET['hash']; ?>" />
								<input type="submit" value="<?php __('front_btn_confirm'); ?>" />
							</form>
						</td>
					</tr>
				</tfoot>
			</table>
			<?php
		}
	}
	?>
</div>
	