<header class="row pjErHeader">
<?php
include PJ_VIEWS_PATH . 'pjFrontEnd/elements/header.php';
$filter = 'packages';
include PJ_VIEWS_PATH . 'pjFrontEnd/elements/search.php'; 
?>
</header><!-- /.row pjErHeader -->

<?php
if (isset($tpl['package_arr']) && !empty($tpl['package_arr']))
{
	?>
	<div class="row pjErBody pjErProducts">
		<?php
		$CART = $controller->cart->getAll();
		$periods = __('items_periods', true);
		foreach ($tpl['package_arr'] as $package)
		{
			$slug = NULL;
			if ((int) $tpl['option_arr']['o_seo_url'] === 1)
			{
				$slug = sprintf("%s-%u.html", pjAppController::friendlyURL($package['title']), $package['id']);
				$href = pjUtil::getReferer() . '#!/Package/' . $slug;
			}else{
				$href = pjUtil::getReferer() . '#!/Package/' . $package['id'];
			}
				
			$src = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/er-noimg.png';
			if (!empty($package['pic']) && is_file($package['pic']))
			{
				$src = PJ_INSTALL_URL . $package['pic'];
			}
			?>
			<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
				<a href="<?php echo $href; ?>" class="thumbnail pjErProduct">
					<div class="pjErProductImage">
						<img src="<?php echo $src; ?>" alt="<?php echo pjSanitize::html($package['title']); ?>" />

						<div class="pjErProductOverlay">
							<p>
							<?php
							if (isset($package['titles']) && !empty($package['titles']))
							{
								foreach ($package['titles'] as $title)
								{
									?><span>&bull; <?php echo pjSanitize::html($title); ?></span><br/><?php
								}
							} 
							?>
							</p>
						</div><!-- /.pjErProductOverlay -->
					</div><!-- /.pjErProductImage -->

					<div class="caption pjErProductContent">
						<p class="pjErProductTitle"><?php echo pjSanitize::html($package['title']); ?></p><!-- /.pjErProductTitle -->
						
						<?php
						if (isset($package['min_from']))
						{
							$max_cnt = pjUtil::getMaxCount($package['cnt'], $package['min_from'], $package['min_to']);
							if ((int) $max_cnt > 0
									&& !$tpl['haveDateOffInRange']
									&& (int) $max_cnt >= (int) $package['booked_qty'] + 1
									&& !isset($tpl['out_of_range']))
							{
								if($tpl['option_arr']['o_disable_payments'] == 0 || $tpl['option_arr']['o_hide_prices'] == 0)
								{
									?>
									<div class="clearfix pjErProductInner">
										<?php
										$key = 'package_' . $package['id'];
										if (isset($CART[$key]))
										{
											?>
											<dl>
												<dt><?php __('front_total')?> (<?php echo (int) $CART[$key]; ?>): </dt>
												<dd><strong><?php echo pjUtil::formatCurrencySign(number_format($package['total_price'] * (int) $CART[$key], 2), $tpl['option_arr']['o_currency']); ?></strong></dd>
											</dl>
											<?php
										}else{
											?>
											<dl>
												<dt><?php __('equipment_price')?>: </dt>
												<dd><strong><?php echo pjUtil::formatCurrencySign(number_format($package['total_price'], 2), $tpl['option_arr']['o_currency']); ?></strong></dd>
											</dl>
											<?php
										} 
										?>
			
										<div class="pjErProductActions">
											<button data-slug="<?php echo $slug;?>" data-id="<?php echo $package['id']; ?>" class="btn btn-default pjErBtn pjErBtnPrimary erSelectorPackage"><?php __('button_continue'); ?></button>
										</div><!-- /.pjErProductActions -->
									</div><!-- /.clearfix pjErProductInner -->
									<?php
								}
							}else{
								if($tpl['option_arr']['o_disable_payments'] == 0 || $tpl['option_arr']['o_hide_prices'] == 0)
								{
									?>
									<div class="clearfix pjErProductInner">
										<dl>
											<dt><?php __('equipment_price'); ?>: </dt>
											<dd><strong><?php __('equipment_na'); ?></strong></dd>
										</dl>
									</div><!-- /.clearfix pjErProductInner -->
									<?php
								}
							}
						} else {
							if (!empty($package['price']) && (float) $package['price'] > 0)
							{
								?>
								<div class="clearfix pjErProductInner">
									<?php
									if($tpl['option_arr']['o_disable_payments'] == 0 || $tpl['option_arr']['o_hide_prices'] == 0)
									{
										?>
										<dl>
											<dt><?php __('equipment_price')?>: </dt>
											<dd><strong><?php echo pjUtil::formatCurrencySign(number_format($package['price'], 2), $tpl['option_arr']['o_currency']); ?></strong> / <?php echo @$periods[$package['period']]; ?></dd>
										</dl>
										<?php
									} 
									?>
									<div class="pjErProductActions">
										<button data-slug="<?php echo $slug;?>" data-id="<?php echo $package['id']; ?>" class="btn btn-default pjErBtn pjErBtnPrimary erSelectorPackage"><?php __('button_continue'); ?></button>
									</div><!-- /.pjErProductActions -->
								</div>
								<?php 
							} elseif ((int) $package['rent_by_hour'] === 1 && (float) $package['price_per_hour'] > 0) {
								?>
								<div class="clearfix pjErProductInner">
									<?php
									if($tpl['option_arr']['o_disable_payments'] == 0 || $tpl['option_arr']['o_hide_prices'] == 0)
									{
										?>
										<dl>
											<dt><?php __('equipment_price')?>: </dt>
											<dd><strong><?php echo pjUtil::formatCurrencySign(number_format($package['price_per_hour'], 2), $tpl['option_arr']['o_currency']); ?></strong>  / <?php echo @$periods['hour']; ?></dd>
										</dl>
										<?php
									} 
									?>
									<div class="pjErProductActions">
										<button data-slug="<?php echo $slug;?>" data-id="<?php echo $package['id']; ?>" class="btn btn-default pjErBtn pjErBtnPrimary erSelectorPackage"><?php __('button_continue'); ?></button>
									</div><!-- /.pjErProductActions -->
								</div>
								<?php 
							} elseif ((int) $package['rent_by_day'] === 1 && (float) $package['price_per_day'] > 0) {
								?>
								<div class="clearfix pjErProductInner">
									<?php
									if($tpl['option_arr']['o_disable_payments'] == 0 || $tpl['option_arr']['o_hide_prices'] == 0)
									{
										?>
										<dl>
											<dt><?php __('equipment_price')?>: </dt>
											<dd><strong><?php echo pjUtil::formatCurrencySign(number_format($package['price_per_day'], 2), $tpl['option_arr']['o_currency']); ?></strong>  / <?php echo @$periods['day']; ?></dd>
										</dl>
										<?php
									} 
									?>
									<div class="pjErProductActions">
										<button data-slug="<?php echo $slug;?>" data-id="<?php echo $package['id']; ?>"  class="btn btn-default pjErBtn pjErBtnPrimary erSelectorPackage"><?php __('button_continue'); ?></button>
									</div><!-- /.pjErProductActions -->
								</div>
								<?php
							}else {
								if($tpl['option_arr']['o_disable_payments'] == 0 || $tpl['option_arr']['o_hide_prices'] == 0)
								{
									?>
									<div class="clearfix pjErProductInner">
										<dl>
											<dt><?php __('equipment_price'); ?>: </dt>
											<dd><strong><?php __('equipment_na'); ?></strong></dd>
										</dl>
									</div><!-- /.clearfix pjErProductInner -->
									<?php
								}
							}
						}
						?>
					</div><!-- /.caption pjErProductContent -->
				</a><!-- /.thumbnail pjErProduct -->
			</div><!-- /.col-lg-4 col-md-4 col-sm-6 col-xs-12 -->
			<?php
		}
		?>
	</div><!-- /.row pjErBody pjErProducts -->
	<?php
	if (isset($tpl['paginator']) && $tpl['paginator']['pages'] > 1)
	{
		?>
		<footer class="pjErFoot">
			<nav class="pjErPagination">
				<ul class="pagination">
					<?php
					if ($tpl['paginator']['pages'] > 1 && $tpl['paginator']['page'] > 1)
					{ 
						$i = $tpl['paginator']['page'] - 1;
						?>
						<li>
							<a href="<?php echo pjUtil::getReferer(); ?>#!/Packages/page:<?php echo $i; ?>" class="erSelectorPackagesPage" data-page="<?php echo $i; ?>" aria-label="<?php __('front_prev', false, true); ?>">&laquo; <span class="hidden-xs"><?php __('front_prev', false, true); ?></span></a>
						</li>
						<?php
					}
					for ($i = 1; $i <= $tpl['paginator']['pages']; $i++)
					{
						?>
						<li<?php echo isset($_GET['page']) ? ($_GET['page'] == $i ? ' class="active"' : NULL) : NULL;?>>
							<a href="<?php echo pjUtil::getReferer(); ?>#!/Packages/page:<?php echo $i; ?>" class="erSelectorPackagesPage<?php echo $tpl['paginator']['page'] != $i ? NULL : ' active'; ?>" data-page="<?php echo $i; ?>"><?php echo $i;?></a>
						</li>
						<?php
					} 
					if ($tpl['paginator']['pages'] > $tpl['paginator']['page'])
					{ 
						$i = $tpl['paginator']['page'] + 1;
						?>
						<li>
							<a href="<?php echo pjUtil::getReferer(); ?>#!/Packages/page:<?php echo $i; ?>" class="erSelectorPackagesPage" data-page="<?php echo $i; ?>" aria-label="<?php __('front_next', false, true); ?>"><span class="hidden-xs"><?php __('front_next', false, true); ?></span> &raquo;</a>
						</li>
						<?php
					} 
					?>
				</ul><!-- /.pagination -->
			</nav><!-- /.pjErPagination -->
		</footer><!-- /.pjErFoot -->
		<?php
	}
} else{
	?>
	<div class="panel panel-default pjErBody pjErProductDetails">
		<div class="panel-body pjErProductDetailsInner">
			<div class="row">
				<div class="col-lg-7 col-md-7 col-sm-6 col-xs-12">
					<div class="pjErProductBody">
						<p><?php __('e_packages_not_found');?></p>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>