<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat campaigns">
				<div class="info">
					<abbr><?php echo $tpl['cnt_active_campaigns'];?></abbr>
					<?php $tpl['cnt_active_campaigns'] != 1 ? __('lblActiveCampaigns') : __('lblActiveCampaigns');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat donations">
				<div class="info">
					<abbr><?php echo $tpl['cnt_received_donations'];?></abbr>
					<?php $tpl['cnt_received_donations'] != 1 ? __('lblDonationsReceived') : __('lblDonationReceived');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat campaigns">
				<div class="info">
					<abbr><?php echo $tpl['cnt_completed_campaigns'];?></abbr>
					<?php $tpl['cnt_completed_campaigns'] != 1 ? __('lblCompletedCampaigns') : __('lblCompletedCampaigns');?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblAlmostCompleted');?></div>
			<div class="dashboard_column_top"><?php __('lblLatestDonations');?></div>
			<div class="dashboard_column_top"><?php __('lblLatestCampaigns');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['almost_completed']) > 0)
					{
						foreach($tpl['almost_completed'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCampaigns&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></a></label>
								<label class="fs15"><?php echo number_format($v['percentage'], 0);?>% <?php __('lblReceived')?></label>
								<label>
									<?php 
									if($v['needed'] >= 0)
									{
										echo pjUtil::formatCurrencySign(number_format($v['needed'], 0), $tpl['option_arr']['o_currency']);?> <?php __('lblMoreNeeded');
									}else{
										echo '+' . pjUtil::formatCurrencySign(number_format($v['needed'] * (-1), 0), $tpl['option_arr']['o_currency']);?> <?php __('lblReceived');
									}
									?>
								</label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblCampaignsNotFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_donations']) > 0)
					{
						$payment_methods = __('payment_methods', true, false);
						foreach($tpl['latest_donations'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label class="fs15"><?php echo pjUtil::formatCurrencySign(number_format($v['amount'], 0), $tpl['option_arr']['o_currency']);?> <?php __('lblVia')?> <?php echo $payment_methods[$v['payment_method']];?></label>
								<label><?php __('lblBy');?> <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminDonations&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo $v['name'];?></a></label>
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCampaigns&amp;action=pjActionUpdate&amp;id=<?php echo $v['campaign_id'];?>"><?php echo pjSanitize::html($v['title']);?></a></label>
								<label><?php __('lblDateTime')?>: <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created']))?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['created']))?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblDonationsNotFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_campaigns']) > 0)
					{
						foreach($tpl['latest_campaigns'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCampaigns&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></a></label>
								<label class="fs15"><?php echo pjUtil::formatCurrencySign(number_format($v['total_amount'], 0), $tpl['option_arr']['o_currency']);?> <?php __('lblReceived')?> <?php echo number_format($v['percentage'], 0);?>% <?php __('lblFunded')?></label>
								<label><?php echo $v['total_donations'];?> <?php $v['total_donations'] != 1 ? __('lblDonations') : __('lblDoantion');?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('lblCampaignsNotFound');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format']); ?></div>
		</div>
	</div>
	<?php
}
?>