<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminDonations&amp;action=pjActionIndex"><?php __('menuDonations'); ?></a></li>
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminDonations&amp;action=pjActionCreate"><?php __('lblAddDonation'); ?></a></li>
		</ul>
	</div>
	
	<?php pjUtil::printNotice(__('infoAddDonationTitle', true, false), __('infoAddDonationDesc', true, false)); ?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminDonations&amp;action=pjActionCreate" method="post" id="frmCreateDonation" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="donation_create" value="1" />
		<p>
			<label class="title"><?php __('lblCampaign'); ?></label>
			<span class="inline_block">
				<?php
				if(!empty($tpl['campaign_arr'])) 
				{
					?>
					<select id="campaign_id" name="campaign_id" class="pj-form-field w300 required">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($tpl['campaign_arr'] as $k => $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo $v['title']; ?></option><?php
						}
						?>
					</select>
					<?php
				}else{
					$message = __('lblNoCampaigns', true, false);
					$message = str_replace("[STAG]", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminCampaigns&amp;action=pjActionCreate">', $message);
					$message = str_replace("[ETAG]", '</a>', $message);
					?><label class="content"><?php echo $message;?></label><?php
				} 
				?>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblName'); ?></label>
			<span class="inline_block">
				<input type="text" name="name" id="name" class="pj-form-field w300 required"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblEmail'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
				<input type="text" name="email" id="email" class="pj-form-field required email w300" placeholder="info@test.com"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblPhone'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
				<input type="text" name="phone" id="phone" class="pj-form-field w300"placeholder="(123) 456-7890" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblAmount'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
				<input type="text" id="amount" name="amount" class="pj-form-field number w100 required" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblPaymentMethod');?></label>
			<span class="inline-block">
				<select name="payment_method" id="payment_method" class="pj-form-field w150 required">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('payment_methods', true, false) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p class="boxCC" style="display: none;">
			<label class="title"><?php __('lblCCType'); ?></label>
			<span class="inline-block">
				<select name="cc_type" class="pj-form-field w150 required">
					<option value="">---</option>
					<?php
					foreach (__('cc_types', true, false) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p class="boxCC" style="display: none;">
			<label class="title"><?php __('lblCCNum'); ?></label>
			<span class="inline-block">
				<input type="text" name="cc_num" id="cc_num" class="pj-form-field w150 required"/>
			</span>
		</p>
		<p class="boxCC" style="display: none;">
			<label class="title"><?php __('lblCCExp'); ?></label>
			<span class="inline-block">
				<select name="cc_exp_month" class="pj-form-field required">
					<option value="">---</option>
					<?php
					$month_arr = __('months', true, false);
					ksort($month_arr);
					foreach ($month_arr as $key => $val)
					{
						?><option value="<?php echo $key;?>"><?php echo $val;?></option><?php
					}
					?>
				</select>
				<select name="cc_exp_year" class="pj-form-field required">
					<option value="">---</option>
					<?php
					$y = (int) date('Y');
					for ($i = $y; $i <= $y + 10; $i++)
					{
						?><option value="<?php echo $i; ?>"><?php echo $i; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p class="boxCC" style="display: none;">
			<label class="title"><?php __('lblCCCode'); ?></label>
			<span class="inline-block">
				<input type="text" name="cc_code" id="cc_code" class="pj-form-field w100 required" />
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblStatus');?></label>
			<span class="inline-block">
				<select name="status" id="status" class="pj-form-field w150 required">
					<option value="">-- <?php __('lblChoose'); ?>--</option>
					<?php
					foreach (__('donation_statuses', true, false) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"><?php echo $v; ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
		</p>
	</form>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};	
	</script>
	<?php
}
?>