<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}
	
	static public function getReferer()
	{
		if (isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SERVER['REDIRECT_URL']))
			{
				return $_SERVER['REDIRECT_URL'];
			}
		}
		
		if (isset($_SERVER['HTTP_REFERER']))
		{
			$pos = strpos($_SERVER['HTTP_REFERER'], "#");
			if ($pos !== FALSE)
			{
				return substr($_SERVER['HTTP_REFERER'], 0, $pos);
			}
			return $_SERVER['HTTP_REFERER'];
		}
	}
	
	static public function getClientIp()
	{
		if (isset($_SERVER['HTTP_CLIENT_IP']))
		{
			return $_SERVER['HTTP_CLIENT_IP'];
		} else if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			return $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else if(isset($_SERVER['HTTP_X_FORWARDED'])) {
			return $_SERVER['HTTP_X_FORWARDED'];
		} else if(isset($_SERVER['HTTP_FORWARDED_FOR'])) {
			return $_SERVER['HTTP_FORWARDED_FOR'];
		} else if(isset($_SERVER['HTTP_FORWARDED'])) {
			return $_SERVER['HTTP_FORWARDED'];
		} else if(isset($_SERVER['REMOTE_ADDR'])) {
			return $_SERVER['REMOTE_ADDR'];
		}

		return 'UNKNOWN';
	}
	
	static public function textToHtml($content)
	{
		$content = preg_replace('/\r\n|\n/', '<br />', $content);
		return '<html><head><title></title></head><body>'.$content.'</body></html>';
	}
	
	static public function html2txt($document)
	{
		$search = array('@<script[^>]*?>.*?</script>@si',
				'@<[\/\!]*?[^<>]*?>@si',
				'@<style[^>]*?>.*?</style>@siU',
				'@<![\s\S]*?--[ \t\n\r]*>@'
		);
		$text = preg_replace($search, '', $document);
		return $text;
	}
	
	static public function getCurrencyData()
	{
		$default = array(
				'USD' => array('$', 1),
				'GBP' => array('&pound;', 1),
				'EUR' => array('&euro;', 1),
				'JPY' => array('&yen;', 1),
				'NOK' => array('NOK', 1),
				'HUF' => array('HUF', 1),
				'CZK' => array('CZK', 1),
				'ILS' => array('ILS', 1),
				'MXN' => array('MXN', 1),
				'AUD' => array('AUD', 2),
				'CAD' => array('CAD', 2),
				'NZD' => array('NZD', 2),
				'CHF' => array('CHF', 2),
				'HKD' => array('HKD', 2),
				'SGD' => array('SGD', 2),
				'SEK' => array('SEK', 2),
				'DKK' => array('DKK', 2),
				'PLN' => array('PLN', 2)
		);
	
		if (isset($GLOBALS['CONFIG'], $GLOBALS['CONFIG']['currencies'])
				&& is_array($GLOBALS['CONFIG']['currencies'])
				&& !empty($GLOBALS['CONFIG']['currencies']))
		{
			return array_merge($default, $GLOBALS['CONFIG']['currencies']);
		}
	
		return $default;
	}
	
	static public function formatCurrencySign($price, $currency, $separator = "")
	{
		$data = pjUtil::getCurrencyData();
	
		if (isset($data[$currency], $data[$currency][0], $data[$currency][1]))
		{
			switch ($data[$currency][1])
			{
				case 1:
					return $data[$currency][0] . $separator . $price;
					break;
				case 2:
				default:
					return $price . $separator . $data[$currency][0];
					break;
			}
		}
	
		return $price . $separator . pjUtil::getCurrencySign($currency, false);
	}
}
?>