<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat offers">
				<div class="info">
					<abbr><?php echo $tpl['cnt_offers'];?></abbr>
					<?php echo $tpl['cnt_offers'] != 1 ? __('lblDashOffersToday') : __('lblDashOfferToday') ;?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat products">
				<div class="info">
					<abbr><?php echo $tpl['cnt_products'];?></abbr>
					<?php echo $tpl['cnt_products'] != 1 ? __('lblDashProducts') : __('lblDashProduct') ;?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat emails">
				<div class="info">
					<abbr><?php echo $tpl['cnt_emails'];?></abbr>
					<?php echo $tpl['cnt_emails'] != 1 ? __('lblDashEmailsCollected') : __('lblDashEmailCollected') ;?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblDashLatestOffers');?></div>
			<div class="dashboard_column_top"><?php __('lblDashMostOffers');?></div>
			<div class="dashboard_column_top"><?php __('lblDashLatestEmails');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(!empty($tpl['latest_offers']))
					{
						foreach($tpl['latest_offers'] as $k => $v)
						{
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']?>?controller=pjAdminProducts&amp;action=pjActionUpdate&amp;id=<?php echo $v['product_id']?>"><?php echo pjSanitize::html($v['name']);?></a></label>
								<label><?php __('lblPrice');?>: <?php echo pjUtil::formatCurrencySign($v['product_price'], $tpl['option_arr']['o_currency']);?></label>
								<label><?php __('lblDashOfferReceived');?>: <a href="<?php echo $_SERVER['PHP_SELF']?>?controller=pjAdminOffers&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']?>"><?php echo pjUtil::formatCurrencySign($v['price'], $tpl['option_arr']['o_currency']);?></a></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><?php __('lblDashNoOffersFound');?></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(!empty($tpl['most_products']))
					{
						foreach($tpl['most_products'] as $k => $v)
						{
							?>
							<div class="dashboard_row">
								<label><?php echo pjSanitize::html($v['name']);?></label>
								<?php
								if($v['cnt_offers'] > 0)
								{
									?><label><a href="<?php echo $_SERVER['PHP_SELF']?>?controller=pjAdminOffers&amp;action=pjActionIndex&amp;product_id=<?php echo $v['id']?>"><?php echo $v['cnt_offers'];?> <?php $v['cnt_offers'] != 1 ? __('lblDashOffers') : __('lblDashOffer'); ?></a></label><?php
								} else {
									?><label>0 <?php __('lblDashOffers');?></label><?php
								}
								?>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><?php __('lblDashNoProductsFound');?></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(!empty($tpl['latest_emails']))
					{
						foreach($tpl['latest_emails'] as $k => $v)
						{
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']?>?controller=pjAdminProducts&amp;action=pjActionUpdate&amp;id=<?php echo $v['product_id']?>"><?php echo pjSanitize::html($v['name']);?></a></label>
								<label><?php __('email');?>: <?php echo $v['email'];?></label>
								<label><?php __('lblDashOfferMade');?>: <a href="<?php echo $_SERVER['PHP_SELF']?>?controller=pjAdminOffers&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']?>"><?php echo pjUtil::formatCurrencySign($v['price'], $tpl['option_arr']['o_currency']);?></a></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row">
							<label><?php __('lblDashNoEmailsFound');?></label>
						</div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> 
		<?php echo date($tpl['option_arr']['o_date_format'], strtotime($_SESSION[$controller->defaultUser]['last_login'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($_SESSION[$controller->defaultUser]['last_login'])); ?></div>
		<div class="float_right overflow">
		<?php
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format']); ?></div>
		</div>
	</div>
	<?php
}
?>