<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	pjUtil::printNotice(__('infoUpdateProductTitle', true), __('infoUpdateProductDesc', true));
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminProducts&amp;action=pjActionUpdate" method="post" id="frmUpdateProduct" class="pj-form form">
		<input type="hidden" name="product_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />

		<div class="clear_both">
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<label class="block float_left t5 r30"><a href="preview.php?product_id=<?php echo $tpl['arr']['id'];?>&theme=<?php echo $tpl['option_arr']['o_theme'];?>" target="_blank"><?php __('lblPreviewOfferWidget');?></a></label>
					<label class="block float_left t5"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionInstall&amp;id=<?php echo $tpl['arr']['id'];?>"><?php __('lblInstallOfferWidget');?></a></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblProductName'); ?></label>
				<span class="inline_block">
					<input type="text" name="name" value="<?php echo pjSanitize::html($tpl['arr']['name']);?>"class="pj-form-field required w300" data-msg-required="<?php __('lblFieldRequired');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblPrice'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-custom pj-form-field-custom-before float_left r10">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="price" name="price" class="pj-form-field required number w60" value="<?php echo $tpl['arr']['price']?>" data-currency="<?php echo $tpl['option_arr']['o_currency'];?>" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-number="<?php __('lblValidPrice');?>"/>
					</span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('menuOfferReceived'); ?></label>
				<span class="block t5 overflow lh20">
					<?php
					if($tpl['cnt_offers'] > 0)
					{
						$tmp_msg = __('lblOffersFromUniqueIP', true);
						$tmp_msg = str_replace("{OFFERS}", $tpl['cnt_offers'], $tmp_msg);
						$tmp_msg = str_replace("{IP}", $tpl['cnt_ips'], $tmp_msg);
						$tmp_msg = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminOffers&amp;action=pjActionIndex&amp;product_id='.$tpl['arr']['id'].'">', $tmp_msg);
						$tmp_msg = str_replace("{ETAG}", '</a>', $tmp_msg);
						 
						$message_arr = array();
						$message_arr[] = $tmp_msg;
						if($tpl['cnt_offers'] > 1 && $tpl['cnt_offers'] > $tpl['cnt_ips'])
						{
							$message_arr[] = '(<a href="#" class="pjSpRemoveDuplicates" data-id="'.$tpl['arr']['id'].'">' . __('lblRemoveDuplicates', true) . '</a>)';
						}
						$tmp_arr = array();
						$tmp_arr[] = $tpl['arr']['cnt_emails'] . ' ' . ($tpl['arr']['cnt_emails'] != 1 ? __('lblEmailAddresses', true) : __('lblEmailAddress', true));
						$tmp_arr[] = $tpl['arr']['cnt_thanks'] . ' ' . __('lblThankYou', true);
						$tmp_arr[] = $tpl['arr']['cnt_codes'] . ' ' . ($tpl['arr']['cnt_codes'] != 1 ? __('lblPromoCodes', true) : mb_strtolower(__('lblPromoCode', true), 'UTF-8'));
						$message_arr[] = '<br/>' . join(", ", $tmp_arr); 
						
						echo join(" ", $message_arr);
					}else{
						echo $tpl['cnt_offers'];
					}
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblAvgOfferedPrice'); ?></label>
				<span class="inline_block">
					<label class="block t5"><?php echo pjUtil::formatCurrencySign(number_format($tpl['arr']['avg_price'], 2), $tpl['option_arr']['o_currency']);?></label>
				</span>
			</p>
			<?php
			$price_suggestions = __('price_suggest', true); 
			$suggest_actions = __('suggest_action', true);
			?>
			<p>
				<label class="title"><?php __('lblPriceSuggestions'); ?></label>
				<span class="inline_block">
					<span class="block float_left r10 t5">
						<input type="radio" name="suggest_type" id="offer_type" value="offer"<?php echo $tpl['arr']['suggest_type'] == 'offer' ? ' checked="checked"' : NULL;?> class="block float_left r5"/><label for="offer_type" class="block float_left"><?php echo $price_suggestions['offer'];?></label>
					</span>
					<span class="block float_left r10 t5">
						<input type="radio" name="suggest_type" id="suggest_type" value="suggest"<?php echo $tpl['arr']['suggest_type'] == 'suggest' ? ' checked="checked"' : NULL;?> class="block float_left r5"/><label for="suggest_type" class="block float_left"><?php echo $price_suggestions['suggest'];?></label>
					</span>
				</span>
			</p>
			
			<div id="pjSpOfferBox" style="display:<?php echo $tpl['arr']['suggest_type'] == 'offer' ? 'block' : 'none'; ?>;">
				<p>
					<label class="title"><?php __('lblPriceSuggestionOne'); ?></label>
					<span class="inline_block">
						<span class="pj-form-field-custom pj-form-field-custom-before float_left r10">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" name="price_suggest_1" value="<?php echo $tpl['arr']['price_suggest_1'];?>" class="pj-form-field number w60" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-number="<?php __('lblValidPrice');?>"/>
						</span>
						<select name="price_suggest_1_action" class="pj-form-field w150 float_left r10 pjSpSuggestAction" data-index="1">
							<option value="">-- <?php __('lblAction'); ?> --</option>
							<?php
							foreach($suggest_actions as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['price_suggest_1_action'] ? ' selected="selected"' : null;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
						<span id="price_suggest_1_promo_box" class="price_suggest_1 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_1_action'] == 'promo' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblPromoCode');?></label>
							<input type="text" name="price_suggest_1_promo" value="<?php echo pjSanitize::html($tpl['arr']['price_suggest_1_promo']);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_suggest_1_email_box" class="price_suggest_1 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_1_action'] == 'email' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblEmailRequest');?></label>
							<input type="text" name="price_suggest_1_email" value="<?php echo !empty($tpl['arr']['price_suggest_1_email']) ? pjSanitize::html($tpl['arr']['price_suggest_1_email']) : __('lblDefaultEmailRequest', true);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_suggest_1_thank_box" class="price_suggest_1 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_1_action'] == 'thank' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblMessage');?></label>
							<input type="text" name="price_suggest_1_message" value="<?php echo !empty($tpl['arr']['price_suggest_1_message']) ? pjSanitize::html($tpl['arr']['price_suggest_1_message']) : __('lblDefaultMessage', true);?>" class="pj-form-field w200"/>
						</span>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblPriceSuggestionTwo'); ?></label>
					<span class="inline_block">
						<span class="pj-form-field-custom pj-form-field-custom-before float_left r10">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" name="price_suggest_2" value="<?php echo $tpl['arr']['price_suggest_2'];?>" class="pj-form-field number w60"/>
						</span>
						
						<select name="price_suggest_2_action" class="pj-form-field w150 float_left r10 pjSpSuggestAction" data-index="2">
							<option value="">-- <?php __('lblAction'); ?> --</option>
							<?php
							foreach($suggest_actions as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['price_suggest_2_action'] ? ' selected="selected"' : null;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
						<span id="price_suggest_2_promo_box" class="price_suggest_2 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_2_action'] == 'promo' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblPromoCode');?></label>
							<input type="text" name="price_suggest_2_promo" value="<?php echo pjSanitize::html($tpl['arr']['price_suggest_2_promo']);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_suggest_2_email_box" class="price_suggest_2 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_2_action'] == 'email' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblEmailRequest');?></label>
							<input type="text" name="price_suggest_2_email" value="<?php echo !empty($tpl['arr']['price_suggest_2_email']) ? pjSanitize::html($tpl['arr']['price_suggest_2_email']) : __('lblDefaultEmailRequest', true);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_suggest_2_thank_box" class="price_suggest_2 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_2_action'] == 'thank' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblMessage');?></label>
							<input type="text" name="price_suggest_2_message" value="<?php echo !empty($tpl['arr']['price_suggest_2_message']) ? pjSanitize::html($tpl['arr']['price_suggest_2_message']) : __('lblDefaultMessage', true);?>" class="pj-form-field w200"/>
						</span>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblPriceSuggestionThree'); ?></label>
					<span class="inline_block">
						<span class="pj-form-field-custom pj-form-field-custom-before float_left r10">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" name="price_suggest_3" value="<?php echo $tpl['arr']['price_suggest_3'];?>" class="pj-form-field number w60" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-number="<?php __('lblValidPrice');?>"/>
						</span>
						
						<select name="price_suggest_3_action" class="pj-form-field w150 float_left r10 pjSpSuggestAction" data-index="3">
							<option value="">-- <?php __('lblAction'); ?> --</option>
							<?php
							foreach($suggest_actions as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['price_suggest_3_action'] ? ' selected="selected"' : null;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
						<span id="price_suggest_3_promo_box" class="price_suggest_3 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_3_action'] == 'promo' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblPromoCode');?></label>
							<input type="text" name="price_suggest_3_promo" value="<?php echo pjSanitize::html($tpl['arr']['price_suggest_3_promo']);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_suggest_3_email_box" class="price_suggest_3 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_3_action'] == 'email' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblEmailRequest');?></label>
							<input type="text" name="price_suggest_3_email" value="<?php echo !empty($tpl['arr']['price_suggest_3_email']) ? pjSanitize::html($tpl['arr']['price_suggest_3_email']) : __('lblDefaultEmailRequest', true);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_suggest_3_thank_box" class="price_suggest_3 block float_left" style="display: <?php echo $tpl['arr']['price_suggest_3_action'] == 'thank' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblMessage');?></label>
							<input type="text" name="price_suggest_3_message" value="<?php echo !empty($tpl['arr']['price_suggest_3_message']) ? pjSanitize::html($tpl['arr']['price_suggest_3_message']) : __('lblDefaultMessage', true);?>" class="pj-form-field w200"/>
						</span>
					</span>
				</p>
			</div>
			<div id="pjSpSuggestBox" style="display:<?php echo $tpl['arr']['suggest_type'] == 'suggest' ? 'block' : 'none'; ?>;">
				<?php
				$label_one =  __('lblPriceRangeOne', true);
				$label_two =  __('lblPriceRangeTwo', true);
				$label_three =  __('lblPriceRangeThree', true);
				
				$range_1 = number_format( ($tpl['arr']['price'] * 0 / 100), 2 );
				$range_2 = number_format( ($tpl['arr']['price'] * 33.33 / 100), 2 );
				$range_3 = number_format( (float) $range_2 + 0.01, 2 );
				$range_4 = number_format( ($tpl['arr']['price'] * 66.66 / 100), 2 );
				$range_5 = number_format( (float) $range_4 + 0.01, 2 );
				$range_6 = number_format( ($tpl['arr']['price'] * 100 / 100), 2 );
				
				$label_one = str_replace("{R1}", pjUtil::formatCurrencySign($range_1, $tpl['option_arr']['o_currency']), $label_one);
				$label_one = str_replace("{R2}", pjUtil::formatCurrencySign($range_2, $tpl['option_arr']['o_currency']), $label_one);
				
				$label_two = str_replace("{R3}", pjUtil::formatCurrencySign($range_3, $tpl['option_arr']['o_currency']), $label_two);
				$label_two = str_replace("{R4}", pjUtil::formatCurrencySign($range_4, $tpl['option_arr']['o_currency']), $label_two);
				
				$label_three = str_replace("{R5}", pjUtil::formatCurrencySign($range_5, $tpl['option_arr']['o_currency']), $label_three);
				$label_three = str_replace("{R6}", pjUtil::formatCurrencySign($range_6, $tpl['option_arr']['o_currency']), $label_three);
				?>
				<p>
					<label id="pjSpLabelOne" class="block float_left w250 t5 r10" data-title="<?php __('lblPriceRangeOne');?>"><?php echo $label_one; ?></label>
					<span class="inline_block">
						<select name="price_range_1_action" class="pj-form-field w150 float_left r10 pjSpRangeAction" data-index="1">
							<option value="">-- <?php __('lblAction'); ?> --</option>
							<?php
							foreach($suggest_actions as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['price_range_1_action'] ? ' selected="selected"' : null;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
						<span id="price_range_1_promo_box" class="price_range_1 block float_left" style="display: <?php echo $tpl['arr']['price_range_1_action'] == 'promo' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblPromoCode');?></label>
							<input type="text" name="price_range_1_promo" value="<?php echo pjSanitize::html($tpl['arr']['price_range_1_promo']);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_range_1_email_box" class="price_range_1 block float_left" style="display: <?php echo $tpl['arr']['price_range_1_action'] == 'email' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblEmailRequest');?></label>
							<input type="text" name="price_range_1_email" value="<?php echo !empty($tpl['arr']['price_range_1_email']) ? pjSanitize::html($tpl['arr']['price_range_1_email']) : __('lblDefaultEmailRequest', true);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_range_1_thank_box" class="price_range_1 block float_left" style="display: <?php echo $tpl['arr']['price_range_1_action'] == 'thank' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblMessage');?></label>
							<input type="text" name="price_range_1_message" value="<?php echo !empty($tpl['arr']['price_range_1_message']) ? pjSanitize::html($tpl['arr']['price_range_1_message']) : __('lblDefaultMessage', true);?>" class="pj-form-field w200"/>
						</span>
					</span>
				</p>
				<p>
					<label id="pjSpLabelTwo" class="block float_left w250 t5 r10" data-title="<?php __('lblPriceRangeTwo');?>"><?php echo $label_two; ?></label>
					<span class="inline_block">
						<select name="price_range_2_action" class="pj-form-field w150 float_left r10 pjSpRangeAction" data-index="2">
							<option value="">-- <?php __('lblAction'); ?> --</option>
							<?php
							foreach($suggest_actions as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['price_range_2_action'] ? ' selected="selected"' : null;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
						<span id="price_range_2_promo_box" class="price_range_2 block float_left" style="display: <?php echo $tpl['arr']['price_range_2_action'] == 'promo' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblPromoCode');?></label>
							<input type="text" name="price_range_2_promo" value="<?php echo pjSanitize::html($tpl['arr']['price_range_2_promo']);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_range_2_email_box" class="price_range_2 block float_left" style="display: <?php echo $tpl['arr']['price_range_2_action'] == 'email' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblEmailRequest');?></label>
							<input type="text" name="price_range_2_email" value="<?php echo !empty($tpl['arr']['price_range_2_email']) ? pjSanitize::html($tpl['arr']['price_range_2_email']) : __('lblDefaultEmailRequest', true);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_range_2_thank_box" class="price_range_2 block float_left" style="display: <?php echo $tpl['arr']['price_range_2_action'] == 'thank' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblMessage');?></label>
							<input type="text" name="price_range_2_message" value="<?php echo !empty($tpl['arr']['price_range_2_message']) ? pjSanitize::html($tpl['arr']['price_range_2_message']) : __('lblDefaultMessage', true);?>" class="pj-form-field w200"/>
						</span>
					</span>
				</p>
				<p>
					<label id="pjSpLabelThree" class="block float_left w250 t5 r10" data-title="<?php __('lblPriceRangeThree');?>"><?php echo $label_three; ?></label>
					<span class="inline_block">
						<select name="price_range_3_action" class="pj-form-field w150 float_left r10 pjSpRangeAction" data-index="3">
							<option value="">-- <?php __('lblAction'); ?> --</option>
							<?php
							foreach($suggest_actions as $k => $v)
							{
								?><option value="<?php echo $k;?>"<?php echo $k == $tpl['arr']['price_range_3_action'] ? ' selected="selected"' : null;?>><?php echo $v;?></option><?php
							} 
							?>
						</select>
						<span id="price_range_3_promo_box" class="price_range_3 block float_left" style="display: <?php echo $tpl['arr']['price_range_3_action'] == 'promo' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblPromoCode');?></label>
							<input type="text" name="price_range_3_promo" value="<?php echo pjSanitize::html($tpl['arr']['price_range_3_promo']);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_range_3_email_box" class="price_range_3 block float_left" style="display: <?php echo $tpl['arr']['price_range_3_action'] == 'email' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblEmailRequest');?></label>
							<input type="text" name="price_range_3_email" value="<?php echo !empty($tpl['arr']['price_range_3_email']) ? pjSanitize::html($tpl['arr']['price_range_3_email']) : __('lblDefaultEmailRequest', true);?>" class="pj-form-field w200"/>
						</span>
						<span id="price_range_3_thank_box" class="price_range_3 block float_left" style="display: <?php echo $tpl['arr']['price_range_3_action'] == 'thank' ? 'block' :'none'; ?>;">
							<label class="block float_left t5 r5 w80"><?php __('lblMessage');?></label>
							<input type="text" name="price_range_3_message" value="<?php echo !empty($tpl['arr']['price_range_3_message']) ? pjSanitize::html($tpl['arr']['price_range_3_message']) : __('lblDefaultMessage', true);?>" class="pj-form-field w200"/>
						</span>
					</span>
				</p>
			</div>
			<p>
				<label class="title"><?php __('lblAskForPrice'); ?></label>
				<span class="inline_block">
					<input type="text" name="ask_price" value="<?php echo !empty($tpl['arr']['ask_price']) ? pjSanitize::html($tpl['arr']['ask_price']) : __('lblAskForPriceDefaultText', true);?>" class="pj-form-field w400"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('u_statarr', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminProducts&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<div id="dialogRemove" title="<?php __('lblRemoveTitle'); ?>" style="display:none;">
		<div class="t5"><?php __('lblRemoveDesc'); ?></div>
	</div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	</script>
	<?php
}
?>