var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateOffer = $("#frmCreateOffer"),
			$frmUpdateOffer = $("#frmUpdateOffer"),
			chosen = ($.fn.chosen !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);

		if (chosen) {
			$("#filter_product_id").chosen();
		}
		function updateEditURL()
		{
			var product_id = $frmUpdateOffer.find('select[name="product_id"]').val(),
				href = $('#pjSPEditProduct').attr('data-href');
			if(product_id != '')
			{
				$('#pjSPEditProduct').attr('href', href).show();
			}else{
				$('#pjSPEditProduct').hide();
			}
		}
		
		if ($frmCreateOffer.length > 0 && validate) 
		{
			$frmCreateOffer.validate({
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'price')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		if ($frmUpdateOffer.length > 0 && validate) {
			$frmUpdateOffer.validate({
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'price')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
			updateEditURL();
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminOffers&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminOffers&action=pjActionDeleteOffer&id={:id}"}
				          ],
				columns: [{text: myLabel.name, type: "text", sortable: true, editable: false, width: 240},
				          {text: myLabel.price, type: "text", sortable: true, editable: false, width: 100},
				          {text: myLabel.type, type: "text", sortable: false, editable: false, width: 100},
				          {text: myLabel.received, type: "text", sortable: true, editable: false, width: 150}],
				dataUrl: "index.php?controller=pjAdminOffers&action=pjActionGetOffer" + pjGrid.queryString,
				dataOffer: "json",
				fields: ['name', 'price', 'type', 'created'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminOffers&action=pjActionDeleteOfferBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminOffers&action=pjActionExportOffers", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminOffers&action=pjActionSaveOffer&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$('#filter_product_id').val("").trigger("liszt:updated");
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminOffers&action=pjActionGetOffer", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminOffers&action=pjActionGetOffer", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminOffers&action=pjActionGetOffer", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("change", "select[name='product_id']", function (e) {
			var product_id = $(this).val();
			if($('#pjSpPriceBox').length > 0)
			{
				if(product_id == '')
				{
					$('#pjSpPriceBox').html('');
				}else{
					$.post(["index.php?controller=pjAdminOffers&action=pjActionGetPrices"].join(""), $frmUpdateOffer.serialize()).done(function (data) {
						$('#pjSpPriceBox').html(data);
					});
				}
				updateEditURL();
			}else{
				var content = $grid.datagrid("option", "content"),
					cache = $grid.datagrid("option", "cache");
				$.extend(cache, {
					product_id: product_id
				});
				$grid.datagrid("option", "cache", cache);
				$grid.datagrid("load", "index.php?controller=pjAdminOffers&action=pjActionGetOffer", "created", "DESC", content.page, content.rowCount);
			}
			
			return false;
		}).on("change", "input[name='price']", function (e) {
			var price = $(this).val();
			if($(this).valid()){
				$.post(["index.php?controller=pjAdminOffers&action=pjActionGetMessages"].join(""), $frmUpdateOffer.serialize()).done(function (data) {
					$('#pjSpMessageBox').html(data);
				});
			}
			return false;
		});
	});
})(jQuery_1_8_2);