var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var tabs = ($.fn.tabs !== undefined),
			$frmNotification = $('#frmNotification'),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		if($frmNotification.length > 0)
		{
			tinymce.init({
				relative_urls : false,
				remove_script_host : false,
			    selector: "textarea.mceEditor",
			    theme: "modern",
			    width: 560,
			    height: 200,
			    plugins: [
			         "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
			         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
			         "save table contextmenu directionality emoticons template paste textcolor"
			   ],
			   toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons"
			 });
		}
		
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme');
			
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme + '&product_id=' + $('#preview_product_id').val(),
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
				}
			});
		}).on("click", ".pj-button-get-code", function (e) {
			reDrawCode.call(null, 1);
		}).on("click", ".pj-button-preview", function (e) {
			if($('#product_id').length > 0)
			{
				var product_id = $('#product_id').val(),
					theme = $('#theme').val();
				
				if(product_id != '')
				{
					$('#product_id').removeClass('pjPcRedBorder');
					window.open("preview.php?product_id=" + product_id + "&theme=" + theme);
				}else{
					$('#product_id').addClass('pjPcRedBorder');
				}
			}
		}).on("change", "#product_id", function (e) {
			reDrawCode.call(null, 0);
		}).on("change", "#theme", function (e) {
			reDrawCode.call(null, 1);
		}).on("change", "#preview_product_id", function (e) {
			var product_id = $(this).val();
			$('.pj_preview_install').each(function(){
				var theme = $(this).attr('data-theme');
				$(this).attr('href', 'preview.php?product_id=' + product_id + '&theme=' + theme);
			});
		});
		
		function reDrawCode(open) {
			var code = $("#hidden_code").text(),
				product_id = $("select[name='product_id']").find("option:selected").val(),
				theme = $("select[name='theme']").find("option:selected").val();
			product_id = parseInt(product_id, 10) > 0 ? "&product_id=" + product_id : "";
			theme = theme != '' ? "&theme=" + theme : "";
			
			code = code.replace(/&action=pjActionLoadCss/g, function(match) {
	            return ["&action=pjActionLoadCss", theme].join("");
	        });
			code = code.replace(/&action=pjActionLoadJS/g, function(match) {
	            return ["&action=pjActionLoad", product_id, theme].join("");
	        });
			
			$("#install_code").text(code);
			if($('#product_id').length > 0)
			{
				var product_id = $('#product_id').val(),
					theme = $('#theme').val();
				if(product_id != '')
				{
					if(open == 1)
					{
						$('#step_container').show();
					}
					$('#product_id').removeClass('pjPcRedBorder');
				}else{
					$('#step_container').hide();
					$('#product_id').addClass('pjPcRedBorder');
				}
			}
		}
	});
})(jQuery_1_8_2);