<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminBids extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['bid_create']))
			{
				$pjBidModel = pjBidModel::factory();
				$pjProductModel = pjProductModel::factory();
				
				$data = array();
				$data['created'] = date('Y-m-d H:i:s');
				$data['modified'] = ":NULL";
				if($_POST['status'] == 'won')
				{
					$pjProductModel->where('id', $_POST['product_id'])->limit(1)->modifyAll(array('status' => 'F'));
					$pjBidModel->reset()->where('product_id', $_POST['product_id'])->where('status', 'won')->modifyAll(array('status' => 'received'));
				}
				$data['bid_price'] = pjUtil::convertToMySQLNumber($_POST['bid_price'], $this->option_arr);
				
				$id = $pjBidModel->reset()->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'ABD03';
					if($_POST['status'] == 'won')
					{
						pjAppController::pjActionConfirmSend($this->option_arr, $id, PJ_SALT, 'bid_won', $this->getLocaleId());
					}
				} else {
					$err = 'ABD04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminBids&action=pjActionIndex&err=$err");
			} else {
				$product_arr = pjProductModel::factory()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->select("t1.*, t2.content AS name")
					->orderBy("name ASC")
					->findAll()
					->getData();
				$this->set('product_arr', $product_arr);
				
				$client_arr = pjClientModel::factory()->where("t1.status", 'T')->orderBy("name ASC")->findAll()->getData();
				$this->set('client_arr', $client_arr);
				
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminBids.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteBid()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjBidModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteBidBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjBidModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetBid()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjBidModel = pjBidModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.product_id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjClient', "t3.id = t1.client_id", 'left')
				->join('pjProduct', "t4.id = t1.product_id", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjBidModel->where("(t2.content LIKE '%$q%' OR t3.name LIKE '%$q%' OR t3.email LIKE '%$q%')");
			}
			if (isset($_GET['name']) && !empty($_GET['name']))
			{
				$q = pjObject::escapeString($_GET['name']);
				$pjBidModel->where("(t3.name LIKE '%$q%')");
			}
			if (isset($_GET['email']) && !empty($_GET['email']))
			{
				$q = pjObject::escapeString($_GET['email']);
				$pjBidModel->where("(t3.email LIKE '%$q%')");
			}
			if (isset($_GET['status']) && in_array($_GET['status'], array('won', 'received', 'rejected')))
			{
				$pjBidModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['product_id']) && (int) $_GET['product_id'] > 0)
			{
				$pjBidModel->where("(t1.product_id=".$_GET['product_id'].")");
			}
			if (isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
			{
				$pjBidModel->where("(t1.client_id=".$_GET['client_id'].")");
			}
			
			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjBidModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjBidModel
				->select("t1.*, t2.content AS product, t3.name, t3.email, t4.status AS product_status, t4.closed")
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				$v['name'] = pjSanitize::html($v['name']);
				$v['bid_price'] = pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['bid_price'], $this->option_arr), $this->option_arr['o_currency']);
				$v['created'] = date($this->option_arr['o_date_format'] . ', ' . $this->option_arr['o_time_format'], strtotime($v['created']));
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$product_arr = pjProductModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->select("t1.*, t2.content AS name")
				->orderBy("name ASC")
				->findAll()
				->getData();
			$this->set('product_arr', $product_arr);
			
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
			$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
			$this->appendJs('pjAdminBids.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveBid()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjBidModel = pjBidModel::factory();
			$arr = $pjBidModel->find($_GET['id'])->getData();
			if($_POST['column'] == 'status' && $_POST['value'] == 'won')
			{
				$pjProductModel = pjProductModel::factory();
				$pjProductModel->where('id', $arr['product_id'])->limit(1)->modifyAll(array('status' => 'F'));
				$pjBidModel->reset()->where('product_id', $arr['product_id'])->where('status', 'won')->modifyAll(array('status' => 'received'));
			}
			$pjBidModel->reset()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value'], 'modified' => date('Y-m-d H:i:s')));
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			if (isset($_POST['bid_update']))
			{
				$pjProductModel = pjProductModel::factory();
				$pjBidModel = pjBidModel::factory();
				
				$product = $pjProductModel->find($_POST['product_id'])->getData();
				$bid = $pjBidModel->find($_POST['id'])->getData();
				
				$data = array();
				$data['modified'] = date('Y-m-d H:i:s');
				if($_POST['status'] == 'won')
				{
					$pjProductModel->reset()->where('id', $_POST['product_id'])->limit(1)->modifyAll(array('status' => 'F'));
					$pjBidModel->reset()->where('product_id', $_POST['product_id'])->where('status', 'won')->modifyAll(array('status' => 'received'));
				}else{
					if($bid['status'] == 'won' && $product['status'] == 'F' && $product['closed'] >= date('Y-m-d H:i:s'))
					{
						$pjProductModel->reset()->where('id', $_POST['product_id'])->limit(1)->modifyAll(array('status' => 'T'));
					}
				}
				$data['bid_price'] = pjUtil::convertToMySQLNumber($_POST['bid_price'], $this->option_arr);
				
				$pjBidModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminBids&action=pjActionIndex&err=ABD01");
			} else {
				$arr = pjBidModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminBids&action=pjActionIndex&err=ABD08");
				}
				$this->set('arr', $arr);
				
				$product_arr = pjProductModel::factory()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->select("t1.*, t2.content AS name")
					->orderBy("name ASC")
					->findAll()
					->getData();
				$this->set('product_arr', $product_arr);
				
				$client_arr = pjClientModel::factory()->where("t1.status", 'T')->orderBy("name ASC")->findAll()->getData();
				$this->set('client_arr', $client_arr);
				
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminBids.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionConfirmation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['send_confirm']) && !empty($_POST['to']) && !empty($_POST['from']) &&
					!empty($_POST['subject']) && !empty($_POST['message']))
			{
				$Email = new pjEmail();
				$Email->setContentType('text/html');
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$Email
						->setTransport('smtp')
						->setSmtpHost($this->option_arr['o_smtp_host'])
						->setSmtpPort($this->option_arr['o_smtp_port'])
						->setSmtpUser($this->option_arr['o_smtp_user'])
						->setSmtpPass($this->option_arr['o_smtp_pass'])
						->setSender($this->option_arr['o_smtp_user']);
				}
	
				$subject = $_POST['subject'];
				$message = $_POST['message'];
				if (get_magic_quotes_gpc())
				{
					$subject = stripslashes($_POST['subject']);
					$message = stripslashes($_POST['message']);
				}
	
				$r = $Email
					->setTo($_POST['to'])
					->setFrom($_POST['from'])
					->setSubject($subject)
					->send($message);
					
				if ($r)
				{
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Email has been sent.'));
				}
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Email failed to send.'));
			}
	
			if (isset($_POST['product_id']) && (int) $_POST['product_id'] > 0 && isset($_POST['client_id']) && (int) $_POST['client_id'] > 0 && isset($_POST['bid_price']) && (float) $_POST['bid_price'] > 0)
			{
				$pjMultiLangModel = pjMultiLangModel::factory();
				$lang_message = $pjMultiLangModel->reset()->select('t1.*')
					->where('t1.model','pjOption')
					->where('t1.locale', $this->getLocaleId())
					->where('t1.field', 'o_email_bid_won_message')
					->limit(0, 1)
					->findAll()->getData();
				$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
					->where('t1.model','pjOption')
					->where('t1.locale', $this->getLocaleId())
					->where('t1.field', 'o_email_bid_won_subject')
					->limit(0, 1)
					->findAll()->getData();
	
				if (count($lang_message) === 1 && count($lang_subject) === 1)
				{
					$product_arr = pjProductModel::factory()
						->select("t1.*, t2.content as name")
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
						->find($_POST['product_id'])
						->getData();
					$client_arr = pjClientModel::factory()->find($_POST['client_id'])->getData();
					$bid_price = pjUtil::convertToMySQLNumber($_POST['bid_price'], $this->option_arr);
					$bid_price = pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($bid_price, $this->option_arr), $this->option_arr['o_currency']);
					$search = array('{Product}','{BidPrice}','{Name}','{Email}');
					$replace = array($product_arr['name'],$bid_price,$client_arr['name'],$client_arr['email']);
					$subject_client = str_replace($search, $replace, $lang_subject[0]['content']);
					$message_client = str_replace($search, $replace, $lang_message[0]['content']);
	
					$this->set('arr', array(
							'to' => $client_arr['email'],
							'from' => $this->getAdminEmail(),
							'message' => $message_client,
							'subject' => $subject_client
					));
				}
			} else {
				exit;
			}
		}
	}
}
?>