<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminProducts extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminProducts&action=pjActionIndex&err=AP05");
			}
			if (isset($_POST['product_create']))
			{
				$pjProductModel = pjProductModel::factory();
				$data = array();
				$closed_arr = pjUtil::convertDateTime($_POST['closed'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
				$data['closed'] = $closed_arr['iso_date_time'];
				$data['created'] = date('Y-m-d H:i:s');
				$id = $pjProductModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AP03';
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjProduct', 'data');
					}
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminProducts&action=pjActionUpdate&id=$id&err=$err");
				} else {
					$err = 'AP04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminProducts&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				$this->set('category_arr', pjCategoryModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCategory' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.status', 'T')
					->orderBy('`name` ASC')
					->findAll()
					->getData());
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery-ui-timepicker-addon.js', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendCss('jquery-ui-timepicker-addon.css', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendJs('pjAdminProducts.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteProduct()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$pjProductModel = pjProductModel::factory();
			$arr = $pjProductModel->find($_GET['id'])->getData();
			if ($pjProductModel->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjMultiLangModel::factory()->where('model', 'pjProduct')->where('foreign_id', $_GET['id'])->eraseAll();
				pjBidModel::factory()->where('product_id', $_GET['id'])->eraseAll();
				$pjGalleryModel = pjGalleryModel::factory();
				$image_arr = $pjGalleryModel->where('t1.foreign_id', $_GET['id'])->findAll()->getData();
				foreach($image_arr as $v){
					@unlink($v['small_path']);
					@unlink($v['medium_path']);
					@unlink($v['large_path']);
					@unlink($v['source_path']);
				}
				$pjGalleryModel->reset()->where('foreign_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteProductBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjProductModel = pjProductModel::factory();
				$arr = $pjProductModel->whereIn('id', $_POST['record'])->findAll()->getData();
				$pjProductModel->reset()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjProduct')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				pjBidModel::factory()->whereIn('product_id', $_POST['record'])->eraseAll();
				$pjGalleryModel = pjGalleryModel::factory();
				$image_arr = $pjGalleryModel->whereIn('t1.foreign_id', $_POST['record'])->findAll()->getData();
				foreach($image_arr as $v){
					@unlink($v['small_path']);
					@unlink($v['medium_path']);
					@unlink($v['large_path']);
					@unlink($v['source_path']);
				}
				$pjGalleryModel->reset()->whereIn('foreign_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetProduct()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjProductModel = pjProductModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.category_id AND t3.model = 'pjCategory' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'name'", 'left');
			
			if (isset($_GET['status']) && !empty($_GET['status']))
			{
				$pjProductModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjProductModel->where("(t2.content LIKE '%$q%')");
			}
			if (isset($_GET['category_id']) && (int) $_GET['category_id'] > 0)
			{
				$pjProductModel->where('t1.category_id', $_GET['category_id']);
			}

			$column = 'created';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjProductModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$bid_table = pjBidModel::factory()->getTable();
			$data = $pjProductModel
				->select("t1.*, t2.content AS name, t3.content AS category, 
						(SELECT COUNT(`TB`.id) FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id) AS cnt_bids,
						(SELECT `TB`.bid_price FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id ORDER BY bid_price DESC LIMIT 1) AS highest_bid,
						(SELECT `TB`.id FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id ORDER BY bid_price DESC LIMIT 1) AS highest_bid_id,
						(SELECT `TB`.bid_price FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id AND `TB`.status='won' LIMIT 1) AS won_price,
						(SELECT `TB`.id FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id AND `TB`.status='won' LIMIT 1) AS won_id,
						(SELECT `small_path` FROM `".pjGalleryModel::factory()->getTable()."` WHERE `foreign_id` = t1.id ORDER BY `sort` ASC LIMIT 1) AS `image`")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				if((float) $v['highest_bid'] > 0)
				{
					$v['highest_bid'] = pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['highest_bid'], $this->option_arr), $this->option_arr['o_currency']);
				}else{
					$v['highest_bid'] = __('lblNa', true);
				}
				if((int) $v['won_id'] > 0)
				{
					$v['won_price'] = pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['won_price'], $this->option_arr), $this->option_arr['o_currency']);
				}else{
					$v['won_price'] = '';
				}
				$v['name'] = pjSanitize::html($v['name']) . '<br/>' . '<i>'.pjSanitize::html($v['category']).'</i>';
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminProducts.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveProduct()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjProductModel = pjProductModel::factory();
			if (!in_array($_POST['column'], $pjRouteModel->i18n))
			{
				$value = $_POST['value'];
				
				$pjProductModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $value));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjProduct', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminProducts&action=pjActionIndex&err=AP06");
			}
			if (isset($_POST['product_update']))
			{
				$pjProductModel = pjProductModel::factory();
				
				$err = 'AP01';
				
				$arr = $pjProductModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminProducts&action=pjActionIndex&err=AP08");
				}
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjProduct', 'data');
				}
				
				$data = array();
				$closed_arr = pjUtil::convertDateTime($_POST['closed'], $this->option_arr['o_date_format'], $this->option_arr['o_time_format']);
				$data['closed'] = $closed_arr['iso_date_time'];
				$data['modified'] = date('Y-m-d H:i:s');
				$pjProductModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				if($err == 'AP01')
				{
					pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminProducts&action=pjActionIndex&err=AP01");
				}else{
					pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminProducts&action=pjActionUpdate&id=".$_POST['id']."&err=$err");
				}
			} else {
				$pjMultiLangModel = pjMultiLangModel::factory();
				$bid_table = pjBidModel::factory()->getTable();
				$arr = pjProductModel::factory()
					->select("t1.*,
						(SELECT COUNT(`TB`.id) FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id) AS cnt_bids,
						(SELECT `TB`.bid_price FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id ORDER BY bid_price DESC LIMIT 1) AS highest_bid,
						(SELECT `TB`.id FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id ORDER BY bid_price DESC LIMIT 1) AS highest_bid_id")
					->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminProducts&action=pjActionIndex&err=AP08");
				}
				$arr['i18n'] = $pjMultiLangModel->getMultiLang($arr['id'], 'pjProduct');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->set('category_arr', pjCategoryModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCategory' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.status', 'T')
					->orderBy('`name` ASC')
					->findAll()
					->getData());
				
				$won_bid = pjBidModel::factory()
					->select("t1.*, t2.name")
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->where('t1.status', 'won')
					->where('t1.product_id', $_GET['id'])
					->findAll()->getDataIndex(0);
				$this->set('won_bid', $won_bid);
				
				$this->appendCss('pj-gallery.css', pjObject::getConstant('pjGallery', 'PLUGIN_CSS_PATH'));
				$this->appendJsFromPlugin('ajaxupload.js', 'ajaxupload', 'pjGallery');
				$this->appendJs('jquery.gallery.js', pjObject::getConstant('pjGallery', 'PLUGIN_JS_PATH'));
				
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery-ui-timepicker-addon.js', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendCss('jquery-ui-timepicker-addon.css', PJ_THIRD_PARTY_PATH . 'datetimepicker/');
				$this->appendJs('pjAdminProducts.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale']) && (int) $_GET['locale'] > 0)
			{
				pjAppController::setFields($_GET['locale']);
				
				$this->set('category_arr', pjCategoryModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCategory' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".pjObject::escapeString($_GET['locale'])."'", 'left outer')
					->where('t1.status', 'T')
					->orderBy('`order` ASC')
					->findAll()
					->getData());
			}
		}
	}
	
	public function pjActionDeleteImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			$pjProductModel = pjProductModel::factory();
			$arr = $pjProductModel->find($_GET['id'])->getData(); 
			
			if(!empty($arr))
			{
				if(!empty($arr['image']))
				{					
					@unlink(PJ_INSTALL_PATH . $arr['image']);
				}
				
				$data = array();
				$data['image'] = ':NULL';
				$pjProductModel->reset()->where(array('id' => $_GET['id']))->limit(1)->modifyAll($data);
				
				$response['code'] = 200;
			}else{
				$response['code'] = 100;
			}
			
			pjAppController::jsonResponse($response);
		}
	}
}
?>