<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFrontPublic extends pjFront
{
	public function __construct()
	{
		parent::__construct();
		
		$this->setAjax(true);
		
		$this->setLayout('pjActionEmpty');
	}
	
	public function pjActionProducts()
	{
		if($this->isXHR())
		{
			$pjProductModel = pjProductModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
				->join('pjMultiLang', "t4.foreign_id = t1.category_id AND t4.model = 'pjCategory' AND t4.locale = '".$this->getLocaleId()."' AND t4.field = 'name'", 'left')
				->where("t1.status='T' AND t1.closed >= NOW()");
			if(isset($_GET['category_id']) && (int) $_GET['category_id'])
			{
				$pjProductModel->where("t1.category_id", $_GET['category_id']);
			}
			$total = $pjProductModel->findCount()->getData();
			$rowCount = (int) $this->option_arr['o_products_per_page'] > 0 ? $this->option_arr['o_products_per_page'] : 5;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$pjProductModel->limit($rowCount, $offset);

			$bid_table = pjBidModel::factory()->getTable();
			$product_arr = $pjProductModel
				->select("t1.*, t2.content AS name, t3.content AS description, t4.content as category,
						(SELECT COUNT(`TB`.id) FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id) AS cnt_bids,
						(SELECT `TB`.bid_price FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id AND `TB`.status='won') AS bid_won_price,
						(SELECT `TB`.bid_price FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id ORDER BY bid_price DESC LIMIT 1) AS highest_bid,
						(SELECT `medium_path` FROM `".pjGalleryModel::factory()->getTable()."` WHERE `foreign_id` = t1.id ORDER BY `sort` ASC LIMIT 1) AS `image`")
				->orderBy("`created` DESC")->findAll()->getData();
			
			$this->set('product_arr', $product_arr);
			$this->set('paginator', array('pages' => $pages, 'page' => $page, 'offset' => $offset, 'total' => $total));
			
			if($this->isFrontLogged())
			{
				$pjBidModel = pjBidModel::factory();
				$product_ids = $pjBidModel->where("t1.client_id", $_SESSION[$this->defaultFrontClient]['id'])->findAll()->getDataPair('product_id', 'bid_price');
				$this->set('product_ids', $product_ids);
			}
		}
	}
	
	public function pjActionLogin()
	{
		if($this->isXHR())
		{
			if(isset($_POST['login']))
			{
				$front_err = pjSanitize::clean(__('front_err', true));
				if (!isset($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG01', 'code' => 100, 'text' => $front_err['LOG01']));
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG02', 'code' => 101, 'text' => $front_err['LOG02']));
				}
				if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG03', 'code' => 103, 'text' => $front_err['LOG03']));
				}
				if (!isset($_POST['password']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG04', 'code' => 104, 'text' => $front_err['LOG04']));
				}
				if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
				{
					pjAppController::jsonResponse(array('status' => 'LOG05', 'code' => 105, 'text' => $front_err['LOG05']));
				}
			
				$pjClientModel = pjClientModel::factory();
				$client = $pjClientModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
					->where('t1.email', $_POST['email'])
					->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['password']), PJ_SALT))
					->limit(1)
					->findAll()
					->getData();
				if (count($client) != 1)
				{
					$temp_client = $pjClientModel
						->reset()
						->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
						->where('t1.email', $_POST['email'])
						->limit(1)
						->findAll()
						->getData();
					if (count($temp_client) != 1)
					{
						pjAppController::jsonResponse(array('status' => 'LOG06', 'code' => 106, 'text' => $front_err['LOG06']));
					}else{
						pjAppController::jsonResponse(array('status' => 'LOG08', 'code' => 108, 'text' => $front_err['LOG08']));
					}
				}else{
					$client = $client[0];
					if ($client['status'] == 'F')
					{
						pjAppController::jsonResponse(array('status' => 'LOG07', 'code' => 107, 'text' => $front_err['LOG07']));
					}
					$_SESSION[$this->defaultFrontClient] = $client;
			
					$data = array();
					$data['last_login'] = date("Y-m-d H:i:s");
					$data['ip'] = pjUtil::getClientIp();
					$pjClientModel->reset()->setAttributes(array('id' => $client['id']))->modify($data);
			
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
				}
			}
		}
	}
	
	public function pjActionForgot()
	{
		if($this->isXHR())
		{
			if(isset($_POST['forgot']))
			{
				$front_err = pjSanitize::clean(__('front_err', true));
				$front_msg = pjSanitize::clean(__('front_msg', true));
	
				if (!isset($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'FOR01', 'code' => 101, 'text' => $front_err['FOR01']));
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'FOR02', 'code' => 102, 'text' => $front_err['FOR02']));
				}
				if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'FOR03', 'code' => 103, 'text' => $front_err['FOR03']));
				}
	
				$pjClientModel = pjClientModel::factory();
				$client_arr = $pjClientModel
					->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`")
					->where('t1.email', $_POST['email'])
					->limit(1)
					->findAll()
					->getData();
				if(count($client_arr) == 0)
				{
					pjAppController::jsonResponse(array('status' => 'FOR05', 'code' => 105, 'text' => $front_err['FOR05']));
				}
				$client = $client_arr[0];
				if($client['status'] == 'F')
				{
					pjAppController::jsonResponse(array('status' => 'FOR04', 'code' => 104, 'text' => $front_err['FOR04']));
				}else{
					$pjMultiLangModel = pjMultiLangModel::factory();
					$lang_message = $pjMultiLangModel->reset()->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_email_forgot_message')
						->limit(0, 1)
						->findAll()->getData();
					$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $this->getLocaleId())
						->where('t1.field', 'o_email_forgot_subject')
						->limit(0, 1)
						->findAll()->getData();
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if(!empty($lang_message[0]['content']) && !empty($lang_subject[0]['content']))
						{
							$pjEmail = new pjEmail();
		
							if ($this->option_arr['o_send_email'] == 'smtp')
							{
								$pjEmail
									->setTransport('smtp')
									->setSmtpHost($this->option_arr['o_smtp_host'])
									->setSmtpPort($this->option_arr['o_smtp_port'])
									->setSmtpUser($this->option_arr['o_smtp_user'])
									->setSmtpPass($this->option_arr['o_smtp_pass'])
									->setSender($this->option_arr['o_smtp_user']);
							}
		
							$to = $_POST['email'];
							$subject = $lang_subject[0]['content'];
							$from = $this->getAdminEmail();
		
							$message = str_replace(
									array('{Name}', '{Email}', '{Password}'),
									array($client['name'], $client['email'], $client['password']),
									$lang_message[0]['content']
							);
		
							$pjEmail->setContentType('text/html');
							$pjEmail->setTo($to);
							$pjEmail->setFrom($from);
							$pjEmail->setSubject($subject);
							$pjEmail->send($message);
		
							pjAppController::jsonResponse(array('status' => 'FOR01', 'code' => 200, 'text' => $front_msg['FOR01']));
						}
					}
				}
			}
		}
	}
	
	public function pjActionRegister()
	{
		if($this->isXHR())
		{
			if(isset($_POST['register']))
			{
				$front_err = pjSanitize::clean(__('front_err', true));
				$front_msg = pjSanitize::clean(__('front_msg', true));
				
				if (!isset($_POST['name']))
				{
					pjAppController::jsonResponse(array('status' => 'REG01', 'code' => 101, 'text' => $front_err['REG01']));
				}
				if (isset($_POST['name']) && !pjValidation::pjActionNotEmpty($_POST['name']))
				{
					pjAppController::jsonResponse(array('status' => 'REG02', 'code' => 102, 'text' => $front_err['REG02']));
				}
				if (!isset($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'REG03', 'code' => 103, 'text' => $front_err['REG02']));
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'REG04', 'code' => 104, 'text' => $front_err['REG04']));
				}
				if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'REG05', 'code' => 105, 'text' => $front_err['REG05']));
				}
				if (!isset($_POST['password']))
				{
					pjAppController::jsonResponse(array('status' => 'REG06', 'code' => 106, 'text' => $front_err['REG06']));
				}
				if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
				{
					pjAppController::jsonResponse(array('status' => 'REG07', 'code' => 107, 'text' => $front_err['REG07']));
				}
				if (!isset($_POST['repeat_password']))
				{
					pjAppController::jsonResponse(array('status' => 'REG08', 'code' => 108, 'text' => $front_err['REG08']));
				}
				if (isset($_POST['repeat_password']) && !pjValidation::pjActionNotEmpty($_POST['repeat_password']))
				{
					pjAppController::jsonResponse(array('status' => 'REG09', 'code' => 109, 'text' => $front_err['REG09']));
				}
				if (isset($_POST['password']) && pjValidation::pjActionNotEmpty($_POST['password']) && isset($_POST['repeat_password']) && pjValidation::pjActionNotEmpty($_POST['repeat_password']) && !pjValidation::pjActionEqualTo($_POST['password'], $_POST['repeat_password']))
				{
					pjAppController::jsonResponse(array('status' => 'REG10', 'code' => 110, 'text' => $front_err['REG10']));
				}
				
				$data = array();
				$data['status'] = 'F';
				$data['ip'] = pjUtil::getClientIp();
				if((int) $this->option_arr['o_registration_confirm'] == 0)
				{
					$data['status'] = 'T';
				}
				$id = pjClientModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$text = $front_msg['REG01'];
					if((int) $this->option_arr['o_registration_confirm'] == 1)
					{
						$text = $front_msg['REG03'];
					}else if((int) $this->option_arr['o_registration_confirm'] == 2){
						$text = $front_msg['REG02'];
					}
					$text = str_replace("{STAG}", '<a href="#" class="pjAsMenuItem" data-load="loadLogin">', $text);
					$text = str_replace("{ETAG}", '</a>', $text);
					pjAppController::pjActionConfirmSend($this->option_arr, $id, PJ_SALT, 'register', $this->getLocaleId());
					pjAppController::jsonResponse(array('status' => 'REG01', 'code' => 200, 'text' => $text));
				} else {
					pjAppController::jsonResponse(array('status' => 'REG11', 'code' => 111, 'text' => $front_err['REG11']));
				}
			}
		}
	}
	public function pjActionProfile()
	{
		if($this->isXHR())
		{
			if(isset($_POST['profile']))
			{
				$front_err = pjSanitize::clean(__('front_err', true));
				$front_msg = pjSanitize::clean(__('front_msg', true));
	
				if (!isset($_POST['name']))
				{
					pjAppController::jsonResponse(array('status' => 'REG01', 'code' => 101, 'text' => $front_err['REG01']));
				}
				if (isset($_POST['name']) && !pjValidation::pjActionNotEmpty($_POST['name']))
				{
					pjAppController::jsonResponse(array('status' => 'REG02', 'code' => 102, 'text' => $front_err['REG02']));
				}
				if (!isset($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'REG03', 'code' => 103, 'text' => $front_err['REG02']));
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'REG04', 'code' => 104, 'text' => $front_err['REG04']));
				}
				if (isset($_POST['email']) && pjValidation::pjActionNotEmpty($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					pjAppController::jsonResponse(array('status' => 'REG05', 'code' => 105, 'text' => $front_err['REG05']));
				}
				if (!isset($_POST['password']))
				{
					pjAppController::jsonResponse(array('status' => 'REG06', 'code' => 106, 'text' => $front_err['REG06']));
				}
				if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
				{
					pjAppController::jsonResponse(array('status' => 'REG07', 'code' => 107, 'text' => $front_err['REG07']));
				}
				$pjClientModel = pjClientModel::factory();
				$pjClientModel->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				$arr = $pjClientModel->reset()->find($_POST['id'])->getData();
				$_SESSION[$this->defaultFrontClient] = $arr;
				pjAppController::jsonResponse(array('status' => 'PRO01', 'code' => 200, 'text' => $front_msg['PRO01']));
			}else{
				$arr = pjClientModel::factory()->find($_SESSION[$this->defaultFrontClient]['id'])->getData();
				$this->set('arr', $arr);
			}
		}
	}
	public function pjActionMyBids()
	{
		if($this->isXHR())
		{
			if (!isset($_SESSION[$this->defaultFrontClient]) || empty($_SESSION[$this->defaultFrontClient]))
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 109));
			}
			
			$client_id = $_SESSION[$this->defaultFrontClient]['id'];
			
			$pjBidModel = pjBidModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.product_id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjClient', "t3.id = t1.client_id", 'left')
				->join('pjProduct', "t4.id = t1.product_id", 'left');
			
			$pjBidModel->where("(t1.client_id=".$client_id.")");
			if (isset($_GET['status']) && in_array($_GET['status'], array('W', 'O', 'C')))
			{
				if($_GET['status'] == 'W')
				{
					$pjBidModel->where('t1.status', 'won');
				}else if($_GET['status'] == 'O'){
					$pjBidModel->where("(t1.status='received' AND t4.status='T' AND t4.closed >= NOW())");
				}else if($_GET['status'] == 'C'){
					$pjBidModel->where("((t1.status='received' AND ( t4.status='F' OR (t4.status='T' AND t4.closed < NOW()))) OR (t1.status='rejected'))");
				}
			}
			
			$column = 'created';
			$direction = 'DESC';
			
			$total = $pjBidModel->findCount()->getData();
			$rowCount = (int) $this->option_arr['o_bids_per_page'] > 0 ? $this->option_arr['o_bids_per_page'] : 5;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			$bid_table = $pjBidModel->getTable();
			$arr = $pjBidModel
				->select("t1.*, t2.content AS product, t3.name, t3.email, t4.status AS product_status, t4.closed, 
						(SELECT `medium_path` FROM `".pjGalleryModel::factory()->getTable()."` WHERE `foreign_id` = t1.product_id ORDER BY `sort` ASC LIMIT 1) AS `image`, 
						(SELECT `TB`.bid_price FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.product_id ORDER BY bid_price DESC LIMIT 1) AS highest_bid")
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			
			$this->set('arr', $arr);
			$this->set('paginator', array('pages' => $pages, 'page' => $page, 'offset' => $offset, 'total' => $total));
		}
	}
	
	public function pjActionProduct()
	{
		if($this->isXHR())
		{
			if (!isset($_GET['product_id']) || (int) $_GET['product_id'] <= 0)
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 101));
			}
				
			$client_id = $_SESSION[$this->defaultFrontClient]['id'];
			$product_id = $_GET['product_id'];	
			
			$pjMultiLangModel = pjMultiLangModel::factory();
			$bid_table = pjBidModel::factory()->getTable();
			$arr = pjProductModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
				->join('pjMultiLang', "t4.foreign_id = t1.category_id AND t4.model = 'pjCategory' AND t4.locale = '".$this->getLocaleId()."' AND t4.field = 'name'", 'left')
				->join('pjMultiLang', "t5.foreign_id = t1.id AND t5.model = 'pjProduct' AND t5.locale = '".$this->getLocaleId()."' AND t5.field = 'full_description'", 'left')
				->select("t1.*, t2.content AS name, t3.content as description, t5.content as full_description, t4.content as category,
						(SELECT COUNT(`TB`.id) FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id) AS cnt_bids,
						(SELECT `TB`.bid_price FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id ORDER BY bid_price DESC LIMIT 1) AS highest_bid,
						(SELECT `TB`.id FROM `".$bid_table."` AS `TB` WHERE `TB`.product_id=t1.id ORDER BY bid_price DESC LIMIT 1) AS highest_bid_id")
				->find($product_id)->getData();
			
			$past_bids = pjBidModel::factory()->where('product_id', $product_id)->where('client_id', $client_id)->orderBy("created DESC")->limit(3)->findAll()->getData();
			
			$gallery_arr = pjGalleryModel::factory()->where('t1.foreign_id', $product_id)->orderBy('t1.sort ASC')->findAll()->getData();
			$this->set('gallery_arr', $gallery_arr);
			
			$this->set('arr', $arr);
			$this->set('client_id', $client_id);
			$this->set('past_bids', $past_bids);
		}
	}
}
?>