<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat bids">
				<div class="info">
					<abbr><?php echo $tpl['total_bids'];?></abbr>
					<?php $tpl['total_bids'] != 1 ? __('dash_total_bids') : __('dash_bid');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat products">
				<div class="info">
					<abbr><?php echo $tpl['total_products'];?></abbr>
					<?php $tpl['total_products'] != 1 ? __('dash_total_products') : __('dash_product');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat clients">
				<div class="info">
					<abbr><?php echo $tpl['total_clients'];?></abbr>
					<?php $tpl['total_clients'] != 1 ? __('dash_total_clients') : __('dash_client');?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('dash_latest_bids');?></div>
			<div class="dashboard_column_top"><?php __('dash_bidding_closes');?></div>
			<div class="dashboard_column_top"><?php __('dash_latest_clients');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_bids']) > 0)
					{
						foreach($tpl['latest_bids'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBids&action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></a></label>
								<label><?php echo pjSanitize::clean($v['name']);?></label>
								<label><?php echo pjSanitize::clean($v['product']);?></label>
								<label><?php echo pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['bid_price'], $tpl['option_arr']), $tpl['option_arr']['o_currency']);?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_bids');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['bidding_closes']) > 0)
					{
						foreach($tpl['bidding_closes'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><?php echo date($tpl['option_arr']['o_date_format'] . ', ' . $tpl['option_arr']['o_time_format'], strtotime($v['closed']));?></label>
								<label><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminProducts&action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo pjSanitize::clean($v['name']);?></a></label>
								<label><?php echo pjSanitize::clean($v['cnt_bids']);?> <?php $v['cnt_bids'] != 1 ? __('dash_bids_so_far') : __('dash_bid_so_far'); ?></label>
								<?php
								if((float) $v['highest_bid'] > 0)
								{ 
									?>
									<label><?php echo pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['highest_bid'], $tpl['option_arr']), $tpl['option_arr']['o_currency']);?> <?php __('dash_highest_bid');?></label>
									<?php
								} 
								?>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_products');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_clients']) > 0)
					{
						foreach($tpl['latest_clients'] as $v)
						{
							?>
							<div class="dashboard_row">							
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['created']));?></label>
								<label><a href="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminClients&action=pjActionUpdate&id=<?php echo $v['id'];?>"><?php echo pjSanitize::clean($v['name']);?></a></label>
								<label><?php echo pjSanitize::clean($v['email']);?></label>
								<label><?php echo pjSanitize::clean($v['cnt_bids']);?> <?php $v['cnt_bids'] != 1 ? __('dash_bids_so_far') : __('dash_bid_so_far'); ?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_clients');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format'], time()); ?></div>
		</div>
	</div>
	<?php
}
?>