<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	pjUtil::printNotice(__('infoBidsTitle', true, false), __('infoBidsDesc', true, false));
	?>
	
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminBids" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddBid'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$bid_statuses = __('statuses', true)
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll'); ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="won"><?php echo $bid_statuses['won']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="received"><?php echo $bid_statuses['received']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="rejected"><?php echo $bid_statuses['rejected']; ?></a>
		</div>
		<br class="clear_both" />
	</div>
	
	<div class="pj-form-filter-advanced" style="display: none;">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="overflow float_left w350">
				<p>
					<label class="title100"><?php __('lblProduct'); ?></label>
					<span class="inline_block">
						<select name="product_id" id="filter_product_id" class="pj-form-field w200">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['product_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title100">&nbsp;</label>
					<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
					<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
				</p>
			</div>
			<div class="overflow float_left">
				<p>
					<label class="title100"><?php __('lblName'); ?></label>
					<span class="inline_block">
						<input type="text" name="name" id="name" class="pj-form-field w150" />
					</span>
				</p>
				<p>
					<label class="title100"><?php __('email'); ?></label>
					<span class="inline_block">
						<input type="text" name="email" id=""email"" class="pj-form-field w150" />
					</span>
				</p>
			</div>
			<br class="clear_both" />
		</form>
	</div>
	
	<div id="grid"></div>
	
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['product_id']) && (int) $_GET['product_id'] > 0)
	{
		?>pjGrid.queryString += "&product_id=<?php echo (int) $_GET['product_id']; ?>";<?php
	}
	if (isset($_GET['client_id']) && (int) $_GET['client_id'] > 0)
	{
		?>pjGrid.queryString += "&client_id=<?php echo (int) $_GET['client_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.product = "<?php __('lblProduct'); ?>";
	myLabel.client = "<?php __('lblClient'); ?>";
	myLabel.created = "<?php __('lblCreated'); ?>";
	myLabel.bid_price = "<?php __('lblBidPrice'); ?>";
	myLabel.status = "<?php __('lblStatus'); ?>";
	myLabel.won = "<?php echo $bid_statuses['won']; ?>";
	myLabel.received = "<?php echo $bid_statuses['received']; ?>";
	myLabel.rejected = "<?php echo $bid_statuses['rejected']; ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	</script>
	<?php
}
?>