<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		$bodies_text = str_replace("{MAXSIZE}", ini_get('upload_max_filesize'), $bodies_text);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	?>
	
	<?php pjUtil::printNotice(__('infoUpdateProductTitle', true, false), __('infoUpdateProductDesc', true, false)); ?>
	
	<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
	<div class="multilang"></div>
	<?php endif; ?>
	<div class="clear_both">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminProducts&amp;action=pjActionUpdate" method="post" id="frmUpdateProduct" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
			<input type="hidden" name="product_update" value="1" />
			<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']?>" />
			<p>
				<label class="title"><?php __('lblBids', false, true); ?></label>
				<span class="inline_block t5">
					<?php
					if((int) $tpl['arr']['cnt_bids'] > 0)
					{
						echo '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminBids&amp;action=pjActionIndex&product_id='.$tpl['arr']['id'].'">'.$tpl['arr']['cnt_bids'].'</a>';
					}else{
						echo 0;
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblHighestBid', false, true); ?></label>
				<span class="inline_block t5">
					<?php
					if((int) $tpl['arr']['highest_bid_id'] > 0)
					{
						echo '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminBids&amp;action=pjActionUpdate&id='.$tpl['arr']['highest_bid_id'].'">'.pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($tpl['arr']['highest_bid'], $tpl['option_arr']), $tpl['option_arr']['o_currency']).'</a>';
						if(isset($tpl['won_bid']) && !empty($tpl['won_bid']))
						{
							$bid_won_msg = __('lblBidWon', true);
							$bid_won_msg = str_replace("{PRICE}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminBids&amp;action=pjActionUpdate&id='.$tpl['won_bid']['id'].'">'.pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($tpl['won_bid']['bid_price'], $tpl['option_arr']), $tpl['option_arr']['o_currency']).'</a>', $bid_won_msg);
							$bid_won_msg = str_replace("{CLIENT}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminClients&amp;action=pjActionUpdate&id='.$tpl['won_bid']['client_id'].'">'.pjSanitize::html($tpl['won_bid']['name']).'</a>', $bid_won_msg);
							echo ' / ' . $bid_won_msg;
						}
					}else{
						echo __('lblNa', true);
					} 
					?>
				</span>
			</p>
			<?php
			foreach ($tpl['lp_arr'] as $v)
			{
			?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblName'); ?></label>
					<span class="inline_block">
						<input type="text" id="i18n_name_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][name]" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['name'])); ?>" data-msg-required="<?php __('pj_field_required'); ?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			foreach ($tpl['lp_arr'] as $v)
			{
			?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblShortDescription'); ?></label>
					<span class="inline_block">
						<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h100<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('pj_field_required'); ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])); ?></textarea>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblFullDescription'); ?></label>
					<span class="inline_block">
						<textarea id="i18n_full_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][full_description]" class="pj-form-field w500 h150 mceEditor" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('pj_field_required'); ?>"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['full_description'])); ?></textarea>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			?>
			<p>
				<label class="title"><?php __('lblCategory'); ?></label>
				<span class="inline_block" id="boxCategory">
					<select name="category_id" id="category_id" class="pj-form-field required w300" data-msg-required="<?php __('pj_field_required'); ?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach ($tpl['category_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"<?php echo $v['id'] == $tpl['arr']['category_id'] ? ' selected="selected"' : null;?>><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<?php
			$closed_at = date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['closed'])) . ' ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['closed']));
			?>
			
			<p>
				<label class="title"><?php __('lblBiddingClosedAt'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="closed" id="closed" class="pj-form-field pointer w120 required datetimepick" value="<?php echo $closed_at;?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('pj_field_required');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('u_statarr', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : null; ?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminProducts&action=pjActionIndex';" />
				</span>
			</p>
		</form>
		
		<?php pjUtil::printNotice(__('infoProductPhotosTitle', true, false), __('infoProductPhotosDesc', true, false)); ?>
		<div id="gallery"></div>
		
	</div>
	<div id="dialogDeleteImage" style="display: none" title="<?php __('lblDeleteImage');?>"><?php __('lblDeleteImageConfirm');?></div>
	
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1) : ?>
	var pjLocale = pjLocale || {};
	var myLabel = myLabel || {};
	myLabel.choose = "-- <?php __('lblChoose'); ?> --";
	var locale_array = new Array(); 
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	
	myLabel.field_required = "<?php __('pj_field_required'); ?>";
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				tooltip: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sit amet faucibus enim.",
				select: function (event, ui) {
					$.get("index.php?controller=pjAdminProducts&action=pjActionGetLocale", {
						"locale" : ui.index
					}).done(function (data) {
						cid = $("#category_id").val();
						$("#boxCategory").html(data.category);
						$("#category_id").val(cid);
					});
				}
			});
		});
	})(jQuery_1_8_2);
	<?php endif; ?>
	</script>
	<?php
}
?>