<?php
include_once dirname(__FILE__) . '/elements/header.php';

if(!empty($tpl['arr']))
{
	?>
	<div class="pjAs-body">
		<div class="pjAs-action-table-filters">
			<span><?php __('front_show');?>: </span>
	
			<a href="#" data-status="A" class="btn btn-link btn-sm pjAsBidsFilter<?php echo !isset($_GET['status']) ? ' active' : NULL;?>"><?php __('front_all_bids');?></a>
	
			<a href="#" data-status="W" class="btn btn-link btn-sm pjAsBidsFilter<?php echo isset($_GET['status']) ? ($_GET['status'] == 'W' ? ' active' : NULL) : NULL;?>"><?php __('front_bids_won');?></a>
	
			<a href="#" data-status="C" class="btn btn-link btn-sm pjAsBidsFilter<?php echo isset($_GET['status']) ? ($_GET['status'] == 'C' ? ' active' : NULL) : NULL;?>"><?php __('front_bids_lost');?></a>
		</div><!-- /.pjAs-action-table-filters -->
	
		<div class="pjAs-action-table">
			<div class="pjAs-action-table-head">
				<div class="pjAs-action-table-row">
					<div class="pjAs-col pjAs-col-1">
						<p><?php __('front_product');?></p>
					</div><!-- /.pjAs-col-1 -->
	
					<div class="pjAs-col pjAs-col-2">
						<p><?php __('front_title');?></p>
					</div><!-- /.pjAs-col-2 -->
	
					<div class="pjAs-col pjAs-col-3">
						<p><?php __('front_status');?></p>
					</div><!-- /.pjAs-col-3 -->
	
					<div class="pjAs-col pjAs-col-4">
						<p><?php __('front_my_bid');?></p>
					</div><!-- /.pjAs-col-4 -->
	
					<div class="pjAs-col pjAs-col-5">
						<p><?php __('front_highest_bid');?></p>
					</div><!-- /.pjAs-col-5 -->
				</div><!-- /.pjAs-action-table-row -->
			</div><!-- /.pjAs-action-table-head -->
	
			<div class="pjAs-action-table-body">
				<?php
				foreach($tpl['arr'] as $k => $v)
				{ 
					$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/310x240.png';
					if(isset($v['image']) && !empty($v['image']) && file_exists(PJ_INSTALL_PATH . $v['image']))
					{
						$image = PJ_INSTALL_URL . $v['image'];
					}
					$status = 'W';
					$badge = ' badge-won';
					if($v['status'] == 'received')
					{
						if($v['product_status'] == 'T')
						{
							if($v['closed'] >= date('Y-m-d H:i:s'))
							{
								$status = 'O';
								$badge = ' badge-opened';
							}else{
								$status = 'C';
								$badge = ' badge-closed';
							}
						}else{
							$status = 'C';
							$badge = ' badge-closed';
						}
					}else if($v['status'] == 'rejected'){
						$status = 'C';
						$badge = ' badge-closed';
					}
					$bidding_statuses = __('bidding_statuses', true);
					$status = $bidding_statuses[$status];
					?>
					<div class="pjAs-action-table-row">
						<div class="pjAs-col pjAs-col-1">
							<img style="width: 76px;" src="<?php echo $image;?>" alt="">
						</div><!-- /.pjAs-col-1 -->
							
						<div class="pjAs-col pjAs-col-2">
							<p><a href="#" class="pjAsProductItem" data-id="<?php echo $v['product_id'];?>"><?php echo pjSanitize::html($v['product']);?></a></p>
						</div><!-- /.pjAs-col-2 -->
		
						<div class="pjAs-col pjAs-col-3">
							<span class="badge<?php echo $badge;?>"><?php echo $status;?></span>
						</div><!-- /.pjAs-col-3 -->
		
						<div class="pjAs-col pjAs-col-4">
							<p data-attr="<?php __('front_my_bid');?>:"><?php echo pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['bid_price'], $tpl['option_arr']), $tpl['option_arr']['o_currency']);?></p>
						</div><!-- /.pjAs-col-4 -->
		
						<div class="pjAs-col pjAs-col-5">
							<p data-attr="<?php __('front_highest_bid');?>:"><?php echo !empty($v['highest_bid']) ? pjUtil::formatCurrencySign(pjUtil::convertToCurrencyFormat($v['highest_bid'], $tpl['option_arr']), $tpl['option_arr']['o_currency']) : '&nbsp;';?></p>
						</div><!-- /.pjAs-col-5 -->
					</div><!-- /.pjAs-action-table-row -->
					<?php
				} 
				?>
			</div><!-- /.pjAs-action-table-body -->
	
			<div class="pjAs-action-table-footer">
				<?php
				include_once dirname(__FILE__) . '/elements/bid_pagination.php';
				?>
			</div><!-- /.pjAs-action-table-footer -->
		</div><!-- /.pjAs-action-table -->
	</div><!-- /.pjAs-body -->
	<?php
}else{
	?>
	<div class="pjAs-body">
		<div class="pjAs-action-table-filters">
			<span><?php __('front_show');?>: </span>
	
			<a href="#" data-status="A" class="btn btn-link btn-sm pjAsBidsFilter<?php echo !isset($_GET['status']) ? ' active' : NULL;?>"><?php __('front_all_bids');?></a>
	
			<a href="#" data-status="W" class="btn btn-link btn-sm pjAsBidsFilter<?php echo isset($_GET['status']) ? ($_GET['status'] == 'W' ? ' active' : NULL) : NULL;?>"><?php __('front_bids_won');?></a>
	
			<a href="#" data-status="C" class="btn btn-link btn-sm pjAsBidsFilter<?php echo isset($_GET['status']) ? ($_GET['status'] == 'C' ? ' active' : NULL) : NULL;?>"><?php __('front_bids_lost');?></a>
		</div><!-- /.pjAs-action-table-filters -->
		<div class="pjAs-action-table">
			<div class="pjAs-action-table-head">
				<div class="pjAs-action-table-row">
					<div class="pjAs-col pjAs-col-1">
						<p><?php __('front_product');?></p>
					</div><!-- /.pjAs-col-1 -->
	
					<div class="pjAs-col pjAs-col-2">
						<p><?php __('front_title');?></p>
					</div><!-- /.pjAs-col-2 -->
	
					<div class="pjAs-col pjAs-col-3">
						<p><?php __('front_status');?></p>
					</div><!-- /.pjAs-col-3 -->
	
					<div class="pjAs-col pjAs-col-4">
						<p><?php __('front_my_bid');?></p>
					</div><!-- /.pjAs-col-4 -->
	
					<div class="pjAs-col pjAs-col-5">
						<p><?php __('front_highest_bid');?></p>
					</div><!-- /.pjAs-col-5 -->
				</div><!-- /.pjAs-action-table-row -->
			</div><!-- /.pjAs-action-table-head -->
			<div class="pjAs-action-table-body">
				<div class="pjAs-action-table-row">
					<div class="pjAs-col pjAs-col-12">
						<?php __('front_no_bids_found');?>
					</div>
				</div><!-- /.pjAs-action-table-row -->
			</div><!-- /.pjAs-action-table-body -->
			<div class="pjAs-action-table-footer">
			</div><!-- /.pjAs-action-table-footer -->
		</div><!-- /.pjAs-action-table -->
	</div><!-- /.pjAs-body -->
	<?php
} 
?>
