DROP TABLE IF EXISTS `shopping_cart_addresses`;
CREATE TABLE IF NOT EXISTS `shopping_cart_addresses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `address_1` varchar(255) DEFAULT NULL,
  `address_2` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_default_shipping` tinyint(1) unsigned DEFAULT '0',
  `is_default_billing` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_attributes`;
CREATE TABLE IF NOT EXISTS `shopping_cart_attributes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `parent_id` (`parent_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_carts`;
CREATE TABLE IF NOT EXISTS `shopping_cart_carts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `stock_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `key_data` text,
  `qty` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_id` (`stock_id`),
  KEY `hash` (`hash`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_categories`;
CREATE TABLE IF NOT EXISTS `shopping_cart_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `lft` int(10) unsigned DEFAULT NULL,
  `rgt` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_clients`;
CREATE TABLE IF NOT EXISTS `shopping_cart_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `client_name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_extras`;
CREATE TABLE IF NOT EXISTS `shopping_cart_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `type` enum('single','multi') DEFAULT 'single',
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `is_mandatory` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_extras_items`;
CREATE TABLE IF NOT EXISTS `shopping_cart_extras_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `extra_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `extra_id` (`extra_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_history`;
CREATE TABLE IF NOT EXISTS `shopping_cart_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `record_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) DEFAULT NULL,
  `table_name` varchar(255) DEFAULT NULL,
  `before` longtext,
  `after` longtext,
  `ip` varchar(15) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `record_id` (`record_id`),
  KEY `user_id` (`user_id`),
  KEY `table_name` (`table_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_options`;
CREATE TABLE IF NOT EXISTS `shopping_cart_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_orders`;
CREATE TABLE IF NOT EXISTS `shopping_cart_orders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(12) DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `address_id` int(10) unsigned DEFAULT NULL,
  `locale_id` int(10) unsigned DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `status` enum('new','pending','cancelled','completed') DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cod') DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  `insurance` decimal(9,2) unsigned DEFAULT NULL,
  `shipping` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(9,2) unsigned DEFAULT NULL,
  `total` decimal(9,2) unsigned DEFAULT NULL,
  `voucher` varchar(255) DEFAULT NULL,
  `notes` text,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  `created` datetime DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `same_as` tinyint(1) unsigned DEFAULT '0',
  `s_name` varchar(255) DEFAULT NULL,
  `s_country_id` int(10) unsigned DEFAULT NULL,
  `s_state` varchar(255) DEFAULT NULL,
  `s_city` varchar(255) DEFAULT NULL,
  `s_zip` varchar(255) DEFAULT NULL,
  `s_address_1` varchar(255) DEFAULT NULL,
  `s_address_2` varchar(255) DEFAULT NULL,
  `b_name` varchar(255) DEFAULT NULL,
  `b_country_id` int(10) unsigned DEFAULT NULL,
  `b_state` varchar(255) DEFAULT NULL,
  `b_city` varchar(255) DEFAULT NULL,
  `b_zip` varchar(255) DEFAULT NULL,
  `b_address_1` varchar(255) DEFAULT NULL,
  `b_address_2` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `client_id` (`client_id`),
  KEY `address_id` (`address_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_orders_extras`;
CREATE TABLE IF NOT EXISTS `shopping_cart_orders_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned DEFAULT NULL,
  `order_stock_id` int(10) unsigned DEFAULT NULL,
  `extra_id` int(10) unsigned DEFAULT NULL,
  `extra_item_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `order_stock_id` (`order_stock_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_orders_stocks`;
CREATE TABLE IF NOT EXISTS `shopping_cart_orders_stocks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned DEFAULT NULL,
  `stock_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `qty` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `stock_id` (`stock_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_products`;
CREATE TABLE IF NOT EXISTS `shopping_cart_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sku` varchar(255) DEFAULT NULL,
  `status` tinyint(3) unsigned DEFAULT NULL,
  `digital_file` varchar(255) DEFAULT NULL,
  `digital_name` varchar(255) DEFAULT NULL,
  `digital_expire` time DEFAULT NULL,
  `is_featured` tinyint(1) unsigned DEFAULT '0',
  `is_digital` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sku` (`sku`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_products_categories`;
CREATE TABLE IF NOT EXISTS `shopping_cart_products_categories` (
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_products_similar`;
CREATE TABLE IF NOT EXISTS `shopping_cart_products_similar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `similar_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`,`similar_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_roles`;
CREATE TABLE IF NOT EXISTS `shopping_cart_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `shopping_cart_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T');

DROP TABLE IF EXISTS `shopping_cart_stocks`;
CREATE TABLE IF NOT EXISTS `shopping_cart_stocks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `image_id` int(10) unsigned DEFAULT NULL,
  `qty` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `image_id` (`image_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_stocks_attributes`;
CREATE TABLE IF NOT EXISTS `shopping_cart_stocks_attributes` (
  `stock_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `attribute_parent_id` int(10) unsigned DEFAULT NULL,
  KEY `stock_id` (`stock_id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `attribute_parent_id` (`attribute_parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_taxes`;
CREATE TABLE IF NOT EXISTS `shopping_cart_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shipping` decimal(9,2) unsigned DEFAULT NULL,
  `free` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_users`;
CREATE TABLE IF NOT EXISTS `shopping_cart_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_vouchers`;
CREATE TABLE IF NOT EXISTS `shopping_cart_vouchers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `type` enum('amount','percent') DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  `valid` enum('fixed','period','recurring') DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `time_to` time DEFAULT NULL,
  `every` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shopping_cart_vouchers_products`;
CREATE TABLE IF NOT EXISTS `shopping_cart_vouchers_products` (
  `voucher_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`voucher_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `shopping_cart_categories` (`id`, `parent_id`, `lft`, `rgt`, `name`) VALUES
(1, 0, 1, 2, 'Products');


INSERT INTO `shopping_cart_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_allow_authorize', 2, '1|0::1', NULL, 'bool', 19, 1, NULL),
(1, 'o_allow_bank', 2, '1|0::1', NULL, 'bool', 24, 1, NULL),
(1, 'o_allow_cod', 2, '1|0::1', NULL, 'bool', 26, 1, NULL),
(1, 'o_allow_creditcard', 2, '1|0::1', NULL, 'bool', 23, 1, NULL),
(1, 'o_allow_paypal', 2, '1|0::1', NULL, 'bool', 16, 1, NULL),
(1, 'o_authorize_key', 2, NULL, NULL, 'string', 21, 1, NULL),
(1, 'o_authorize_mid', 2, NULL, NULL, 'string', 20, 1, NULL),
(1, 'o_authorize_hash', 2, NULL, NULL, 'string', 22, 1, NULL),
(1, 'o_authorize_tz', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 23, 1, NULL),
(1, 'o_bank_account', 2, 'Bank of America', NULL, 'text', 25, 1, NULL),
(1, 'o_bf_b_address_1', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 6, 1, NULL),
(1, 'o_bf_b_address_2', 3, '1|2|3::1', 'No|Yes|Yes (Required)', 'enum', 7, 1, NULL),
(1, 'o_bf_b_city', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 3, 1, NULL),
(1, 'o_bf_b_country_id', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 2, 1, NULL),
(1, 'o_bf_b_name', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 1, 1, NULL),
(1, 'o_bf_b_state', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 4, 1, NULL),
(1, 'o_bf_b_zip', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 5, 1, NULL),
(1, 'o_bf_c_name', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 41, 1, NULL),
(1, 'o_bf_c_phone', 3, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 42, 1, NULL),
(1, 'o_bf_c_url', 3, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 43, 1, NULL),
(1, 'o_bf_captcha', 3, '1|3::3', 'No|Yes (Required)', 'enum', 52, 1, NULL),
(1, 'o_bf_notes', 3, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 51, 1, NULL),
(1, 'o_bf_s_address_1', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 26, 1, NULL),
(1, 'o_bf_s_address_2', 3, '1|2|3::1', 'No|Yes|Yes (Required)', 'enum', 27, 1, NULL),
(1, 'o_bf_s_city', 3, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 23, 1, NULL),
(1, 'o_bf_s_country_id', 3, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 22, 1, NULL),
(1, 'o_bf_s_name', 3, '1|2|3::3', 'No|Yes|Yes (Required)', 'enum', 21, 1, NULL),
(1, 'o_bf_s_state', 3, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 24, 1, NULL),
(1, 'o_bf_s_zip', 3, '1|2|3::2', 'No|Yes|Yes (Required)', 'enum', 25, 1, NULL),
(1, 'o_bf_terms', 3, '1|3::3', 'No|Yes (Required)', 'enum', 53, 1, NULL),
(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 6, 1, NULL),
(1, 'o_datetime_format', 1, 'd.m.Y, H:i|d.m.Y, H:i:s|m.d.Y, H:i|m.d.Y, H:i:s|Y.m.d, H:i|Y.m.d, H:i:s|j.n.Y, H:i|j.n.Y, H:i:s|n.j.Y, H:i|n.j.Y, H:i:s|Y.n.j, H:i|Y.n.j, H:i:s|d/m/Y, H:i|d/m/Y, H:i:s|m/d/Y, H:i|m/d/Y, H:i:s|Y/m/d, H:i|Y/m/d, H:i:s|j/n/Y, H:i|j/n/Y, H:i:s|n/j/Y, H:i|n/j/Y, H:i:s|Y/n/j, H:i|Y/n/j, H:i:s|d-m-Y, H:i|d-m-Y, H:i:s|m-d-Y, H:i|m-d-Y, H:i:s|Y-m-d, H:i|Y-m-d, H:i:s|j-n-Y, H:i|j-n-Y, H:i:s|n-j-Y, H:i|n-j-Y, H:i:s|Y-n-j, H:i|Y-n-j, H:i:s::j/n/Y, H:i', 'd.m.Y, H:i (25.09.2010, 09:51)|d.m.Y, H:i:s (25.09.2010, 09:51:47)|m.d.Y, H:i (09.25.2010, 09:51)|m.d.Y, H:i:s (09.25.2010, 09:51:47)|Y.m.d, H:i (2010.09.25, 09:51)|Y.m.d, H:i:s (2010.09.25, 09:51:47)|j.n.Y, H:i (25.9.2010, 09:51)|j.n.Y, H:i:s (25.9.2010, 09:51:47)|n.j.Y, H:i (9.25.2010, 09:51)|n.j.Y, H:i:s (9.25.2010, 09:51:47)|Y.n.j, H:i (2010.9.25, 09:51)|Y.n.j, H:i:s (2010.9.25, 09:51:47)|d/m/Y, H:i (25/09/2010, 09:51)|d/m/Y, H:i:s (25/09/2010, 09:51:47)|m/d/Y, H:i (09/25/2010, 09:51)|m/d/Y, H:i:s (09/25/2010, 09:51:47)|Y/m/d, H:i (2010/09/25, 09:51)|Y/m/d, H:i:s (2010/09/25, 09:51:47)|j/n/Y, H:i (25/9/2010, 09:51)|j/n/Y, H:i:s (25/9/2010, 09:51:47)|n/j/Y, H:i (9/25/2010, 09:51)|n/j/Y, H:i:s (9/25/2010, 09:51:47)|Y/n/j, H:i (2010/9/25, 09:51)|Y/n/j, H:i:s (2010/9/25, 09:51:47)|d-m-Y, H:i (25-09-2010, 09:51)|d-m-Y, H:i:s (25-09-2010, 09:51:47)|m-d-Y, H:i (09-25-2010, 09:51)|m-d-Y, H:i:s (09-25-2010, 09:51:47)|Y-m-d, H:i (2010-09-25, 09:51)|Y-m-d, H:i:s (2010-09-25, 09:51:47)|j-n-Y, H:i (25-9-2010, 09:51)|j-n-Y, H:i:s (25-9-2010, 09:51:47)|n-j-Y, H:i (9-25-2010, 09:51)|n-j-Y, H:i:s (9-25-2010, 09:51:47)|Y-n-j, H:i (2010-9-25, 09:51)|Y-n-j, H:i:s (2010-9-25, 09:51:47)', 'enum', 2, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_disable_payments', 2, '1|0::0', NULL, 'bool', 4, 1, NULL),
(1, 'o_disable_orders', 2, '1|0::0', NULL, 'bool', 5, 1, NULL),
(1, 'o_insurance', 2, '12', NULL, 'float', 12, 1, NULL),
(1, 'o_insurance_type', 2, 'amount|percent::amount', 'Amount|Percent', 'enum', NULL, 0, NULL),
(1, 'o_layout', 1, '1|2::1', 'Layout 1|Layout 2', 'enum', 5, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_paypal_address', 2, 'paypal_seller@example.com', NULL, 'string', 17, 1, NULL),
(1, 'o_products_per_page', 1, '16', NULL, 'int', 7, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 11, 1, NULL),
(1, 'o_seo_url', 1, '1|0::1', NULL, 'bool', 4, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 15, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 13, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 14, 1, NULL),
(1, 'o_thankyou_page', 2, 'http://www.phpjabbers.com/', NULL, 'string', 18, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 6, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 3, 1, NULL),
(1, 'o_email_password_reminder', 8, 'Dear {Name},\r\n\r\nYour password is: {Password}', NULL, 'text', 8, 1, NULL),
(1, 'o_email_password_reminder_subject', 8, 'Password reminder.', NULL, 'string', 7, 1, NULL),
(1, 'o_sms_new_order', 9, 'New order has been received.', NULL, 'text', 1, 1, NULL),
(1, 'o_sms_order_cancelled', 9, 'A order has been cancelled.', NULL, 'text', 2, 1, NULL),
(1, 'o_email_new_registration', 8, 'Dear {Name},\r\n\r\nThank you for registering!\r\n', NULL, 'text', 6, 1, NULL),
(1, 'o_email_new_registration_subject', 8, 'Registration completed', NULL, 'string', 5, 1, NULL);









DROP TABLE IF EXISTS `shopping_cart_fields`;

CREATE TABLE `shopping_cart_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `shopping_cart_fields` VALUES
('5', 'user', 'backend', 'Username', 'script', NULL),
('6', 'pass', 'backend', 'Password', 'script', NULL),
('7', 'email', 'backend', 'E-Mail', 'script', NULL),
('8', 'url', 'backend', 'URL', 'script', NULL),
('13', 'created', 'backend', 'Created', 'script', NULL),
('16', 'btnSave', 'backend', 'Save', 'script', NULL),
('17', 'btnReset', 'backend', 'Reset', 'script', NULL),
('18', 'addLocale', 'backend', 'Add language', 'script', NULL),
('22', 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
('23', 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
('24', 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
('25', 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
('26', 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
('31', 'btnUpdate', 'backend', 'Update', 'script', NULL),
('36', 'lblChoose', 'backend', 'Choose', 'script', NULL),
('37', 'btnSearch', 'backend', 'Search', 'script', NULL),
('40', 'backend', 'backend', 'Backend titles', 'script', NULL),
('41', 'frontend', 'backend', 'Front-end titles', 'script', NULL),
('42', 'locales', 'backend', 'Languages', 'script', NULL),
('44', 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
('45', 'btnLogin', 'backend', 'Login', 'script', NULL),
('47', 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
('57', 'lblOptionList', 'backend', 'Option list', 'script', NULL),
('58', 'btnAdd', 'backend', 'Button Add', 'script', NULL),
('62', 'lblDelete', 'backend', 'Delete', 'script', NULL),
('65', 'lblType', 'backend', 'Type', 'script', NULL),
('66', 'lblName', 'backend', 'Name', 'script', NULL),
('67', 'lblRole', 'backend', 'Role', 'script', NULL),
('68', 'lblStatus', 'backend', 'Status', 'script', NULL),
('69', 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
('70', 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
('71', 'lblAddUser', 'backend', 'Add user', 'script', NULL),
('72', 'lblValue', 'backend', 'Value', 'script', NULL),
('73', 'lblOption', 'backend', 'Option', 'script', NULL),
('74', 'lblDays', 'backend', 'Days', 'script', NULL),
('115', 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
('116', 'lblYes', 'backend', 'Yes', 'script', NULL),
('117', 'lblNo', 'backend', 'No', 'script', NULL),
('338', 'lblError', 'backend', 'Error', 'script', NULL),
('347', 'btnBack', 'backend', 'Button Back', 'script', NULL),
('355', 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
('356', 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
('357', 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
('358', 'btnSend', 'backend', 'Button Send', 'script', NULL),
('359', 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
('360', 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
('365', 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
('380', 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
('381', 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
('382', 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
('383', 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
('384', 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
('385', 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
('386', 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
('387', 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
('388', 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
('389', 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
('390', 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
('391', 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
('392', 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
('393', 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
('395', 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
('396', 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
('408', 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
('409', 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
('410', 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
('411', 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
('412', 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
('413', 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
('414', 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
('415', 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
('416', 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
('417', 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
('418', 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
('419', 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
('420', 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
('421', 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
('422', 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
('423', 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
('424', 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
('425', 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
('426', 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
('433', 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
('434', 'lblIp', 'backend', 'IP address', 'script', NULL),
('435', 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
('441', 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
('442', 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
('451', 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
('452', 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
('455', 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
('456', 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
('457', 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
('458', 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
('471', '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
('472', '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
('476', 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
('477', 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
('478', 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
('479', 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
('480', 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
('481', 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
('482', 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
('483', 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
('496', 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
('497', 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
('498', 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
('499', 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
('500', 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
('501', 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
('502', 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
('503', 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
('504', 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
('505', 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
('506', 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
('507', 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
('508', 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
('509', 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
('510', 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
('511', 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
('512', 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
('513', 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
('514', 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
('515', 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
('516', 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
('517', 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
('518', 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
('519', 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
('520', 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
('521', 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
('540', 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
('541', 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
('542', 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
('543', 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
('544', 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
('552', 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
('553', 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
('554', 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
('555', 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
('556', 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
('557', 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
('558', 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
('559', 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
('578', 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
('579', 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
('580', 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
('581', 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
('582', 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
('589', 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
('590', 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
('591', 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
('592', 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
('593', 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
('594', 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
('595', 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
('596', 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
('597', 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
('627', 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
('628', 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
('629', 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
('630', 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
('631', 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
('632', 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
('633', 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
('634', 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
('635', 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
('636', 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
('637', 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
('638', 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
('639', 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
('640', 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
('641', 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
('642', 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
('643', 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
('644', 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
('645', 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
('646', 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
('647', 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
('648', 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
('649', 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
('650', 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
('651', 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
('652', 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
('653', 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
('654', 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
('655', 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
('656', 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
('657', 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
('658', 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
('659', 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
('660', 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
('661', 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
('662', 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
('663', 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
('664', 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
('665', 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
('666', 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
('667', 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
('668', 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
('669', 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
('670', 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
('671', 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
('672', 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
('673', 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
('674', 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
('675', 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
('676', 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
('677', 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
('678', 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
('679', 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
('907', 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
('908', 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
('909', 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
('910', 'lnkBack', 'backend', 'Link Back', 'script', NULL),
('982', 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
('983', 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
('984', 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
('985', 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
('986', 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
('990', 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
('992', 'vr_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
('993', 'revert_status', 'backend', 'Revert status', 'script', NULL),
('994', 'lblExport', 'backend', 'Export', 'script', NULL),
('995', 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
('996', 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
('997', 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
('998', 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
('999', 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
('1026', 'menuProducts', 'backend', 'Menu Products', 'script', NULL),
('1027', 'menuVouchers', 'backend', 'Menu Vouchers', 'script', NULL),
('1028', 'menuOrders', 'backend', 'Menu Orders', 'script', NULL),
('1029', 'menuClients', 'backend', 'Menu Clients', 'script', NULL),
('1030', 'menuCategories', 'backend', 'Menu Categories', 'script', NULL),
('1031', 'menuInstall', 'backend', 'Menu Install', 'script', NULL),
('1032', 'menuPreview', 'backend', 'Menu Preview', 'script', NULL),
('1033', 'lblProductsList', 'backend', 'Products / List', 'script', NULL),
('1034', 'lblProductsCreate', 'backend', 'Products / Add', 'script', NULL),
('1035', 'product_statuses_ARRAY_1', 'arrays', 'product_statuses_ARRAY_1', 'script', NULL),
('1036', 'product_statuses_ARRAY_2', 'arrays', 'product_statuses_ARRAY_2', 'script', NULL),
('1038', 'login_email', 'backend', 'login_email', 'script', NULL),
('1039', 'login_password', 'backend', 'login_password', 'script', NULL),
('1040', 'login_login', 'backend', 'login_login', 'script', NULL),
('1042', 'login_error', 'backend', 'login_error', 'script', NULL),
('1044', 'home_options', 'backend', 'home_options', 'script', NULL),
('1045', 'home_install', 'backend', 'home_install', 'script', NULL),
('1046', 'menu_dashboard', 'backend', 'menu_dashboard', 'script', NULL),
('1047', 'menu_options', 'backend', 'menu_options', 'script', NULL),
('1048', 'menu_preview', 'backend', 'menu_preview', 'script', NULL),
('1049', 'menu_install', 'backend', 'menu_install', 'script', NULL),
('1050', 'menu_logout', 'backend', 'menu_logout', 'script', NULL),
('1051', 'menu_products', 'backend', 'menu_products', 'script', NULL),
('1052', 'menu_clients', 'backend', 'menu_clients', 'script', NULL),
('1053', 'menu_orders', 'backend', 'menu_orders', 'script', NULL),
('1054', 'menu_categories', 'backend', 'menu_categories', 'script', NULL),
('1055', 'menu_vouchers', 'backend', 'menu_vouchers', 'script', NULL),
('1056', 'product_list', 'backend', 'product_list', 'script', NULL),
('1057', 'product_create', 'backend', 'product_create', 'script', NULL),
('1058', 'product_empty', 'backend', 'product_empty', 'script', NULL),
('1059', 'product_update', 'backend', 'product_update', 'script', NULL),
('1060', 'product_f_category', 'backend', 'product_f_category', 'script', NULL),
('1061', 'product_details', 'backend', 'product_details', 'script', NULL),
('1062', 'product_digital', 'backend', 'product_digital', 'script', NULL),
('1063', 'product_attr', 'backend', 'product_attr', 'script', NULL),
('1064', 'product_stock', 'backend', 'product_stock', 'script', NULL),
('1065', 'product_photos', 'backend', 'product_photos', 'script', NULL),
('1066', 'product_extras', 'backend', 'product_extras', 'script', NULL),
('1067', 'product_history', 'backend', 'product_history', 'script', NULL),
('1068', 'product_status', 'backend', 'product_status', 'script', NULL),
('1070', 'product_name', 'backend', 'product_name', 'script', NULL),
('1071', 'product_sku', 'backend', 'product_sku', 'script', NULL),
('1072', 'product_short_desc', 'backend', 'product_short_desc', 'script', NULL),
('1073', 'product_full_desc', 'backend', 'product_full_desc', 'script', NULL),
('1074', 'product_is_featured', 'backend', 'product_is_featured', 'script', NULL),
('1075', 'product_category', 'backend', 'product_category', 'script', NULL),
('1076', 'product_is_digital', 'backend', 'product_is_digital', 'script', NULL),
('1077', 'product_file', 'backend', 'product_file', 'script', NULL),
('1078', 'product_file_1', 'backend', 'product_file_1', 'script', NULL),
('1079', 'product_file_2', 'backend', 'product_file_2', 'script', NULL),
('1080', 'product_digital_expire', 'backend', 'product_digital_expire', 'script', NULL),
('1081', 'product_digital_delete_title', 'backend', 'product_digital_delete_title', 'script', NULL),
('1082', 'product_digital_delete_desc', 'backend', 'product_digital_delete_desc', 'script', NULL),
('1083', 'product_del_title', 'backend', 'product_del_title', 'script', NULL),
('1084', 'product_del_body', 'backend', 'product_del_body', 'script', NULL),
('1085', 'product_extra_type', 'backend', 'product_extra_type', 'script', NULL),
('1087', 'product_extra_add', 'backend', 'product_extra_add', 'script', NULL),
('1088', 'product_extra_item_add', 'backend', 'product_extra_item_add', 'script', NULL),
('1089', 'product_extra_name', 'backend', 'product_extra_name', 'script', NULL),
('1090', 'product_extra_price', 'backend', 'product_extra_price', 'script', NULL),
('1091', 'product_extra_title', 'backend', 'product_extra_title', 'script', NULL),
('1092', 'product_extra_mandatory', 'backend', 'product_extra_mandatory', 'script', NULL),
('1093', 'product_extra_delete', 'backend', 'product_extra_delete', 'script', NULL),
('1094', 'product_extra_delete_title', 'backend', 'product_extra_delete_title', 'script', NULL),
('1095', 'product_extra_delete_desc', 'backend', 'product_extra_delete_desc', 'script', NULL),
('1096', 'product_attr_add', 'backend', 'product_attr_add', 'script', NULL),
('1097', 'product_attr_copy', 'backend', 'product_attr_copy', 'script', NULL),
('1098', 'product_attr_add_item', 'backend', 'product_attr_add_item', 'script', NULL),
('1099', 'product_attr_attr', 'backend', 'product_attr_attr', 'script', NULL),
('1100', 'product_attr_item', 'backend', 'product_attr_item', 'script', NULL),
('1101', 'product_attr_delete', 'backend', 'product_attr_delete', 'script', NULL),
('1102', 'product_attr_delete_title', 'backend', 'product_attr_delete_title', 'script', NULL),
('1103', 'product_attr_delete_desc', 'backend', 'product_attr_delete_desc', 'script', NULL),
('1104', 'product_attr_copy_title', 'backend', 'product_attr_copy_title', 'script', NULL),
('1105', 'product_attr_or', 'backend', 'product_attr_or', 'script', NULL),
('1106', 'product_attr_copy_btn', 'backend', 'product_attr_copy_btn', 'script', NULL),
('1107', 'product_stock_qty', 'backend', 'product_stock_qty', 'script', NULL),
('1108', 'product_stock_price', 'backend', 'product_stock_price', 'script', NULL),
('1109', 'product_stock_image', 'backend', 'product_stock_image', 'script', NULL),
('1110', 'product_stock_attributes', 'backend', 'product_stock_attributes', 'script', NULL),
('1111', 'product_stock_choose_image', 'backend', 'product_stock_choose_image', 'script', NULL),
('1112', 'product_stock_add', 'backend', 'product_stock_add', 'script', NULL),
('1113', 'product_stock_img_title', 'backend', 'product_stock_img_title', 'script', NULL),
('1114', 'product_stock_delete_title', 'backend', 'product_stock_delete_title', 'script', NULL),
('1115', 'product_stock_delete_desc', 'backend', 'product_stock_delete_desc', 'script', NULL),
('1116', 'product_history_empty', 'backend', 'product_history_empty', 'script', NULL),
('1117', 'product_history_created', 'backend', 'product_history_created', 'script', NULL),
('1118', 'product_history_product', 'backend', 'product_history_product', 'script', NULL),
('1119', 'product_history_qty_before', 'backend', 'product_history_qty_before', 'script', NULL),
('1120', 'product_history_qty_after', 'backend', 'product_history_qty_after', 'script', NULL),
('1122', 'image_upload_add', 'backend', 'image_upload_add', 'script', NULL),
('1123', 'image_del_title', 'backend', 'image_del_title', 'script', NULL),
('1124', 'image_del_body', 'backend', 'image_del_body', 'script', NULL),
('1125', 'image_edit_title', 'backend', 'image_edit_title', 'script', NULL),
('1126', 'image_title', 'backend', 'image_title', 'script', NULL),
('1127', 'image_delete', 'backend', 'image_delete', 'script', NULL),
('1128', 'image_edit', 'backend', 'image_edit', 'script', NULL),
('1129', 'image_back', 'backend', 'image_back', 'script', NULL),
('1130', 'image_empty', 'backend', 'image_empty', 'script', NULL),
('1131', 'home_coming', 'backend', 'home_coming', 'script', NULL),
('1132', 'home_leaving', 'backend', 'home_leaving', 'script', NULL),
('1133', 'home_name', 'backend', 'home_name', 'script', NULL),
('1134', 'home_regno', 'backend', 'home_regno', 'script', NULL),
('1135', 'home_company', 'backend', 'home_company', 'script', NULL),
('1136', 'home_date', 'backend', 'home_date', 'script', NULL),
('1137', 'home_status', 'backend', 'home_status', 'script', NULL),
('1138', 'home_payment', 'backend', 'home_payment', 'script', NULL),
('1139', 'home_space', 'backend', 'home_space', 'script', NULL),
('1140', 'home_bookings', 'backend', 'home_bookings', 'script', NULL),
('1141', 'home_available', 'backend', 'home_available', 'script', NULL),
('1142', 'home_empty', 'backend', 'home_empty', 'script', NULL),
('1143', 'voucher_update', 'backend', 'voucher_update', 'script', NULL),
('1144', 'voucher_create', 'backend', 'voucher_create', 'script', NULL),
('1145', 'voucher_list', 'backend', 'voucher_list', 'script', NULL),
('1146', 'voucher_code', 'backend', 'voucher_code', 'script', NULL),
('1147', 'voucher_products', 'backend', 'voucher_products', 'script', NULL),
('1148', 'voucher_ch_product', 'backend', 'voucher_ch_product', 'script', NULL),
('1149', 'voucher_discount', 'backend', 'voucher_discount', 'script', NULL),
('1150', 'voucher_type', 'backend', 'voucher_type', 'script', NULL),
('1152', 'voucher_valid', 'backend', 'voucher_valid', 'script', NULL),
('1154', 'voucher_date', 'backend', 'voucher_date', 'script', NULL),
('1155', 'voucher_time_from', 'backend', 'voucher_time_from', 'script', NULL),
('1156', 'voucher_time_to', 'backend', 'voucher_time_to', 'script', NULL),
('1157', 'voucher_date_from', 'backend', 'voucher_date_from', 'script', NULL),
('1158', 'voucher_date_to', 'backend', 'voucher_date_to', 'script', NULL),
('1159', 'voucher_every', 'backend', 'voucher_every', 'script', NULL),
('1160', 'voucher_vouchers', 'backend', 'voucher_vouchers', 'script', NULL),
('1161', 'voucher_choose', 'backend', 'voucher_choose', 'script', NULL),
('1162', 'voucher_empty', 'backend', 'voucher_empty', 'script', NULL),
('1163', 'voucher_del_title', 'backend', 'voucher_del_title', 'script', NULL),
('1164', 'voucher_del_body', 'backend', 'voucher_del_body', 'script', NULL),
('1165', 'voucher_p_del_title', 'backend', 'voucher_p_del_title', 'script', NULL),
('1166', 'voucher_p_del_body', 'backend', 'voucher_p_del_body', 'script', NULL),
('1167', 'client_index', 'backend', 'client_index', 'script', NULL),
('1168', 'client_create', 'backend', 'client_create', 'script', NULL),
('1169', 'client_update', 'backend', 'client_update', 'script', NULL),
('1170', 'client_filter', 'backend', 'client_filter', 'script', NULL),
('1171', 'client_email', 'backend', 'client_email', 'script', NULL),
('1172', 'client_password', 'backend', 'client_password', 'script', NULL),
('1173', 'client_phone', 'backend', 'client_phone', 'script', NULL),
('1174', 'client_url', 'backend', 'client_url', 'script', NULL),
('1175', 'client_client_name', 'backend', 'client_client_name', 'script', NULL),
('1176', 'client_created', 'backend', 'client_created', 'script', NULL),
('1177', 'client_last_login', 'backend', 'client_last_login', 'script', NULL),
('1178', 'client_country', 'backend', 'client_country', 'script', NULL),
('1179', 'client_state', 'backend', 'client_state', 'script', NULL),
('1180', 'client_city', 'backend', 'client_city', 'script', NULL),
('1181', 'client_zip', 'backend', 'client_zip', 'script', NULL),
('1182', 'client_address_1', 'backend', 'client_address_1', 'script', NULL),
('1183', 'client_address_2', 'backend', 'client_address_2', 'script', NULL),
('1184', 'client_name', 'backend', 'client_name', 'script', NULL),
('1185', 'client_default_shipping', 'backend', 'client_default_shipping', 'script', NULL),
('1186', 'client_default_billing', 'backend', 'client_default_billing', 'script', NULL),
('1187', 'client_empty', 'backend', 'client_empty', 'script', NULL),
('1188', 'client_address_book', 'backend', 'client_address_book', 'script', NULL),
('1189', 'client_general', 'backend', 'client_general', 'script', NULL),
('1190', 'client_choose', 'backend', 'client_choose', 'script', NULL),
('1191', 'client_add_address', 'backend', 'client_add_address', 'script', NULL),
('1192', 'client_del_address', 'backend', 'client_del_address', 'script', NULL),
('1193', 'client_da_title', 'backend', 'client_da_title', 'script', NULL),
('1194', 'client_da_body', 'backend', 'client_da_body', 'script', NULL),
('1195', 'client_del_title', 'backend', 'client_del_title', 'script', NULL),
('1196', 'client_del_body', 'backend', 'client_del_body', 'script', NULL),
('1197', 'client_orders', 'backend', 'client_orders', 'script', NULL),
('1198', 'client_last_order', 'backend', 'client_last_order', 'script', NULL),
('1199', 'category_update', 'backend', 'category_update', 'script', NULL),
('1200', 'category_create', 'backend', 'category_create', 'script', NULL),
('1201', 'category_list', 'backend', 'category_list', 'script', NULL),
('1202', 'category_name', 'backend', 'category_name', 'script', NULL),
('1203', 'category_parent', 'backend', 'category_parent', 'script', NULL),
('1204', 'category_categories', 'backend', 'category_categories', 'script', NULL),
('1205', 'category_choose', 'backend', 'category_choose', 'script', NULL),
('1206', 'category_no_parent', 'backend', 'category_no_parent', 'script', NULL),
('1207', 'category_empty', 'backend', 'category_empty', 'script', NULL),
('1208', 'category_del_title', 'backend', 'category_del_title', 'script', NULL),
('1209', 'category_del_body', 'backend', 'category_del_body', 'script', NULL),
('1210', 'order_index', 'backend', 'order_index', 'script', NULL),
('1211', 'order_create', 'backend', 'order_create', 'script', NULL),
('1212', 'order_update', 'backend', 'order_update', 'script', NULL),
('1213', 'order_uuid', 'backend', 'order_uuid', 'script', NULL),
('1214', 'order_status', 'backend', 'order_status', 'script', NULL),
('1216', 'order_price', 'backend', 'order_price', 'script', NULL),
('1217', 'order_shipping', 'backend', 'order_shipping', 'script', NULL),
('1218', 'order_tax', 'backend', 'order_tax', 'script', NULL),
('1219', 'order_discount', 'backend', 'order_discount', 'script', NULL),
('1220', 'order_total', 'backend', 'order_total', 'script', NULL),
('1221', 'order_voucher', 'backend', 'order_voucher', 'script', NULL),
('1222', 'order_payment', 'backend', 'order_payment', 'script', NULL),
('1224', 'order_products', 'backend', 'order_products', 'script', NULL),
('1225', 'order_client', 'backend', 'order_client', 'script', NULL),
('1226', 'order_address', 'backend', 'order_address', 'script', NULL),
('1227', 'order_email', 'backend', 'order_email', 'script', NULL),
('1228', 'order_phone', 'backend', 'order_phone', 'script', NULL),
('1229', 'order_url', 'backend', 'order_url', 'script', NULL),
('1230', 'order_created', 'backend', 'order_created', 'script', NULL),
('1231', 'order_country', 'backend', 'order_country', 'script', NULL),
('1232', 'order_state', 'backend', 'order_state', 'script', NULL),
('1233', 'order_city', 'backend', 'order_city', 'script', NULL),
('1234', 'order_zip', 'backend', 'order_zip', 'script', NULL),
('1235', 'order_address_1', 'backend', 'order_address_1', 'script', NULL),
('1236', 'order_address_2', 'backend', 'order_address_2', 'script', NULL),
('1237', 'order_name', 'backend', 'order_name', 'script', NULL),
('1238', 'order_notes', 'backend', 'order_notes', 'script', NULL),
('1239', 'order_empty', 'backend', 'order_empty', 'script', NULL),
('1240', 'order_general', 'backend', 'order_general', 'script', NULL),
('1241', 'order_choose', 'backend', 'order_choose', 'script', NULL),
('1242', 'order_del_product', 'backend', 'order_del_product', 'script', NULL),
('1243', 'order_del_title', 'backend', 'order_del_title', 'script', NULL),
('1244', 'order_del_body', 'backend', 'order_del_body', 'script', NULL),
('1245', 'order_customer', 'backend', 'order_customer', 'script', NULL),
('1246', 'order_shipping_details', 'backend', 'order_shipping_details', 'script', NULL),
('1247', 'order_billing_details', 'backend', 'order_billing_details', 'script', NULL),
('1248', 'order_copy_s', 'backend', 'order_copy_s', 'script', NULL),
('1249', 'order_copy_b', 'backend', 'order_copy_b', 'script', NULL),
('1250', 'order_same', 'backend', 'order_same', 'script', NULL),
('1251', 'order_p_name', 'backend', 'order_p_name', 'script', NULL),
('1252', 'order_p_price', 'backend', 'order_p_price', 'script', NULL),
('1253', 'order_p_qty', 'backend', 'order_p_qty', 'script', NULL),
('1254', 'order_p_attr', 'backend', 'order_p_attr', 'script', NULL),
('1255', 'order_p_sku', 'backend', 'order_p_sku', 'script', NULL),
('1256', 'option_install', 'backend', 'option_install', 'script', NULL),
('1257', 'option_list', 'backend', 'option_list', 'script', NULL),
('1258', 'option_key', 'backend', 'option_key', 'script', NULL),
('1259', 'option_description', 'backend', 'option_description', 'script', NULL),
('1260', 'option_value', 'backend', 'option_value', 'script', NULL),
('1261', 'option_general', 'backend', 'option_general', 'script', NULL),
('1262', 'option_bookings', 'backend', 'option_bookings', 'script', NULL),
('1263', 'option_confirmation', 'backend', 'option_confirmation', 'script', NULL),
('1264', 'option_booking_form', 'backend', 'option_booking_form', 'script', NULL),
('1265', 'option_terms', 'backend', 'option_terms', 'script', NULL),
('1266', 'option_email', 'backend', 'option_email', 'script', NULL),
('1267', 'option_password', 'backend', 'option_password', 'script', NULL),
('1268', 'option_hours_before', 'backend', 'option_hours_before', 'script', NULL),
('1269', 'option_get_key', 'backend', 'option_get_key', 'script', NULL),
('1270', 'option_cron', 'backend', 'option_cron', 'script', NULL),
('1271', 'option_cron_info', 'backend', 'option_cron_info', 'script', NULL),
('1273', 'extra_title', 'backend', 'extra_title', 'script', NULL),
('1274', 'extra_description', 'backend', 'extra_description', 'script', NULL),
('1275', 'extra_update', 'backend', 'extra_update', 'script', NULL),
('1276', 'extra_create', 'backend', 'extra_create', 'script', NULL),
('1277', 'extra_list', 'backend', 'extra_list', 'script', NULL),
('1278', 'extra_price', 'backend', 'extra_price', 'script', NULL),
('1280', 'extra_count', 'backend', 'extra_count', 'script', NULL),
('1281', 'extra_type', 'backend', 'extra_type', 'script', NULL),
('1283', 'extra_is_single', 'backend', 'extra_is_single', 'script', NULL),
('1284', 'extra_empty', 'backend', 'extra_empty', 'script', NULL),
('1285', 'extra_del_title', 'backend', 'extra_del_title', 'script', NULL),
('1286', 'extra_del_body', 'backend', 'extra_del_body', 'script', NULL),
('1290', '_view_calendar', 'backend', '_view_calendar', 'script', NULL),
('1291', '_switch', 'backend', '_switch', 'script', NULL),
('1292', '_search', 'backend', '_search', 'script', NULL),
('1293', '_save', 'backend', '_save', 'script', NULL),
('1294', '_cancel', 'backend', '_cancel', 'script', NULL),
('1295', '_upload', 'backend', '_upload', 'script', NULL),
('1296', '_edit', 'backend', '_edit', 'script', NULL),
('1297', '_contact', 'backend', '_contact', 'script', NULL),
('1298', '_email', 'backend', '_email', 'script', NULL),
('1299', '_bookings', 'backend', '_bookings', 'script', NULL),
('1300', '_print', 'backend', '_print', 'script', NULL),
('1301', '_delete', 'backend', '_delete', 'script', NULL),
('1302', '_delete_all', 'backend', '_delete_all', 'script', NULL),
('1303', '_view', 'backend', '_view', 'script', NULL),
('1304', '_back', 'backend', '_back', 'script', NULL),
('1305', '_never', 'backend', '_never', 'script', NULL),
('1306', '_empty', 'backend', '_empty', 'script', NULL),
('1307', '_sure', 'backend', '_sure', 'script', NULL),
('1308', '_up', 'backend', '_up', 'script', NULL),
('1309', '_down', 'backend', '_down', 'script', NULL),
('1321', 'delete_selected', 'backend', 'Grid / Delete selected', 'script', NULL),
('1328', 'product_extra_types_ARRAY_single', 'arrays', 'product_extra_types_ARRAY_single', 'script', NULL),
('1329', 'product_extra_types_ARRAY_multi', 'arrays', 'product_extra_types_ARRAY_multi', 'script', NULL),
('1330', 'voucher_types_ARRAY_amount', 'arrays', 'voucher_types_ARRAY_amount', 'script', NULL),
('1331', 'voucher_types_ARRAY_percent', 'arrays', 'voucher_types_ARRAY_percent', 'script', NULL),
('1332', 'voucher_valids_ARRAY_fixed', 'arrays', 'voucher_valids_ARRAY_fixed', 'script', NULL),
('1333', 'voucher_valids_ARRAY_period', 'arrays', 'voucher_valids_ARRAY_period', 'script', NULL),
('1334', 'voucher_valids_ARRAY_recurring', 'arrays', 'voucher_valids_ARRAY_recurring', 'script', NULL),
('1335', 'order_statuses_ARRAY_new', 'arrays', 'order_statuses_ARRAY_new', 'script', NULL),
('1336', 'order_statuses_ARRAY_pending', 'arrays', 'order_statuses_ARRAY_pending', 'script', NULL),
('1337', 'order_statuses_ARRAY_cancelled', 'arrays', 'order_statuses_ARRAY_cancelled', 'script', NULL),
('1338', 'order_statuses_ARRAY_completed', 'arrays', 'order_statuses_ARRAY_completed', 'script', NULL),
('1339', 'order_payments_ARRAY_paypal', 'arrays', 'order_payments_ARRAY_paypal', 'script', NULL),
('1340', 'order_payments_ARRAY_authorize', 'arrays', 'order_payments_ARRAY_authorize', 'script', NULL),
('1341', 'order_payments_ARRAY_creditcard', 'arrays', 'order_payments_ARRAY_creditcard', 'script', NULL),
('1342', 'option_err_ARRAY_5', 'arrays', 'option_err_ARRAY_5', 'script', NULL),
('1343', 'extra_per_ARRAY_booking', 'arrays', 'extra_per_ARRAY_booking', 'script', NULL),
('1344', 'extra_per_ARRAY_day', 'arrays', 'extra_per_ARRAY_day', 'script', NULL),
('1345', 'extra_types_ARRAY_limited', 'arrays', 'extra_types_ARRAY_limited', 'script', NULL),
('1346', 'extra_types_ARRAY_unlimited', 'arrays', 'extra_types_ARRAY_unlimited', 'script', NULL),
('1347', 'extra_err_ARRAY_1', 'arrays', 'extra_err_ARRAY_1', 'script', NULL),
('1348', 'extra_err_ARRAY_2', 'arrays', 'extra_err_ARRAY_2', 'script', NULL),
('1349', 'extra_err_ARRAY_3', 'arrays', 'extra_err_ARRAY_3', 'script', NULL),
('1350', 'extra_err_ARRAY_4', 'arrays', 'extra_err_ARRAY_4', 'script', NULL),
('1351', 'extra_err_ARRAY_5', 'arrays', 'extra_err_ARRAY_5', 'script', NULL),
('1352', 'extra_err_ARRAY_6', 'arrays', 'extra_err_ARRAY_6', 'script', NULL),
('1353', 'extra_err_ARRAY_7', 'arrays', 'extra_err_ARRAY_7', 'script', NULL),
('1354', 'extra_err_ARRAY_8', 'arrays', 'extra_err_ARRAY_8', 'script', NULL),
('1357', '_bool_ARRAY_1', 'arrays', '_bool_ARRAY_1', 'script', NULL),
('1358', '_bool_ARRAY_0', 'arrays', '_bool_ARRAY_0', 'script', NULL),
('1359', '_titles_ARRAY_mr', 'arrays', '_titles_ARRAY_mr', 'script', NULL),
('1360', '_titles_ARRAY_mrs', 'arrays', '_titles_ARRAY_mrs', 'script', NULL),
('1361', '_titles_ARRAY_ms', 'arrays', '_titles_ARRAY_ms', 'script', NULL),
('1362', '_titles_ARRAY_dr', 'arrays', '_titles_ARRAY_dr', 'script', NULL),
('1363', '_titles_ARRAY_prof', 'arrays', '_titles_ARRAY_prof', 'script', NULL),
('1364', '_titles_ARRAY_rev', 'arrays', '_titles_ARRAY_rev', 'script', NULL),
('1365', '_titles_ARRAY_other', 'arrays', '_titles_ARRAY_other', 'script', NULL),
('1366', '_payments_ARRAY_paypal', 'arrays', '_payments_ARRAY_paypal', 'script', NULL),
('1367', '_payments_ARRAY_authorize', 'arrays', '_payments_ARRAY_authorize', 'script', NULL),
('1368', '_payments_ARRAY_creditcard', 'arrays', '_payments_ARRAY_creditcard', 'script', NULL),
('1369', '_payments_ARRAY_cash', 'arrays', '_payments_ARRAY_cash', 'script', NULL),
('1373', 'status_ARRAY_4', 'arrays', 'status_ARRAY_4', 'script', NULL),
('1375', 'status_ARRAY_8', 'arrays', 'status_ARRAY_8', 'script', NULL),
('1376', 'status_ARRAY_9', 'arrays', 'status_ARRAY_9', 'script', NULL),
('1377', 'status_ARRAY_20', 'arrays', 'status_ARRAY_20', 'script', NULL),
('1379', 'err_ARRAY_1', 'arrays', 'err_ARRAY_1', 'script', NULL),
('1380', 'errors_ARRAY_AU01', 'arrays', 'errors_ARRAY_AU01', 'script', NULL),
('1381', 'errors_ARRAY_AU02', 'arrays', 'errors_ARRAY_AU02', 'script', NULL),
('1382', 'errors_ARRAY_AU03', 'arrays', 'errors_ARRAY_AU03', 'script', NULL),
('1383', 'errors_ARRAY_AU04', 'arrays', 'errors_ARRAY_AU04', 'script', NULL),
('1384', 'errors_ARRAY_AU05', 'arrays', 'errors_ARRAY_AU05', 'script', NULL),
('1385', 'errors_ARRAY_AU06', 'arrays', 'errors_ARRAY_AU06', 'script', NULL),
('1386', 'errors_ARRAY_AU08', 'arrays', 'errors_ARRAY_AU08', 'script', NULL),
('1387', 'errors_ARRAY_AU09', 'arrays', 'errors_ARRAY_AU09', 'script', NULL),
('1388', 'error_titles_ARRAY_AU10', 'arrays', 'error_titles_ARRAY_AU10', 'script', NULL),
('1389', 'errors_ARRAY_AE01', 'arrays', 'errors_ARRAY_AE01', 'script', NULL),
('1390', 'errors_ARRAY_AE02', 'arrays', 'errors_ARRAY_AE02', 'script', NULL),
('1391', 'errors_ARRAY_AE03', 'arrays', 'errors_ARRAY_AE03', 'script', NULL),
('1392', 'errors_ARRAY_AE04', 'arrays', 'errors_ARRAY_AE04', 'script', NULL),
('1393', 'errors_ARRAY_AE05', 'arrays', 'errors_ARRAY_AE05', 'script', NULL),
('1394', 'errors_ARRAY_AE06', 'arrays', 'errors_ARRAY_AE06', 'script', NULL),
('1395', 'errors_ARRAY_AE08', 'arrays', 'errors_ARRAY_AE08', 'script', NULL),
('1396', 'errors_ARRAY_AP01', 'arrays', 'errors_ARRAY_AP01', 'script', NULL),
('1397', 'errors_ARRAY_AP02', 'arrays', 'errors_ARRAY_AP02', 'script', NULL),
('1398', 'errors_ARRAY_AP03', 'arrays', 'errors_ARRAY_AP03', 'script', NULL),
('1399', 'errors_ARRAY_AP04', 'arrays', 'errors_ARRAY_AP04', 'script', NULL),
('1400', 'errors_ARRAY_AP05', 'arrays', 'errors_ARRAY_AP05', 'script', NULL),
('1401', 'errors_ARRAY_AP06', 'arrays', 'errors_ARRAY_AP06', 'script', NULL),
('1402', 'errors_ARRAY_AP08', 'arrays', 'errors_ARRAY_AP08', 'script', NULL),
('1403', 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
('1404', 'error_titles_ARRAY_AC02', 'arrays', 'error_titles_ARRAY_AC02', 'script', NULL),
('1407', 'error_titles_ARRAY_AC05', 'arrays', 'error_titles_ARRAY_AC05', 'script', NULL),
('1408', 'error_titles_ARRAY_AC06', 'arrays', 'error_titles_ARRAY_AC06', 'script', NULL),
('1409', 'error_titles_ARRAY_AC07', 'arrays', 'error_titles_ARRAY_AC07', 'script', NULL),
('1410', 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
('1411', 'errors_ARRAY_AO01', 'arrays', 'errors_ARRAY_AO01', 'script', NULL),
('1412', 'errors_ARRAY_AO02', 'arrays', 'errors_ARRAY_AO02', 'script', NULL),
('1413', 'errors_ARRAY_AO03', 'arrays', 'errors_ARRAY_AO03', 'script', NULL),
('1414', 'errors_ARRAY_AO04', 'arrays', 'errors_ARRAY_AO04', 'script', NULL),
('1415', 'errors_ARRAY_AO05', 'arrays', 'errors_ARRAY_AO05', 'script', NULL),
('1416', 'errors_ARRAY_AO06', 'arrays', 'errors_ARRAY_AO06', 'script', NULL),
('1417', 'errors_ARRAY_AO08', 'arrays', 'errors_ARRAY_AO08', 'script', NULL),
('1418', 'error_titles_ARRAY_AG01', 'arrays', 'error_titles_ARRAY_AG01', 'script', NULL),
('1419', 'error_titles_ARRAY_AG02', 'arrays', 'error_titles_ARRAY_AG02', 'script', NULL),
('1422', 'error_titles_ARRAY_AG05', 'arrays', 'error_titles_ARRAY_AG05', 'script', NULL),
('1424', 'error_titles_ARRAY_AG08', 'arrays', 'error_titles_ARRAY_AG08', 'script', NULL),
('1425', 'error_titles_ARRAY_AV01', 'arrays', 'error_titles_ARRAY_AV01', 'script', NULL),
('1426', 'error_titles_ARRAY_AV02', 'arrays', 'error_titles_ARRAY_AV02', 'script', NULL),
('1429', 'error_titles_ARRAY_AV05', 'arrays', 'error_titles_ARRAY_AV05', 'script', NULL),
('1430', 'error_titles_ARRAY_AV06', 'arrays', 'error_titles_ARRAY_AV06', 'script', NULL),
('1431', 'error_titles_ARRAY_AV08', 'arrays', 'error_titles_ARRAY_AV08', 'script', NULL),
('1432', 'errors_ARRAY_AS01', 'arrays', 'errors_ARRAY_AS01', 'script', NULL),
('1433', 'errors_ARRAY_AA07', 'arrays', 'errors_ARRAY_AA07', 'script', NULL),
('1434', 'info_ARRAY_users_create', 'arrays', 'info_ARRAY_users_create', 'script', NULL),
('1435', 'info_ARRAY_users_profile', 'arrays', 'info_ARRAY_users_profile', 'script', NULL),
('1436', 'info_ARRAY_options_index', 'arrays', 'info_ARRAY_options_index', 'script', NULL),
('1437', 'info_ARRAY_options_install', 'arrays', 'info_ARRAY_options_install', 'script', NULL),
('1438', 'info_ARRAY_dashboard', 'arrays', 'info_ARRAY_dashboard', 'script', NULL),
('1439', 'info_ARRAY_add_product', 'arrays', 'info_ARRAY_add_product', 'script', NULL),
('1440', 'info_ARRAY_price', 'arrays', 'info_ARRAY_price', 'script', NULL),
('1441', 'info_ARRAY_discounts', 'arrays', 'info_ARRAY_discounts', 'script', NULL),
('1442', 'info_ARRAY_add_extra', 'arrays', 'info_ARRAY_add_extra', 'script', NULL),
('1443', 'info_ARRAY_client_index', 'arrays', 'info_ARRAY_client_index', 'script', NULL),
('1444', 'info_ARRAY_add_category', 'arrays', 'info_ARRAY_add_category', 'script', NULL),
('1445', 'info_ARRAY_add_voucher', 'arrays', 'info_ARRAY_add_voucher', 'script', NULL),
('1446', 'months_full_ARRAY_1', 'arrays', 'months_full_ARRAY_1', 'script', NULL),
('1447', 'months_full_ARRAY_2', 'arrays', 'months_full_ARRAY_2', 'script', NULL),
('1448', 'months_full_ARRAY_3', 'arrays', 'months_full_ARRAY_3', 'script', NULL),
('1449', 'months_full_ARRAY_4', 'arrays', 'months_full_ARRAY_4', 'script', NULL),
('1450', 'months_full_ARRAY_5', 'arrays', 'months_full_ARRAY_5', 'script', NULL),
('1451', 'months_full_ARRAY_6', 'arrays', 'months_full_ARRAY_6', 'script', NULL),
('1452', 'months_full_ARRAY_7', 'arrays', 'months_full_ARRAY_7', 'script', NULL),
('1453', 'months_full_ARRAY_8', 'arrays', 'months_full_ARRAY_8', 'script', NULL),
('1454', 'months_full_ARRAY_9', 'arrays', 'months_full_ARRAY_9', 'script', NULL),
('1455', 'months_full_ARRAY_10', 'arrays', 'months_full_ARRAY_10', 'script', NULL),
('1456', 'months_full_ARRAY_11', 'arrays', 'months_full_ARRAY_11', 'script', NULL),
('1457', 'months_full_ARRAY_12', 'arrays', 'months_full_ARRAY_12', 'script', NULL),
('1458', 'day_name_ARRAY_0', 'arrays', 'day_name_ARRAY_0', 'script', NULL),
('1459', 'day_name_ARRAY_1', 'arrays', 'day_name_ARRAY_1', 'script', NULL),
('1460', 'day_name_ARRAY_2', 'arrays', 'day_name_ARRAY_2', 'script', NULL),
('1461', 'day_name_ARRAY_3', 'arrays', 'day_name_ARRAY_3', 'script', NULL),
('1462', 'day_name_ARRAY_4', 'arrays', 'day_name_ARRAY_4', 'script', NULL),
('1463', 'day_name_ARRAY_5', 'arrays', 'day_name_ARRAY_5', 'script', NULL),
('1464', 'day_name_ARRAY_6', 'arrays', 'day_name_ARRAY_6', 'script', NULL),
('1465', 'daynames_ARRAY_monday', 'arrays', 'daynames_ARRAY_monday', 'script', NULL),
('1466', 'daynames_ARRAY_tuesday', 'arrays', 'daynames_ARRAY_tuesday', 'script', NULL),
('1467', 'daynames_ARRAY_wednesday', 'arrays', 'daynames_ARRAY_wednesday', 'script', NULL),
('1468', 'daynames_ARRAY_thursday', 'arrays', 'daynames_ARRAY_thursday', 'script', NULL),
('1469', 'daynames_ARRAY_friday', 'arrays', 'daynames_ARRAY_friday', 'script', NULL),
('1470', 'daynames_ARRAY_saturday', 'arrays', 'daynames_ARRAY_saturday', 'script', NULL),
('1471', 'daynames_ARRAY_sunday', 'arrays', 'daynames_ARRAY_sunday', 'script', NULL),
('1472', 'f_ARRAY_extras', 'arrays', 'f_ARRAY_extras', 'script', NULL),
('1473', 'opt_o_datetime_format', 'backend', 'Options / Date & Time format', 'script', NULL),
('1474', 'delete_confirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
('1475', 'order_payment_details', 'backend', 'order_payment_details', 'script', NULL),
('1476', 'menuPayments', 'backend', 'Menu Payments', 'script', NULL),
('1477', 'opt_o_allow_authorize', 'backend', 'Options / Allow Authorize.net', 'script', NULL),
('1478', 'opt_o_allow_bank', 'backend', 'Options / Allow Bank', 'script', NULL),
('1479', 'opt_o_allow_creditcard', 'backend', 'Options / Allow Credit Card', 'script', NULL),
('1480', 'opt_o_allow_paypal', 'backend', 'Options / Allow Paypal', 'script', NULL),
('1481', 'opt_o_authorize_key', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
('1482', 'opt_o_authorize_mid', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
('1483', 'opt_o_authorize_tz', 'backend', 'Options / Authorize.net Time zone', 'script', NULL),
('1484', 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
('1485', 'opt_o_thankyou_page', 'backend', 'Options / "Thank you" page location', 'script', NULL),
('1486', 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
('1487', 'opt_o_insurance', 'backend', 'Options / Insurance', 'script', NULL),
('1490', 'opt_o_disable_payments', 'backend', 'Options / Disable payments', 'script', NULL),
('1491', 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
('1492', 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
('1493', 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
('1494', 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
('1495', 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
('1496', 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
('1497', 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
('1498', 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
('1499', 'bf_cc_num', 'frontend', 'Booking form / CC Number', 'script', NULL),
('1500', 'bf_cc_exp', 'frontend', 'Booking form / CC Exp.date', 'script', NULL),
('1501', 'bf_cc_sec', 'frontend', 'Booking form / CC Sec.code', 'script', NULL),
('1502', 'bf_cc_type', 'frontend', 'Booking form / CC Type', 'script', NULL),
('1503', 'bf_payment', 'frontend', 'Booking form / Payment method', 'script', NULL),
('1504', 'choose_address', 'frontend', 'Booking form / Choose address', 'script', NULL),
('1505', 'choose_country', 'backend', 'Booking form / Choose country', 'script', NULL),
('1506', 'choose_payment', 'backend', 'Booking form / Choose payment', 'script', NULL),
('1507', 'payment_methods_ARRAY_cod', 'arrays', 'payment_methods_ARRAY_cod', 'script', NULL),
('1508', 'opt_o_allow_cod', 'backend', 'Options / Allow Cash on delivery', 'script', NULL),
('1509', 'menuGeneral', 'backend', 'Menu General', 'script', NULL),
('1510', 'menuCheckout', 'backend', 'Menu Checkout', 'script', NULL),
('1511', 'opt_o_bf_b_name', 'backend', 'Options / Name (Billing details)', 'script', NULL),
('1512', 'opt_o_bf_b_city', 'backend', 'Options / City (Billing details)', 'script', NULL),
('1513', 'opt_o_bf_b_state', 'backend', 'Options / State (Billing details)', 'script', NULL),
('1514', 'opt_o_bf_b_country_id', 'backend', 'Options / Country (Billing details)', 'script', NULL),
('1515', 'opt_o_bf_b_zip', 'backend', 'Options / Zip (Billing details)', 'script', NULL),
('1517', 'opt_o_bf_b_address_2', 'backend', 'Options / Address 2 (Billing details)', 'script', NULL),
('1518', 'opt_o_bf_b_address_1', 'backend', 'Options / Address 1 (Billing details)', 'script', NULL),
('1519', 'opt_o_bf_s_address_1', 'backend', 'Options / Address 1 (Shipping details)', 'script', NULL),
('1520', 'opt_o_bf_s_address_2', 'backend', 'Options / Address 2 (Shipping details)', 'script', NULL),
('1521', 'opt_o_bf_s_zip', 'backend', 'Options / Zip (Shipping details)', 'script', NULL),
('1522', 'opt_o_bf_s_country_id', 'backend', 'Options / Country (Shipping details)', 'script', NULL),
('1523', 'opt_o_bf_s_state', 'backend', 'Options / State (Shipping details)', 'script', NULL),
('1524', 'opt_o_bf_s_city', 'backend', 'Options / City (Shipping details)', 'script', NULL),
('1525', 'opt_o_bf_s_name', 'backend', 'Options / Name (Shipping details)', 'script', NULL),
('1526', 'opt_o_bf_captcha', 'backend', 'Options / Captcha', 'script', NULL),
('1527', 'opt_o_bf_terms', 'backend', 'Options / Terms', 'script', NULL),
('1528', 'opt_o_notes', 'backend', 'Options / Notes', 'script', NULL),
('1529', 'opt_o_bf_notes', 'backend', 'Options / Notes', 'script', NULL),
('1530', 'bf_captcha', 'frontend', 'Booking form / Captcha', 'script', NULL),
('1531', 'bf_notes', 'frontend', 'Booking form / Notes', 'script', NULL),
('1532', 'bf_terms', 'frontend', 'Booking form / Terms', 'script', NULL),
('1534', 'order_other_details', 'backend', 'Checkout / Other details', 'script', NULL),
('1654', 'bf_bank_account', 'frontend', 'Booking form / Bank account', 'script', NULL),
('1655', 'order_insurance', 'backend', 'order_insurance', 'script', NULL),
('1656', 'order_p_subtotal', 'backend', 'order_p_subtotal', 'script', NULL),
('1657', 'error_bodies_ARRAY_AG01', 'arrays', 'error_bodies_ARRAY_AG01', 'script', NULL),
('1658', 'error_bodies_ARRAY_AG02', 'arrays', 'error_bodies_ARRAY_AG02', 'script', NULL),
('1659', 'error_bodies_ARRAY_AG05', 'arrays', 'error_bodies_ARRAY_AG05', 'script', NULL),
('1660', 'error_bodies_ARRAY_AG08', 'arrays', 'error_bodies_ARRAY_AG08', 'script', NULL),
('1808', 'menuShippingTax', 'backend', 'Menu Shipping & Tax', 'script', NULL),
('1809', 'tax_location', 'backend', 'Shipping & Taxes / Location', 'script', NULL),
('1810', 'tax_shipping', 'backend', 'Shipping & Taxes / Shipping', 'script', NULL),
('1811', 'tax_tax', 'backend', 'Shipping & Taxes / Tax', 'script', NULL),
('1812', 'tax_del_title', 'backend', 'Shipping & Taxes / Delete title', 'script', NULL),
('1813', 'tax_del_body', 'backend', 'Shipping & Taxes / Delete body', 'script', NULL),
('1814', 'order_shipping_location', 'backend', 'Order / Shipping location', 'script', NULL),
('1815', 'product_similar', 'backend', 'Product / Similar products', 'script', NULL),
('1816', 'order_invoice_details', 'backend', 'order_invoice_details', 'script', NULL),
('1817', 'order_create_invoice', 'backend', 'order_create_invoice', 'script', NULL),
('1818', 'order_find_invoices', 'backend', 'order_find_invoices', 'script', NULL),
('1819', 'lblInstallJs1_1', 'backend', 'Install / Step 1', 'script', NULL),
('1820', 'lblInstallJs1_2', 'backend', 'Install / Step 2', 'script', NULL),
('1821', 'lblInstallJs1_3', 'backend', 'Install / Step 3', 'script', NULL),
('1822', 'lblInstallJs1_title', 'backend', 'Install / Title', 'script', NULL),
('1823', 'lblInstallJs1_body', 'backend', 'Install / Body', 'script', NULL),
('1824', 'lblInstallConfig', 'backend', 'Install / Config', 'script', NULL),
('1825', 'lblInstallConfigLocale', 'backend', 'Install / Locale', 'script', NULL),
('1826', 'front_register', 'frontend', 'Menu Register', 'script', NULL),
('1827', 'front_login', 'frontend', 'Menu Login', 'script', NULL),
('1828', 'front_forgot', 'frontend', 'Menu Forgot password', 'script', NULL),
('1829', 'front_logout', 'frontend', 'Menu Logout', 'script', NULL),
('1830', 'front_profile', 'frontend', 'Menu Profile', 'script', NULL),
('1831', 'front_favs', 'frontend', 'Menu Favorites', 'script', NULL),
('1832', 'front_search', 'frontend', 'Search products', 'script', NULL),
('1833', 'front_cart', 'frontend', 'Menu My Bag', 'script', NULL),
('1834', 'front_checkout', 'frontend', 'Menu Checkout', 'script', NULL),
('1835', 'front_item', 'frontend', 'Item (singular)', 'script', NULL),
('1836', 'front_items', 'frontend', 'Item (plural)', 'script', NULL),
('1837', 'front_all', 'frontend', 'All', 'script', NULL),
('1838', 'front_select_category', 'frontend', 'Select category', 'script', NULL),
('1839', 'front_shopping_cart', 'frontend', 'Shopping Cart', 'script', NULL),
('1840', 'front_empty_shopping_cart', 'frontend', 'Empty Shopping Cart', 'script', NULL),
('1842', 'front_back_products', 'frontend', 'Back to Products', 'script', NULL),
('1843', 'front_total', 'frontend', 'Total', 'script', NULL),
('1844', 'front_tax', 'frontend', 'Tax', 'script', NULL),
('1845', 'front_shipping', 'frontend', 'Shipping', 'script', NULL),
('1846', 'front_shipping_location', 'frontend', 'Shipping Location', 'script', NULL),
('1847', 'front_insurance', 'frontend', 'Insurance', 'script', NULL),
('1848', 'front_choose_location', 'frontend', 'Choose location', 'script', NULL),
('1849', 'front_promo_code', 'frontend', 'Promo Code', 'script', NULL),
('1850', 'front_discount', 'frontend', 'Discount', 'script', NULL),
('1851', 'front_apply_code', 'frontend', 'Apply code', 'script', NULL),
('1852', 'front_sub_total', 'frontend', 'Sub Total', 'script', NULL),
('1853', 'front_up', 'frontend', 'Up', 'script', NULL),
('1854', 'front_down', 'frontend', 'Down', 'script', NULL),
('1855', 'front_quantity', 'frontend', 'Quantity', 'script', NULL),
('1856', 'front_product', 'frontend', 'Product', 'script', NULL),
('1857', 'front_price', 'frontend', 'Price', 'script', NULL),
('1858', 'front_product_price', 'frontend', 'Product/Price', 'script', NULL),
('1859', 'front_quantity_total', 'frontend', 'Quantity/Total', 'script', NULL),
('1860', 'front_placeholder_email', 'frontend', 'Type your email address', 'script', NULL),
('1861', 'front_placeholder_password', 'frontend', 'Type your password', 'script', NULL),
('1862', 'front_placeholder_name', 'frontend', 'Type your name', 'script', NULL),
('1863', 'front_placeholder_phone', 'frontend', 'Type your phone', 'script', NULL),
('1864', 'front_placeholder_url', 'frontend', 'Type your website', 'script', NULL),
('1865', 'front_preview_order', 'frontend', 'Preview order', 'script', NULL),
('1866', 'front_back', 'frontend', 'Back', 'script', NULL),
('1867', 'front_placeholder_b_name', 'frontend', 'Type your billing name', 'script', NULL),
('1868', 'front_placeholder_b_city', 'frontend', 'Type your billing city', 'script', NULL),
('1869', 'front_placeholder_b_state', 'frontend', 'Type your billing state', 'script', NULL),
('1870', 'front_placeholder_b_zip', 'frontend', 'Type your billing zip', 'script', NULL),
('1871', 'front_placeholder_b_address_1', 'frontend', 'Type your billing address 1', 'script', NULL),
('1872', 'front_placeholder_b_address_2', 'frontend', 'Type your billing address 2', 'script', NULL),
('1873', 'front_placeholder_s_name', 'frontend', 'Type your shipping name', 'script', NULL),
('1874', 'front_placeholder_s_city', 'frontend', 'Type your shipping city', 'script', NULL),
('1875', 'front_placeholder_s_state', 'frontend', 'Type your shipping state', 'script', NULL),
('1876', 'front_placeholder_s_zip', 'frontend', 'Type your shipping zip', 'script', NULL),
('1877', 'front_placeholder_s_address_1', 'frontend', 'Type your shipping address 1', 'script', NULL),
('1878', 'front_placeholder_s_address_2', 'frontend', 'Type your shipping address 2', 'script', NULL),
('1879', 'front_placeholder_cc_number', 'frontend', 'Type your credit card number', 'script', NULL),
('1880', 'front_placeholder_cc_code', 'frontend', 'Type your credit card security code', 'script', NULL),
('1881', 'front_placeholder_notes', 'frontend', 'Type any additional notes', 'script', NULL),
('1882', 'front_my_favorites', 'frontend', 'My favorites', 'script', NULL),
('1883', 'front_not_available', 'frontend', 'Not available', 'script', NULL),
('1884', 'front_out_of_stock', 'frontend', 'Out of stock', 'script', NULL),
('1885', 'front_empty_favs', 'frontend', 'Empty Favorites', 'script', NULL),
('1886', 'front_favs_not_found', 'frontend', 'Your favorite list is empty', 'script', NULL),
('1887', 'front_forgot_password', 'frontend', 'Forgot password', 'script', NULL),
('1888', 'front_send', 'frontend', 'Send', 'script', NULL),
('1889', 'front_forgot_note', 'frontend', 'Forgot password note', 'script', NULL),
('1890', 'front_login_note', 'frontend', 'Login note', 'script', NULL),
('1891', 'front_edit_order', 'frontend', 'Edit order', 'script', NULL),
('1892', 'front_confirm_procees', 'frontend', 'Confirm & Process order', 'script', NULL),
('1893', 'front_select_extra', 'frontend', 'Select extra', 'script', NULL),
('1894', 'front_add_to_favs', 'frontend', 'Add to Favorites', 'script', NULL),
('1895', 'front_send_to_friend', 'frontend', 'Send to Friend', 'script', NULL),
('1896', 'front_s2f_your_email', 'frontend', 'Your Email address', 'script', NULL),
('1897', 'front_s2f_your_name', 'frontend', 'Your Name', 'script', NULL),
('1898', 'front_s2f_friend_name', 'frontend', 'Friend Name', 'script', NULL),
('1899', 'front_s2f_friend_email', 'frontend', 'Friend Email address', 'script', NULL),
('1900', 'front_cancel', 'frontend', 'Cancel', 'script', NULL),
('1901', 'front_description', 'frontend', 'Description', 'script', NULL),
('1902', 'front_similar', 'frontend', 'Similar Products', 'script', NULL),
('1903', 'front_product_not_found', 'frontend', 'Product not found', 'script', NULL),
('1904', 'front_buy_now', 'frontend', 'Buy Now', 'script', NULL),
('1905', 'front_view_details', 'frontend', 'View Details', 'script', NULL),
('1906', 'front_products_not_found', 'frontend', 'No products found', 'script', NULL),
('1907', 'front_prev', 'frontend', 'Previous', 'script', NULL),
('1908', 'front_next', 'frontend', 'Next', 'script', NULL),
('1909', 'front_profile_note', 'frontend', 'Profile note', 'script', NULL),
('1910', 'front_save_changes', 'frontend', 'Save changes', 'script', NULL),
('1911', 'front_register_note', 'frontend', 'Register note', 'script', NULL),
('1912', 'front_add_to_cart', 'frontend', 'Add to Cart', 'script', NULL),
('1913', 'system_100', 'frontend', 'System / Send to Friend / Missing or empty params', 'script', NULL),
('1914', 'system_101', 'frontend', 'System / Send to Friend / Email not sent', 'script', NULL),
('1915', 'system_200', 'frontend', 'System / Send to Friend / Email sent', 'script', NULL),
('1916', 'system_201', 'frontend', 'System / Account / Successful logout', 'script', NULL),
('1917', 'system_202', 'frontend', 'System / Favs / Product added', 'script', NULL),
('1918', 'system_203', 'frontend', 'System / Favs / Product removed', 'script', NULL),
('1919', 'system_102', 'frontend', 'System / Favs / Product not removed', 'script', NULL),
('1920', 'system_204', 'frontend', 'System / Favs / Favs emptied', 'script', NULL),
('1921', 'system_103', 'frontend', 'System / Favs / Favs not emptied', 'script', NULL),
('1922', 'system_104', 'frontend', 'System / Cart / Voucher code empty', 'script', NULL),
('1923', 'system_205', 'frontend', 'System / Cart / Voucher removed', 'script', NULL),
('1924', 'system_206', 'frontend', 'System / Cart / Product added', 'script', NULL),
('1925', 'system_105', 'frontend', 'System / Cart / Product not added', 'script', NULL),
('1926', 'system_207', 'frontend', 'System / Cart / Product removed', 'script', NULL),
('1927', 'system_106', 'frontend', 'System / Cart / Product not removed', 'script', NULL),
('1928', 'system_208', 'frontend', 'System / Cart / Cart emptied', 'script', NULL),
('1929', 'system_107', 'frontend', 'System / Cart / Cart not emptied', 'script', NULL),
('1930', 'system_108', 'frontend', 'System / Cart / Cart not updated', 'script', NULL),
('1931', 'system_209', 'frontend', 'System / Cart / Cart updated', 'script', NULL),
('1932', 'system_109', 'frontend', 'System / Order / Missing parameters', 'script', NULL),
('1933', 'system_110', 'frontend', 'System / Order / Missing or wrong captcha', 'script', NULL),
('1934', 'system_111', 'frontend', 'System / Order / Customer invalid data', 'script', NULL),
('1936', 'system_112', 'frontend', 'System / Order / Email taken or wrong pswd', 'script', NULL),
('1937', 'system_113', 'frontend', 'System / Order / Client not added', 'script', NULL),
('1938', 'system_114', 'frontend', 'System / Order / Invalid data', 'script', NULL),
('1939', 'system_115', 'frontend', 'System / Order / Empty cart', 'script', NULL),
('1940', 'system_116', 'frontend', 'System / Order / Stocks in cart not in DB', 'script', NULL),
('1941', 'system_117', 'frontend', 'System / Order / Stocks in cart not equal', 'script', NULL),
('1942', 'system_118', 'frontend', 'System / Order / Stock qty not enough', 'script', NULL),
('1943', 'system_210', 'frontend', 'System / Order / Order stored', 'script', NULL),
('1944', 'system_119', 'frontend', 'System / Order / Order not stored', 'script', NULL),
('1945', 'system_211', 'frontend', 'System / Order / Checkout submitted', 'script', NULL),
('1946', 'system_120', 'frontend', 'System / Login / Invalid data', 'script', NULL),
('1947', 'system_121', 'frontend', 'System / Login / Account not found', 'script', NULL),
('1948', 'system_122', 'frontend', 'System / Login / Password doesn''t match', 'script', NULL),
('1949', 'system_212', 'frontend', 'System / Login / Success', 'script', NULL),
('1950', 'system_123', 'frontend', 'System / Forgot / Invalid data', 'script', NULL),
('1952', 'system_124', 'frontend', 'System / Forgot / Account not found', 'script', NULL),
('1953', 'system_125', 'frontend', 'System / Forgot / Password not sent', 'script', NULL),
('1954', 'system_213', 'frontend', 'System / Forgot / Password sent', 'script', NULL),
('1955', 'system_126', 'frontend', 'System / Profile / Invalid data', 'script', NULL),
('1956', 'system_127', 'frontend', 'System / Profile / Email taken', 'script', NULL),
('1957', 'system_214', 'frontend', 'System / Profile / Updated', 'script', NULL),
('1958', 'system_128', 'frontend', 'System / Register / Captcha not match', 'script', NULL),
('1959', 'system_129', 'frontend', 'System / Register / Invalid data', 'script', NULL),
('1960', 'system_130', 'frontend', 'System / Register / Email taken', 'script', NULL),
('1961', 'system_131', 'frontend', 'System / Register / Proccess failed', 'script', NULL),
('1962', 'system_215', 'frontend', 'System / Register / Registered without email', 'script', NULL),
('1963', 'system_216', 'frontend', 'System / Register / Registered with email', 'script', NULL),
('1964', 'menuCountries', 'backend', 'Menu Countries', 'script', NULL),
('1965', 'lblCountry', 'backend', 'Country', 'script', NULL),
('1966', 'lblDeleteConfirmation', 'backend', 'Delete confirmation', 'script', NULL),
('1967', 'lblDeleteSelected', 'backend', 'Delete selected', 'script', NULL),
('1968', 'tabEmails', 'backend', 'Tab Emails', 'script', NULL),
('1969', 'tabSms', 'backend', 'Tab SMS', 'script', NULL),
('1970', 'infoNotificationsEmailTitle', 'backend', 'Infobox / Email notifications title', 'script', NULL),
('1971', 'infoNotificationsEmailBody', 'backend', 'Infobox / Email notifications body', 'script', NULL),
('1972', 'opt_o_email_new_order', 'backend', 'Options / New order received', 'script', NULL),
('1974', 'opt_o_email_password_reminder', 'backend', 'Notifications / Password reminder', 'script', NULL),
('1975', 'opt_subject', 'backend', 'Notifications / Subject', 'script', NULL),
('1976', 'opt_body_forgot_password', 'backend', 'Notifications / Body', 'script', NULL),
('1978', 'infoNotificationsSmsBody', 'backend', 'Infobox / Sms notifications body', 'script', NULL),
('1979', 'infoNotificationsSmsTitle', 'backend', 'Infobox / Sms notifications title', 'script', NULL),
('1980', 'product_attr_group_create', 'backend', 'Add attribute group', 'script', NULL),
('1981', 'product_attr_group_update', 'backend', 'Update attribute group', 'script', NULL),
('1982', 'product_attr_update', 'backend', 'Update attribute', 'script', NULL),
('1983', 'product_attr_create', 'backend', 'Add attribute', 'script', NULL),
('1984', 'product_attr_group_name', 'backend', 'Attributes set name', 'script', NULL),
('1985', 'product_attr_name', 'backend', 'Attribute value', 'script', NULL),
('1986', 'product_attr_group_delete', 'backend', 'Delete attribute group', 'script', NULL),
('1987', 'product_attr_group_delete_body', 'backend', 'Delete attribute group text', 'script', NULL),
('1988', 'product_attr_delete_body', 'backend', 'Delete attribute text', 'script', NULL),
('1989', 'product_attr_erase', 'backend', 'Delete attribute', 'script', NULL),
('1990', 'menuNotifications', 'backend', 'Menu Notifications', 'script', NULL),
('1991', 'opt_o_email_new_registration', 'backend', 'Notifications / New registration', 'script', NULL),
('1992', 'opt_body_new_registration', 'backend', 'Notifications / Body', 'script', NULL),
('1993', 'info_ARRAY_product_details_title', 'arrays', 'info_ARRAY_product_details_title', 'script', NULL),
('1994', 'info_ARRAY_product_details_body', 'arrays', 'info_ARRAY_product_details_body', 'script', NULL),
('1995', 'info_ARRAY_product_digital_title', 'arrays', 'info_ARRAY_product_digital_title', 'script', NULL),
('1996', 'info_ARRAY_product_digital_body', 'arrays', 'info_ARRAY_product_digital_body', 'script', NULL),
('1997', 'info_ARRAY_product_attr_title', 'arrays', 'info_ARRAY_product_attr_title', 'script', NULL),
('1998', 'info_ARRAY_product_attr_body', 'arrays', 'info_ARRAY_product_attr_body', 'script', NULL),
('1999', 'info_ARRAY_product_stock_title', 'arrays', 'info_ARRAY_product_stock_title', 'script', NULL),
('2000', 'info_ARRAY_product_stock_body', 'arrays', 'info_ARRAY_product_stock_body', 'script', NULL),
('2001', 'info_ARRAY_product_photos_title', 'arrays', 'info_ARRAY_product_photos_title', 'script', NULL),
('2002', 'info_ARRAY_product_photos_body', 'arrays', 'info_ARRAY_product_photos_body', 'script', NULL),
('2003', 'info_ARRAY_product_extras_title', 'arrays', 'info_ARRAY_product_extras_title', 'script', NULL),
('2004', 'info_ARRAY_product_extras_body', 'arrays', 'info_ARRAY_product_extras_body', 'script', NULL),
('2005', 'info_ARRAY_product_similar_title', 'arrays', 'info_ARRAY_product_similar_title', 'script', NULL),
('2006', 'info_ARRAY_product_similar_body', 'arrays', 'info_ARRAY_product_similar_body', 'script', NULL),
('2007', 'info_ARRAY_product_history_title', 'arrays', 'info_ARRAY_product_history_title', 'script', NULL),
('2008', 'info_ARRAY_product_history_body', 'arrays', 'info_ARRAY_product_history_body', 'script', NULL),
('2009', 'category_products', 'backend', 'category_products', 'script', NULL),
('2010', 'client_status', 'backend', 'client_status', 'script', NULL),
('2011', 'system_132', 'frontend', 'System / Login / Access denied', 'script', NULL),
('2012', 'order_tab_order', 'backend', 'order_tab_order', 'script', NULL),
('2013', 'order_tab_client', 'backend', 'order_tab_client', 'script', NULL),
('2014', 'order_tab_shipping', 'backend', 'order_tab_shipping', 'script', NULL),
('2015', 'product_stock_tab', 'backend', 'product_stock_tab', 'script', NULL),
('2016', 'front_empty_shipping_location', 'frontend', 'Shipping location is not set', 'script', NULL),
('2017', 'front_empty_checkout_form', 'frontend', 'Checkout form not submitted', 'script', NULL),
('2211', 'error_titles_ARRAY_AC10', 'arrays', 'error_titles_ARRAY_AC10', 'script', NULL),
('2212', 'error_bodies_ARRAY_AC10', 'arrays', 'error_bodies_ARRAY_AC10', 'script', NULL),
('2213', 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
('2214', 'error_bodies_ARRAY_AC07', 'arrays', 'error_bodies_ARRAY_AC07', 'script', NULL),
('2215', 'error_bodies_ARRAY_AC06', 'arrays', 'error_bodies_ARRAY_AC06', 'script', NULL),
('2216', 'error_bodies_ARRAY_AC05', 'arrays', 'error_bodies_ARRAY_AC05', 'script', NULL),
('2217', 'error_bodies_ARRAY_AC02', 'arrays', 'error_bodies_ARRAY_AC02', 'script', NULL),
('2218', 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
('2219', 'info_ARRAY_product_details_add_body', 'arrays', 'info_ARRAY_product_details_add_body', 'script', NULL),
('2220', 'info_ARRAY_product_details_add_title', 'arrays', 'info_ARRAY_product_details_add_title', 'script', NULL),
('2221', 'error_titles_ARRAY_AO10', 'arrays', 'error_titles_ARRAY_AO10', 'script', NULL),
('2222', 'error_titles_ARRAY_AO11', 'arrays', 'error_titles_ARRAY_AO11', 'script', NULL),
('2223', 'error_titles_ARRAY_AO12', 'arrays', 'error_titles_ARRAY_AO12', 'script', NULL),
('2224', 'error_bodies_ARRAY_AO10', 'arrays', 'error_titles_ARRAY_AO10', 'script', NULL),
('2225', 'error_bodies_ARRAY_AO11', 'arrays', 'error_titles_ARRAY_AO11', 'script', NULL),
('2226', 'error_bodies_ARRAY_AO12', 'arrays', 'error_titles_ARRAY_AO12', 'script', NULL),
('2229', 'error_titles_ARRAY_AO24', 'arrays', 'error_titles_ARRAY_AO24', 'script', NULL),
('2230', 'error_bodies_ARRAY_AO24', 'arrays', 'error_titles_ARRAY_AO24', 'script', NULL),
('2231', 'front_booking_status_ARRAY_1', 'arrays', 'front_booking_status_ARRAY_1', 'script', NULL),
('2232', 'front_booking_status_ARRAY_11', 'arrays', 'front_booking_status_ARRAY_11', 'script', NULL),
('2233', 'error_titles_ARRAY_AV10', 'arrays', 'error_titles_ARRAY_AV10', 'script', NULL),
('2234', 'error_bodies_ARRAY_AV10', 'arrays', 'error_bodies_ARRAY_AV10', 'script', NULL),
('2235', 'error_bodies_ARRAY_AV01', 'arrays', 'error_bodies_ARRAY_AV01', 'script', NULL),
('2236', 'error_bodies_ARRAY_AV08', 'arrays', 'error_bodies_ARRAY_AV08', 'script', NULL),
('2237', 'error_bodies_ARRAY_AV06', 'arrays', 'error_bodies_ARRAY_AV06', 'script', NULL),
('2238', 'error_bodies_ARRAY_AV05', 'arrays', 'error_bodies_ARRAY_AV05', 'script', NULL),
('2239', 'error_bodies_ARRAY_AV02', 'arrays', 'error_bodies_ARRAY_AV02', 'script', NULL),
('2240', 'dashboard_last_login', 'backend', 'Dashboard / Last login', 'script', NULL),
('2241', 'dashboard_last_orders', 'backend', 'Dashboard / Latest orders', 'script', NULL),
('2242', 'dashboard_last_clients', 'backend', 'Dashboard / Latest clients', 'script', NULL),
('2243', 'dashboard_stock', 'backend', 'Dashboard / Stock', 'script', NULL),
('2244', 'dashboard_orders_today', 'backend', 'Dashboard / Orders today', 'script', NULL),
('2245', 'dashboard_order_today', 'backend', 'Dashboard / Order today', 'script', NULL),
('2246', 'dashboard_clients_today', 'backend', 'Dashboard / Clients today', 'script', NULL),
('2247', 'dashboard_client_today', 'backend', 'Dashboard / Client today', 'script', NULL),
('2248', 'lblAll', 'backend', 'All', 'script', NULL),
('2249', 'error_titles_ARRAY_AO21', 'arrays', 'error_titles_ARRAY_AO21', 'script', NULL),
('2250', 'error_bodies_ARRAY_AO21', 'arrays', 'error_titles_ARRAY_AO21', 'script', NULL),
('2251', 'error_titles_ARRAY_AO22', 'arrays', 'error_titles_ARRAY_AO22', 'script', NULL),
('2252', 'error_bodies_ARRAY_AO22', 'arrays', 'error_titles_ARRAY_AO22', 'script', NULL),
('2253', 'error_titles_ARRAY_AO23', 'arrays', 'error_titles_ARRAY_AO23', 'script', NULL),
('2254', 'error_bodies_ARRAY_AO23', 'arrays', 'error_titles_ARRAY_AO23', 'script', NULL),
('2255', 'error_titles_ARRAY_AC11', 'arrays', 'error_titles_ARRAY_AC11', 'script', NULL),
('2256', 'error_bodies_ARRAY_AC11', 'arrays', 'error_bodies_ARRAY_AC11', 'script', NULL),
('2257', 'error_titles_ARRAY_AC12', 'arrays', 'error_titles_ARRAY_AC12', 'script', NULL),
('2258', 'error_bodies_ARRAY_AC12', 'arrays', 'error_bodies_ARRAY_AC12', 'script', NULL),
('2259', 'error_titles_ARRAY_AC13', 'arrays', 'error_titles_ARRAY_AC13', 'script', NULL),
('2260', 'error_bodies_ARRAY_AC13', 'arrays', 'error_bodies_ARRAY_AC13', 'script', NULL),
('2261', 'error_titles_ARRAY_AP11', 'arrays', 'error_titles_ARRAY_AP11', 'script', NULL),
('2262', 'error_bodies_ARRAY_AP11', 'arrays', 'error_bodies_ARRAY_AP11', 'script', NULL),
('2263', 'order_select_product', 'backend', 'order_select_product', 'script', NULL),
('2264', 'error_titles_ARRAY_AOR05', 'arrays', 'error_titles_ARRAY_AOR05', 'script', NULL),
('2265', 'error_bodies_ARRAY_AOR05', 'arrays', 'error_bodies_ARRAY_AOR05', 'script', NULL),
('2266', 'error_titles_ARRAY_AOR08', 'arrays', 'error_titles_ARRAY_AOR08', 'script', NULL),
('2267', 'error_bodies_ARRAY_AOR08', 'arrays', 'error_bodies_ARRAY_AOR08', 'script', NULL),
('2268', 'error_titles_ARRAY_AOR07', 'arrays', 'error_titles_ARRAY_AOR07', 'script', NULL),
('2269', 'error_bodies_ARRAY_AOR07', 'arrays', 'error_bodies_ARRAY_AOR07', 'script', NULL),
('2270', 'order_all_list', 'backend', 'order_all_list', 'script', NULL),
('2271', 'gridEmptyDate', 'backend', 'Grid / Empty date', 'script', NULL),
('2272', 'gridInvalidDate', 'backend', 'Grid / Invalid date', 'script', NULL),
('2273', 'gridInvalidDatetime', 'backend', 'Grid / Invalid datetime', 'script', NULL),
('2274', 'gridEmptyDatetime', 'backend', 'Grid / Empty datetime', 'script', NULL),
('2275', 'dashboard_products', 'backend', 'Dashboard / Products', 'script', NULL),
('2276', 'dashboard_product', 'backend', 'Dashboard / Product', 'script', NULL),
('2279', 'save_to_address_book', 'frontend', 'Frontend / Save to address book', 'script', NULL),
('2280', 'front_price_from', 'frontend', 'front_price_from', 'script', NULL),
('2281', 'opt_o_seo_url', 'backend', 'Options / Seo URLs', 'script', NULL),
('2282', 'product_image', 'backend', 'Product / Image', 'script', NULL),
('2283', 'tax_free', 'backend', 'Shipping & Taxes / Free shipping', 'script', NULL),
('2284', 'opt_o_disable_orders', 'backend', 'Options / Disable orders', 'script', NULL),
('2495', 'validate_ARRAY_captcha', 'arrays', 'Validate / Captcha', 'script', NULL),
('2496', 'validate_ARRAY_password', 'arrays', 'Validate / Password', 'script', NULL),
('2497', 'validate_ARRAY_name', 'arrays', 'Validate / Name', 'script', NULL),
('2498', 'validate_ARRAY_email', 'arrays', 'Validate / Email', 'script', NULL),
('2499', 'validate_ARRAY_email_invalid', 'arrays', 'Validate / Email invalid', 'script', NULL),
('2500', 'validate_ARRAY_captcha_wrong', 'arrays', 'Validate / Captcha is wrong', 'script', NULL),
('2501', 'validate_ARRAY_voucher', 'arrays', 'Validate / Voucher', 'script', NULL),
('2502', 'validate_ARRAY_tax', 'arrays', 'Validate / Shipping Location', 'script', NULL),
('2503', 'validate_ARRAY_country', 'arrays', 'Validate / Country', 'script', NULL),
('2504', 'validate_ARRAY_city', 'arrays', 'Validate / City', 'script', NULL),
('2505', 'validate_ARRAY_state', 'arrays', 'Validate / State', 'script', NULL),
('2506', 'validate_ARRAY_zip', 'arrays', 'Validate / Zip', 'script', NULL),
('2507', 'validate_ARRAY_address_1', 'arrays', 'Validate / Address 1', 'script', NULL),
('2508', 'validate_ARRAY_address_2', 'arrays', 'Validate / Address 2', 'script', NULL),
('2509', 'validate_ARRAY_notes', 'arrays', 'Validate / Notes', 'script', NULL),
('2510', 'validate_ARRAY_payment', 'arrays', 'Validate / Payment method', 'script', NULL),
('2511', 'validate_ARRAY_terms', 'arrays', 'Validate / Terms & Conditions', 'script', NULL),
('2512', 'opt_o_authorize_hash', 'backend', 'Options / Authorize.net hash value', 'script', NULL),
('2513', 'menuConfirmation', 'backend', 'Menu Confirmation', 'script', NULL),
('2514', 'error_bodies_ARRAY_AO25', 'arrays', 'error_titles_ARRAY_AO25', 'script', NULL),
('2515', 'error_titles_ARRAY_AO25', 'arrays', 'error_titles_ARRAY_AO25', 'script', NULL),
('2516', 'confirmation_body', 'backend', 'Confirmation / Email body', 'script', NULL),
('2517', 'confirmation_subject', 'backend', 'Confirmation / Email subject', 'script', NULL),
('2518', 'confirmation_admin_payment', 'backend', 'Confirmation / Admin payment title', 'script', NULL),
('2519', 'confirmation_admin_confirmation', 'backend', 'Confirmation / Admin confirmation title', 'script', NULL),
('2520', 'confirmation_client_payment', 'backend', 'Confirmation / Client payment title', 'script', NULL),
('2521', 'confirmation_client_confirmation', 'backend', 'Confirmation / Client confirmation title', 'script', NULL),
('2522', 'menuTerms', 'backend', 'Menu Terms', 'script', NULL),
('2523', 'error_bodies_ARRAY_AO26', 'arrays', 'error_titles_ARRAY_AO26', 'script', NULL),
('2524', 'error_titles_ARRAY_AO26', 'arrays', 'error_titles_ARRAY_AO26', 'script', NULL),
('2525', 'terms_content', 'backend', 'Options / Order terms content', 'script', NULL),
('2526', 'terms_url', 'backend', 'Options / Order terms URL', 'script', NULL),
('2737', 'digital_status_ARRAY_1', 'arrays', 'Digital / Missing params', 'script', NULL),
('2738', 'digital_status_ARRAY_2', 'arrays', 'Digital / Order not found', 'script', NULL),
('2739', 'digital_status_ARRAY_3', 'arrays', 'Digital / Order not paid', 'script', NULL),
('2740', 'digital_status_ARRAY_4', 'arrays', 'Digital / Digital products not found', 'script', NULL),
('2741', 'digital_status_ARRAY_5', 'arrays', 'Digital / Digital products expired', 'script', NULL),
('2952', 'menuSeo', 'backend', 'Menu SEO', 'script', NULL),
('2953', 'error_titles_ARRAY_AO30', 'arrays', 'error_titles_ARRAY_AO30', 'script', NULL),
('2954', 'error_bodies_ARRAY_AO30', 'arrays', 'error_titles_ARRAY_AO30', 'script', NULL),
('2955', 'lblInstallSeo_1', 'backend', 'Install / SEO Step 1', 'script', NULL),
('2956', 'lblInstallSeo_2', 'backend', 'Install / SEO Step 2', 'script', NULL),
('2957', 'lblInstallSeo_3', 'backend', 'Install / SEO Step 3', 'script', NULL),
('2958', 'lblInstallConfigHide', 'backend', 'Install / Config hide', 'script', NULL),
('2959', 'order_send_confirm', 'backend', 'Order / Send order confirmation', 'script', NULL),
('2960', 'order_send_payment', 'backend', 'Order / Send payment confirmation', 'script', NULL),
('2961', 'order_payment_title', 'backend', 'Order / Payment confirmation', 'script', NULL),
('2962', 'order_confirm_title', 'backend', 'Order / Order confirmation', 'script', NULL),
('2963', 'order_send_subject', 'backend', 'Order / Confirmation subject', 'script', NULL),
('2964', 'order_send_body', 'backend', 'Order / Confirmation body', 'script', NULL),
('2965', 'order_unit_price', 'backend', 'Order / Unit price', 'script', NULL),
('2966', 'order_current_stock', 'backend', 'Order / Current stock', 'script', NULL),
('3177', 'front_terms_title', 'frontend', 'Checkout / Terms & Conditions', 'script', NULL),
('3178', 'confirm_sms_admin', 'backend', 'Confirmation / Admin - order confirmation sms', 'script', NULL),
('3179', 'payment_sms_admin', 'backend', 'Confirmation / Admin - payment confirmation sms', 'script', NULL),
('3180', 'sms_body', 'backend', 'Confirmation / SMS content', 'script', NULL),
('3181', 'product_extra_copy', 'backend', 'product_extra_copy', 'script', NULL),
('3182', 'product_extra_copy_title', 'backend', 'product_extra_copy_title', 'script', NULL),
('3183', 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
('3184', 'product_v_sku', 'backend', 'product_v_sku', 'script', '2014-06-02 06:01:46'),
('3185', 'opt_o_products_per_page', 'backend', 'Options / Products per page', 'script', '2014-06-02 07:48:37'),
('3186', 'product_stock_print_all', 'backend', 'product_stock_print_all', 'script', '2014-06-02 08:45:20'),
('3187', 'product_stock_print_selected', 'backend', 'product_stock_print_selected', 'script', '2014-06-02 08:45:02'),
('3188', 'opt_o_bf_c_name', 'backend', 'Options / Name (Client)', 'script', '2014-06-02 10:52:47'),
('3189', 'opt_o_bf_c_phone', 'backend', 'Options / Phone (Client)', 'script', '2014-06-02 10:53:01'),
('3190', 'opt_o_bf_c_url', 'backend', 'Options / Website (Client)', 'script', '2014-06-02 10:53:13'),
('3191', 'validate_ARRAY_phone', 'arrays', 'Validate / Phone', 'script', '2014-06-02 10:59:41'),
('3192', 'validate_ARRAY_url', 'arrays', 'Validate / Website', 'script', '2014-06-02 11:00:16');

DROP TABLE IF EXISTS `shopping_cart_multi_lang`;

CREATE TABLE `shopping_cart_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(60) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(60) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `shopping_cart_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 5, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 347, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Listing Address Title', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Listing Address Body', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 417, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 907, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 908, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 909, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 910, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 983, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 984, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 985, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 986, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 990, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 992, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 993, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 994, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 995, 'pjField', 1, 'title', 'Select email sending method', 'script'),
(NULL, 996, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 997, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 998, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 999, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 1026, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 1027, 'pjField', 1, 'title', 'Vouchers', 'script'),
(NULL, 1028, 'pjField', 1, 'title', 'Orders', 'script'),
(NULL, 1029, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 1030, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 1031, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 1032, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 1033, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 1034, 'pjField', 1, 'title', 'Add', 'script'),
(NULL, 1035, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 1036, 'pjField', 1, 'title', 'Hidden', 'script'),
(NULL, 1038, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1039, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 1040, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 1042, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 1044, 'pjField', 1, 'title', 'Options and Account Details', 'script'),
(NULL, 1045, 'pjField', 1, 'title', 'Installation instructions', 'script'),
(NULL, 1046, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 1047, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 1048, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 1049, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 1050, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 1051, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 1052, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 1053, 'pjField', 1, 'title', 'Orders', 'script'),
(NULL, 1054, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 1055, 'pjField', 1, 'title', 'Vouchers', 'script'),
(NULL, 1056, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 1057, 'pjField', 1, 'title', 'Add product', 'script'),
(NULL, 1058, 'pjField', 1, 'title', 'No products found', 'script'),
(NULL, 1059, 'pjField', 1, 'title', 'Product update', 'script'),
(NULL, 1060, 'pjField', 1, 'title', '-- Category --', 'script'),
(NULL, 1061, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 1062, 'pjField', 1, 'title', 'Digital', 'script'),
(NULL, 1063, 'pjField', 1, 'title', 'Attributes', 'script'),
(NULL, 1064, 'pjField', 1, 'title', 'In Stock', 'script'),
(NULL, 1065, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 1066, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 1067, 'pjField', 1, 'title', 'History', 'script'),
(NULL, 1068, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 1070, 'pjField', 1, 'title', 'Product name', 'script'),
(NULL, 1071, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 1072, 'pjField', 1, 'title', 'Short description', 'script'),
(NULL, 1073, 'pjField', 1, 'title', 'Full description', 'script'),
(NULL, 1074, 'pjField', 1, 'title', 'Is featured', 'script'),
(NULL, 1075, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 1076, 'pjField', 1, 'title', 'Is digital', 'script'),
(NULL, 1077, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 1078, 'pjField', 1, 'title', 'Browse file', 'script'),
(NULL, 1079, 'pjField', 1, 'title', 'File path', 'script'),
(NULL, 1080, 'pjField', 1, 'title', 'Link expiration', 'script'),
(NULL, 1081, 'pjField', 1, 'title', 'Confirm digital file delete', 'script'),
(NULL, 1082, 'pjField', 1, 'title', 'Are you sure you want to delete selected digital file?', 'script'),
(NULL, 1083, 'pjField', 1, 'title', 'Confirm product delete', 'script'),
(NULL, 1084, 'pjField', 1, 'title', 'Are you sure you want to delete selected product?', 'script'),
(NULL, 1085, 'pjField', 1, 'title', 'Extra type', 'script'),
(NULL, 1087, 'pjField', 1, 'title', 'Add extra', 'script'),
(NULL, 1088, 'pjField', 1, 'title', 'Add extra item', 'script'),
(NULL, 1089, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1090, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1091, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1092, 'pjField', 1, 'title', 'Required', 'script'),
(NULL, 1093, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 1094, 'pjField', 1, 'title', 'Confirm extra delete', 'script'),
(NULL, 1095, 'pjField', 1, 'title', 'Are you sure you want to delete selected extra?', 'script'),
(NULL, 1096, 'pjField', 1, 'title', 'Add new attributes set', 'script'),
(NULL, 1097, 'pjField', 1, 'title', 'Copy attributes from similar product', 'script'),
(NULL, 1098, 'pjField', 1, 'title', 'Add attribute item', 'script'),
(NULL, 1099, 'pjField', 1, 'title', 'Attribute title', 'script'),
(NULL, 1100, 'pjField', 1, 'title', 'Attribute item', 'script'),
(NULL, 1101, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 1102, 'pjField', 1, 'title', 'Confirm attribute delete', 'script'),
(NULL, 1103, 'pjField', 1, 'title', 'Are you sure you want to delete selected attribute?', 'script'),
(NULL, 1104, 'pjField', 1, 'title', 'Copy attributes from similar product', 'script'),
(NULL, 1105, 'pjField', 1, 'title', 'OR', 'script'),
(NULL, 1106, 'pjField', 1, 'title', 'Copy', 'script'),
(NULL, 1107, 'pjField', 1, 'title', 'Qty', 'script'),
(NULL, 1108, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1109, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 1110, 'pjField', 1, 'title', 'Attributes', 'script'),
(NULL, 1111, 'pjField', 1, 'title', 'Choose image', 'script'),
(NULL, 1112, 'pjField', 1, 'title', 'Add combination', 'script'),
(NULL, 1113, 'pjField', 1, 'title', 'Choose an image', 'script'),
(NULL, 1114, 'pjField', 1, 'title', 'Confirm stock delete', 'script'),
(NULL, 1115, 'pjField', 1, 'title', 'Are you sure you want to delete selected stock?', 'script'),
(NULL, 1116, 'pjField', 1, 'title', 'No history found', 'script'),
(NULL, 1117, 'pjField', 1, 'title', 'Date/Time', 'script'),
(NULL, 1118, 'pjField', 1, 'title', 'Product', 'script'),
(NULL, 1119, 'pjField', 1, 'title', 'Qty before', 'script'),
(NULL, 1120, 'pjField', 1, 'title', 'Qty after', 'script'),
(NULL, 1122, 'pjField', 1, 'title', 'Upload', 'script'),
(NULL, 1123, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 1124, 'pjField', 1, 'title', 'Are you sure you want to delete this image?', 'script'),
(NULL, 1125, 'pjField', 1, 'title', 'Edit image', 'script'),
(NULL, 1126, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1127, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 1128, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 1129, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1130, 'pjField', 1, 'title', 'Click on upload images button above to start uploading images', 'script'),
(NULL, 1131, 'pjField', 1, 'title', 'COMING ON', 'script'),
(NULL, 1132, 'pjField', 1, 'title', 'LEAVING ON', 'script'),
(NULL, 1133, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1134, 'pjField', 1, 'title', 'Registration number', 'script'),
(NULL, 1135, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 1136, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 1137, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 1138, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 1139, 'pjField', 1, 'title', 'Space type', 'script'),
(NULL, 1140, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 1141, 'pjField', 1, 'title', 'Available spaces', 'script'),
(NULL, 1142, 'pjField', 1, 'title', 'No bookings', 'script'),
(NULL, 1143, 'pjField', 1, 'title', 'Update voucher', 'script'),
(NULL, 1144, 'pjField', 1, 'title', 'Add voucher', 'script'),
(NULL, 1145, 'pjField', 1, 'title', 'Voucher list', 'script'),
(NULL, 1146, 'pjField', 1, 'title', 'Voucher code', 'script'),
(NULL, 1147, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 1148, 'pjField', 1, 'title', 'Choose a product', 'script'),
(NULL, 1149, 'pjField', 1, 'title', 'Discount', 'script'),
(NULL, 1150, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 1152, 'pjField', 1, 'title', 'Valid', 'script'),
(NULL, 1154, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 1155, 'pjField', 1, 'title', 'Time from', 'script'),
(NULL, 1156, 'pjField', 1, 'title', 'Time to', 'script'),
(NULL, 1157, 'pjField', 1, 'title', 'From date/time', 'script'),
(NULL, 1158, 'pjField', 1, 'title', 'To date/time', 'script'),
(NULL, 1159, 'pjField', 1, 'title', 'Every', 'script'),
(NULL, 1160, 'pjField', 1, 'title', 'Vouchers', 'script'),
(NULL, 1161, 'pjField', 1, 'title', '-- Choose --', 'script'),
(NULL, 1162, 'pjField', 1, 'title', 'No vouchers found', 'script'),
(NULL, 1163, 'pjField', 1, 'title', 'Delete this voucher?', 'script'),
(NULL, 1164, 'pjField', 1, 'title', 'All voucher'' details will be deleted and will not be possible to restore them.', 'script'),
(NULL, 1165, 'pjField', 1, 'title', 'Delete product association confirmation', 'script'),
(NULL, 1166, 'pjField', 1, 'title', 'Are you sure you want to delete product association?', 'script'),
(NULL, 1167, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 1168, 'pjField', 1, 'title', 'Add client', 'script'),
(NULL, 1169, 'pjField', 1, 'title', 'Update client', 'script'),
(NULL, 1170, 'pjField', 1, 'title', 'Find', 'script'),
(NULL, 1171, 'pjField', 1, 'title', 'E-Mail address', 'script'),
(NULL, 1172, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 1173, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1174, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 1175, 'pjField', 1, 'title', 'Client Name', 'script'),
(NULL, 1176, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 1177, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 1178, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1179, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1180, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1181, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1182, 'pjField', 1, 'title', 'Address line 1', 'script'),
(NULL, 1183, 'pjField', 1, 'title', 'Address line 2', 'script'),
(NULL, 1184, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1185, 'pjField', 1, 'title', 'Default shipping address', 'script'),
(NULL, 1186, 'pjField', 1, 'title', 'Default billing address', 'script'),
(NULL, 1187, 'pjField', 1, 'title', 'No clients found', 'script'),
(NULL, 1188, 'pjField', 1, 'title', 'Address book', 'script'),
(NULL, 1189, 'pjField', 1, 'title', 'General info', 'script'),
(NULL, 1190, 'pjField', 1, 'title', '-- Choose --', 'script'),
(NULL, 1191, 'pjField', 1, 'title', '+ Add new address', 'script'),
(NULL, 1192, 'pjField', 1, 'title', 'delete', 'script'),
(NULL, 1193, 'pjField', 1, 'title', 'Confirm address delete', 'script'),
(NULL, 1194, 'pjField', 1, 'title', 'Are you sure you want to delete selected address?', 'script'),
(NULL, 1195, 'pjField', 1, 'title', 'Confirm client delete', 'script'),
(NULL, 1196, 'pjField', 1, 'title', 'Are you sure you want to delete selected client?', 'script'),
(NULL, 1197, 'pjField', 1, 'title', 'Total orders', 'script'),
(NULL, 1198, 'pjField', 1, 'title', 'Last order', 'script'),
(NULL, 1199, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 1200, 'pjField', 1, 'title', 'Add category', 'script'),
(NULL, 1201, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 1202, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1203, 'pjField', 1, 'title', 'Parent category', 'script'),
(NULL, 1204, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 1205, 'pjField', 1, 'title', '-- Choose --', 'script'),
(NULL, 1206, 'pjField', 1, 'title', 'No parent', 'script'),
(NULL, 1207, 'pjField', 1, 'title', 'No categories found', 'script'),
(NULL, 1208, 'pjField', 1, 'title', 'Delete this category?', 'script'),
(NULL, 1209, 'pjField', 1, 'title', 'All category'' details will be deleted and will not be possible to restore them.', 'script'),
(NULL, 1210, 'pjField', 1, 'title', 'Orders', 'script'),
(NULL, 1211, 'pjField', 1, 'title', 'Add order', 'script'),
(NULL, 1212, 'pjField', 1, 'title', 'Update order', 'script'),
(NULL, 1213, 'pjField', 1, 'title', 'Order number', 'script'),
(NULL, 1214, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 1216, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1217, 'pjField', 1, 'title', 'Shipping', 'script'),
(NULL, 1218, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 1219, 'pjField', 1, 'title', 'Discount', 'script'),
(NULL, 1220, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 1221, 'pjField', 1, 'title', 'Voucher', 'script'),
(NULL, 1222, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 1224, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 1225, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 1226, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1227, 'pjField', 1, 'title', 'E-Mail address', 'script'),
(NULL, 1228, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1229, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 1230, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 1231, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1232, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1233, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1234, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1235, 'pjField', 1, 'title', 'Address line 1', 'script'),
(NULL, 1236, 'pjField', 1, 'title', 'Address line 2', 'script'),
(NULL, 1237, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1238, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1239, 'pjField', 1, 'title', 'No orders found', 'script'),
(NULL, 1240, 'pjField', 1, 'title', 'Order details', 'script'),
(NULL, 1241, 'pjField', 1, 'title', '-- Choose --', 'script'),
(NULL, 1242, 'pjField', 1, 'title', 'delete', 'script'),
(NULL, 1243, 'pjField', 1, 'title', 'Confirm order delete', 'script'),
(NULL, 1244, 'pjField', 1, 'title', 'Are you sure you want to delete selected order?', 'script'),
(NULL, 1245, 'pjField', 1, 'title', 'Customer info', 'script'),
(NULL, 1246, 'pjField', 1, 'title', 'Shipping details', 'script'),
(NULL, 1247, 'pjField', 1, 'title', 'Billing details', 'script'),
(NULL, 1248, 'pjField', 1, 'title', 'Use for Shipping address', 'script'),
(NULL, 1249, 'pjField', 1, 'title', 'Use for Billing address', 'script'),
(NULL, 1250, 'pjField', 1, 'title', 'Same as Billing details', 'script'),
(NULL, 1251, 'pjField', 1, 'title', 'Product', 'script'),
(NULL, 1252, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1253, 'pjField', 1, 'title', 'Qty', 'script'),
(NULL, 1254, 'pjField', 1, 'title', 'Attributes', 'script'),
(NULL, 1255, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 1256, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 1257, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 1258, 'pjField', 1, 'title', 'Option key', 'script'),
(NULL, 1259, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 1260, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 1261, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 1262, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 1263, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 1264, 'pjField', 1, 'title', 'Checkout Form', 'script'),
(NULL, 1265, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 1266, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1267, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 1268, 'pjField', 1, 'title', 'hours before', 'script'),
(NULL, 1269, 'pjField', 1, 'title', 'get key', 'script'),
(NULL, 1270, 'pjField', 1, 'title', 'Cron script', 'script'),
(NULL, 1271, 'pjField', 1, 'title', 'You need to set up a cron job using your hosting account control panel which should execute every hour. Depending on your web server you should use either the URL or script path.\r\n<br /><br/>\r\nServer path:<br /><span class="bold">%1$s</span>\r\n<br /><br />\r\nURL:<br /><span class="bold">%2$s</span>', 'script'),
(NULL, 1273, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1274, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 1275, 'pjField', 1, 'title', 'Update extra', 'script'),
(NULL, 1276, 'pjField', 1, 'title', 'Add extra', 'script'),
(NULL, 1277, 'pjField', 1, 'title', 'Extra list', 'script'),
(NULL, 1278, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1280, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 1281, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 1283, 'pjField', 1, 'title', 'Is single', 'script'),
(NULL, 1284, 'pjField', 1, 'title', 'No extras found', 'script'),
(NULL, 1285, 'pjField', 1, 'title', 'Delete this extra?', 'script'),
(NULL, 1286, 'pjField', 1, 'title', 'All extra'' details will be deleted and will not be possible to restore them.', 'script'),
(NULL, 1290, 'pjField', 1, 'title', 'calendar', 'script'),
(NULL, 1291, 'pjField', 1, 'title', 'Switch On/Off', 'script'),
(NULL, 1292, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 1293, 'pjField', 1, 'title', 'Save changes', 'script'),
(NULL, 1294, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1295, 'pjField', 1, 'title', 'Upload', 'script'),
(NULL, 1296, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 1297, 'pjField', 1, 'title', 'Contact', 'script'),
(NULL, 1298, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1299, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 1300, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 1301, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 1302, 'pjField', 1, 'title', 'delete all', 'script'),
(NULL, 1303, 'pjField', 1, 'title', 'view', 'script'),
(NULL, 1304, 'pjField', 1, 'title', 'back', 'script'),
(NULL, 1305, 'pjField', 1, 'title', 'never', 'script'),
(NULL, 1306, 'pjField', 1, 'title', 'No records.', 'script'),
(NULL, 1307, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 1308, 'pjField', 1, 'title', 'up', 'script'),
(NULL, 1309, 'pjField', 1, 'title', 'down', 'script'),
(NULL, 1321, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 1328, 'pjField', 1, 'title', 'Single', 'script'),
(NULL, 1329, 'pjField', 1, 'title', 'Multi', 'script'),
(NULL, 1330, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 1331, 'pjField', 1, 'title', 'Percent', 'script'),
(NULL, 1332, 'pjField', 1, 'title', 'Fixed date', 'script'),
(NULL, 1333, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 1334, 'pjField', 1, 'title', 'Recurring', 'script'),
(NULL, 1335, 'pjField', 1, 'title', 'New', 'script'),
(NULL, 1336, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 1337, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 1338, 'pjField', 1, 'title', 'Completed', 'script'),
(NULL, 1339, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 1340, 'pjField', 1, 'title', 'Authorize.NET', 'script'),
(NULL, 1341, 'pjField', 1, 'title', 'Credit Card', 'script'),
(NULL, 1342, 'pjField', 1, 'title', 'Options has been updated', 'script'),
(NULL, 1343, 'pjField', 1, 'title', 'Per booking', 'script'),
(NULL, 1344, 'pjField', 1, 'title', 'Per day', 'script'),
(NULL, 1345, 'pjField', 1, 'title', 'Limited', 'script'),
(NULL, 1346, 'pjField', 1, 'title', 'Unlimited', 'script'),
(NULL, 1347, 'pjField', 1, 'title', 'Extra has been added', 'script'),
(NULL, 1348, 'pjField', 1, 'title', 'Extra has not been added', 'script'),
(NULL, 1349, 'pjField', 1, 'title', 'Extra has been deleted', 'script'),
(NULL, 1350, 'pjField', 1, 'title', 'Extra has not been deleted', 'script'),
(NULL, 1351, 'pjField', 1, 'title', 'Extra has been updated', 'script'),
(NULL, 1352, 'pjField', 1, 'title', 'Extra has not been updated', 'script'),
(NULL, 1353, 'pjField', 1, 'title', '', 'script'),
(NULL, 1354, 'pjField', 1, 'title', 'Extra doesn''t exists', 'script'),
(NULL, 1357, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1358, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 1359, 'pjField', 1, 'title', 'Mr', 'script'),
(NULL, 1360, 'pjField', 1, 'title', 'Mrs', 'script'),
(NULL, 1361, 'pjField', 1, 'title', 'Ms', 'script'),
(NULL, 1362, 'pjField', 1, 'title', 'Dr', 'script'),
(NULL, 1363, 'pjField', 1, 'title', 'Prof', 'script'),
(NULL, 1364, 'pjField', 1, 'title', 'Rev', 'script'),
(NULL, 1365, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 1366, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 1367, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 1368, 'pjField', 1, 'title', 'Credit Card', 'script'),
(NULL, 1369, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 1373, 'pjField', 1, 'title', 'The operation has not been successful', 'script'),
(NULL, 1375, 'pjField', 1, 'title', 'The operation is allowed only in Multi-calendar mode', 'script'),
(NULL, 1376, 'pjField', 1, 'title', 'The operation is allowed only in Multi-user mode', 'script'),
(NULL, 1377, 'pjField', 1, 'title', 'The operation has been successful', 'script'),
(NULL, 1379, 'pjField', 1, 'title', 'Operation has not been successful.', 'script'),
(NULL, 1380, 'pjField', 1, 'title', 'User has been added', 'script'),
(NULL, 1381, 'pjField', 1, 'title', 'User has not been added', 'script'),
(NULL, 1382, 'pjField', 1, 'title', 'User has been deleted', 'script'),
(NULL, 1383, 'pjField', 1, 'title', 'User has not been deleted', 'script'),
(NULL, 1384, 'pjField', 1, 'title', 'User has been updated', 'script'),
(NULL, 1385, 'pjField', 1, 'title', 'User has not been updated', 'script'),
(NULL, 1386, 'pjField', 1, 'title', 'User doesn''t exists', 'script'),
(NULL, 1387, 'pjField', 1, 'title', 'Email already exists', 'script'),
(NULL, 1388, 'pjField', 1, 'title', 'Profile has been updated', 'script'),
(NULL, 1389, 'pjField', 1, 'title', 'Extra has been added', 'script'),
(NULL, 1390, 'pjField', 1, 'title', 'Extra has not been added', 'script'),
(NULL, 1391, 'pjField', 1, 'title', 'Extra has been deleted', 'script'),
(NULL, 1392, 'pjField', 1, 'title', 'Extra has not been deleted', 'script'),
(NULL, 1393, 'pjField', 1, 'title', 'Extra has been updated', 'script'),
(NULL, 1394, 'pjField', 1, 'title', 'Extra has not been updated', 'script'),
(NULL, 1395, 'pjField', 1, 'title', 'Extra doesn''t exists', 'script'),
(NULL, 1396, 'pjField', 1, 'title', 'Product has been added', 'script'),
(NULL, 1397, 'pjField', 1, 'title', 'Product has not been added', 'script'),
(NULL, 1398, 'pjField', 1, 'title', 'Product has been deleted', 'script'),
(NULL, 1399, 'pjField', 1, 'title', 'Product has not been deleted', 'script'),
(NULL, 1400, 'pjField', 1, 'title', 'Product has been updated', 'script'),
(NULL, 1401, 'pjField', 1, 'title', 'Product has not been updated', 'script'),
(NULL, 1402, 'pjField', 1, 'title', 'Product doesn''t exists', 'script'),
(NULL, 1403, 'pjField', 1, 'title', 'Client has been added', 'script'),
(NULL, 1404, 'pjField', 1, 'title', 'Client has not been added', 'script'),
(NULL, 1407, 'pjField', 1, 'title', 'Client has been updated', 'script'),
(NULL, 1408, 'pjField', 1, 'title', 'Client has not been updated', 'script'),
(NULL, 1409, 'pjField', 1, 'title', 'E-Mail address already in use', 'script'),
(NULL, 1410, 'pjField', 1, 'title', 'Client doesn''t exists', 'script'),
(NULL, 1411, 'pjField', 1, 'title', 'Order has been added', 'script'),
(NULL, 1412, 'pjField', 1, 'title', 'Order has not been added', 'script'),
(NULL, 1413, 'pjField', 1, 'title', 'Order has been deleted', 'script'),
(NULL, 1414, 'pjField', 1, 'title', 'Order has not been deleted', 'script'),
(NULL, 1415, 'pjField', 1, 'title', 'Order has been updated', 'script'),
(NULL, 1416, 'pjField', 1, 'title', 'Order has not been updated', 'script'),
(NULL, 1417, 'pjField', 1, 'title', 'Order doesn''t exists', 'script'),
(NULL, 1418, 'pjField', 1, 'title', 'Category has been added', 'script'),
(NULL, 1419, 'pjField', 1, 'title', 'Category has not been added', 'script'),
(NULL, 1422, 'pjField', 1, 'title', 'Category has been updated', 'script'),
(NULL, 1424, 'pjField', 1, 'title', 'Category doesn''t exists', 'script'),
(NULL, 1425, 'pjField', 1, 'title', 'Voucher has been added', 'script'),
(NULL, 1426, 'pjField', 1, 'title', 'Voucher has not been added', 'script'),
(NULL, 1429, 'pjField', 1, 'title', 'Voucher has been updated', 'script'),
(NULL, 1430, 'pjField', 1, 'title', 'Voucher has not been updated', 'script'),
(NULL, 1431, 'pjField', 1, 'title', 'Voucher doesn''t exists', 'script'),
(NULL, 1432, 'pjField', 1, 'title', 'Options has been updated', 'script'),
(NULL, 1433, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 1434, 'pjField', 1, 'title', 'You can create different users and set which calendars each user can manage. If ''Change options'' is checked user will be able to change the options for the calendar and not its availability status. If ''Install code'' is checked user will be able to view installation code for his/her calendar.', 'script'),
(NULL, 1435, 'pjField', 1, 'title', 'Administration login details.', 'script'),
(NULL, 1436, 'pjField', 1, 'title', 'Manage the options for your Parking Booking software.', 'script'),
(NULL, 1437, 'pjField', 1, 'title', 'Copy the HTML code below and put it on your web page where you want the booking engine to appear. Please note that the booking engine can ONLY be placed on a web page from the same domain where the script is installed.', 'script'),
(NULL, 1438, 'pjField', 1, 'title', 'Using the date picker below select a date to view bookings and availability', 'script'),
(NULL, 1439, 'pjField', 1, 'title', 'Add space type name and description. You can set different number of available parking spaces for this type for different periods during the year. For example you can create a space type with 100 spaces for 1st Jan - 31 May, and then during the summer season 1st June - 31th Aug you can set different amount of available spaces for this same type.', 'script'),
(NULL, 1440, 'pjField', 1, 'title', 'For each space type you can set different price for different dates. For example you can add higher rates for the summer season.', 'script'),
(NULL, 1441, 'pjField', 1, 'title', 'First select space type and date period for which price is already set under Prices menu. Then you can set number of days for a booking and a new daily price. For example if you set min days 5 and max days 6, then any booking for 5 or 6 days will be priced based on the new added ''Price per day''. ', 'script'),
(NULL, 1442, 'pjField', 1, 'title', 'Add different extras which people can purchase along with the parking space. For each extra you can add name, description and price. Price can be for the whole booking or per day. Each extra also has type - Limited and Unlimited. If extra is limited then there is a fixed number of items that can be booked. Under Count textbox you can set the number of available items. ''Is single'' option is used to specify if users should select number of extras that can be purchased.', 'script'),
(NULL, 1443, 'pjField', 1, 'title', 'Lorem ipsum...', 'script'),
(NULL, 1444, 'pjField', 1, 'title', 'Lorem ipsum...', 'script'),
(NULL, 1445, 'pjField', 1, 'title', 'Lorem ipsum...', 'script'),
(NULL, 1446, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 1447, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 1448, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 1449, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 1450, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 1451, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 1452, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 1453, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 1454, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 1455, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 1456, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 1457, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 1458, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 1459, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 1460, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 1461, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 1462, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 1463, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 1464, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 1465, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 1466, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 1467, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 1468, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 1469, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 1470, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 1471, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 1472, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 1473, 'pjField', 1, 'title', 'Date/Time format', 'script'),
(NULL, 1474, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 1475, 'pjField', 1, 'title', 'Payment details', 'script'),
(NULL, 1476, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 1477, 'pjField', 1, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 1478, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 1479, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 1480, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 1481, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 1482, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 1483, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 1484, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 1485, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
(NULL, 1486, 'pjField', 1, 'title', 'Paypal address', 'script'),
(NULL, 1487, 'pjField', 1, 'title', 'Add insurance fee for each order', 'script'),
(NULL, 1490, 'pjField', 1, 'title', 'Check if you want to disable payments and only collect order details', 'script'),
(NULL, 1491, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 1492, 'pjField', 1, 'title', 'Authorize.NET', 'script'),
(NULL, 1493, 'pjField', 1, 'title', 'Credit Card', 'script'),
(NULL, 1494, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 1495, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 1496, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 1497, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 1498, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 1499, 'pjField', 1, 'title', 'CC Number', 'script'),
(NULL, 1500, 'pjField', 1, 'title', 'CC Exp.date', 'script'),
(NULL, 1501, 'pjField', 1, 'title', 'CC Sec.code', 'script'),
(NULL, 1502, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 1503, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 1504, 'pjField', 1, 'title', '-- Choose address --', 'script'),
(NULL, 1505, 'pjField', 1, 'title', '-- Choose country --', 'script'),
(NULL, 1506, 'pjField', 1, 'title', '-- Choose payment --', 'script'),
(NULL, 1507, 'pjField', 1, 'title', 'Cash on delivery', 'script'),
(NULL, 1508, 'pjField', 1, 'title', 'Allow Cash on delivery payment option', 'script'),
(NULL, 1509, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 1510, 'pjField', 1, 'title', 'Checkout Form', 'script'),
(NULL, 1511, 'pjField', 1, 'title', 'Name (Billing details)', 'script'),
(NULL, 1512, 'pjField', 1, 'title', 'City (Billing details)', 'script'),
(NULL, 1513, 'pjField', 1, 'title', 'State (Billing details)', 'script'),
(NULL, 1514, 'pjField', 1, 'title', 'Country (Billing details)', 'script'),
(NULL, 1515, 'pjField', 1, 'title', 'Zip (Billing details)', 'script'),
(NULL, 1517, 'pjField', 1, 'title', 'Address 2 (Billing details)', 'script'),
(NULL, 1518, 'pjField', 1, 'title', 'Address 1 (Billing details)', 'script'),
(NULL, 1519, 'pjField', 1, 'title', 'Address 1 (Shipping details)', 'script'),
(NULL, 1520, 'pjField', 1, 'title', 'Address 2 (Shipping details)', 'script'),
(NULL, 1521, 'pjField', 1, 'title', 'Zip (Shipping details)', 'script'),
(NULL, 1522, 'pjField', 1, 'title', 'Country (Shipping details)', 'script'),
(NULL, 1523, 'pjField', 1, 'title', 'State (Shipping details)', 'script'),
(NULL, 1524, 'pjField', 1, 'title', 'City (Shipping details)', 'script'),
(NULL, 1525, 'pjField', 1, 'title', 'Name (Shipping details)', 'script'),
(NULL, 1526, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 1527, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 1528, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1529, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1530, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 1531, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1532, 'pjField', 1, 'title', 'I Agree with terms and conditions', 'script'),
(NULL, 1534, 'pjField', 1, 'title', 'Other details', 'script'),
(NULL, 1654, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 1655, 'pjField', 1, 'title', 'Insurance', 'script'),
(NULL, 1656, 'pjField', 1, 'title', 'SubTotal', 'script'),
(NULL, 1657, 'pjField', 1, 'title', 'You can now add another category', 'script'),
(NULL, 1658, 'pjField', 1, 'title', 'Category has not been added', 'script'),
(NULL, 1659, 'pjField', 1, 'title', 'Category has been updated', 'script'),
(NULL, 1660, 'pjField', 1, 'title', 'Category doesn''t exists', 'script'),
(NULL, 1808, 'pjField', 1, 'title', 'Shipping & Tax', 'script'),
(NULL, 1809, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 1810, 'pjField', 1, 'title', 'Shipping', 'script'),
(NULL, 1811, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 1812, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 1813, 'pjField', 1, 'title', 'Are you sure you want to delete selected location?', 'script'),
(NULL, 1814, 'pjField', 1, 'title', 'Shipping location', 'script'),
(NULL, 1815, 'pjField', 1, 'title', 'Similar products', 'script'),
(NULL, 1816, 'pjField', 1, 'title', 'Invoice details', 'script'),
(NULL, 1817, 'pjField', 1, 'title', 'Create Invoice', 'script'),
(NULL, 1818, 'pjField', 1, 'title', 'Find Invoices', 'script'),
(NULL, 1819, 'pjField', 1, 'title', 'Step 1 (Required)', 'script'),
(NULL, 1820, 'pjField', 1, 'title', 'Step 2 (Optional) - for SEO purposes and better ranking you need to put next meta tag into the HEAD part of your page', 'script'),
(NULL, 1821, 'pjField', 1, 'title', 'Step 3 (Optional) - for SEO purposes and better ranking you need to create a .htaccess file (or update existinig one) with data below. Put the file in the same folder as your webpage.', 'script'),
(NULL, 1822, 'pjField', 1, 'title', 'Install instructions', 'script'),
(NULL, 1823, 'pjField', 1, 'title', 'Copy the code below and put it on the web page where you want shopping cart to appear. If you have a multi language shopping cart you can select the default language and to hide the language selector.', 'script'),
(NULL, 1824, 'pjField', 1, 'title', 'Language options', 'script'),
(NULL, 1825, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 1826, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 1827, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 1828, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 1829, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 1830, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 1831, 'pjField', 1, 'title', 'Favorites', 'script'),
(NULL, 1832, 'pjField', 1, 'title', 'SEARCH PRODUCTS', 'script'),
(NULL, 1833, 'pjField', 1, 'title', 'My Cart', 'script'),
(NULL, 1834, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 1835, 'pjField', 1, 'title', 'Item', 'script'),
(NULL, 1836, 'pjField', 1, 'title', 'Items', 'script'),
(NULL, 1837, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 1838, 'pjField', 1, 'title', '[Select category]', 'script'),
(NULL, 1839, 'pjField', 1, 'title', 'Shopping Cart', 'script'),
(NULL, 1840, 'pjField', 1, 'title', 'Your shopping cart is empty', 'script'),
(NULL, 1842, 'pjField', 1, 'title', 'Back to Products', 'script'),
(NULL, 1843, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 1844, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 1845, 'pjField', 1, 'title', 'Shipping', 'script'),
(NULL, 1846, 'pjField', 1, 'title', 'Shipping Location', 'script'),
(NULL, 1847, 'pjField', 1, 'title', 'Insurance', 'script'),
(NULL, 1848, 'pjField', 1, 'title', '-- Choose location --', 'script'),
(NULL, 1849, 'pjField', 1, 'title', 'Promo Code', 'script'),
(NULL, 1850, 'pjField', 1, 'title', 'Discount', 'script'),
(NULL, 1851, 'pjField', 1, 'title', 'Apply code', 'script'),
(NULL, 1852, 'pjField', 1, 'title', 'Sub Total', 'script'),
(NULL, 1853, 'pjField', 1, 'title', 'up', 'script'),
(NULL, 1854, 'pjField', 1, 'title', 'down', 'script'),
(NULL, 1855, 'pjField', 1, 'title', 'Quantity', 'script'),
(NULL, 1856, 'pjField', 1, 'title', 'Product', 'script'),
(NULL, 1857, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1858, 'pjField', 1, 'title', 'Product/Price', 'script'),
(NULL, 1859, 'pjField', 1, 'title', 'Quantity/Total', 'script'),
(NULL, 1860, 'pjField', 1, 'title', 'Type your email address', 'script'),
(NULL, 1861, 'pjField', 1, 'title', 'Type your password', 'script'),
(NULL, 1862, 'pjField', 1, 'title', 'Type your name', 'script'),
(NULL, 1863, 'pjField', 1, 'title', 'Type your phone', 'script'),
(NULL, 1864, 'pjField', 1, 'title', 'Type your website', 'script'),
(NULL, 1865, 'pjField', 1, 'title', 'Preview order', 'script'),
(NULL, 1866, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1867, 'pjField', 1, 'title', 'Type your billing name', 'script'),
(NULL, 1868, 'pjField', 1, 'title', 'Type your billing city', 'script'),
(NULL, 1869, 'pjField', 1, 'title', 'Type your billing state', 'script');
INSERT INTO `shopping_cart_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1870, 'pjField', 1, 'title', 'Type your billing zip', 'script'),
(NULL, 1871, 'pjField', 1, 'title', 'Type your billing address 1', 'script'),
(NULL, 1872, 'pjField', 1, 'title', 'Type your billing address 2', 'script'),
(NULL, 1873, 'pjField', 1, 'title', 'Type your shipping name', 'script'),
(NULL, 1874, 'pjField', 1, 'title', 'Type your shipping city', 'script'),
(NULL, 1875, 'pjField', 1, 'title', 'Type your shipping state', 'script'),
(NULL, 1876, 'pjField', 1, 'title', 'Type your shipping zip', 'script'),
(NULL, 1877, 'pjField', 1, 'title', 'Type your shipping address 1', 'script'),
(NULL, 1878, 'pjField', 1, 'title', 'Type your shipping address 2', 'script'),
(NULL, 1879, 'pjField', 1, 'title', 'Type your credit card number', 'script'),
(NULL, 1880, 'pjField', 1, 'title', 'Type your credit card security code', 'script'),
(NULL, 1881, 'pjField', 1, 'title', 'Type any additional notes', 'script'),
(NULL, 1882, 'pjField', 1, 'title', 'My favorites', 'script'),
(NULL, 1883, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 1884, 'pjField', 1, 'title', 'Out of stock', 'script'),
(NULL, 1885, 'pjField', 1, 'title', 'Empty Favorites', 'script'),
(NULL, 1886, 'pjField', 1, 'title', 'Your favorite list is empty', 'script'),
(NULL, 1887, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 1888, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 1889, 'pjField', 1, 'title', 'Morbi dignissim est ut odio aliquam varius. Quisque pellentesque pharetra adipiscing. Mauris tempus, augue vel tristique sollicitudin, neque tellus faucibus nibh, eu scelerisque quam elit non augue. Vestibulum cursus lobortis elementum. Maecenas semper eros molestie euismod sodales.', 'script'),
(NULL, 1890, 'pjField', 1, 'title', 'Sed id urna sed arcu euismod dictum in in lectus. Mauris a felis sit amet nibh ultrices aliquet. Donec imperdiet molestie euismod. Quisque fringilla nunc id justo vehicula, eget accumsan est tincidunt. Aenean tincidunt, purus vitae semper egestas.', 'script'),
(NULL, 1891, 'pjField', 1, 'title', 'Edit order', 'script'),
(NULL, 1892, 'pjField', 1, 'title', 'Confirm & Process order', 'script'),
(NULL, 1893, 'pjField', 1, 'title', '--- Select ---', 'script'),
(NULL, 1894, 'pjField', 1, 'title', 'Add to Favorites', 'script'),
(NULL, 1895, 'pjField', 1, 'title', 'Send to Friend', 'script'),
(NULL, 1896, 'pjField', 1, 'title', 'Your Email address', 'script'),
(NULL, 1897, 'pjField', 1, 'title', 'Your Name', 'script'),
(NULL, 1898, 'pjField', 1, 'title', 'Friend Name', 'script'),
(NULL, 1899, 'pjField', 1, 'title', 'Friend Email address', 'script'),
(NULL, 1900, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1901, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 1902, 'pjField', 1, 'title', 'Similar Products', 'script'),
(NULL, 1903, 'pjField', 1, 'title', 'Product not found', 'script'),
(NULL, 1904, 'pjField', 1, 'title', 'Buy Now', 'script'),
(NULL, 1905, 'pjField', 1, 'title', 'View Details', 'script'),
(NULL, 1906, 'pjField', 1, 'title', 'No products found', 'script'),
(NULL, 1907, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 1908, 'pjField', 1, 'title', 'Next', 'script'),
(NULL, 1909, 'pjField', 1, 'title', 'Mauris sed massa massa. Aenean diam nisl, iaculis quis pulvinar eget, commodo vitae sem. Quisque et ipsum in ipsum hendrerit vestibulum. Nam ullamcorper pharetra nunc ac convallis. Fusce porta vel nisl sit amet congue. Vestibulum at commodo justo. Morbi pharetra vestibulum ultrices.', 'script'),
(NULL, 1910, 'pjField', 1, 'title', 'Save changes', 'script'),
(NULL, 1911, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras imperdiet venenatis dignissim. In tellus orci, condimentum id nulla eget, posuere ornare nisl. Nunc tempor, nibh at euismod tincidunt, arcu odio consectetur magna, at dictum justo libero a arcu. Donec fringilla dui ut enim imperdiet, in euismod neque pulvinar. Aliquam vulputate justo ligula, et euismod massa dictum quis. Proin lacinia urna vitae felis pharetra, id cursus ipsum auctor.', 'script'),
(NULL, 1912, 'pjField', 1, 'title', 'Add to Cart', 'script'),
(NULL, 1913, 'pjField', 1, 'title', 'Missing or empty parameters.', 'script'),
(NULL, 1914, 'pjField', 1, 'title', 'Email has not been sent.', 'script'),
(NULL, 1915, 'pjField', 1, 'title', 'Email has been sent.', 'script'),
(NULL, 1916, 'pjField', 1, 'title', 'You''ve been successfully loged out.', 'script'),
(NULL, 1917, 'pjField', 1, 'title', 'Product has been added to favorites.', 'script'),
(NULL, 1918, 'pjField', 1, 'title', 'Product has been removed from the favorites.', 'script'),
(NULL, 1919, 'pjField', 1, 'title', 'Product has not been removed from the favorites.', 'script'),
(NULL, 1920, 'pjField', 1, 'title', 'Favorite list has been emptied.', 'script'),
(NULL, 1921, 'pjField', 1, 'title', 'Favorite list has not been emptied.', 'script'),
(NULL, 1922, 'pjField', 1, 'title', 'Voucher code couldn''t be empty.', 'script'),
(NULL, 1923, 'pjField', 1, 'title', 'Voucher has been removed.', 'script'),
(NULL, 1924, 'pjField', 1, 'title', 'Product has been added to the cart.', 'script'),
(NULL, 1925, 'pjField', 1, 'title', 'Product has not been added to the cart.', 'script'),
(NULL, 1926, 'pjField', 1, 'title', 'Product has been removed from the cart.', 'script'),
(NULL, 1927, 'pjField', 1, 'title', 'Product has not been removed from the cart.', 'script'),
(NULL, 1928, 'pjField', 1, 'title', 'Shopping cart has been emptied.', 'script'),
(NULL, 1929, 'pjField', 1, 'title', 'Shopping cart has not been emptied.', 'script'),
(NULL, 1930, 'pjField', 1, 'title', 'Shopping cart has not been updated.', 'script'),
(NULL, 1931, 'pjField', 1, 'title', 'Shopping cart has been updated.', 'script'),
(NULL, 1932, 'pjField', 1, 'title', 'Missing parameters.', 'script'),
(NULL, 1933, 'pjField', 1, 'title', 'Missing or wrong captcha.', 'script'),
(NULL, 1934, 'pjField', 1, 'title', 'Customer info contains invalid data.', 'script'),
(NULL, 1936, 'pjField', 1, 'title', 'Email is already taken (password doesn''t match).', 'script'),
(NULL, 1937, 'pjField', 1, 'title', 'Creating client failed.', 'script'),
(NULL, 1938, 'pjField', 1, 'title', 'Order contains invalid data.', 'script'),
(NULL, 1939, 'pjField', 1, 'title', 'Empty cart.', 'script'),
(NULL, 1940, 'pjField', 1, 'title', 'Stocks in cart not found into the database.', 'script'),
(NULL, 1941, 'pjField', 1, 'title', 'Stocks in cart not equal.', 'script'),
(NULL, 1942, 'pjField', 1, 'title', 'Stock qty not enough.', 'script'),
(NULL, 1943, 'pjField', 1, 'title', 'Order has been stored.', 'script'),
(NULL, 1944, 'pjField', 1, 'title', 'Order has not been stored.', 'script'),
(NULL, 1945, 'pjField', 1, 'title', 'Checkout form has been submitted.', 'script'),
(NULL, 1946, 'pjField', 1, 'title', 'Data is not valid.', 'script'),
(NULL, 1947, 'pjField', 1, 'title', 'Account not found.', 'script'),
(NULL, 1948, 'pjField', 1, 'title', 'Password doesn''t match.', 'script'),
(NULL, 1949, 'pjField', 1, 'title', 'You''ve been successfully loged in.', 'script'),
(NULL, 1950, 'pjField', 1, 'title', 'Data is not valid.', 'script'),
(NULL, 1952, 'pjField', 1, 'title', 'Account not found.', 'script'),
(NULL, 1953, 'pjField', 1, 'title', 'Password has not been sent successful.', 'script'),
(NULL, 1954, 'pjField', 1, 'title', 'Password has been sent successful.', 'script'),
(NULL, 1955, 'pjField', 1, 'title', 'Data is not valid.', 'script'),
(NULL, 1956, 'pjField', 1, 'title', 'Email is already taken.', 'script'),
(NULL, 1957, 'pjField', 1, 'title', 'Profile has been updated.', 'script'),
(NULL, 1958, 'pjField', 1, 'title', 'Captcha is not set or doesn''t match.', 'script'),
(NULL, 1959, 'pjField', 1, 'title', 'Data is not valid.', 'script'),
(NULL, 1960, 'pjField', 1, 'title', 'Email is already taken.', 'script'),
(NULL, 1961, 'pjField', 1, 'title', 'Registration has not been successful.', 'script'),
(NULL, 1962, 'pjField', 1, 'title', 'You''ve been registered, but confirmation email has not been sent for some reason.', 'script'),
(NULL, 1963, 'pjField', 1, 'title', 'You''ve been registered.', 'script'),
(NULL, 1964, 'pjField', 1, 'title', 'Countries', 'script'),
(NULL, 1965, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1966, 'pjField', 1, 'title', 'Are you sure you want to delete selected records?', 'script'),
(NULL, 1967, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 1968, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 1969, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 1970, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 1971, 'pjField', 1, 'title', 'Below you can edit the email message which will be sent out.', 'script'),
(NULL, 1972, 'pjField', 1, 'title', 'New order received', 'script'),
(NULL, 1974, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 1975, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 1976, 'pjField', 1, 'title', 'Body\r\n<br />\r\n<br />Available tokens:\r\n<br />{Name}\r\n<br />{Password}', 'script'),
(NULL, 1978, 'pjField', 1, 'title', 'Different SMS notifications will be sent when various events happen. You can edit each of the Users and set which SMS messages to receive. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
(NULL, 1979, 'pjField', 1, 'title', 'Sms notifications', 'script'),
(NULL, 1980, 'pjField', 1, 'title', 'Add attribute group', 'script'),
(NULL, 1981, 'pjField', 1, 'title', 'Update attribute group', 'script'),
(NULL, 1982, 'pjField', 1, 'title', 'Update attribute', 'script'),
(NULL, 1983, 'pjField', 1, 'title', 'Add attribute value', 'script'),
(NULL, 1984, 'pjField', 1, 'title', 'Attributes set name', 'script'),
(NULL, 1985, 'pjField', 1, 'title', 'Attribute value', 'script'),
(NULL, 1986, 'pjField', 1, 'title', 'Delete attribute group', 'script'),
(NULL, 1987, 'pjField', 1, 'title', 'Are you sure you want to delete selected attribute group?', 'script'),
(NULL, 1988, 'pjField', 1, 'title', 'Are you sure you want to delete selected attribute?', 'script'),
(NULL, 1989, 'pjField', 1, 'title', 'Delete attribute', 'script'),
(NULL, 1990, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 1991, 'pjField', 1, 'title', 'New registration', 'script'),
(NULL, 1992, 'pjField', 1, 'title', 'Body\r\n<br />\r\n<br />Available tokens:\r\n<br />{Name}\r\n<br />{Password}\r\n<br />{Email}\r\n<br />{URL}\r\n<br />{Phone}', 'script'),
(NULL, 1993, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 1994, 'pjField', 1, 'title', 'Enter product details below. You can assign a product to one or more categories (change categories under Options page, Categories tab) and to make it featured.', 'script'),
(NULL, 1995, 'pjField', 1, 'title', 'Digital product', 'script'),
(NULL, 1996, 'pjField', 1, 'title', 'If you sell digital content (videos, mp3, images, files, etc..) you can use this page to upload the file and set various options for it. If file is too large you can upload it via FTP and under "File path" set full server path to it. Once an order for that file is made a confirmation email is sent to the customer. You can set when this link to expire so file cannot be downloaded any more.', 'script'),
(NULL, 1997, 'pjField', 1, 'title', 'Attributes', 'script'),
(NULL, 1998, 'pjField', 1, 'title', 'Using "Attributes" you can set different options for your products. For example, you may sell a t-shirt in 2 different sizes (XXL, M) and 3 colors (red, green, blue). So you need to create attribute set for size and then add the 2 different sizes as different attributes from that set. You can do that for color too. Then under the "In stock" tab you can set default image, Quantity and Price for each combination - Green XXL t-shirt, Green M t-shirt, Blue XXL t-shirt, Blue M t-shirt,... and so on.', 'script'),
(NULL, 1999, 'pjField', 1, 'title', 'In Stock', 'script'),
(NULL, 2000, 'pjField', 1, 'title', 'Here you can set default image, available quantity and price for each combination of attributes that your product comes with. Click on the "Choose image" button to select one of the uploaded images, select the corresponding attributes and add quantity and price. You can add as many combinations as you need. Following the example from "Attributes" tab you need to do that for all possible size and color combination.', 'script'),
(NULL, 2001, 'pjField', 1, 'title', 'Photos', 'script'),
(NULL, 2002, 'pjField', 1, 'title', 'Upload as many images as you want for this product. You can resize, crop, rotate, watermark and compress the uploaded images. Drag & drop to change their order.', 'script'),
(NULL, 2003, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 2004, 'pjField', 1, 'title', 'You can add additional extras which can be purchased with this product. For example if you sell a mobile phone you can offer a case or a charger for it. You can create single extras (can be bought using a checkbox) or multiple extras (where you select the extra from a drop down).', 'script'),
(NULL, 2005, 'pjField', 1, 'title', 'Similar products', 'script'),
(NULL, 2006, 'pjField', 1, 'title', 'Select similar products which will be offered to shoppers on the current product details page. Just start typing a product name and after the 3rd character available products will be shown. Select a product and it will appear on the products details page.', 'script'),
(NULL, 2007, 'pjField', 1, 'title', 'Stock History', 'script'),
(NULL, 2008, 'pjField', 1, 'title', 'Below you can see a history log for every change made to quantity or price under the "In stock" tab.', 'script'),
(NULL, 2009, 'pjField', 1, 'title', 'Products', 'script'),
(NULL, 2010, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 2011, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 2012, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 2013, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 2014, 'pjField', 1, 'title', 'Shipping & Billing', 'script'),
(NULL, 2015, 'pjField', 1, 'title', 'Stock', 'script'),
(NULL, 2016, 'pjField', 1, 'title', 'Shipping location is not set', 'script'),
(NULL, 2017, 'pjField', 1, 'title', 'Checkout form not submitted', 'script'),
(NULL, 2211, 'pjField', 1, 'title', 'Address book', 'script'),
(NULL, 2212, 'pjField', 1, 'title', 'Strore and organize your client''s addresses.', 'script'),
(NULL, 2213, 'pjField', 1, 'title', 'Sorry but the client you''ve been looking for doesn''t exists.', 'script'),
(NULL, 2214, 'pjField', 1, 'title', 'Sorry but the email address is already in use.', 'script'),
(NULL, 2215, 'pjField', 1, 'title', 'Client has not been updated', 'script'),
(NULL, 2216, 'pjField', 1, 'title', 'Client has been updated', 'script'),
(NULL, 2217, 'pjField', 1, 'title', 'Client has not been added', 'script'),
(NULL, 2218, 'pjField', 1, 'title', 'Client has been added', 'script'),
(NULL, 2219, 'pjField', 1, 'title', 'Enter product details below. You can assign a product to one or more categories (change categories under Options page, Categories tab) and to make it featured.', 'script'),
(NULL, 2220, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 2221, 'pjField', 1, 'title', 'Order details', 'script'),
(NULL, 2222, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 2223, 'pjField', 1, 'title', 'Shipping and billing details', 'script'),
(NULL, 2224, 'pjField', 1, 'title', 'You can change order details using the form below. If you add or remove a product click on the "Recalculate the price" button to calculate new price based on the new selection. At the bottom of the page you can view the invoice for the order and create new one if needed.', 'script'),
(NULL, 2225, 'pjField', 1, 'title', 'Find information about your client and their previous purchases.', 'script'),
(NULL, 2226, 'pjField', 1, 'title', 'Below you can see shipping and billing details for the order. Using your client''s address book you can easily change these details.', 'script'),
(NULL, 2229, 'pjField', 1, 'title', 'Shipping & Tax fee', 'script'),
(NULL, 2230, 'pjField', 1, 'title', 'You can add unlimited amount of locations. For each location you can enter shipping and tax fees. When clients purchase something they will select their location and the shipping and tax fees will be added to the order total amount.', 'script'),
(NULL, 2231, 'pjField', 1, 'title', 'Your request has been sent successfully. Thank you.', 'script'),
(NULL, 2232, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 2233, 'pjField', 1, 'title', 'Vouchers', 'script'),
(NULL, 2234, 'pjField', 1, 'title', 'Create vouchers and give discounts to your clients. You can create percent or fixed amount voucher codes. You can set period for each promo offer that you create. If you want to offer a voucher for specific products only, in the Products text box, just start typing a product name and after the 3rd character products will be shown.', 'script'),
(NULL, 2235, 'pjField', 1, 'title', 'All the changes made to this voucher have been saved.', 'script'),
(NULL, 2236, 'pjField', 1, 'title', 'Sorry but the voucher you''ve been looking for was not found.', 'script'),
(NULL, 2237, 'pjField', 1, 'title', 'Sorry but the voucher has not been updated.', 'script'),
(NULL, 2238, 'pjField', 1, 'title', 'All the changes made to this voucher has been saved.', 'script'),
(NULL, 2239, 'pjField', 1, 'title', 'Sorry, but the voucher has not been added.', 'script'),
(NULL, 2240, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 2241, 'pjField', 1, 'title', 'Latest orders', 'script'),
(NULL, 2242, 'pjField', 1, 'title', 'Latest clients', 'script'),
(NULL, 2243, 'pjField', 1, 'title', 'Stock', 'script'),
(NULL, 2244, 'pjField', 1, 'title', 'orders today', 'script'),
(NULL, 2245, 'pjField', 1, 'title', 'order today', 'script'),
(NULL, 2246, 'pjField', 1, 'title', 'clients today', 'script'),
(NULL, 2247, 'pjField', 1, 'title', 'client today', 'script'),
(NULL, 2248, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 2249, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 2250, 'pjField', 1, 'title', 'Use form below to manage the general options.', 'script'),
(NULL, 2251, 'pjField', 1, 'title', 'Payment options', 'script'),
(NULL, 2252, 'pjField', 1, 'title', 'Use form below to manage the payment options.', 'script'),
(NULL, 2253, 'pjField', 1, 'title', 'Checkout form options', 'script'),
(NULL, 2254, 'pjField', 1, 'title', 'Use form below to manage the checkout form options.', 'script'),
(NULL, 2255, 'pjField', 1, 'title', 'Category list', 'script'),
(NULL, 2256, 'pjField', 1, 'title', 'Use arrows below to re-order your categories.', 'script'),
(NULL, 2257, 'pjField', 1, 'title', 'Add category', 'script'),
(NULL, 2258, 'pjField', 1, 'title', 'Use form below to add your custom category.', 'script'),
(NULL, 2259, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 2260, 'pjField', 1, 'title', 'Use form below to update your custom category.', 'script'),
(NULL, 2261, 'pjField', 1, 'title', 'Stock list', 'script'),
(NULL, 2262, 'pjField', 1, 'title', 'Use search field below to filter the stock you''re looking for. Price and quantity could be changed by clicked on them.', 'script'),
(NULL, 2263, 'pjField', 1, 'title', 'Select a product', 'script'),
(NULL, 2264, 'pjField', 1, 'title', 'Order updated', 'script'),
(NULL, 2265, 'pjField', 1, 'title', 'Order has been updated', 'script'),
(NULL, 2266, 'pjField', 1, 'title', 'Order not found.', 'script'),
(NULL, 2267, 'pjField', 1, 'title', 'Order your''re looking for is missing.', 'script'),
(NULL, 2268, 'pjField', 1, 'title', 'Add a Stock', 'script'),
(NULL, 2269, 'pjField', 1, 'title', 'In the below table are listed all current stocks for selected product. After chosing desired stock(s) click on Add button.', 'script'),
(NULL, 2270, 'pjField', 1, 'title', 'All orders', 'script'),
(NULL, 2271, 'pjField', 1, 'title', '(empty date)', 'script'),
(NULL, 2272, 'pjField', 1, 'title', '(invalid date)', 'script'),
(NULL, 2273, 'pjField', 1, 'title', '(invalid date/time)', 'script'),
(NULL, 2274, 'pjField', 1, 'title', '(empty date/time)', 'script'),
(NULL, 2275, 'pjField', 1, 'title', 'products', 'script'),
(NULL, 2276, 'pjField', 1, 'title', 'product', 'script'),
(NULL, 2279, 'pjField', 1, 'title', 'Save to address book', 'script'),
(NULL, 2280, 'pjField', 1, 'title', 'from', 'script'),
(NULL, 2281, 'pjField', 1, 'title', 'Use Seo-friendly URLs', 'script'),
(NULL, 2282, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 2283, 'pjField', 1, 'title', 'Free shipping', 'script'),
(NULL, 2284, 'pjField', 1, 'title', 'Check if you want to disable placing orders and use the cart in catalogue mode', 'script'),
(NULL, 2495, 'pjField', 1, 'title', 'Captcha is required', 'script'),
(NULL, 2496, 'pjField', 1, 'title', 'Password is required', 'script'),
(NULL, 2497, 'pjField', 1, 'title', 'Name is required', 'script'),
(NULL, 2498, 'pjField', 1, 'title', 'Email is required', 'script'),
(NULL, 2499, 'pjField', 1, 'title', 'Email is invalid', 'script'),
(NULL, 2500, 'pjField', 1, 'title', 'Captcha is wrong', 'script'),
(NULL, 2501, 'pjField', 1, 'title', 'Promo code is required', 'script'),
(NULL, 2502, 'pjField', 1, 'title', 'Shipping location is required', 'script'),
(NULL, 2503, 'pjField', 1, 'title', 'Country is required', 'script'),
(NULL, 2504, 'pjField', 1, 'title', 'City is required', 'script'),
(NULL, 2505, 'pjField', 1, 'title', 'State is required', 'script'),
(NULL, 2506, 'pjField', 1, 'title', 'Zip is required', 'script'),
(NULL, 2507, 'pjField', 1, 'title', 'Address 1 is required', 'script'),
(NULL, 2508, 'pjField', 1, 'title', 'Address 2 is required', 'script'),
(NULL, 2509, 'pjField', 1, 'title', 'Notes is required', 'script'),
(NULL, 2510, 'pjField', 1, 'title', 'Payment method is required', 'script'),
(NULL, 2511, 'pjField', 1, 'title', 'You have to agree with terms', 'script'),
(NULL, 2512, 'pjField', 1, 'title', 'Authorize.net MD5 hash value', 'script'),
(NULL, 2513, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 2514, 'pjField', 1, 'title', '<p>Email notifications will be sent to people who make an order after checkout form is completed or/and payment is made. Different messages are sent to the administrator. Using tokens you can customize all the messages.</p><br />\r\n<table width="100%" border="0" cellspacing="0" cellpadding="0">\r\n  <tr>\r\n    <td width="50%" valign="top"><p>{ClientName} - customer''s name<br />\r\n      {ClientEmail} - customer''s e-mail<br />\r\n      {ClientPassword} - customer''s password<br />\r\n      {ClientPhone} -  customer''s phone number<br />\r\n      {ClientURL} - customer''s website<br />\r\n      {BillingName} - customer''s billing name<br />\r\n      {BillingAddress1} - billing address 1<br />\r\n      {BillingAddress2} - billing address 2<br />\r\n      {BillingCity} - billing city<br />\r\n      {BillingState} - billing state<br />\r\n      {BillingZip} - billing zip code<br />\r\n      {BillingCountry} - billing country<br />\r\n      {ShippingName} - customer''s shipping name<br />\r\n      {ShippingAddress1} - shipping address 1<br />\r\n      {ShippingAddress2} - shipping address 2<br />\r\n      {ShippingCity} - shipping city<br />\r\n      {ShippingState} - shipping state<br />\r\n      {ShippingZip} - shipping zip code; <br />\r\n    {ShippingCountry} - shipping country</p></td>\r\n    <td width="50%" valign="top"> {Notes} - additional notes<br />\r\n{CCType} - CC type<br />\r\n{CCNum} - CC number<br />\r\n{CCExpMonth} - CC exp.month<br />\r\n{CCExpYear} - CC exp.year<br />\r\n{CCSec} - CC sec. code<br />\r\n{PaymentMethod} - selected payment method<br />\r\n{Insurance} -  insurance fee<br />\r\n{Shipping} - shipping fee<br />\r\n{Tax} - tax fee<br />\r\n{Price} - price<br />\r\n{Total} - total amount<br />\r\n{Discount} - discount<br />\r\n{Voucher} - promo code<br />\r\n{Products} - list with purchased products<br />\r\n{OrderUUID} - Order number<br />\r\n{DigitalDownload} - Digital products download link</td>\r\n  </tr>\r\n</table>\r\n<p>&nbsp;</p>', 'script'),
(NULL, 2515, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 2516, 'pjField', 1, 'title', 'Email body', 'script'),
(NULL, 2517, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 2518, 'pjField', 1, 'title', 'Admin - payment confirmation email', 'script'),
(NULL, 2519, 'pjField', 1, 'title', 'Admin - order confirmation email', 'script'),
(NULL, 2520, 'pjField', 1, 'title', 'Client - payment confirmation email', 'script'),
(NULL, 2521, 'pjField', 1, 'title', 'Client - order confirmation email', 'script'),
(NULL, 2522, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 2523, 'pjField', 1, 'title', 'Enter order terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
(NULL, 2524, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 2525, 'pjField', 1, 'title', 'Order terms content', 'script'),
(NULL, 2526, 'pjField', 1, 'title', 'Order terms URL', 'script'),
(NULL, 2737, 'pjField', 1, 'title', 'Missing or invalid parameters', 'script'),
(NULL, 2738, 'pjField', 1, 'title', 'Order not found', 'script'),
(NULL, 2739, 'pjField', 1, 'title', 'Order not paid', 'script'),
(NULL, 2740, 'pjField', 1, 'title', 'Order doesn''t contain any digital product', 'script'),
(NULL, 2741, 'pjField', 1, 'title', 'All digital products are expired', 'script'),
(NULL, 2952, 'pjField', 1, 'title', 'SEO', 'script'),
(NULL, 2953, 'pjField', 1, 'title', 'SEO Optimization', 'script'),
(NULL, 2954, 'pjField', 1, 'title', 'To better optimize your shopping cart please follow the steps below', 'script'),
(NULL, 2955, 'pjField', 1, 'title', 'Step 1. Webpage where your front end shopping cart is', 'script'),
(NULL, 2956, 'pjField', 1, 'title', 'Step 2. Put the meta tag below between &lt;head&gt; and &lt;/head&gt;tags on your web page', 'script'),
(NULL, 2957, 'pjField', 1, 'title', 'Step 3. Create .htaccess file (or update existing one) in the folder where your web page is and put the data below in it', 'script'),
(NULL, 2958, 'pjField', 1, 'title', 'Hide language selector', 'script'),
(NULL, 2959, 'pjField', 1, 'title', 'Send order confirmation', 'script'),
(NULL, 2960, 'pjField', 1, 'title', 'Send payment confirmation', 'script'),
(NULL, 2961, 'pjField', 1, 'title', 'Payment confirmation', 'script'),
(NULL, 2962, 'pjField', 1, 'title', 'Order confirmation', 'script'),
(NULL, 2963, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 2964, 'pjField', 1, 'title', 'Body', 'script'),
(NULL, 2965, 'pjField', 1, 'title', 'Unit price', 'script'),
(NULL, 2966, 'pjField', 1, 'title', 'Current stock', 'script'),
(NULL, 3177, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 3178, 'pjField', 1, 'title', 'Admin - order confirmation sms', 'script'),
(NULL, 3179, 'pjField', 1, 'title', 'Admin - payment confirmation sms', 'script'),
(NULL, 3180, 'pjField', 1, 'title', 'SMS content', 'script'),
(NULL, 3181, 'pjField', 1, 'title', 'Copy extras from another product', 'script'),
(NULL, 3182, 'pjField', 1, 'title', 'Copy extras from another product', 'script'),
(NULL, 3183, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 3184, 'pjField', 1, 'title', 'There is another product with such ID.', 'script'),
(NULL, 3185, 'pjField', 1, 'title', 'Products per page', 'script'),
(NULL, 3186, 'pjField', 1, 'title', 'Print all', 'script'),
(NULL, 3187, 'pjField', 1, 'title', 'Print selected', 'script'),
(NULL, 3188, 'pjField', 1, 'title', 'Name (Client)', 'script'),
(NULL, 3189, 'pjField', 1, 'title', 'Phone (Client)', 'script'),
(NULL, 3190, 'pjField', 1, 'title', 'Website (Client)', 'script'),
(NULL, 3191, 'pjField', 1, 'title', 'Phone is required', 'script'),
(NULL, 3192, 'pjField', 1, 'title', 'Website is required', 'script');

--
-- Do not remove below
--
INSERT INTO `shopping_cart_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjOption', 1, 'confirm_subject_client', 'Order confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'confirm_tokens_client', 'Dear {ClientName},\r\n\r\nthank you for your order. Your order number is: {OrderUUID}\r\n\r\nPurchased products:\r\n{Products}\r\n\r\nPlease, complete your payment and another confirmation email will be sent.\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 1, 'payment_subject_client', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'payment_tokens_client', 'Dear {ClientName},\r\n\r\nthank you for your payment. \r\n\r\nAmount: {Price}\r\n\r\nWe will ship the products to you in next 24 - 48 hours.\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 1, 'confirm_subject_admin', 'New order received', 'data'),
(NULL, 1, 'pjOption', 1, 'confirm_tokens_admin', 'New order has been made. \r\n\r\nOrder number: {OrderUUID}\r\n\r\nPurchased products:\r\n{Products}\r\n\r\nOrder details\r\n\r\n{ClientName} - customer''s name\r\n{ClientEmail} - customer''s e-mail\r\n{ClientPassword} - customer''s password\r\n{ClientPhone} - customer''s phone number\r\n{ClientURL} - customer''s website\r\n{BillingName} - customer''s billing name\r\n{BillingAddress1} - billing address 1\r\n{BillingAddress2} - billing address 2\r\n{BillingCity} - billing city\r\n{BillingState} - billing state\r\n{BillingZip} - billing zip code\r\n{BillingCountry} - billing country\r\n{ShippingName} - customer''s shipping name\r\n{ShippingAddress1} - shipping address 1\r\n{ShippingAddress2} - shipping address 2\r\n{ShippingCity} - shipping city\r\n{ShippingState} - shipping state\r\n{ShippingZip} - shipping zip code; \r\n{ShippingCountry} - shipping country\r\n{Notes} - additional notes\r\n{CCType} - CC type\r\n{CCNum} - CC number\r\n{CCExpMonth} - CC exp.month\r\n{CCExpYear} - CC exp.year\r\n{CCSec} - CC sec. code\r\n{PaymentMethod} - selected payment method\r\n{Insurance} - insurance fee\r\n{Shipping} - shipping fee\r\n{Tax} - tax fee\r\n{Total} - total amount\r\n{Price} - price\r\n{Discount} - discount\r\n{Voucher} - promo code', 'data'),
(NULL, 1, 'pjOption', 1, 'payment_subject_admin', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 1, 'payment_tokens_admin', 'Payment for Order {OrderUUID} has been made.\r\n\r\nYou can ship the products.\r\n\r\n{Products}', 'data'),
(NULL, 1, 'pjOption', 3, 'confirm_subject_client', 'Order confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'confirm_tokens_client', 'Dear {ClientName},\r\n\r\nthank you for your order. Your order number is: {OrderUUID}\r\n\r\nPurchased products:\r\n{Products}\r\n\r\nPlease, complete your payment and another confirmation email will be sent.\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 3, 'payment_subject_client', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'payment_tokens_client', 'Dear {ClientName},\r\n\r\nthank you for your payment. \r\n\r\nAmount: {Price}\r\n\r\nWe will ship the products to you in next 24 - 48 hours.\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 3, 'confirm_subject_admin', 'New order received', 'data'),
(NULL, 1, 'pjOption', 3, 'confirm_tokens_admin', 'New order has been made. \r\n\r\nOrder number: {OrderUUID}\r\n\r\nPurchased products:\r\n{Products}\r\n\r\nOrder details\r\n\r\n{ClientName} - customer''s name\r\n{ClientEmail} - customer''s e-mail\r\n{ClientPassword} - customer''s password\r\n{ClientPhone} - customer''s phone number\r\n{ClientURL} - customer''s website\r\n{BillingName} - customer''s billing name\r\n{BillingAddress1} - billing address 1\r\n{BillingAddress2} - billing address 2\r\n{BillingCity} - billing city\r\n{BillingState} - billing state\r\n{BillingZip} - billing zip code\r\n{BillingCountry} - billing country\r\n{ShippingName} - customer''s shipping name\r\n{ShippingAddress1} - shipping address 1\r\n{ShippingAddress2} - shipping address 2\r\n{ShippingCity} - shipping city\r\n{ShippingState} - shipping state\r\n{ShippingZip} - shipping zip code; \r\n{ShippingCountry} - shipping country\r\n{Notes} - additional notes\r\n{CCType} - CC type\r\n{CCNum} - CC number\r\n{CCExpMonth} - CC exp.month\r\n{CCExpYear} - CC exp.year\r\n{CCSec} - CC sec. code\r\n{PaymentMethod} - selected payment method\r\n{Insurance} - insurance fee\r\n{Shipping} - shipping fee\r\n{Tax} - tax fee\r\n{Total} - total amount\r\n{Price} - price\r\n{Discount} - discount\r\n{Voucher} - promo code', 'data'),
(NULL, 1, 'pjOption', 3, 'payment_subject_admin', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 3, 'payment_tokens_admin', 'Payment for Order {OrderUUID} has been made.\r\n\r\nYou can ship the products.\r\n\r\n{Products}', 'data'),
(NULL, 1, 'pjOption', 2, 'confirm_subject_client', 'Order confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'confirm_tokens_client', 'Dear {ClientName},\r\n\r\nthank you for your order. Your order number is: {OrderUUID}\r\n\r\nPurchased products:\r\n{Products}\r\n\r\nPlease, complete your payment and another confirmation email will be sent.\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 2, 'payment_subject_client', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'payment_tokens_client', 'Dear {ClientName},\r\n\r\nthank you for your payment. \r\n\r\nAmount: {Price}\r\n\r\nWe will ship the products to you in next 24 - 48 hours.\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 2, 'confirm_subject_admin', 'New order received', 'data'),
(NULL, 1, 'pjOption', 2, 'confirm_tokens_admin', 'New order has been made. \r\n\r\nOrder number: {OrderUUID}\r\n\r\nPurchased products:\r\n{Products}\r\n\r\nOrder details\r\n\r\n{ClientName} - customer''s name\r\n{ClientEmail} - customer''s e-mail\r\n{ClientPassword} - customer''s password\r\n{ClientPhone} - customer''s phone number\r\n{ClientURL} - customer''s website\r\n{BillingName} - customer''s billing name\r\n{BillingAddress1} - billing address 1\r\n{BillingAddress2} - billing address 2\r\n{BillingCity} - billing city\r\n{BillingState} - billing state\r\n{BillingZip} - billing zip code\r\n{BillingCountry} - billing country\r\n{ShippingName} - customer''s shipping name\r\n{ShippingAddress1} - shipping address 1\r\n{ShippingAddress2} - shipping address 2\r\n{ShippingCity} - shipping city\r\n{ShippingState} - shipping state\r\n{ShippingZip} - shipping zip code; \r\n{ShippingCountry} - shipping country\r\n{Notes} - additional notes\r\n{CCType} - CC type\r\n{CCNum} - CC number\r\n{CCExpMonth} - CC exp.month\r\n{CCExpYear} - CC exp.year\r\n{CCSec} - CC sec. code\r\n{PaymentMethod} - selected payment method\r\n{Insurance} - insurance fee\r\n{Shipping} - shipping fee\r\n{Tax} - tax fee\r\n{Total} - total amount\r\n{Price} - price\r\n{Discount} - discount\r\n{Voucher} - promo code', 'data'),
(NULL, 1, 'pjOption', 2, 'payment_subject_admin', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 2, 'payment_tokens_admin', 'Payment for Order {OrderUUID} has been made.\r\n\r\nYou can ship the products.\r\n\r\n{Products}', 'data'),
(NULL, 1, 'pjOption', 1, 'register_subject', 'Registration completed', 'data'),
(NULL, 1, 'pjOption', 1, 'register_tokens', 'Dear {Name},\r\n\r\nThank you for registering with us!\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 1, 'forgot_subject', 'Password reminder', 'data'),
(NULL, 1, 'pjOption', 1, 'forgot_tokens', 'Dear {Name},\r\n\r\nYour password is: {Password}\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 3, 'register_subject', 'Registration completed', 'data'),
(NULL, 1, 'pjOption', 3, 'register_tokens', 'Dear {Name},\r\n\r\nThank you for registering with us!\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 3, 'forgot_subject', 'Password reminder', 'data'),
(NULL, 1, 'pjOption', 3, 'forgot_tokens', 'Dear {Name},\r\n\r\nYour password is: {Password}\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 2, 'register_subject', 'Registration completed', 'data'),
(NULL, 1, 'pjOption', 2, 'register_tokens', 'Dear {Name},\r\n\r\nThank you for registering with us!\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 2, 'forgot_subject', 'Password reminder', 'data'),
(NULL, 1, 'pjOption', 2, 'forgot_tokens', 'Dear {Name},\r\n\r\nYour password is: {Password}\r\n\r\nRegards,\r\nShop Name', 'data'),
(NULL, 1, 'pjOption', 1, 'confirm_sms_admin', 'New order received {OrderUUID}', 'data'),
(NULL, 1, 'pjOption', 1, 'payment_sms_admin', 'New payment received {OrderUUID}', 'data'),
(NULL, 1, 'pjOption', 3, 'confirm_sms_admin', 'New order received {OrderUUID}', 'data'),
(NULL, 1, 'pjOption', 3, 'payment_sms_admin', 'New payment received {OrderUUID}', 'data'),
(NULL, 1, 'pjOption', 2, 'confirm_sms_admin', 'New order received {OrderUUID}', 'data'),
(NULL, 1, 'pjOption', 2, 'payment_sms_admin', 'New payment received {OrderUUID}', 'data');