<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/requestmenu.php';
	
	pjUtil::printNotice(__('infoExportFeedTitle', true), __('infoExportFeedDesc', true));
	
	$export_formats = __('export_formats', true, false);
	$export_periods = __('export_periods', true, false);
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminRequests&amp;action=pjActionFeed" method="post" id="frmXMLFeed" class="form pj-form">
		<input type="hidden" name="request_feed" value="1" />
		<p>
			<label class="title"><?php __('lblReasonToCall'); ?></label>
			<span class="inline_block">
				<select name="reason_id" id="reason_id" class="pj-form-field w150">
					<option value="">-- <?php __('lblAllReasons');?> --</option>
					<?php
					foreach($tpl['reason_arr'] as $v)
					{
						?><option value="<?php echo $v['id']?>"<?php echo (isset($_POST['reason_id']) && $_POST['reason_id'] == $v['id']) || (isset($_GET['reason_id']) && $_GET['reason_id'] == $v['id']) ? ' selected="selected"' : null; ?>><?php echo pjSanitize::html($v['reason']);?></option><?php
					} 
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblFormat'); ?></label>
			<span class="inline_block">
				<select name="format" id="format" class="pj-form-field w100">
					<?php
					foreach ($export_formats as $k => $v)
					{
						?><option value="<?php echo $k; ?>"<?php echo isset($_POST['format']) && $_POST['format'] == $k ? ' selected="selected"' : null; ?>><?php echo pjSanitize::html($v); ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblEnterPassword');?></label>
			<span class="pj-form-field-custom pj-form-field-custom-before">
				<span class="pj-form-field-before"><abbr class="pj-form-field-icon-password"></abbr></span>
				<input type="text" id="feed_password" name="password" class="pj-form-field w200 required" value="<?php echo isset($_POST['password']) ? $_POST['password'] : null; ?>"/>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblPeriod'); ?></label>
			<span class="inline_block">
				<span class="block float_left overflow r20">
					<select name="period" id="export_period" class="pj-form-field w200 r20 float_left">
						<option value="next"<?php echo isset($_POST['period']) ? ($_POST['period'] == 'next' ? ' selected="selected"' : null) : ' selected="selected"'; ?>><?php echo pjSanitize::html($export_periods['next']); ?></option>
						<option value="last"<?php echo isset($_POST['period']) ? ($_POST['period'] == 'last' ? ' selected="selected"' : null) : null; ?>><?php echo pjSanitize::html($export_periods['last']); ?></option>
					</select>
				</span>
				<span id="next_label" class="block float_left overflow r20" style="display:<?php echo isset($_POST['period']) ? ($_POST['period'] == 'next' ? ' block' : ' none') : ' block'; ?>;">
					<select name="coming_period" id="coming_period" class="pj-form-field w150">
						<?php
						foreach(__('coming_arr', true) as $k => $v)
						{
							?><option value="<?php echo $k;?>"<?php echo isset($_POST['coming_period']) ? ($_POST['coming_period'] == $k ? ' selected="selected"' : null) : null; ?>><?php echo $v;?></option><?php 
						} 
						?>
					</select>
				</span>
				<span id="last_label" class="block float_left overflow r20" style="display:<?php echo isset($_POST['period']) ? ($_POST['period'] == 'last' ? ' block' : ' none') : ' none'; ?>;">
					<select name="made_period" id="made_period" class="pj-form-field w150">
						<?php
						foreach(__('made_arr', true) as $k => $v)
						{
							?><option value="<?php echo $k;?>"<?php echo isset($_POST['made_period']) ? ($_POST['made_period'] == $k ? ' selected="selected"' : null) : null; ?>><?php echo $v;?></option><?php 
						} 
						?>
					</select>
				</span>
			</span>
		</p>
		
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" id="tsSubmitButton" value="<?php __('btnGetFeedURL'); ?>" class="pj-button" />
		</p>
		<?php
		if(isset($_POST['request_feed'])) 
		{
			?>
			<div class="tsFeedContainer">
				<br/>
				<?php pjUtil::printNotice(__('infoRequestsFeedTitle', true), __('infoRequestsFeedDesc', true)); ?>
				<span class="inline_block">
					<textarea name="requests_feed" class="pj-form-field h80" style="width: 726px;"><?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminRequests&amp;action=pjActionExportFeed<?php echo !empty($_POST['reason_id']) ? '&reason_id=' . $_POST['reason_id'] : null;?>&amp;format=<?php echo$_POST['format']; ?>&amp;type=<?php echo $_POST['period'] == 'next' ? '1' : '2'; ?>&amp;period=<?php echo $_POST['period'] == 'next' ? $_POST['coming_period'] : $_POST['made_period']; ?>&amp;p=<?php echo isset($tpl['password']) ? $tpl['password'] : null;?></textarea>
				</span>
			</div>
			<?php
		} 
		?>
	</form>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.btn_export = "<?php __('btnExport'); ?>";
	myLabel.btn_get_url = "<?php __('btnGetFeedURL'); ?>";
	</script>
	<?php
}
?>