<?php
$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);

$months = __('months', true);
$short_months = __('short_months', true);
ksort($months);
ksort($short_months);
$days = __('days', true);
$short_days = __('short_days', true); 
$validate = str_replace(array('"', "'"), array('\"', "\'"), __('front_validation', true, true));
?>
<section class="sectionCallBack">
	<div class="sectionInner">
		<header class="sectionHead">
			<div class="sectionActions">
				<a href="#" class="btn btnFull btnCallBack btnSectionTrigger">
					<?php __('front_call_me_back');?>
					<i class="ico icoPhoneRounded"></i>
				</a>
			</div><!-- /.sectionActions -->
		</header><!-- /.sectionHead -->
		
		<div class="sectionBody clearfix">
			<div class="formCallBack">
				<form id="frmRequestCallBack_<?php echo $_GET['index']; ?>" action="#" method="post">
					<div class="formBody">
						<div class="formRow">
							<label for="" class="formLabel"><?php __('front_reason_for_call');?>: </label>

							<div class="formControls">
								<div class="select">
									<select name="reason_id" class="required" data-msg-required="<?php echo $validate['required'];?>">
										<option value="">-- <?php __('front_select');?> --</option>
										<?php
										foreach($tpl['reason_arr'] as $v)
										{
											?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['reason']);?></option><?php
										} 
										?>
									</select>
								</div><!-- /.select -->
							</div><!-- /.formControls -->
						</div><!-- /.formRow -->
						<?php
						if (in_array((int) $tpl['option_arr']['o_bf_include_name'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_name');?>: </label>
	
								<div class="formControls">
									<input type="text" name="name" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_name'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						} 
						if (in_array((int) $tpl['option_arr']['o_bf_include_email'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_email');?>: </label>
	
								<div class="formControls">
									<input type="text" name="email" class="field email<?php echo (int) $tpl['option_arr']['o_bf_include_email'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>" data-msg-email="<?php echo $validate['email'];?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_phone'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_phone_number');?>: </label>
	
								<div class="formControls">
									<input type="text" name="phone" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_phone'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_company'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_company');?>: </label>
	
								<div class="formControls">
									<input type="text" name="company" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_company'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_address'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_address');?>: </label>
	
								<div class="formControls">
									<input type="text" name="address" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_address'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_city'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_city');?>: </label>
	
								<div class="formControls">
									<input type="text" name="city" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_city'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_state'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_state');?>: </label>
	
								<div class="formControls">
									<input type="text" name="state" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_state'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_zip'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_zipcode');?>: </label>
	
								<div class="formControls">
									<input type="text" name="zip" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_zip'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_country'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_country');?>: </label>
	
								<div class="formControls">
									<div class="select">
										<select name="country_id" class="<?php echo (int) $tpl['option_arr']['o_bf_include_country'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>">
											<option value="">-- <?php __('front_select'); ?>--</option>
											<?php
											foreach ($tpl['country_arr'] as $k => $v)
											{
												?><option value="<?php echo $v['id']; ?>"><?php echo $v['country_title']; ?></option><?php
											}
											?>
										</select>
									</div><!-- /.select -->									
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						} 
						if (in_array((int) $tpl['option_arr']['o_bf_include_notes'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_notes');?>: </label>
	
								<div class="formControls">
									<textarea name="notes" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_country'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>"></textarea>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_calltime'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_best_time_to_call');?>: </label>
								<div class="formControls">
									<input type="text" name="besttime" class="pjCwDateTimePicker field<?php echo (int) $tpl['option_arr']['o_bf_include_calltime'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>" data-fday="<?php echo $week_start; ?>" data-dformat="<?php echo $jqDateFormat; ?>" data-tformat="<?php echo $jqTimeFormat; ?>" data-months="<?php echo join(',', $months);?>" data-shortmonths="<?php echo join(',', $short_months);?>" data-day="<?php echo join(',', $days);?>" data-daymin="<?php echo join(',', $short_days);?>" data-timeText="<?php __('front_time');?>" data-hourText="<?php __('front_hour');?>" data-minuteText="<?php __('front_minute');?>" data-currentText="<?php __('front_now');?>" data-closeText="<?php __('front_done');?>"/>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_timezone'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_my_timezone');?>: </label>
	
								<div class="formControls">
									<div class="select">
										<select name="timezone" class="<?php echo (int) $tpl['option_arr']['o_bf_include_timezone'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>">
											<?php
											$default = explode("::", $tpl['timezone_arr']['value']);
											$enum = explode("|", $default[0]);
											
											$enumLabels = array();
											if (!empty($tpl['timezone_arr']['label']) && strpos($tpl['timezone_arr']['label'], "|") !== false)
											{
												$enumLabels = explode("|", $tpl['timezone_arr']['label']);
											}
											foreach ($enum as $k => $el)
											{
												if ($default[1] == $el)
												{
													?><option value="<?php echo $el; ?>" selected="selected"><?php echo array_key_exists($k, $enumLabels) ? stripslashes($enumLabels[$k]) : stripslashes($el); ?></option><?php
												} else {
													?><option value="<?php echo $el; ?>"><?php echo array_key_exists($k, $enumLabels) ? stripslashes($enumLabels[$k]) : stripslashes($el); ?></option><?php
												}
											}
											?>
										</select>										
									</div><!-- /.select -->
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						if (in_array((int) $tpl['option_arr']['o_bf_include_captcha'], array(2,3)))
						{
							?>
							<div class="formRow">
								<label for="" class="formLabel"><?php __('front_captcha');?>: </label>
	
								<div class="formControls">
									<div class="captcha">
										<input type="text" name="captcha" class="field<?php echo (int) $tpl['option_arr']['o_bf_include_captcha'] === 3 ? ' required' : NULL; ?>" data-msg-required="<?php echo $validate['required'];?>" data-msg-remote="<?php echo $validate['captcha'];?>"/>
										<img src="<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjFront&amp;action=pjActionCaptcha&amp;rand=<?php echo rand(1, 99999); ?>" alt="Captcha" style="vertical-align: middle" />
									</div>
								</div><!-- /.formControls -->
							</div><!-- /.formRow -->
							<?php
						}
						?>
					</div><!-- /.formBody -->
					
					<footer class="formFoot">
						<div class="formActions">
							<button type="submit" class="btn btnFull btnForm btnFormSubmit"><?php __('front_btn_request_call_back');?></button>

							<a href="#" class="btn btnLink btnFormRemove"><?php __('front_cancel');?></a>
						</div><!-- /.formActions -->
					</footer><!-- /.formFoot -->
				</form>
			</div><!-- /.formCallBack -->
		</div><!-- /.sectionBody clearfix -->
		
		<footer class="sectionFoot">
			<div class="sectionMessage">
				<div class="sectionMessageImage">
					<i class="ico icoPhoneRoundedGreen"></i>
				</div><!-- /.sectionMessageImage -->

				<p class="sectionMessageTitle"><?php __('front_thank_you');?></p><!-- /.sectionMessageTitle -->
				<p class="sectionMessageTitle"><?php __('front_we_will_call_back');?></p><!-- /.sectionMessageTitle -->

				<div class="sectionMessageActions">
					<a href="#" class="btn btnClose btnSectionRemove"></a>
				</div><!-- /.sectionMessageActions -->
			</div><!-- /.sectionMessage -->
		</footer><!-- /.sectionFoot -->
	</div><!-- /.sectionInner -->
</section><!-- /.sectionCallBack -->