var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateRequest = $("#frmCreateRequest"),
			$frmUpdateRequest = $("#frmUpdateRequest"),
			$frmXMLFeed = $('#frmXMLFeed'),
			chosen = ($.fn.chosen !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);

		if (chosen) 
		{
			$("#country_id").chosen();
		}
	
		if ($frmXMLFeed.length > 0 && validate) 
		{
			$frmXMLFeed.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		if ($frmCreateRequest.length > 0 && validate) {
			$frmCreateRequest.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				onfocusout: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		if ($frmUpdateRequest.length > 0 && validate) {
			$frmUpdateRequest.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				onfocusout: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminRequests&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminRequests&action=pjActionDeleteRequest&id={:id}"}
				          ],
				columns: [{text: myLabel.name, type: "text", sortable: true, editable: true, width: 160, editableWidth: 140},
				          {text: myLabel.phone, type: "text", sortable: true, editable: true, width: 120, editableWidth: 100},
				          {text: myLabel.received, type: "text", sortable: true, editable: false, width: 130},
				          {text: myLabel.call_time, type: "text", sortable: true, editable: false, width: 160}
				         ],
				dataUrl: "index.php?controller=pjAdminRequests&action=pjActionGetRequest",
				dataType: "json",
				fields: ['name', 'phone', 'created', 'actual_besttime'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminRequests&action=pjActionDeleteRequestBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminRequests&action=pjActionExportRequest", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminRequests&action=pjActionSaveRequest&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminRequests&action=pjActionGetRequest", "created", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminRequests&action=pjActionGetRequest", "created", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminRequests&action=pjActionGetRequest", "created", "ASC", content.page, content.rowCount);
			return false;
		}).on("focusin", ".datetimepick", function (e) {
			var coeff = 1000 * 60 * 15;
			var date = new Date(); 
			var rounded = new Date(Math.round(date.getTime() / coeff) * coeff);
			var $this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev"),
					timeFormat: $this.attr("lang"),
					stepMinute: 15,
					minDateTime: rounded
			};
			$(this).datetimepicker($.extend(o, custom));
			
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
			
		}).on("change", "#export_period", function (e) {
			var period = $(this).val();
			if(period == 'last')
			{
				$('#last_label').show();
				$('#next_label').hide();
			}else{
				$('#last_label').hide();
				$('#next_label').show();
			}
		});
	});
})(jQuery_1_8_2);