DROP TABLE IF EXISTS `documentcreator_documents`;
CREATE TABLE IF NOT EXISTS `documentcreator_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template_id` int(10) unsigned DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `content` text,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `template_id` (`template_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_histories`;
CREATE TABLE IF NOT EXISTS `documentcreator_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `document_id` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `content` text,
  `modified` datetime DEFAULT NULL,
  `ip` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `document_id` (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_templates`;
CREATE TABLE IF NOT EXISTS `documentcreator_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `content` text,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_customers`;
CREATE TABLE IF NOT EXISTS `documentcreator_customers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,	
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_customers_tokens`;
CREATE TABLE IF NOT EXISTS `documentcreator_customers_tokens` (
  `customer_id` int(10) unsigned NOT NULL,
  `token_id` int(10) unsigned NOT NULL,
  `content` text,
  PRIMARY KEY (`customer_id`,`token_id`),
  KEY `customer_id` (`customer_id`),
  KEY `token_id` (`token_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_tokens`;
CREATE TABLE IF NOT EXISTS `documentcreator_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `fixed` enum('T','F') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `token` (`token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_fields`;
CREATE TABLE IF NOT EXISTS `documentcreator_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_multi_lang`;
CREATE TABLE IF NOT EXISTS `documentcreator_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_options`;
CREATE TABLE IF NOT EXISTS `documentcreator_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_roles`;
CREATE TABLE IF NOT EXISTS `documentcreator_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `documentcreator_users`;
CREATE TABLE IF NOT EXISTS `documentcreator_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `documentcreator_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(480, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(481, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(482, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(483, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(484, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(485, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(486, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(487, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(488, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(489, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(490, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(491, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(492, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(493, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(612, 'menuTokens', 'backend', 'Menu / Tokens', 'script', NULL),
(613, 'menuCustomers', 'backend', 'Menu / Customers', 'script', NULL),
(614, 'menuTemplates', 'backend', 'Menu / Templates', 'script', NULL),
(615, 'menuDocuments', 'backend', 'Menu / Documents', 'script', NULL),
(616, 'infoTokensTitle', 'backend', 'Infobox / List of tokens', 'script', NULL),
(617, 'infoTokensDesc', 'backend', 'Infobox / List of tokens', 'script', NULL),
(618, 'btnAddToken', 'backend', 'Button / + Add token', 'script', NULL),
(619, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(620, 'lblToken', 'backend', 'Label / Token', 'script', NULL),
(621, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(622, 'infoAddTokenTitle', 'backend', 'Infobox / Add token', 'script', NULL),
(623, 'infoAddTokenDesc', 'backend', 'Infobox / Add token', 'script', NULL),
(624, 'lblSameToken', 'backend', 'Label / Token was already used.', 'script', NULL),
(625, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(626, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(627, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(628, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(629, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(630, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(631, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(632, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(633, 'infoUpdateTokenTitle', 'backend', 'Infobox / Update token', 'script', NULL),
(634, 'infoUpdateTokenDesc', 'backend', 'Infobox / Update token', 'script', NULL),
(635, 'error_titles_ARRAY_ACU01', 'arrays', 'error_titles_ARRAY_ACU01', 'script', NULL),
(636, 'error_bodies_ARRAY_ACU01', 'arrays', 'error_bodies_ARRAY_ACU01', 'script', NULL),
(637, 'error_titles_ARRAY_ACU03', 'arrays', 'error_titles_ARRAY_ACU03', 'script', NULL),
(638, 'error_bodies_ARRAY_ACU03', 'arrays', 'error_bodies_ARRAY_ACU03', 'script', NULL),
(639, 'error_titles_ARRAY_ACU04', 'arrays', 'error_titles_ARRAY_ACU04', 'script', NULL),
(640, 'error_bodies_ARRAY_ACU04', 'arrays', 'error_bodies_ARRAY_ACU04', 'script', NULL),
(641, 'error_titles_ARRAY_ACU08', 'arrays', 'error_titles_ARRAY_ACU08', 'script', NULL),
(642, 'infoCustomersTitle', 'backend', 'Infbox / List of customers', 'script', NULL),
(643, 'infoCustomersDesc', 'backend', 'Infbox / List of customers', 'script', NULL),
(644, 'btnAddCustomer', 'backend', 'Button / + Add customer', 'script', NULL),
(645, 'lblFirstName', 'backend', 'Label / First Name', 'script', NULL),
(646, 'lblLastName', 'backend', 'Label / Last Name', 'script', NULL),
(647, 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
(648, 'lblDocuments', 'backend', 'Label / Documents', 'script', NULL),
(649, 'infoAddCustomerTitle', 'backend', 'Infobox / Add customer', 'script', NULL),
(650, 'infoAddCustomerDesc', 'backend', 'Infobox / Add customer', 'script', NULL),
(651, 'lblEmailInvalid', 'backend', 'Label / Email is invalid.', 'script', NULL),
(652, 'lblEmailUsed', 'backend', 'Label / Email was already used.', 'script', NULL),
(653, 'infoUpdateCustomerTitle', 'backend', 'Infobox / Update customer', 'script', NULL),
(654, 'infoUpdateCustomerDesc', 'backend', 'Infobox / Update customer', 'script', NULL),
(655, 'error_titles_ARRAY_ATE01', 'arrays', 'error_titles_ARRAY_ATE01', 'script', NULL),
(656, 'error_bodies_ARRAY_ATE01', 'arrays', 'error_bodies_ARRAY_ATE01', 'script', NULL),
(657, 'error_titles_ARRAY_ATE03', 'arrays', 'error_titles_ARRAY_ATE03', 'script', NULL),
(658, 'error_bodies_ARRAY_ATE03', 'arrays', 'error_bodies_ARRAY_ATE03', 'script', NULL),
(659, 'error_titles_ARRAY_ATE04', 'arrays', 'error_titles_ARRAY_ATE04', 'script', NULL),
(660, 'error_bodies_ARRAY_ATE04', 'arrays', 'error_bodies_ARRAY_ATE04', 'script', NULL),
(661, 'error_titles_ARRAY_ATE08', 'arrays', 'error_titles_ARRAY_ATE08', 'script', NULL),
(662, 'error_bodies_ARRAY_ATE08', 'arrays', 'error_bodies_ARRAY_ATE08', 'script', NULL),
(663, 'infoTemplatesTitle', 'backend', 'Infobox / List of templates', 'script', NULL),
(664, 'infoTemplatesDesc', 'backend', 'Infobox / List of templates', 'script', NULL),
(665, 'btnAddTemplate', 'backend', 'Button / + Add template', 'script', NULL),
(666, 'lblText', 'backend', 'Label / Text', 'script', NULL),
(667, 'infoAddTemplateTitle', 'backend', 'Infobox / Add template', 'script', NULL),
(668, 'infoAddTemplateDesc', 'backend', 'Infobox / Add template', 'script', NULL),
(669, 'lblTitleUsed', 'backend', 'Label / Template title was already used.', 'script', NULL),
(670, 'infoUpdateTemplateTitle', 'backend', 'Infobox / Update template', 'script', NULL),
(671, 'infoUpdateTemplateDesc', 'backend', 'Infobox / Update template', 'script', NULL),
(672, 'error_titles_ARRAY_AD01', 'arrays', 'error_titles_ARRAY_AD01', 'script', NULL),
(673, 'error_bodies_ARRAY_AD01', 'arrays', 'error_bodies_ARRAY_AD01', 'script', NULL),
(674, 'error_titles_ARRAY_AD03', 'arrays', 'error_titles_ARRAY_AD03', 'script', NULL),
(675, 'error_bodies_ARRAY_AD03', 'arrays', 'error_bodies_ARRAY_AD03', 'script', NULL),
(676, 'error_titles_ARRAY_AD04', 'arrays', 'error_titles_ARRAY_AD04', 'script', NULL),
(677, 'error_bodies_ARRAY_AD04', 'arrays', 'error_bodies_ARRAY_AD04', 'script', NULL),
(678, 'error_titles_ARRAY_AD08', 'arrays', 'error_titles_ARRAY_AD08', 'script', NULL),
(679, 'error_bodies_ARRAY_AD08', 'arrays', 'error_bodies_ARRAY_AD08', 'script', NULL),
(680, 'infoDocumentsTitle', 'backend', 'Infobox / List of documents', 'script', NULL),
(681, 'infoDocumentsDesc', 'backend', 'Infobox / List of documents', 'script', NULL),
(682, 'btnAddDocument', 'backend', 'Button / + Add document', 'script', NULL),
(683, 'lblCreated', 'backend', 'Label / Created', 'script', NULL),
(684, 'tabDocuments', 'backend', 'Tab / Documents', 'script', NULL),
(685, 'tabChanges', 'backend', 'Tab / Changes', 'script', NULL),
(686, 'lblContent', 'backend', 'Label / Content', 'script', NULL),
(687, 'lblTemplate', 'backend', 'Label / Template', 'script', NULL),
(688, 'lblCustomer', 'backend', 'Label / Customer', 'script', NULL),
(689, 'infoAddDocumentTitle', 'backend', 'Infobox / Add document', 'script', NULL),
(690, 'infoAddDocumentDesc', 'backend', 'Infobox / Add document', 'script', NULL),
(691, 'infoUpdateDocumentTitle', 'backend', 'Infobox / Update document', 'script', NULL),
(692, 'infoUpdateDocumentDesc', 'backend', 'Infobox / Update document', 'script', NULL),
(693, 'lblLastChanged', 'backend', 'Lable / Last changed', 'script', NULL),
(694, 'lblViewAllChanges', 'backend', 'Label / view all {cnt} changes', 'script', NULL),
(695, 'lblViewOneChange', 'backend', 'Label / view 1 change', 'script', NULL),
(696, 'lblNA', 'backend', 'Label / n/a', 'script', NULL),
(697, 'infoUpdateHistoryTitle', 'backend', 'Infobox / Update history', 'script', NULL),
(698, 'infoUpdateHistoryDesc', 'backend', 'Infobox / Update history', 'script', NULL),
(699, 'lblFilterByDocument', 'backend', 'Label / Filter by document', 'script', NULL),
(700, 'lblDocumentContent', 'backend', 'Label / Document content', 'script', NULL),
(701, 'lblRestoreDocument', 'backend', 'Label / Restore document', 'script', NULL),
(702, 'lblRestoreConfirmation', 'backend', 'Label / Restore confirmation', 'script', NULL),
(703, 'lblDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(704, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(705, 'lblView', 'backend', 'Label / View', 'script', NULL),
(706, 'lblRestore', 'backend', 'Label / Restore', 'script', NULL),
(707, 'lblEdit', 'backend', 'Label / Edit', 'script', NULL),
(709, 'lblDocument', 'backend', 'Label / Document', 'script', NULL),
(710, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(711, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(712, 'buttons_ARRAY_restore', 'arrays', 'buttons_ARRAY_restore', 'script', NULL),
(713, 'buttons_ARRAY_close', 'arrays', 'buttons_ARRAY_close', 'script', NULL),
(832, 'tabCustomerDetails', 'backend', 'Tab / Customer Details', 'script', NULL),
(833, 'lblGeneratedDocuments', 'backend', 'Label / Generated documents', 'script', NULL),
(834, 'document_statuses_ARRAY_1', 'arrays', 'document_statuses_ARRAY_1', 'script', NULL),
(835, 'document_statuses_ARRAY_4', 'arrays', 'document_statuses_ARRAY_4', 'script', NULL),
(836, 'document_statuses_ARRAY_3', 'arrays', 'document_statuses_ARRAY_3', 'script', NULL),
(837, 'lblDocumentsUsingTemplate', 'backend', 'Label / documents using template', 'script', NULL),
(838, 'lblDocumentUsingTemplate', 'backend', 'Label / document using template', 'script', NULL),
(839, 'lblViewLink', 'backend', 'Label / View link', 'script', NULL),
(840, 'btnSendToClient', 'backend', 'Button / Send to client', 'script', NULL),
(841, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(842, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(843, 'lblCustomerEmail', 'backend', 'Label / Customer email', 'script', NULL),
(844, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(845, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(846, 'lblFilterBy', 'backend', 'Label / Filter by', 'script', NULL),
(847, 'lblAllDocuments', 'backend', 'Label / All documents', 'script', NULL),
(848, 'lblAllTemplates', 'backend', 'Label / All templates', 'script', NULL),
(849, 'btnFilter', 'backend', 'Button / Filter', 'script', NULL),
(850, 'lblDownload', 'backend', 'Label / Download', 'script', NULL),
(851, 'lblAllCustomers', 'backend', 'Label / All customers', 'script', NULL),
(852, 'lblUser', 'backend', 'Label / User', 'script', NULL),
(853, 'lblNoTemplateMessage', 'backend', 'Label / No tempalte message', 'script', NULL),
(854, 'lblNoCustomerMessage', 'backend', 'Label / No customer message', 'script', NULL),
(855, 'lblNoTemplateMessageEditor', 'backend', 'Label / No tempalte message', 'script', NULL),
(856, 'lblNoCustomerMessageEditor', 'backend', 'Label / No customer message', 'script', NULL);

INSERT INTO `documentcreator_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'List of users', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Below you can see users who have access to the Menu Builder administration pages. There are two types of users Administrators and Editors only. Click on "+ Add user" button to add a new user.', 'script'),
(NULL, 482, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'You can add an "Administrator" who has full access to the administration page or an "Editor" who can access all system menus, but is not able to modify Options and add other Users.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update user information.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Here you can set the General options for the Menu Builder.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Tokens', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Customers', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Templates', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Documents', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'List of tokens', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Below is a list of predefined tokens. Four of them are fixed - First Name, Last Name, Email and Phone. Click on the button "+ Add token" to add a new token.', 'script'),
(NULL, 618, 'pjField', 1, 'title', '+ Add token', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Token', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Add token', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Please fill in the title of the token and click "Save" button. The token will be automatically generated based on the title entered.', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Token was already used.', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Token updated', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'The token information has been updated.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Token added', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'New token has been added into the list.', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Token not added', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'The token could not be added. Please try again.', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Token not found', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'The token you are looking for is missing.', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Update token', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'You can make any change on the title of the token and click "Save" button.', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Customer updated', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'All changes made to the customer have been updated.', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Customer added', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'New customer has been added into the list.', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Customer not added', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Customer could not be added. Please try again.', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Customer not found', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'List of customers', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'You can see below the list of customers. If you want to add a new customer, just click on the "+ Add customer" button. To edit customer information, click on the pencil icon on the right side.', 'script'),
(NULL, 644, 'pjField', 1, 'title', '+ Add customer', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'First Name', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Last Name', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Documents', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Add customer', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Fill out the form below and click "Save" to add a new customer.', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Email was already used.', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Update customer', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'You can make any change to the form below. Just edit and save to update customer information.', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Template updated', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'All changes made to the template have been updated.', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Template added', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'New template has been added into the list.', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Template not added', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Template could not be added. Please try again.', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Template not found', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'The template you are looking for is missing.', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'List of templates', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Below is a list of all templates that have been added. If you want to add a new one, just click on  "+ Add template".', 'script'),
(NULL, 665, 'pjField', 1, 'title', '+ Add template', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Text', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Add template', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Fill in the title and text on the form below and click "Save" button to create new template. There are some available tokens that you can use:', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Template title was already used.', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'Update template', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'You can edit the form below as you wish. Just click "Save" to create a new template. You can use following predefined tokens:', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Document updated', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'All changes made to the document have been saved.', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Document added', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'New document has been added into the list.', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Document not added', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Document could not be added. Please try again.', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Document not found', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'The document you are looking for is missing.', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'List of documents', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Below is a list of all documents. If you want to add a new document template, click on the "+ Add document" button.  Click on the pencil icon of each entry to edit the respective document.', 'script'),
(NULL, 682, 'pjField', 1, 'title', '+ Add document', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Created', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Documents', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Changes', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Content', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Template', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Customer', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Add document', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'On the form below, you will need to select the template and customer that you want to generate document for. ', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Update document', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'You can make any change to the form below. Just click "Save" to update the information.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Last changed', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'view all {cnt} changes', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'view 1 change', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'n/a', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Update history', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Below is a list with all changes made to the documents. You can view previous versions of your documents and restore them.', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Filter by document', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Document content before being changed on {DATETIME}', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Restore document', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Do you want to restore this content for the current document?', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Restore', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Document', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Restore', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'Customer Details', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Generated documents', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Document with such ID does not exist.', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'Hash value is not valid.', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'documents generated using this template', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'document generated using this template', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'View link', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'Send to client', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'Customer email', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'Filter by', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'All documents', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'All templates', 'script'),
(NULL, 849, 'pjField', 1, 'title', 'Filter', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Download', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'All customers', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 853, 'pjField', 1, 'title', 'No templates added. Click {STAG}here{ETAG} to add one.', 'script'),
(NULL, 854, 'pjField', 1, 'title', 'No customers added. Click {STAG}here{ETAG} to add one.', 'script'),
(NULL, 855, 'pjField', 1, 'title', 'No templates added.', 'script'),
(NULL, 856, 'pjField', 1, 'title', 'No customers added.', 'script');

INSERT INTO `documentcreator_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 3, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 0, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 0, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10|theme11::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10|Theme 11', 'enum', 6, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 7, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 10, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 11, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `documentcreator_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `documentcreator_tokens` (`id`, `title`, `token`, `fixed`) VALUES
(1, 'First Name', '{FirstName}', 'T'),
(2, 'Last Name', '{LastName}', 'T'),
(3, 'Email', '{Email}', 'T'),
(4, 'Phone', '{Phone}', 'T');