<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjAdminTokens extends pjAdmin
{
	public function pjActionCheckToken()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['token']) || empty($_GET['token']))
			{
				echo 'false';
				exit;
			}
			$pjTokenModel = pjTokenModel::factory()->where('t1.token', $_GET['token']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjTokenModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjTokenModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['token_create']))
			{
				$pjTokenModel = pjTokenModel::factory();
				
				$id = $pjTokenModel->reset()->setAttributes($_POST)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AT03';
				} else {
					$err = 'AT04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTokens&action=pjActionIndex&err=$err");
			} else {
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminTokens.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteToken()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$response = array();
			if ($this->isAdmin())
			{
				if (pjTokenModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					pjCustomerTokenModel::factory()->where('token_id', $_GET['id'])->eraseAll();
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteTokenBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if ($this->isAdmin())
			{
				if (isset($_POST['record']) && count($_POST['record']) > 0)
				{
					$pjTokenModel = pjTokenModel::factory();
					$id_arr = $pjTokenModel->where('fixed', 'F')->whereIn('id', $_POST['record'])->findAll()->getDataPair(null, 'id');
					$pjTokenModel->reset()->whereIn('id', $id_arr)->eraseAll();
					pjCustomerTokenModel::factory()->whereIn('token_id', $id_arr)->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionExportToken()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjTokenModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Tokens-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetToken()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjTokenModel = pjTokenModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjTokenModel->where('t1.title LIKE', "%$q%");
				$pjTokenModel->orWhere('t1.token LIKE', "%$q%");
			}
	
			$column = 'id';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjTokenModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = $pjTokenModel
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();

			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminTokens.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$pjTokenModel = pjTokenModel::factory();
			if (isset($_POST['token_update']))
			{
				$pjTokenModel->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminTokens&action=pjActionIndex&err=AT01");
				
			} else {
				$arr = $pjTokenModel->find($_GET['id'])->getData();
					
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminTokens&action=pjActionIndex&err=AT08");
				}
				
				$this->set('arr', $arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminTokens.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>