<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/docmenu.php';
	pjUtil::printNotice(__('infoAddDocumentTitle', true), __('infoAddDocumentDesc', true), false); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminDocuments&amp;action=pjActionCreate" method="post" id="frmCreateDocument" class="form pj-form" autocomplete="off">
		<input type="hidden" name="document_create" value="1" />
		<div class="pj-loader-outer">
			<div class="pj-loader"></div>
			<p>
				<label class="title"><?php __('lblTemplate'); ?></label>
				<span class="inline_block">
					<?php
					if(!empty($tpl['template_arr']))
					{ 
						?>
						<select id="template_id" name="template_id" class="pj-form-field w300 required pj-chosen" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach($tpl['template_arr'] as $template)
							{
								?><option value="<?php echo $template['id'];?>"><?php echo pjSanitize::html($template['title']);?></option><?php
							} 
							?>
						</select>
						<?php
					}else{
						if($controller->isAdmin())
						{
							$message = __('lblNoTemplateMessage', true);
							$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminTemplates&amp;action=pjActionCreate">', $message);
							$message = str_replace("{ETAG}", '</a>', $message);
						}else{
							$message = __('lblNoTemplateMessageEditor', true);
						}
						?><label class="content"><?php echo $message;?></label><?php
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblCustomer'); ?></label>
				<span class="inline_block">
					<?php
					if(!empty($tpl['customer_arr']))
					{ 
						?>
						<select id="customer_id" name="customer_id" class="pj-form-field w300 required pj-chosen" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach($tpl['customer_arr'] as $customer)
							{
								$name_arr = array();
								if(!empty($customer['first_name']))
								{
									$name_arr[] = pjSanitize::html($customer['first_name']);
								}
								if(!empty($customer['last_name']))
								{
									$name_arr[] = pjSanitize::html($customer['last_name']);
								}
								?><option value="<?php echo $customer['id'];?>"><?php echo join(" ", $name_arr);?></option><?php
							} 
							?>
						</select>
						<?php
					}else{
						if($controller->isAdmin())
						{
							$message = __('lblNoCustomerMessage', true);
							$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminCustomers&amp;action=pjActionCreate">', $message);
							$message = str_replace("{ETAG}", '</a>', $message);
						}else{
							$message = __('lblNoCustomerMessageEditor', true);
						}
						?><label class="content"><?php echo $message;?></label><?php
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblTitle'); ?></label>
				<span class="inline_block">
					<input type="text" name="title" id="title" class="pj-form-field w400 required" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-remote="<?php __('lblTitleUsed');?>"/>
				</span>
			</p>
			<p style="display: none;">
				<label class="title"><?php __('lblContent'); ?></label>
				<span id="pjDmContent" class="inline_block">
					<textarea name="content" class="pj-form-field required mceEditor" data-msg-required="<?php __('lblFieldRequired');?>"></textarea>
				</span>
			</p>
			
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminDocuments&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<script>
	var myLabel = myLabel || {};
	myLabel.fileuploader_version = '<?php echo $tpl['fileuploader_version']; ?>';
	myLabel.fileuploader_url = '<?php echo $tpl['fileuploader_url']; ?>';
	</script>
	<?php
}
?>