<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/docmenu.php'; 
	pjUtil::printNotice(__('infoUpdateHistoryTitle', true, false), __('infoUpdateHistoryDesc', true, false));
	
	if(!empty($tpl['arr']))
	{ 
		?>
		<div class="b10">
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="pj-form b10">
				<input type="hidden" name="controller" value="pjAdminDocuments" />
				<input type="hidden" name="action" value="pjActionHistory" />
				<span class="inline-block">
					<label class="block float_left r10 t5"><?php __('lblFilterBy');?>:</label>
						<span class="block float_left r5">
							<select name="document_id" class="pj-form-field w200 pj-chosen">
								<option value="">-- <?php __('lblAllDocuments'); ?> --</option>
								<?php
								foreach($tpl['arr'] as $v)
								{
									?>
									<option value="<?php echo $v['id']?>"<?php echo isset($_GET['document_id']) ? ($_GET['document_id'] == $v['id'] ? ' selected="selected"' : null) : null ;?>><?php echo pjSanitize::html($v['title']);?></option>
									<?php
								} 
								?>
							</select>
						</span>
						<span class="block float_left r5">
							<select name="template_id" class="pj-form-field w200 pj-chosen">
								<option value="">-- <?php __('lblAllTemplates'); ?> --</option>
								<?php
								foreach($tpl['template_arr'] as $v)
								{
									?>
									<option value="<?php echo $v['id']?>"<?php echo isset($_GET['template_id']) ? ($_GET['template_id'] == $v['id'] ? ' selected="selected"' : null) : null ;?>><?php echo pjSanitize::html($v['title']);?></option>
									<?php
								} 
								?>
							</select>
						</span>
					<input type="submit" value="<?php __('btnFilter'); ?>" class="pj-button" />
				</span>
			</form>
		</div>
		<?php
	} 
	?>
	
	<div id="history_grid"></div>
	
	<div id="dialogView" style="display: none" title="" data-title="<?php __('lblDocumentContent');?>"></div>
	<div id="dialogRestore" style="display: none" title="<?php __('lblRestoreDocument');?>"><?php __('lblRestoreConfirmation');?></div>
	
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['document_id']) && (int) $_GET['document_id'] > 0)
	{
		?>pjGrid.queryString += "&document_id=<?php echo (int) $_GET['document_id']; ?>";<?php
	}
	if (isset($_GET['template_id']) && (int) $_GET['template_id'] > 0)
	{
		?>pjGrid.queryString += "&template_id=<?php echo (int) $_GET['template_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.document = "<?php __('lblDocument'); ?>";
	myLabel.customer = "<?php __('lblCustomer'); ?>";
	myLabel.datetime = "<?php __('lblDateTime'); ?>";
	myLabel.user = "<?php __('lblUser'); ?>";
	myLabel.ip = "<?php __('lblIpAddress'); ?>";
	myLabel.view = "<?php __('lblView'); ?>";
	myLabel.restore = "<?php __('lblRestore'); ?>";
	myLabel.edit = "<?php __('lblEdit'); ?>";
	myLabel.delete = "<?php __('lblDelete'); ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	</script>
	<?php
}
?>