<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/docmenu.php';
	pjUtil::printNotice(__('infoDocumentsTitle', true), __('infoDocumentsDesc', true)); 
	?>
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminDocuments" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddDocument'); ?>" />
		</form>
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="pj-form b10">
			<input type="hidden" name="controller" value="pjAdminDocuments" />
			<input type="hidden" name="action" value="pjActionIndex" />
			<span class="inline-block">
				<span class="block float_left r5">
					<select name="customer_id" class="pj-form-field w200 pj-chosen">
						<option value="">-- <?php __('lblAllCustomers'); ?>--</option>
						<?php
						foreach($tpl['customer_arr'] as $customer)
						{
							$name_arr = array();
							if(!empty($customer['first_name']))
							{
								$name_arr[] = pjSanitize::html($customer['first_name']);
							}
							if(!empty($customer['last_name']))
							{
								$name_arr[] = pjSanitize::html($customer['last_name']);
							}
							?><option value="<?php echo $customer['id'];?>"<?php echo isset($_GET['customer_id']) ? ($_GET['customer_id'] == $customer['id'] ? ' selected="selected"' : null) : null ;?>><?php echo join(" ", $name_arr);?></option><?php
						} 
						?>
					</select>
				</span>
				<span class="block float_left r5">
					<select name="template_id" class="pj-form-field w200 pj-chosen">
						<option value="">-- <?php __('lblAllTemplates'); ?> --</option>
						<?php
						foreach($tpl['template_arr'] as $v)
						{
							?>
							<option value="<?php echo $v['id']?>"<?php echo isset($_GET['template_id']) ? ($_GET['template_id'] == $v['id'] ? ' selected="selected"' : null) : null ;?>><?php echo pjSanitize::html($v['title']);?></option>
							<?php
						} 
						?>
					</select>
				</span>
				<input type="submit" value="<?php __('btnFilter'); ?>" class="pj-button" />
			</span>
		</form>
	</div>

	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.isAdmin = <?php echo $controller->isAdmin() ? 'true' : 'false'; ?>;
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['customer_id']) && (int) $_GET['customer_id'] > 0)
	{
		?>pjGrid.queryString += "&customer_id=<?php echo (int) $_GET['customer_id']; ?>";<?php
	}
	if (isset($_GET['template_id']) && (int) $_GET['template_id'] > 0)
	{
		?>pjGrid.queryString += "&template_id=<?php echo (int) $_GET['template_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.customer = "<?php __('lblCustomer', false, true); ?>";
	myLabel.template = "<?php __('lblTemplate', false, true); ?>";
	myLabel.title = "<?php __('lblTitle'); ?>";
	myLabel.created = "<?php __('lblCreated'); ?>";
	
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	</script>
	<?php
}
?>