<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/docmenu.php';
	pjUtil::printNotice(__('infoUpdateDocumentTitle', true), __('infoUpdateDocumentDesc', true), false); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminDocuments&amp;action=pjActionUpdate" method="post" id="frmUpdateDocument" class="form pj-form" autocomplete="off">
		<input type="hidden" name="document_update" value="1" />
		<input type="hidden" name="id" value="<?php echo (int) $tpl['arr']['id']; ?>" />
		<div class="pj-loader-outer">
			<div class="pj-loader"></div>
			<p>
				<label class="title"><?php __('lblCreated'); ?></label>
				<span class="inline_block">
					<label class="content"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created']));?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']));?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblLastChanged'); ?></label>
				<span class="inline_block">
					<label class="content">
					<?php
					if($tpl['arr']['changes'] > 0)
					{ 
						$all_changes = str_replace("{cnt}", $tpl['arr']['changes'], __('lblViewAllChanges', true, false));
						$_arr = array();
						$_arr[] = pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['modified'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['modified'])), 'H:i:s', $tpl['option_arr']['o_time_format']);
						
						if($controller->isAdmin())
						{
							$_arr[] = ' (<a href="'. $_SERVER['PHP_SELF'] .'?controller=pjAdminDocuments&amp;action=pjActionHistory&amp;document_id='.$tpl['arr']['id'].'">' . ($tpl['arr']['changes'] != 1 ? $all_changes : __('lblViewOneChange', true, false)) .'</a>)';
						} 
						echo join(' ', $_arr);
					}else{
						__('lblNA');
					}
					?>
				</label>
				</span>
			</p>
			
			<p>
				<label class="title"><?php __('lblTemplate'); ?></label>
				<span class="inline_block">
					<label class="content">
						<?php
						if($controller->isAdmin())
						{ 
							?>
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTemplates&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['arr']['template_id'];?>"><?php echo pjSanitize::html($tpl['arr']['template']);?></a>
							<?php
						}else{
							echo pjSanitize::html($tpl['arr']['template']);
						} 
						?>
					</label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblCustomer'); ?></label>
				<span class="inline_block">
					<?php
					$name_arr = array();
					if(!empty($tpl['arr']['first_name']))
					{
						$name_arr[] = pjSanitize::html($tpl['arr']['first_name']);
					}
					if(!empty($tpl['arr']['last_name']))
					{
						$name_arr[] = pjSanitize::html($tpl['arr']['last_name']);
					} 
					?>
					<label class="content float_left r10">
						<?php
						if($controller->isAdmin())
						{ 
							?>
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminCustomers&amp;action=pjActionUpdate&amp;id=<?php echo $tpl['arr']['customer_id'];?>"><?php echo join(' ', $name_arr);?></a>
							<?php
						} else {
							echo join(' ', $name_arr);
						}
						?>
					</label>
					<input type="button" value="<?php __('btnSendToClient'); ?>" class="pj-button pjDmSendDoc" />
				</span>
			</p>
			<?php
			$view_link = $_SERVER['PHP_SELF'] . '?controller=pjAdminDocuments&amp;action=pjActionPreview&amp;id='.$tpl['arr']['id'] . '&amp;hash=' . sha1($tpl['arr']['id'].$tpl['arr']['created'].PJ_SALT);
			?>
			<p>
				<label class="title"><?php __('lblTitle'); ?></label>
				<span class="inline_block">
					<input type="text" name="title" id="title" class="pj-form-field w400 required float_left r5" value="<?php echo pjSanitize::html($tpl['arr']['title']); ?>" data-msg-required="<?php __('lblFieldRequired');?>" data-msg-remote="<?php __('lblTitleUsed');?>"/>
					<a href="<?php echo $view_link;?>" target="_blank" title="<?php __('lblView');?>" class="pj-table-icon-view l5 t5 r5"></a>
					<a href="<?php echo PJ_INSTALL_URL . 'file.php?id='.$tpl['arr']['id']. '&amp;hash=' . sha1($tpl['arr']['id'].$tpl['arr']['created'].PJ_SALT); ?>" title="<?php __('lblDownload');?>" class="pj-table-icon-download t5"></a>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblContent'); ?></label>
				<span id="pjDmContent" class="inline_block">
					<textarea name="content" class="pj-form-field required mceEditor" data-msg-required="<?php __('lblFieldRequired');?>"><?php echo stripslashes($tpl['arr']['content']);?></textarea>
				</span>
			</p>
			
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminDocuments&action=pjActionIndex';" />
			</p>
		</div>
	</form>
	
	<div id="dialogSend" style="display: none" title="<?php __('btnSendToClient');?>">
		<form action="#" method="post" id="frmSendDocument" class="form pj-form">
			<p>
				<label class="block b5"><?php __('lblCustomerEmail'); ?>:</label>
				<span class="inline_block">
					<input name="customer_email" value="<?php echo pjSanitize::html($tpl['arr']['email']); ?>" class="pj-form-field w500" />
				</span>
			</p>
			<p>
				<label class="block b5"><?php __('lblSubject'); ?>:</label>
				<span class="inline_block">
					<input name="subject" value="<?php echo pjSanitize::html($tpl['arr']['title']); ?>" class="pj-form-field w500" />
				</span>
			</p>
			<?php
			$link = PJ_INSTALL_URL . 'index.php?controller=pjAdminDocuments&amp;action=pjActionPreview&amp;id='.$tpl['arr']['id'] . '&amp;hash=' . sha1($tpl['arr']['id'].$tpl['arr']['created'].PJ_SALT);
			$link = '<a href="'.$link.'">'.$link.'</a>';
			?>
			<p>
				<label class="title b5"><?php __('lblMessage'); ?>:</label>
				<span class="inline_block">
					<textarea name="message" class="pj-form-field mceMessage"><?php echo $link;?></textarea>
				</span>
			</p>
		</form>
	</div>
	
	<script>
	var myLabel = myLabel || {};
	myLabel.fileuploader_version = '<?php echo $tpl['fileuploader_version']; ?>';
	myLabel.fileuploader_url = '<?php echo $tpl['fileuploader_url']; ?>';
	</script>
	<?php
}
?>