var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateCustomer = $("#frmCreateCustomer"),
			$frmUpdateCustomer = $("#frmUpdateCustomer"),
			datagrid = ($.fn.datagrid !== undefined);
		
		if ($frmCreateCustomer.length > 0) {
			$frmCreateCustomer.validate({
				rules: {
					"token_3": {
						remote: "index.php?controller=pjAdminCustomers&action=pjActionCheckEmail"
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateCustomer.length > 0) {
			$frmUpdateCustomer.validate({
				rules: {
					"token_3": {
						remote: "index.php?controller=pjAdminCustomers&action=pjActionCheckEmail&id=" + $frmUpdateCustomer.find("input[name='id']").val()
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		function formatDocuments (str, obj) {
			if (parseInt(str, 10) > 0) {
				return '<a href="index.php?controller=pjAdminDocuments&action=pjActionIndex&customer_id='+obj.id+'">'+str+'</a>';
			} else {
				return str;
			}
		}		
		if ($("#grid").length > 0 && datagrid) {
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminCustomers&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminCustomers&action=pjActionDeleteCustomer&id={:id}"}
				          ],
				columns: [{text: myLabel.first_name, type: "text", sortable: true, editable: false, width: 110},
				          {text: myLabel.last_name, type: "text", sortable: true, editable: false, width: 110},
				          {text: myLabel.email, type: "text", sortable: true, editable: false, width: 165},
				          {text: myLabel.documents, type: "text", sortable: true, editable: false, align: 'center', width: 90, renderer: formatDocuments},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminCustomers&action=pjActionGetCustomer",
				dataType: "json",
				fields: ['first_name', 'last_name', 'email', 'documents', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminCustomers&action=pjActionDeleteCustomerBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminCustomers&action=pjActionSaveCustomer&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminCustomers&action=pjActionGetCustomer", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminCustomers&action=pjActionGetCustomer", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminCustomers&action=pjActionGetCustomer", "id", "ASC", content.page, content.rowCount);
			return false;
		});
	});
})(jQuery_1_8_2);