var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateToken = $("#frmCreateToken"),
			$frmUpdateToken = $("#frmUpdateToken"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if ($frmCreateToken.length > 0 && validate) {
			$frmCreateToken.validate({
				rules: {
					"token": {
						remote: "index.php?controller=pjAdminTokens&action=pjActionCheckToken"
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		if ($frmUpdateToken.length > 0 && validate) {
			$frmUpdateToken.validate({
				rules: {
					"token": {
						remote: "index.php?controller=pjAdminTokens&action=pjActionCheckToken&id=" + $frmUpdateToken.find("input[name='id']").val()
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			function deleteBeforeShow (obj) {
				if (obj.fixed === 'T') {
					return false;
				}
				return true;
			}
			
			var $grid = $("#grid").datagrid({
				buttons: [
				          	{type: "edit", url: "index.php?controller=pjAdminTokens&action=pjActionUpdate&id={:id}"},
				          	{type: "delete", url: "index.php?controller=pjAdminTokens&action=pjActionDeleteToken&id={:id}", beforeShow: deleteBeforeShow}
						 ],
				columns: [
				          	{text: myLabel.title, type: "text", sortable: false, editable: false, width: 350},
				          	{text: myLabel.token, type: "text", sortable: false, editable: false, width: 250}
						 ],
				dataUrl: "index.php?controller=pjAdminTokens&action=pjActionGetToken",
				dataType: "json",
				fields: ['title', 'token'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminTokens&action=pjActionDeleteTokenBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminTokens&action=pjActionExportToken", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminTokens&action=pjActionSaveToken&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminTokens&action=pjActionGetToken", "id", "ASC", content.page, content.rowCount);
			return false;
		}).on("keyup", "#title", function (e) {
			var title = $(this).val();
			if(title != '')
			{
				$('#token').val( '{' + title.replace(/ /g,'') + '}');
			}else{
				$('#token').val('');
			}
		});
	});
})(jQuery_1_8_2);