<?php
$pj_root_path = dirname(__FILE__) . "/../../../../../";
$pj_paths = array(
	'config' => $pj_root_path . "app/config/",
	'cms' => $pj_root_path . "app/plugins/pjCms/config/",
);
$pj_authorized = false;
foreach ($pj_paths as $pj_path)
{
	$pj_filemanager_config = $pj_path . 'filemanager-top.inc.php';
	if (is_file($pj_filemanager_config))
	{
		$pj_authorized = include $pj_filemanager_config;
		break;
	}
}
if (!$pj_authorized)
{
	header('HTTP/1.1 401 Unauthorized');
	exit;
}

/* ---------------------------------------- */

$config = array(
	'fu_relative_path'   => '',
    'fu_base_folder'     => '/',
	'fu_source_path'     => dirname(__FILE__) . '/source/',
	'fu_thumbs_path'     => dirname(__FILE__) . 'thumbs/',
	'fu_source_folder'   => 'source/',
	'fu_thumbs_folder'   => 'thumbs/',
    'fu_thumbs_width'    => 120,
    'fu_thumbs_height'   => 90,
	'fu_accept_files'    => array(), # Supports: type/*, type/subtype, and extensions. For example: 'video/*', 'image/gif', '.pdf', '.rtf'
	'fu_allow_upload'    => true,
	'fu_allow_reload'    => true,
	'fu_allow_search'    => true,
	'fu_allow_preview'   => true,
	'fu_allow_delete'    => true,
	'fu_allow_download'  => true,
	'fu_allow_rename'    => true,
	'fu_allow_truncate'  => true,
	'fu_multiple_upload' => true,
	'fu_label_upload'    => 'Upload',
	'fu_label_reload'    => 'Reload',
	'fu_label_search'    => 'Search',
	'fu_label_use'       => 'Use',
	'fu_label_preview'   => 'Preview',
	'fu_label_delete'    => 'Delete',
	'fu_label_download'  => 'Download',
	'fu_label_rename'    => 'Rename',
	'fu_label_truncate'  => 'Delete all',
	'fu_label_no_files'  => 'File(s) not found.',
	'fu_label_dragdrop'  => 'Drop files here or click to upload.',
	'fu_label_uploading' => 'Uploading...',
	'fu_label_loading'   => 'Loading...',
	'fu_label_trunc_msg' => 'Are you sure you want to delete all files?',
	'fu_label_del_msg'   => 'Are you sure you want to delete selected file?',
	'fu_label_rename_f'  => 'Rename file',
	'fu_label_file_name' => 'Name',
	'fu_label_rename_bt' => 'Rename',
	'fu_label_cancel_bt' => 'Cancel',
	'fu_label_no_accept' => 'Sorry, no single file type is accepted.',
	'fu_label_size_err'  => 'The uploaded file is {X} bytes which exceeds the limit of {Y} bytes.',
	'fu_label_post_err'  => 'POST Content-Length of {X} bytes exceeds the limit of {Y} bytes.',
);

/* ---------------------------------------- */

foreach ($pj_paths as $pj_path)
{
	$pj_filemanager_config = $pj_path . 'filemanager.inc.php';
	if (is_file($pj_filemanager_config))
	{
		include $pj_filemanager_config;
		break;
	}
}

return $config;