<?php
$name = $config['fu_multiple_upload'] && !$is_safari ? 'userfile[]' : 'userfile';
?>
<!doctype html>
<html>
<head>
	<title>File uploader</title>
	<meta charset="utf-8">
	<link rel="stylesheet" href="web/css/app.css">
</head>
<body>
	<div class="container">
        <nav class="navbar">
        <?php 
        if ($config['fu_allow_upload'])
        {
        	?><button type="button" class="btn btn-icon btn-labeled btn-upload"><i class="icon icon-upload"></i><label><?php echo htmlspecialchars($config['fu_label_upload']); ?></label></button>
        	<?php
        }
        if ($config['fu_allow_reload'])
        {
        	?><button type="button" class="btn btn-icon btn-labeled btn-reload"><i class="icon icon-reload"></i><label><?php echo htmlspecialchars($config['fu_label_reload']); ?></label></button>
        	<?php
        }
        if ($config['fu_allow_truncate'])
        {
        	?><button type="button" class="btn btn-icon btn-labeled btn-truncate"><i class="icon icon-delete"></i><label><?php echo htmlspecialchars($config['fu_label_truncate']); ?></label></button>
        	<?php
        }
        if ($config['fu_allow_search'])
        {
        	?>
        	<form action="" method="get" class="form-search">
        		<input type="text" name="q" placeholder="<?php echo htmlspecialchars($config['fu_label_search']); ?>" class="form-control"><button type="submit" class="btn btn-icon btn-search" title="Search"><i class="icon icon-search"></i></button>
       		</form>
        	<?php
        }
        ?>
        </nav>
        <?php 
        if ($config['fu_allow_upload'] && $have_allowed)
        {
        	?>
	        <form action="" method="post" enctype="multipart/form-data" class="upload">
	        	<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo pjUtil::getMaxFilesize(); ?>">
	        	<input type="file" id="userfile"
	        		name="<?php echo $name; ?>" 
	        		accept="<?php echo htmlspecialchars(join(',', $config['fu_accept_files'])); ?>"<?php echo $config['fu_multiple_upload'] && !$is_safari ? ' multiple' : NULL; ?>>
	        </form>
	        <?php 
        }
        ?>
		<div id="app"></div>
	</div>
	<script src="web/js/app.js"></script>
	<script>
	(function () {
		var opts = <?php echo json_encode($config); ?>;
		opts.opener = <?php echo isset($_GET['opener']) && $_GET['opener'] == 1 ? 1 : 0; ?>;
		opts.type = "<?php echo isset($_GET['type']) && !empty($_GET['type']) ? $_GET['type'] : ''; ?>";
		opts.upload_max_filesize = <?php echo json_encode(pjUtil::getMaxFilesize()); ?>;
		opts.post_max_size = <?php echo json_encode(pjUtil::getPostMaxSize()); ?>;
		pjFileUploader(opts);
	})();
	</script>
</body>
</html>