BEGIN;

DROP TABLE IF EXISTS `floorplan_floorplans`;
CREATE TABLE IF NOT EXISTS `floorplan_floorplans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `original_image` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `floorplan_sections`;
CREATE TABLE IF NOT EXISTS `floorplan_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `floorplan_id` int(10) unsigned DEFAULT NULL,
  `top` smallint(5) unsigned DEFAULT NULL,
  `left` smallint(5) unsigned DEFAULT NULL,
  `width` smallint(5) unsigned DEFAULT NULL,
  `height` smallint(5) unsigned DEFAULT NULL,
  `type` enum('image','info') DEFAULT NULL,
  `image_id` int(10) unsigned DEFAULT NULL,
  `deg` int(10) DEFAULT NULL,
  `transform` varchar(255) DEFAULT NULL,
  `position` varchar(50) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `size` varchar(255) DEFAULT NULL,
  `dimensions` varchar(255) DEFAULT NULL,
  `info` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `floorplan_id` (`floorplan_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `floorplan_fields`;
CREATE TABLE IF NOT EXISTS `floorplan_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `floorplan_multi_lang`;
CREATE TABLE IF NOT EXISTS `floorplan_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `floorplan_options`;
CREATE TABLE IF NOT EXISTS `floorplan_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `floorplan_roles`;
CREATE TABLE IF NOT EXISTS `floorplan_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `floorplan_users`;
CREATE TABLE IF NOT EXISTS `floorplan_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `floorplan_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(480, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(481, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(482, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(483, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(484, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(485, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(486, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(487, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(488, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(489, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(490, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(491, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(492, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(493, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(639, 'menuFloorplans', 'backend', 'Menu / Floor plans', 'script', NULL),
(640, 'infoFloorplansTitle', 'backend', 'Infobox / Floor plans list', 'script', NULL),
(641, 'infoFloorplansDesc', 'backend', 'Infobox / List of floorplans', 'script', NULL),
(642, 'btnAddFloorplan', 'backend', 'Button / + Add floor plan', 'script', NULL),
(643, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(644, 'lblFloorplan', 'backend', 'Label / Floorplan', 'script', NULL),
(645, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(646, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(647, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(648, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(649, 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
(650, 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
(651, 'error_titles_ARRAY_AF05', 'arrays', 'error_titles_ARRAY_AF05', 'script', NULL),
(652, 'error_bodies_ARRAY_AF05', 'arrays', 'error_bodies_ARRAY_AF05', 'script', NULL),
(653, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(654, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(655, 'error_titles_ARRAY_AF09', 'arrays', 'error_titles_ARRAY_AF09', 'script', NULL),
(656, 'error_bodies_ARRAY_AF09', 'arrays', 'error_bodies_ARRAY_AF09', 'script', NULL),
(657, 'infoAddFloorplanTitle', 'backend', 'Infobox / Add floor plan', 'script', NULL),
(658, 'infoAddFloorplanDesc', 'backend', 'Infobox / Add floor plan', 'script', NULL),
(659, 'tabFloorplan', 'backend', 'Tab / Floor plan', 'script', NULL),
(660, 'tabImages', 'backend', 'Tab / Images', 'script', NULL),
(661, 'infoUpdateFloorplanTitle', 'backend', 'Infobox / Edit floor plan', 'script', NULL),
(662, 'infoUpdateFloorplanDesc', 'backend', 'Infobox / Update floorplan', 'script', NULL),
(663, 'infoImagesTitle', 'backend', 'Infobox / Images', 'script', NULL),
(664, 'infoImagesDesc', 'backend', 'Infobox / Images', 'script', NULL),
(665, 'btnDeleteFloorplan', 'backend', 'Button / Delete floor plan', 'script', NULL),
(666, 'lblAdd', 'backend', 'Label / Add', 'script', NULL),
(667, 'lblRotationDegree', 'backend', 'Label / Rotation degree', 'script', NULL),
(668, 'lblSize', 'backend', 'Label / Size', 'script', NULL),
(669, 'buttons_ARRAY_save', 'arrays', 'buttons_ARRAY_save', 'script', NULL),
(670, 'lblUpdate', 'backend', 'Label / Edit camera icon & image', 'script', NULL),
(671, 'lblImagePosition', 'backend', 'Label / Image tooltip position', 'script', NULL),
(672, 'position_ARRAY_top_left', 'arrays', 'position_ARRAY_top_left', 'script', NULL),
(673, 'position_ARRAY_top_center', 'arrays', 'position_ARRAY_top_center', 'script', NULL),
(674, 'position_ARRAY_top_right', 'arrays', 'position_ARRAY_top_right', 'script', NULL),
(675, 'position_ARRAY_bottom_right', 'arrays', 'position_ARRAY_bottom_right', 'script', NULL),
(676, 'position_ARRAY_bottom_center', 'arrays', 'position_ARRAY_bottom_center', 'script', NULL),
(677, 'position_ARRAY_bottom_left', 'arrays', 'position_ARRAY_bottom_left', 'script', NULL),
(678, 'lblDimensions', 'backend', 'Label / Dimensions', 'script', NULL),
(679, 'lblInfo', 'backend', 'Label / Description', 'script', NULL),
(680, 'lblDeleteFloorplanConfirm', 'backend', 'Label / Delete floor plan confirmation', 'script', NULL),
(681, 'lblInstallJs1_title', 'backend', 'Label / Install title', 'script', NULL),
(682, 'lblInstallJs1_body', 'backend', 'Label / Install body', 'script', NULL),
(683, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(684, 'infoPreviewTitle', 'backend', 'Label / Preview front end', 'script', NULL),
(685, 'infoPreviewDesc', 'backend', 'Label / Preview front end', 'script', NULL),
(686, 'infoThemeTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(687, 'infoThemeDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(688, 'lblInstallTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(689, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(690, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(691, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(692, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(693, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(694, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(695, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(696, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(697, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(698, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(699, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(700, 'btnUseThisTheme', 'backend', 'Label / Use this theme', 'script', NULL),
(701, 'infoGeneralOptionTitle', 'backend', 'General options', 'script', NULL),
(702, 'infoGeneralOptionDesc', 'backend', 'General options', 'script', NULL),
(703, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(704, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(705, 'front_size', 'frontend', 'Label / Size', 'script', NULL),
(706, 'front_dimensions', 'frontend', 'Label / Dimensions', 'script', NULL),
(707, 'buttons_ARRAY_resize', 'arrays', 'buttons_ARRAY_resize', 'script', NULL),
(708, 'btnResizeImage', 'backend', 'Button / Resize floor plan', 'script', NULL),
(709, 'lblCurrentImageSize', 'backend', 'Label / Current image size', 'script', NULL),
(710, 'lblNewWidth', 'backend', 'Label / New width', 'script', NULL),
(711, 'lblNewHeight', 'backend', 'Label / New height', 'script', NULL),
(712, 'lblSelectFloorplan', 'backend', 'Label / Select floor plan', 'script', NULL),
(713, 'lblNoFloorplansMessage', 'backend', 'Label / No floorplans found.', 'script', NULL),
(714, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(715, 'btnGetInstallCode', 'backend', 'Button / Get Install Code', 'script', NULL),
(716, 'menuInstallPreview', 'backend', 'Menu / Install & Preview', 'script', NULL),
(717, 'lblImages', 'backend', 'Label / Images', 'script', NULL),
(718, 'lblSelectAnImage', 'backend', 'Label / Select an image', 'script', NULL),
(719, 'lblFieldRequired', 'backend', 'Label / This field is required.', 'script', NULL),
(720, 'lblNoImagesMessage', 'backend', 'Label / No images found.', 'script', NULL),
(721, 'lblEmailInvalid', 'backend', 'Label / Email is invalid.', 'script', NULL),
(722, 'front_floorplan_not_exist', 'frontend', 'Label / The floorplan does not exist.', 'script', NULL),
(723, 'error_titles_ARRAY_AF07', 'arrays', 'error_titles_ARRAY_AF07', 'script', NULL),
(724, 'error_bodies_ARRAY_AF07', 'arrays', 'error_bodies_ARRAY_AF07', 'script', NULL),
(725, 'error_titles_ARRAY_AF10', 'arrays', 'error_titles_ARRAY_AF10', 'script', NULL),
(727, 'error_bodies_ARRAY_AF10', 'arrays', 'error_bodies_ARRAY_AF10', 'script', NULL),
(728, 'lblRestoreImage', 'backend', 'Label / Restore image', 'script', NULL),
(729, 'lblOriginalSize', 'backend', 'Label / Original size', 'script', NULL),
(730, 'lblCameraIcon', 'backend', 'Label / Camera icon', 'script', NULL),
(731, 'lblInfoBox', 'backend', 'Label / Infobox', 'script', NULL),
(732, 'lblUpdate2', 'backend', 'Label / Edit infobox', 'script', NULL),
(733, 'role_arr_ARRAY_admin', 'arrays', 'role_arr_ARRAY_admin', 'script', NULL),
(734, 'role_arr_ARRAY_editor', 'arrays', 'role_arr_ARRAY_editor', 'script', NULL),
(735, 'error_titles_ARRAY_AF06', 'arrays', 'error_titles_ARRAY_AF06', 'script', NULL),
(736, 'error_bodies_ARRAY_AF06', 'arrays', 'error_bodies_ARRAY_AF06', 'script', NULL),
(737, 'error_titles_ARRAY_AF11', 'arrays', 'error_titles_ARRAY_AF11', 'script', NULL),
(738, 'error_bodies_ARRAY_AF11', 'arrays', 'error_bodies_ARRAY_AF11', 'script', NULL);

INSERT INTO `floorplan_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next ', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Below you can see all users who have access to the Interactive Floor Plan admin panel. There are two types of users - Administrators and Editors. Click on "+ Add user" to add a new user.', 'script'),
(NULL, 482, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'You can add a new Administrator who has full access to the back-end system and can add other users; or an Editor who will only be able to access the Floor plans.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'You can make any change to the form below. Just click "Save" to update the user information.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Here you can set the General options for the Menu Builder.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Floor plans', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Floor plans list', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Below is a list of all floor plans. To add a new floor plan, just click on "+ Add floor plan". Click on the pencil icon of the corresponding floor plan entry to view more details.', 'script'),
(NULL, 642, 'pjField', 1, 'title', '+ Add floor plan', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Floor plan', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Floor plan updated!', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Changes made on floor plan have been saved.', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Floor plan added!', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Floor plan has been added into the system.', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Floor plan not added!', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Floor plan could not be added. Please try again.', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Floor plan not added!', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Floor plan could not be added because the post content is greater than {MAXSIZE}.', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Floor plan not found!', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Floor plan you are looking is missing. Please try again.', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Floor plan not updated!', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Floor plan could not be updated because the post content is greater than {MAXSIZE}. Please try again.', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Add floor plan', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Fill in the fields below and click "Save" to add a new floor plan. Click "Browse" to upload your floor plan (.jpg, .png, .gif files up to {MAXSIZE}). After this you can set more details for your new floor plan. Enable/disable the floor plan from the "Status" menu.', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Floor plan', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Images', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Edit floor plan', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Rename the floor plan, if necessary. Delete and replace the floor plan you have previously uploaded or just resize the image. Select the icon you would like to add. <br/> \r\n<br/>\r\nClick to add a new camera icon and show image. Rotate the camera icon; resize it by clicking on the bottom right corner and drag & drop to move it. Click on the camera icon to select image, specify rotation degree, size and set tooltip position. <br/> \r\n <br/> \r\nUse the same logic to add an infobox. Add title, size, dimensions and short description. You can rename the "Size" and "Dimensions" fields and add your own parameters from Options/Languages.', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Images', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Upload as many images as you need for this floor plan. You can resize, crop, rotate, watermark and compress the images. Drag & drop to rearrange them.', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Delete floor plan', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Add / Edit', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Rotation degree', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Size', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'Edit camera icon & image', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Image tooltip position', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Top left', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Top center', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Top right', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Bottom right', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Bottom center', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Bottom left', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Dimensions', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'If you delete the floor plan image, it will also delete all hotspots. Are you sure that you want to delete floorplan image?', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Install instructions', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Copy the code below and paste it on the web page where you want the floor plan to appear. The code can be placed just before the closing body tag of your web page.', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Here you can make the general settings for the Interactive Floor Plan script.', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Size', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Dimensions', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Resize', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Resize floor plan', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Current image size', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'New width', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'New height', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Select floor plan', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'No floor plans found. Click {STAG}here{ETAG} to add one.', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Get Install Code', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Images', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Select an image', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'No images found. {STAG}Upload images{ETAG}', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'The floor plan does not exist.', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Floor plan image not uploaded!', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'Floor plan title was added, but the floor plan image could not be uploaded because the image size is greater than {POSTSIZE}.', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'Floor plan image not uploaded!', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Floor plan title was updated, but the floor plan image could not be uploaded because the image size is greater than {POSTSIZE}.', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'Restore image', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Original size', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Camera icon', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'Infobox', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Edit infobox', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'Admin', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Floor plan image not uploaded!', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Floor plan title has been saved, but floor plan file could not be uploaded because the selected file is not an image. Please check file extension again. Only images files are allowed.', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Floor plan image not uploaded!', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Floor plan title was updated, but the floor plan file could not be uploaded because the selected file is not an image. Please check file extension again. Only images files are allowed.', 'script');

INSERT INTO `floorplan_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 5, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 6, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 7, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 8, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 10, 0, NULL),

(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `floorplan_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

COMMIT;