<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{MAXSIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		$bodies_text = str_replace("{POSTSIZE}", ini_get('upload_max_filesize'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminFloorplans&amp;action=pjActionUpdate" method="post" id="frmUpdateFloorplan" class="pj-form form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="floorplan_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabFloorplan'); ?></a></li>
				<li><a href="#tabs-2"><?php __('tabImages'); ?></a></li>
			</ul>
			<div id="tabs-1">
				<?php
				pjUtil::printNotice(__('infoUpdateFloorplanTitle', true), __('infoUpdateFloorplanDesc', true), false);
				?>
				<div class="clear_both">
					<p>
						<label class="title"><?php __('lblTitle'); ?></label>
						<span class="inline_block">
							<input type="text" name="title" id="title" value="<?php echo pjSanitize::html($tpl['arr']['title']);?>" class="pj-form-field w250 float_left r4 required" data-msg-required="<?php __('lblFieldRequired');?>"/>
							<a href="preview.php?floorplan_id=<?php echo $tpl['arr']['id']; ?>" class="pjFmPreview" target="_blank"></a>
						</span>
					</p>
					<?php
					$floorplan = $tpl['arr']['image'];
					if (is_file($floorplan))
					{
						$size = getimagesize($floorplan);
						?>
						<p>
							<label class="title"><?php __('lblFloorplan'); ?></label>
							<span class="inline_block">
								<input type="button" value="<?php __('btnDeleteFloorplan'); ?>" class="pj-button pj-delete-floorplan" data-id="<?php echo $tpl['arr']['id']?>"/>
								<input type="button" value="<?php __('btnResizeImage'); ?>" class="pj-button pj-resize-floorplan" data-id="<?php echo $tpl['arr']['id']?>"/>
							</span>
						</p>
						<p>
							<label class="title"><?php __('lblAdd'); ?></label>
							<span class="inline_block">
								<span class="block t5 float_left r20"><input type="radio" id="image" name="type" value="image" checked="checked" class="float_left r3"/><label for="image"><?php __('lblCameraIcon');?></label></span>
								<span class="block t5 float_left r20"><input type="radio" id="info" name="type" value="info"  class="float_left r3"/><label for="info"><?php __('lblInfoBox');?></label></span>
							</span>
						</p>
						<div class="fmFloorplanHolder">
							<div id="floorplanHolder" data-id="<?php echo $tpl['arr']['id']?>" style="position: relative; overflow: hidden; width: <?php echo $size[0]; ?>px; height: <?php echo $size[1]; ?>px; margin: 0 auto;">
								<img id="floorplan" src="<?php echo $floorplan; ?>" alt="" style="margin: 0; border: none; position: absolute; top: 0; left: 0; z-index: 500" />
								<?php
								foreach ($tpl['section_arr'] as $section)
								{
									if($section['type'] == 'image')
									{
										?>
										<div class="fmDraggable" data-id="<?php echo $section['id'];?>" data-type="<?php echo $section['type'];?>" style="left: <?php echo $section['left']; ?>px; top: <?php echo $section['top']; ?>px; width:<?php echo $section['width']; ?>px; heigth:<?php echo $section['height']; ?>px;">
											<span id="fmRect_<?php echo $section['id'];?>" data-id="<?php echo $section['id'];?>" data-deg="<?php echo $section['deg'];?>" data-type="<?php echo $section['type'];?>" class="fmRect fmCameraIcon fmIcons" style="width:<?php echo $section['width']; ?>px; height:<?php echo $section['height']; ?>px;"><span class="fmClose" data-id="<?php echo $section['id'];?>">X</span></span>
										</div>
										<?php
									}else{
										?>
										<span id="fmRect_<?php echo $section['id'];?>" data-id="<?php echo $section['id'];?>" data-type="<?php echo $section['type'];?>" class="fmInfoIcon fmIcons" style="left: <?php echo $section['left']; ?>px; top: <?php echo $section['top']; ?>px;"></span>
										<?php
									}
								}
								?>
							</div>
						</div>
						<?php
					}else{
						?>
						<p>
							<label class="title"><?php __('lblFloorplan'); ?></label>
							<span class="inline_block">
								<input type="file" name="image" id="image" class="pj-form-field w250 required" data-msg-required="<?php __('lblFieldRequired');?>"/>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title"><?php __('lblStatus'); ?></label>
						<span class="inline_block">
							<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('lblFieldRequired');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								foreach (__('u_statarr', true) as $k => $v)
								{
									?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
								}
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminFloorplans&action=pjActionIndex';" />
					</p>
				</div>
			</div><!-- Tab-1 -->
			<div id="tabs-2">
				<?php
				pjUtil::printNotice(__('infoImagesTitle', true), __('infoImagesDesc', true));
				?>
				<div id="gallery"></div>
			</div>
		</div>
	</form>
	
	<div id="dialogUpdateSection" title="<?php __('lblUpdate');?>" data-title1="<?php __('lblUpdate');?>" data-title2="<?php __('lblUpdate2');?>"></div>
	
	<div id="dialogDelete" title="<?php __('btnDeleteFloorplan'); ?>" style="display:none"><p><?php __('lblDeleteFloorplanConfirm'); ?></p></div>
	
	<div id="dialogResizeImage" title="<?php __('btnResizeImage');?>">
		<?php
		$size = getimagesize($floorplan);
		?>
		<form action="" method="post" id="frmResizeImage" class="pj-form form" autocomplete="off">
			<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
			<?php
			if(!empty($tpl['arr']['original_image']))
			{ 
				$original = getimagesize($tpl['arr']['original_image']);
				?>
				<p>
					<label class="title"><?php __('lblOriginalSize'); ?></label>
					<span class="inline_block">
						<label class="block t5"><?php echo $original[0]; ?>px x <?php echo $original[1]; ?>px <?php if($original[0] != $size[0] || $original[1] != $size[1]) {?>&nbsp;&nbsp;(<a href="#" class="pjFmRestoreImage" data-id="<?php echo $tpl['arr']['id'];?>"><?php __('lblRestoreImage'); ?></a>)<?php }?></label>
					</span>
				</p>
				<?php
			} 
			?>
			<p>
				<label class="title"><?php __('lblCurrentImageSize'); ?></label>
				<span class="inline_block">
					<label class="block t5"><?php echo $size[0]; ?>px x <?php echo $size[1]; ?>px</label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblNewWidth'); ?></label>
				<span class="inline_block">
					<input type="text" id="new_width" name="new_width" class="pj-form-field w100" data-width="<?php echo $size[0];?>" data-height="<?php echo $size[1];?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblNewHeight'); ?></label>
				<span class="inline_block">
					<input type="text" id="new_height" name="new_height" class="pj-form-field w100" readonly="readonly"/>
				</span>
			</p>
		</form>
	</div>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
	$tab_id = explode("-", $_GET['tab_id']);
	$tab_id = (int) $tab_id[1] - 1;
	$tab_id = $tab_id < 0 ? 0 : $tab_id;
	?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>