var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var tabs = ($.fn.tabs !== undefined),
			spinner = ($.fn.spinner !== undefined),
			tipsy = ($.fn.tipsy !== undefined),
			$tabs = $("#tabs");
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		if (spinner) {
			$(".field-int").spinner({
				min: 0
			});
		}
		if (tipsy) {
			$(".option-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
				}
			});
		}).on("click", ".pj-button-preview", function (e) {
			if($('#floorplan_id').length > 0)
			{
				var floorplan_id = $('#floorplan_id').val();
				
				if(floorplan_id != '')
				{
					$('#floorplan_id').removeClass('pjPcRedBorder');
					window.open("preview.php?floorplan_id=" + floorplan_id);
				}else{
					$('#floorplan_id').addClass('pjPcRedBorder');
				}
			}
		}).on("change", "#floorplan_id", function (e) {
			reDrawCode.call(null, 0);
		}).on("click", ".pj-button-get-code", function (e) {
			reDrawCode.call(null, 1);
		});
		
		function reDrawCode(open) {
			var code = $("#hidden_code").text(),
				floorplan_id = $("select[name='floorplan_id']").find("option:selected").val(),
				floorplan_id = parseInt(floorplan_id, 10) > 0 ? "&floorplan_id=" + floorplan_id : "";
			
			code = code.replace(/&action=pjActionLoadJS/g, function(match) {
	            return ["&action=pjActionLoad", floorplan_id].join("");
	        });
			
			$("#install_code").text(code);
			if($('#floorplan_id').length > 0)
			{
				var floorplan_id = $('#floorplan_id').val(),
					theme = $('#theme').val();
				if(floorplan_id != '')
				{
					if(open == 1)
					{
						$('#step_container').show();
					}
					$('#floorplan_id').removeClass('pjPcRedBorder');
				}else{
					$('#step_container').hide();
					$('#floorplan_id').addClass('pjPcRedBorder');
				}
			}
		}
	});
})(jQuery_1_8_2);