/*!
 * Floorplan Manager Script v1.0
 * https://www.phpjabbers.com/interactive-floor-plan-software/
 * 
 * Copyright 2015, StivaSoft Ltd.
 * 
 */
(function (window, undefined){
	"use strict";
	
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	
	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined),
		datepicker = (pjQ.$.fn.datepicker !== undefined),
		dialog = (pjQ.$.fn.dialog !== undefined),
		routes = [
		          	
		          ];
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadEvents");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function FloorplanManager(opts) {
		if (!(this instanceof FloorplanManager)) {
			return new FloorplanManager(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	FloorplanManager.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	FloorplanManager.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	FloorplanManager.prototype = {
		reset: function () {
			this.$container = null;
			this.container = null;
			this.opts = {};
			
			return this;
		},
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("fmContainer_" + this.opts.index);
			this.$container = pjQ.$(this.container),
						
			pjQ.$(window).on("loadMain", this.container, function (e) {
				self.loadMain.call(self);
			});
			
			if (window.location.hash.length === 0) {
				this.loadMain.call(this);
			} else {
				onHashChange.call(null);
			}
		},
		
		loadMain: function () {
			var self = this,
				index = this.opts.index,
				params = 	{"index": this.opts.index};
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionMain"].join(""), params).done(function (data) {
				self.$container.html(data);
				
				if (pjQ.$('.sliderThumbs').length) {
					var $images = pjQ.$('.cameras .camera').find('.popupTrigger');
					
					pjQ.$('.thumb').on('mouseenter mouseleave', function(e) {
						var $currentThumbImageSrc = pjQ.$(this).find('img').attr('src');
						var $currentCamera = pjQ.$('.cameras').find('img[src="' + $currentThumbImageSrc + '"]').parents('.camera');
						var $currentCameraImage = $currentCamera.find('.cameraImage');
						if ($currentCamera.length) {
							if (e.type === 'mouseenter') {
								$currentCamera.css('opacity', 1);
								$currentCameraImage.css('margin', 0).css('opacity', 1).css('transform', 'scale(1)');
							} else if (e.type === 'mouseleave') {
								$currentCamera.css('opacity', '');
								$currentCameraImage.css('margin', '').css('opacity', '').css('transform', '');
							};
						};
					});

					pjQ.$('.sliderThumbs .slides').carouFredSel({
						width: '100%',
						items: {
							visible: 'variable',
							width: 140,
							height: 140
						},
						scroll: {
							items: 1,
							pauseOnHover: true,
							duration: 1000
						},
						prev: {
							button: function(){
								return pjQ.$(this).parents('.sliderThumbs').find('.sliderPrev');
							}
						},
						next: {
							button: function(){
								return pjQ.$(this).parents('.sliderThumbs').find('.sliderNext');
							}
						}
					});
				};

				if (pjQ.$('.popupTrigger').length) {
					pjQ.$('.popupTrigger').colorbox({
						rel: function() {
							return pjQ.$(this).attr('data-imageGroup');
						},
						slideshow: false,
						slideshowSpeed: 3000
					});
				};
				
				pjQ.$( ".roomInfo" ).each(function(e){
					var _height = parseInt(pjQ.$(this).attr('data-height'), 10),
						_pos = pjQ.$(this).position(),
						_top = _pos.top,
						top = 0;
					var $inner = pjQ.$(this).find('.roomInfoInner').eq(0); 
					var innerHeight = parseInt($inner.height(), 10) + 20;
					var _tmp = parseInt(innerHeight / 2, 10);
					
					if(_top < _tmp + 20)
					{
						top = top - _top;
					}else if((_top + _tmp + 20) > _height){
						top = top - _tmp - 20;
					}else{
						top = top - _tmp + 20;
					}
					$inner.css({'top': top + 'px', 'height': innerHeight + 'px'});
				});
				  	
			}).fail(function () {
				self.enableButtons.call(self);
			});
		}
	};
	
	window.FloorplanManager = FloorplanManager;	
})(window);