<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminImages extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminImages&action=pjActionIndex&err=AI09");
			}
			if (isset($_POST['image_create']))
			{
				$pjMainImageModel = pjMainImageModel::factory();
				
				$id = $pjMainImageModel->setAttributes($_POST)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AI03';
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjMainImage', 'data');
					}
					
					if (isset($_FILES['image']))
					{
						if($_FILES['image']['error'] == 0)
						{
							if(getimagesize($_FILES['image']["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
									if ($Image->load($_FILES['image']))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$hash = md5(uniqid(rand(), true));
											$thumb_path = PJ_UPLOAD_PATH . 'gallery/thumbs/' . $id . '_' . $hash . '.' . $Image->getExtension();
											$image_path = PJ_UPLOAD_PATH . 'gallery/' . $id . '_' . $hash . '.' . $Image->getExtension();
												
											$data = array();
											$data['thumb_path'] = $thumb_path;
											$data['image_path'] = $image_path;
											
											$Image->loadImage($_FILES['image']["tmp_name"]);
											$Image->saveImage($image_path);
											$Image->resizeSmart(100, 67);
											$Image->saveImage($thumb_path);
					
											$pjMainImageModel->reset()->where('id', $id)->limit(1)->modifyAll($data);
										}
									}
								}
							}else{
								$err = 'AI12';
							}
						}else if($_FILES['image']['error'] != 4){
							$err = 'AI11';
						}
					}
				} else {
					$err = 'AI04';
				}
				if($err == 'AI03' || $err == 'AI11' || $err == 'AI12')
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminImages&action=pjActionUpdate&id=$id&err=$err");
				}else{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminImages&action=pjActionIndex&err=$err");
				}
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminImages.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$pjMainImageModel = pjMainImageModel::factory();
			$arr = $pjMainImageModel->find($_GET['id'])->getData();
			if ($pjMainImageModel->reset()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				if (file_exists(PJ_INSTALL_PATH . $arr['thumb_path']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['thumb_path']);
				}
				if (file_exists(PJ_INSTALL_PATH . $arr['image_path']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['image_path']);
				}
				pjMultiLangModel::factory()->where('model', 'pjMainImage')->where('foreign_id', $_GET['id'])->eraseAll();
				
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteImageBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjMainImageModel = pjMainImageModel::factory();
				$arr = $pjMainImageModel->whereIn('id', $_POST['record'])->findAll()->getData();
				foreach($arr as $v)
				{
					if (file_exists(PJ_INSTALL_PATH . $v['thumb_path'])) {
						@unlink(PJ_INSTALL_PATH . $v['thumb_path']);
					}
					if (file_exists(PJ_INSTALL_PATH . $v['image_path'])) {
						@unlink(PJ_INSTALL_PATH . $v['image_path']);
					}
				}
				$pjMainImageModel->reset()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjMainImage')->whereIn('foreign_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjMainImageModel = pjMainImageModel::factory()->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjMainImage' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjMainImageModel->where("(t2.content LIKE '%$q%')");
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjMainImageModel->where('t1.status', $_GET['status']);
			}
			
			$column = 'title';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjMainImageModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjMainImageModel
				->select("t1.*, t2.content AS title, (SELECT COUNT(`TH`.id) FROM `".pjHotspotModel::factory()->getTable()."` AS `TH` WHERE `TH`.image_id=t1.id) AS hotspots")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
				
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminImages.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjMainImageModel = pjMainImageModel::factory();
			if (!in_array($_POST['column'], $pjMainImageModel->getI18n()))
			{
				$pjMainImageModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjMainImage', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminImages&action=pjActionIndex&err=AI09");
			}
			if (isset($_POST['image_update']))
			{
				$pjMainImageModel = pjMainImageModel::factory();
				
				$err = 'AI01';
				
				$arr = $pjMainImageModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminImages&action=pjActionIndex&err=AI08");
				}
				
				$data = array();
				
				if (isset($_FILES['image']))
				{
					if($_FILES['image']['error'] == 0)
					{
						if(getimagesize($_FILES['image']["tmp_name"]) != false)
						{
							$Image = new pjImage();
							if ($Image->getErrorCode() !== 200)
							{
								$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
								if ($Image->load($_FILES['image']))
								{
									$resp = $Image->isConvertPossible();
									if ($resp['status'] === true)
									{
										if(!empty($arr['thumb_path']))
										{
											@unlink(PJ_INSTALL_PATH . $arr['thumb_path']);
										}
										if(!empty($arr['image_path']))
										{
											@unlink(PJ_INSTALL_PATH . $arr['image_path']);
										}
				
										$hash = md5(uniqid(rand(), true));
										$thumb_path = PJ_UPLOAD_PATH . 'gallery/thumbs/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
										$image_path = PJ_UPLOAD_PATH . 'gallery/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
				
										$Image->loadImage($_FILES['image']["tmp_name"]);
										$Image->saveImage($image_path);
										$Image->resizeSmart(100, 67);
										$Image->saveImage($thumb_path);
				
										$data['thumb_path'] = $thumb_path;
										$data['image_path'] = $image_path;
									}
								}
							}
						}else{
							$err = 'AI12';
						}
					}else if($_FILES['image']['error'] != 4){
						$err = 'AI11';
					}
				}
				
				pjMainImageModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjMainImage', 'data');
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminImages&action=pjActionUpdate&id=".$_POST['id']."&err=$err");
				
			} else {
				$arr = pjMainImageModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminImages&action=pjActionIndex&err=AI08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjMainImage');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->set('hotspot_arr', pjHotspotModel::factory()->where('image_id', $_GET['id'])->orderBy("t1.id ASC")->findAll()->getData());
				
				$this->appendJs('jquery.form.js', PJ_THIRD_PARTY_PATH . 'jform/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminImages.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionRemoveImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if(isset($_POST['id']) && (int) $_POST['id'] > 0)
			{
				$pjMainImageModel = pjMainImageModel::factory();
				
				$data = array();
				$data['thumb_path'] = ':NULL';
				$data['image_path'] = ':NULL';
				$pjMainImageModel->where('id', $_POST['id'])->limit(1)->modifyAll($data);
				
				$pjHotspotModel = pjHotspotModel::factory();
				$pjMultipleImageModel = pjMultipleImageModel::factory();
				$arr = $pjHotspotModel->where('image_id', $_POST['id'])->findAll()->getData();
				foreach($arr as $k => $v)
				{
					$pjHotspotModel->deleteThumbnail($v['id']);
					$pjHotspotModel->deleteImage($v['id']);
					$pjMultipleImageModel->deleteImages($v['id']);
					
					$pjMultipleImageModel->reset()->where('hotspot_id', $v['id'])->eraseAll();
				}
				$pjHotspotModel->reset()->where('image_id', $_POST['id'])->eraseAll();
			}
			pjAppController::jsonResponse(array('status' => 'OK'));
		}
		exit;
	}
	public function pjActionAddHotSpot()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjHotspotModel = pjHotspotModel::factory();
			
			$data = array();
			$data['name'] = pjObject::escapeString($_GET['name']);
			$data['image_id'] = (int) $_GET['image_id'];
			$data['type'] = pjObject::escapeString($_GET['type']);
			$data['effect'] = '1';
			$data['icon'] = '1';
			$data['width'] = (int) $_GET['width'];
			$data['height'] = (int) $_GET['height'];
			$data['box_width'] = 100;
			$data['box_height'] = 100;
			$data['top'] = (int) $_GET['top'];
			$data['left'] = (int) $_GET['left'];
			$data['use_tooltip'] = 'T';
			
			$id = $pjHotspotModel->setAttributes($data)->insert()->getInsertId();
			if ($id !== false && (int) $id > 0)
			{
				pjAppController::jsonResponse(array('status' => 'OK', 'id' => $id));
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR'));
			}
		}
		exit;
	}
	public function pjActionUpdatePosition()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjHotspotModel = pjHotspotModel::factory();

			$arr = $pjHotspotModel->find($_GET['id'])->getData();
			
			$data = array();
			$data['width'] = (int) $_GET['width'];
			$data['height'] = (int) $_GET['height'];
			if($arr['type'] == 'box')
			{
				$data['box_width'] = (int) $_GET['width'];
				$data['box_height'] = (int) $_GET['height'];
			}
			$data['top'] = (int) $_GET['top'];
			$data['left'] = (int) $_GET['left'];

			$pjHotspotModel->reset()->where('id', $_GET['id'])->limit(1)->modifyAll($data);
			
			pjAppController::jsonResponse(array('status' => 'OK'));
		}
		exit;
	}
	public function pjActionRemoveHotSpot()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjHotspotModel = pjHotspotModel::factory();
			$pjHotspotModel->deleteThumbnail($_GET['id']);
			$pjHotspotModel->deleteImage($_GET['id']);
			pjMultipleImageModel::factory()->deleteImages($_GET['id']);
			$pjHotspotModel->reset()->setAttributes(array('id' => $_GET['id']))->erase();
			
			pjAppController::jsonResponse(array('status' => 'OK'));
		}
		exit;
	}
	public function pjActionDeleteMultiImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjMultipleImageModel = pjMultipleImageModel::factory();
			$arr = pjMultipleImageModel::factory()->find($_GET['id'])->getData();
			$image_path = $arr['image_path'];
			$thumb_path = $arr['thumb_path'];
			if (file_exists(PJ_INSTALL_PATH . $image_path)) {
				@unlink(PJ_INSTALL_PATH . $image_path);
			}
			if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
				@unlink(PJ_INSTALL_PATH . $thumb_path);
			}
			$pjMultipleImageModel->reset()->setAttributes(array('id' => $_GET['id']))->erase();
				
			pjAppController::jsonResponse(array('status' => 'OK'));
		}
		exit;
	}
	public function pjActionGetHotSpot()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if(isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjHotspotModel = pjHotspotModel::factory();
				
				$arr = $pjHotspotModel->find($_GET['id'])->getData();
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjHotSpot');
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$image_arr = pjMultipleImageModel::factory()->where('hotspot_id', $arr['id'])->findAll()->getData();
				
				$this->set('arr', $arr);
				$this->set('image_arr', $image_arr);
			}
		}
	}
	public function pjActionUpdateHotSpot()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjAppController::jsonResponse(array('status' => 'ERR', 'text' => __('lblHotSpotContentLenght', true) ));
			}
			
			if(isset($_POST['update_hotspot']))
			{
				$pjHotspotModel = pjHotspotModel::factory();
				
				$data = array();
				
				$err = 0;
				$hp = $pjHotspotModel->find($_POST['id'])->getData();
				$data['type'] = $_POST['dialog_hotspot_type'];
				$data['effect'] = $_POST['effect'];
				if($_POST['dialog_hotspot_type'] == 'icon')
				{
					$data['icon'] = $_POST['icon'];
					$data['width'] = 36;
					$data['height'] = 36;
					$top = $hp['top'] + (int)($hp['height'] / 2) - 18;
					$left = $hp['left'] + (int)($hp['width'] / 2) - 18;
					$data['top'] = $top;
					$data['left'] = $left;
					$data['box_width'] = ':NULL';
					$data['box_height'] = ':NULL';
					$data['thumbnail'] = ':NULL';
					$pjHotspotModel->deleteThumbnail($_POST['id']);
				}else if($_POST['dialog_hotspot_type'] == 'box'){
					
					$data['box_width'] = $_POST['box_width'];
					$data['box_height'] = $_POST['box_height'];
					$data['width'] = $_POST['box_width'];
					$data['height'] = $_POST['box_height'];
					
					$top = $hp['top'] + (int)($hp['height'] / 2) - (int)($_POST['box_height'] / 2);
					$left = $hp['left'] + (int)($hp['width'] / 2) - (int)($_POST['box_width'] / 2);
					$data['top'] = $top;
					$data['left'] = $left;
					
					$data['icon'] = ':NULL';
					$data['thumbnail'] = ':NULL';
					$pjHotspotModel->deleteThumbnail($_POST['id']);
				}else if($_POST['dialog_hotspot_type'] == 'thumb'){
					if (isset($_FILES['thumbnail']))
					{
						if($_FILES['thumbnail']['error'] == 0)
						{
							if(getimagesize($_FILES['thumbnail']["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
									if ($Image->load($_FILES['thumbnail']))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$pjHotspotModel->deleteThumbnail($_POST['id']);
											
											$hash = md5(uniqid(rand(), true));
											$thumbnail_path = PJ_UPLOAD_PATH . 'hotspots/thumbs/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
												
											$Image->loadImage($_FILES['thumbnail']["tmp_name"]);
											$Image->resizeSmart(100, 100);
											$Image->saveImage($thumbnail_path);
											
											$data['thumbnail'] = $thumbnail_path;
											$data['box_width'] = ':NULL';
											$data['box_height'] = ':NULL';
											$data['icon'] = ':NULL';
										}
									}
								}
							}else{
								$err = 1;
							}
						}else if($_FILES['thumbnail']['error'] != 4){
							$err = 2;
						}
					}
					$top = $hp['top'] + (int)($hp['height'] / 2) - 50;
					$left = $hp['left'] + (int)($hp['width'] / 2) - 50;
					$data['top'] = $top;
					$data['left'] = $left;
					$data['width'] = 100;
					$data['height'] = 100;
				}
				
				$data['use_tooltip'] = $_POST['use_tooltip'];
				$data['data_type'] = $_POST['data_type'];
				
				$pjMultipleImageModel = pjMultipleImageModel::factory();
				
				if($_POST['data_type'] == 'text')
				{
					$data['link'] = ':NULL';
					$data['video_url'] = ':NULL';
					$data['image_path'] = ':NULL';
					$data['thumb_path'] = ':NULL';
					$pjHotspotModel->deleteImage($_POST['id']);
					$pjMultipleImageModel->deleteImages($_POST['id']);
				}else if($_POST['data_type'] == 'link'){
					$data['link'] = $_POST['link'];
					$data['video_url'] = ':NULL';
					$data['image_path'] = ':NULL';
					$data['thumb_path'] = ':NULL';
					$pjHotspotModel->deleteImage($_POST['id']);
					$pjMultipleImageModel->deleteImages($_POST['id']);
				}else if($_POST['data_type'] == 'video'){
					$data['video_url'] = $_POST['video_url'];
					$data['link'] = ':NULL';
					$data['image_path'] = ':NULL';
					$data['thumb_path'] = ':NULL';
					$pjHotspotModel->deleteImage($_POST['id']);
					$pjMultipleImageModel->deleteImages($_POST['id']);
				}else if($_POST['data_type'] == 'image'){
					if (isset($_FILES['image']))
					{
						if($_FILES['image']['error'] == 0)
						{
							if(getimagesize($_FILES['image']["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
									if ($Image->load($_FILES['image']))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$pjHotspotModel->deleteImage($_POST['id']);
											
											$hash = md5(uniqid(rand(), true));
											$image_path = PJ_UPLOAD_PATH . 'hotspots/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
											$thumb_path = PJ_UPLOAD_PATH . 'hotspots/thumbs/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
					
											$Image->loadImage($_FILES['image']["tmp_name"]);
											$Image->saveImage($image_path);
											$Image->resizeSmart(100, 100);
											$Image->saveImage($thumb_path);
												
											$data['image_path'] = $image_path;
											$data['thumb_path'] = $thumb_path;
											$data['video_url'] = ':NULL';
											$data['link'] = ':NULL';
											$pjMultipleImageModel->deleteImages($_POST['id']);
										}
									}
								}
							}else{
								$err = 3;
							}
						}else if($_FILES['image']['error'] != 4){
							$err = 4;
						}
					}
				}else if($_POST['data_type'] == 'multi'){
					
					$files = array();
					foreach ($_FILES['images'] as $k => $l) {
						foreach ($l as $i => $v) {
							if (!array_key_exists($i, $files))
							{
								$files[$i] = array();
							}
							$files[$i][$k] = $v;
						}
					}
					$has_error = false;
					foreach ($files as $file)
					{
						if($file['error'] != 4 && $file['error'] != 0)
						{
							$has_error = true;
							$err = 5;
						}
						if(getimagesize($file["tmp_name"]) == false)
						{
							$has_error = true;
							$err = 6;
						}
					}
					
					if($has_error == false)
					{
						$data['video_url'] = ':NULL';
						$data['link'] = ':NULL';
						$data['image_path'] = ':NULL';
						$data['thumb_path'] = ':NULL';
						$pjHotspotModel->deleteImage($_POST['id']);
						foreach ($files as $file)
						{
							$hash = md5(uniqid(rand(), true));
							if(getimagesize($file["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									if ($Image->load($file))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$image_path = PJ_UPLOAD_PATH . 'images/' . $hash . '.' . $Image->getExtension();
											$thumb_path = PJ_UPLOAD_PATH . 'images/thumbs/' . $hash . '.' . $Image->getExtension();
											if ($Image->save($image_path))
											{
												$Image->loadImage($image_path);
												$Image->resizeSmart(100, 100);
												$Image->saveImage($thumb_path);
											}
								
											$image_data = array();
											$image_data['hotspot_id'] = $_POST['id'];
											$image_data['image_path'] = $image_path;
											$image_data['thumb_path'] = $thumb_path;
												
											$pjMultipleImageModel->reset()->setAttributes($image_data)->insert();
										}
									}
								}
							}
						}
					}
				}
				
				$pjHotspotModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll($data);
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjHotSpot', 'data');
				}
				
				if($err == 0)
				{
					$hp = $pjHotspotModel->reset()->find($_POST['id'])->getData();
					pjAppController::jsonResponse(array('status' => 'OK', 'text' => '', 'image_id' => $hp['image_id']));
				}else{
					$hotspot_errors = __('hotspot_errors', true);
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $hotspot_errors[$err]));
				}
			}
		}
		exit;
	}
}
?>