<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{	
	public $defaultCaptcha = 'pjIIGalery_Captcha';
	
	public $defaultLocale = 'pjIIGalery_LocaleId';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		
		self::allowCORS();
	}
	
	public function afterFilter()
	{		
		if (!isset($_GET['hide']) || (isset($_GET['hide']) && (int) $_GET['hide'] !== 1) &&
			in_array($_GET['action'], array('pjActionIndex')))
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$this->set('locale_arr', $locale_arr);
		}
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		
		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				$this->loadSetFields(true);
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionLoadCss()
	{
		$arr = array(
			array('file' => 'style.css', 'path' => PJ_CSS_PATH)
		);
		$image_id = NULL;
		if(isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			$image_id = $_GET['id'];
		}
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
				
			if ($string !== FALSE)
			{
				echo str_replace(
						array('../fonts/glyphicons', 'images/', "pjWrapper"),
						array(
								PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
								PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/',
								"pjWrapperIIGallery_" . $image_id
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
		
		if(isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			$arr = pjMainImageModel::factory()->find($_GET['id'])->getData();
		
			$this->set('arr', $arr);
		}
	}
	public function pjActionGallery()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if(isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$arr = pjMainImageModel::factory()->find($_GET['id'])->getData();
			
				$pjHotspotModel = pjHotspotModel::factory();
				$hotspot_arr = $pjHotspotModel
					->select("t1.*, t2.content as tooltip, t3.content as text")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjHotSpot' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'tooltip'", 'left')
					->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjHotSpot' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'text'", 'left')
					->where('image_id', $_GET['id'])
					->findAll()->getData();
				
				$hotspot_id_arr = $pjHotspotModel->findAll()->getDataPair(null, 'id');
				$image_arr = array();
				if(!empty($hotspot_id_arr))
				{
					$temp_image_arr = pjMultipleImageModel::factory()->whereIn('hotspot_id', $hotspot_id_arr)->findAll()->getData();
					foreach($temp_image_arr as $k => $v)
					{
						$image_arr[$v['hotspot_id']][] = $v;
					}
				}
				
				$this->set('arr', $arr);
				$this->set('hotspot_arr', $hotspot_arr);
				$this->set('image_arr', $image_arr);
			}
		}
	}
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header('P3P: CP="ALL DSP COR CUR ADM TAI OUR IND COM NAV INT"');
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
}
?>