<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjHotspotModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'hotspots';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'image_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'name', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'width', 'type' => 'smallint', 'default' => ':NULL'),
		array('name' => 'height', 'type' => 'smallint', 'default' => ':NULL'),
		array('name' => 'top', 'type' => 'smallint', 'default' => ':NULL'),
		array('name' => 'left', 'type' => 'smallint', 'default' => ':NULL'),
		array('name' => 'type', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'effect', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'thumbnail', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'icon', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'box_width', 'type' => 'smallint', 'default' => ':NULL'),
		array('name' => 'box_height', 'type' => 'smallint', 'default' => ':NULL'),
		array('name' => 'use_tooltip', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'data_type', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'thumb_path', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'image_path', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'video_url', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'link', 'type' => 'varchar', 'default' => ':NULL')
	);
	
	public $i18n = array('tooltip', 'text');
	
	public static function factory($attr=array())
	{
		return new pjHotspotModel($attr);
	}
	
	public function deleteThumbnail($hotspot_id)
	{
		$arr = $this->reset()->find($hotspot_id)->getData();
		if (file_exists(PJ_INSTALL_PATH . $arr['thumbnail'])) {
			@unlink(PJ_INSTALL_PATH . $arr['thumbnail']);
		}
	}
	public function deleteImage($hotspot_id)
	{
		$arr = $this->reset()->find($hotspot_id)->getData();
		$image_path = $arr['image_path'];
		$thumb_path = $arr['thumb_path'];
		if (file_exists(PJ_INSTALL_PATH . $image_path)) {
			@unlink(PJ_INSTALL_PATH . $image_path);
		}
		if (file_exists(PJ_INSTALL_PATH . $thumb_path)) {
			@unlink(PJ_INSTALL_PATH . $thumb_path);
		}
	}
}
?>