var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmUpdateHotSpot = $('#frmUpdateHotSpot'),
			datagrid = ($.fn.datagrid !== undefined);
		
		if($frmUpdateHotSpot.length > 0)
		{
			$frmUpdateHotSpot.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
			
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminHotSpots&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminHotSpots&action=pjActionDeleteHotSpot&id={:id}"}
				          ],
				columns: [{text: myLabel.type, type: "text", sortable: true, editable: false, width: 150},
				          {text: myLabel.use_tooltip, type: "text", sortable: true, editable: false, width: 150},
				          {text: myLabel.data_type, type: "text", sortable: true, editable: false, width: 250}],
				dataUrl: "index.php?controller=pjAdminHotSpots&action=pjActionGetHotSpot" + pjGrid.queryString,
				dataType: "json",
				fields: ['type', 'use_tooltip', 'data_type'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminHotSpots&action=pjActionDeleteHotSpotBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminHotSpots&action=pjActionSaveHotspot&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("change", "input:radio[name='dialog_hotspot_type']", function (e) {
			$('.thumbWrapper').hide();
			$('.boxWrapper').hide();
			$('.iconWrapper').hide();
			$('.thumbWrapper').find('input').removeClass('required');
			$('.boxWrapper').find('input').removeClass('required');
			var hotspot_type = $frmUpdateHotSpot.find('input[name="dialog_hotspot_type"]:checked').val();
			$('.'+hotspot_type+'Wrapper').show();
			if(hotspot_type == 'icon')
			{
				$('.iconWrapper').find('input').addClass('required');
			}
			if(hotspot_type == 'thumb')
			{
				$('.thumbWrapper').find('input').addClass('required');
			}
			if(hotspot_type == 'box')
			{
				$('.boxWrapper').find('input').addClass('required');
			}
		}).on("click", ".pjIgIcon", function (e) {
			var icon = $(this).attr('data-icon');
			$('.pjIgIcon').removeClass('active');
			$(this).addClass('active');
			$('.iconWrapper').find('input').val(icon);
		}).on("change", "input:radio[name='use_tooltip']", function (e) {
			var use_tooltip = $frmUpdateHotSpot.find('input[name="use_tooltip"]:checked').val();
			if(use_tooltip == 'T')
			{
				$('.tooltipWrapper').show();
				$('.pjIIgTooltipDefault').addClass("required");
			}else{
				$('.tooltipWrapper').hide();
				$('.pjIIgTooltip').val("");
				$('.pjIIgTooltipDefault').removeClass("required");
			}
		}).on("change", "#data_type", function (e) {
			var value = $(this).val();
			$('.dataWrapper').hide();
			$('.'+value+'Wrapper').show();
			if(value != 'text')
			{
				$('.pjIIgText').val("");
				$('.pjIIgTextDefault').removeClass("required");
			}else{
				$('.pjIIgTextDefault').addClass("required");
			}
		}).on("click", ".deleteImg", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this);
			var id = $this.attr('data-id');
			$('#dialogLoader').show();
			$.get(["index.php?controller=pjAdminImages&action=pjActionDeleteMultiImage", "&id=", id].join("")).done(function (data) {
				$this.parent().remove();
				$('#dialogLoader').hide();
			}).fail(function () {
				
			});
			return false;
		});
	});
})(jQuery_1_8_2);