var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateImage = $("#frmCreateImage"),
			$frmUpdateImage = $("#frmUpdateImage"),
			$frmUpdateHotSpot = $('#frmUpdateHotSpot'),
			$dialogUpdate = $("#dialogUpdate"),
			$dialogDel = $("#dialogDelete"),
			$dialogHotspot = $("#dialogHotspot"),
			$boxMap = $("#boxMap"),
			datagrid = ($.fn.datagrid !== undefined),
			validate = ($.fn.validate !== undefined),
			hotspot_width = 36,
			hotspot_height = 36,
			vOpts = {
				
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: '',
				invalidHandler: function (event, validator) {
				    $(".pj-multilang-wrap").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).css('display','block');
						}else{
							$(this).css('display','none');
						}
					});
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
			};
		if ($frmCreateImage.length > 0 || $frmUpdateImage.length > 0) {
			$.validator.addMethod('positiveNumber',
				function (value) { 
		        	return Number(value) > 0;
		    	}, 
		    myLabel.seat_count_greater_zero);
		}
		
		
		function collisionDetect(o) {
			var i, pos, horizontalMatch, verticalMatch, collision = false;
			$("#mapHolder").children("span").each(function (i) {
				pos = getPositions(this);
				horizontalMatch = comparePositions([o.left, o.left + o.width], pos[0]);
				verticalMatch = comparePositions([o.top, o.top + o.height], pos[1]);			
				if (horizontalMatch && verticalMatch) {
					collision = true;
					return false;
				}
			});
			if (collision) {
				return true;
			}
			return false;
		}
		function getPositions(box) {
			var $box = $(box);
			var pos = $box.position();
			var width = $box.width();
			var height = $box.height();
			return [[pos.left, pos.left + width], [pos.top, pos.top + height]];
		}
		
		function comparePositions(p1, p2) {
			var x1 = p1[0] < p2[0] ? p1 : p2;
			var x2 = p1[0] < p2[0] ? p2 : p1;
			return x1[1] > x2[0] || x1[0] === x2[0] ? true : false;
		}
		
		function getMax() {
			var tmp, index = 0;
			$("span.empty").each(function (i) {
				if (!isNaN(Number(this.title))) {
					tmp = Number(this.title);
				} else {
					tmp = parseInt($(this).attr("rel").split("_")[1], 10);
				}
				if (tmp > index) {
					index = tmp;
				}
			});
			return index;
		}
		
		function GetZoomFactor () {
            var factor = 1;
            if (document.body.getBoundingClientRect) {
                // rect is only in physical pixel size in IE before version 8 
                var rect = document.body.getBoundingClientRect ();
                var physicalW = rect.right - rect.left;
                var logicalW = document.body.offsetWidth;

                // the zoom level is always an integer percent value
                factor = Math.round ((physicalW / logicalW) * 100) / 100;
            }
            return factor;
        }
		
		function updateElem(event, ui) {
			var $this = $(this);		
			var hotspot_id = $this.attr('data-id');
			var params = {};
			params.id = hotspot_id;
			params.width = parseInt($this.width(), 10);
			params.height = parseInt($this.height(), 10);
			params.top = ui.position.top;
			params.left = ui.position.left;
			
			$.get(["index.php?controller=pjAdminImages&action=pjActionUpdatePosition"].join(""), params).done(function (data) {
							
			}).fail(function () {
				
			});
		}
		
		function initializeHotSpot(name, width, height, top, left)
		{
			var image_id = $frmUpdateImage.find('input[name="id"]').val();
			var hotspot_type = 'icon';
			var params = {};
			params.image_id = image_id;
			params.type = 'icon';
			params.name = name;
			params.width = width;
			params.height = height;
			params.top = top;
			params.left = left;

			$('#mainLoader').show();
			$.get(["index.php?controller=pjAdminImages&action=pjActionAddHotSpot"].join(""), params).done(function (data) {
				var $image_wrapper = $('#mapHolder')
				var hotspot_id = data.id;
				$('#mainLoader').hide();
				$image_wrapper.find('.rect').removeClass("rect-selected");
				$("<span>", {
					css: {
						"top": top + "px",
						"left": left + "px",
						"width": width + "px",
						"height": height + "px",
						"line-height": height + "px",
						"position": "absolute"
					},
					html: '',
					"data-id": hotspot_id,
					"data-type": hotspot_type,
					title: name
				}).addClass("rect empty info rect-selected").draggable(dragOpts).resizable({
					resize: function(e, ui) {
						var height = $(this).height();
						$(this).css("line-height", height + "px"); 
			        },
					stop: function(e, ui) {
						var height = $(this).height();
						$(this).css("line-height", height + "px"); 
						updateElem.apply(this, [e, ui]);
			        }
				}).bind("click", function (e) {
					$dialogUpdate.data('id', hotspot_id).data('init', 'no').dialog("open");
					$(this).siblings(".rect").removeClass("rect-selected").end().addClass("rect-selected");
				}).appendTo($image_wrapper);
				
				$dialogUpdate.data('id', hotspot_id).data('init', 'yes').dialog("open");
				
			}).fail(function () {
				
			});
		}
		
		if ($frmCreateImage.length > 0 && validate) {
			var validator = $frmCreateImage.submit(function() {
				
			}).validate(vOpts);
		}
		if ($frmUpdateImage.length > 0) {
			var validator = $frmUpdateImage.submit(function() {
				
			}).validate(vOpts);
			
			var offset = $("#map").offset(),
				dragOpts = {
					containment: "parent",
					stop: function (event, ui) {
						updateElem.apply(this, [event, ui]);
					}
				};
			$("span.empty").draggable(dragOpts).resizable({
				resize: function(e, ui) {
					var height = $(this).height();
					$(this).css("line-height", height + "px"); 
		        },
				stop: function(e, ui) {
					var height = $(this).height();
					$(this).css("line-height", height + "px");
					updateElem.apply(this, [e, ui]);
		        }
			}).bind("click", function (e) {
				$dialogUpdate.data('id', $(this).attr("data-id")).data('init', 'no').dialog("open");
				$(this).siblings(".rect").removeClass("rect-selected").end().addClass("rect-selected");
			});
			
			$("#mapHolder").click(function (e) {
				var px = $('.bsMapHolder').scrollLeft();
				var $this = $(this),
					index = getMax();
				
				var hotspot_type = 'icon';
				if(hotspot_type == 'box')
				{
					hotspot_width = 100;
					hotspot_height = 100;
				}
				var w = hotspot_width;
				var h = hotspot_height;
				
				var t = Math.ceil(e.pageY - offset.top - (parseInt(hotspot_height / 2, 10)));
				var l = Math.ceil(e.pageX - offset.left - (parseInt(hotspot_width / 2, 10)) + px);
				if($('.pj-form-langbar').length > 0)
				{
					t = t - 26;
				}
				var o = {top: t, left: l, width: w, height: h};
				
				if (!collisionDetect(o)) {
					index++;
					
					initializeHotSpot.apply(this, [index, w, h, t, l]);
					
				} else {
					if (window.console && window.console.log) {
						
					}
				}
			});
			
			if ($dialogUpdate.length > 0) {
				var seat_id = null;
				$dialogUpdate.dialog({
					autoOpen: false,
					resizable: false,
					draggable: false,
					modal: true,
					width: 650,
					position: ['center',70], 
					open: function () {
						var hotspot_id = $(this).data("id");
						var init = $(this).data("init");
						$.get(["index.php?controller=pjAdminImages&action=pjActionGetHotSpot", "&id=", hotspot_id].join("")).done(function (data) {
							$frmUpdateHotSpot.html(data);
							if (validate) {
								$frmUpdateHotSpot.validate({
									errorPlacement: function (error, element) {
										error.insertAfter(element.parent());
									},
									onkeyup: false,
									errorClass: "err",
									wrapper: "em",
									ignore: "",
									submitHandler: function (form) {
										var ajax_options = { 
									        success: function(resp){
									        	if(resp.status == 'OK')
									        	{
									        		window.location.href='index.php?controller=pjAdminImages&action=pjActionUpdate&id=' + resp.image_id;
									        		$dialogUpdate.dialog('close');
									        	}else{
									        		$('#pjIIgErrorMessage').html(resp.text).parent().show();
									        		setTimeout(function() {
									        			$('#pjIIgErrorMessage').parent().hide();
									        	    }, 3000);
									        	}
									        }
									    }; 
										$frmUpdateHotSpot.ajaxSubmit(ajax_options); 
										return false;
									}
								});
							}
						}).fail(function () {
							
						});
					},
					close: function () {
						$frmUpdateHotSpot.html("");			
					},
					buttons: (function () {
						var buttons = {};
						buttons[iigApp.locale.button.save] = function () {
							$frmUpdateHotSpot.submit();
						};
						buttons[iigApp.locale.button.delete] = function () {
							var hotspot_id = $(this).data("id");
							$.get(["index.php?controller=pjAdminImages&action=pjActionRemoveHotSpot", "&id=", hotspot_id].join("")).done(function (data) {
								$(".rect-selected[data-id='"+ hotspot_id +"']", $("#mapHolder")).remove();
								$dialogUpdate.dialog('close');
							}).fail(function () {
								
							});
						};
						buttons[iigApp.locale.button.cancel] = function () {
							var init = $(this).data("init");
							if(init == 'no')
							{
								$dialogUpdate.dialog('close');
							}else{
								var hotspot_id = $(this).data("id");
								$.get(["index.php?controller=pjAdminImages&action=pjActionRemoveHotSpot", "&id=", hotspot_id].join("")).done(function (data) {
									$(".rect-selected[data-id='"+ hotspot_id +"']", $("#mapHolder")).remove();
									$dialogUpdate.dialog('close');
								}).fail(function () {
									
								});
							}
						};
						
						return buttons;
					})()
				});
			}
		}
		
		function formatThumb(val, obj) {
			return '<a href="index.php?controller=pjAdminImages&action=pjActionUpdate&id='+obj.id+'"><img src="'+val+'"></a>';
		}
		
		if ($("#grid").length > 0 && datagrid) {
			
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminImages&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminImages&action=pjActionDeleteImage&id={:id}"},
						  {type: "preview", url: "preview.php?id={:id}", target: "_blank"},
				          {type: "install", url: "index.php?controller=pjAdminOptions&action=pjActionInstall&id={:id}"}
				          ],
				columns: [{text: myLabel.thumb, type: "text", sortable: true, editable: false, width: 100, renderer: formatThumb},
				          {text: myLabel.title, type: "text", sortable: true, editable: false, width: 250},
				          {text: myLabel.hot_spots, type: "text", sortable: true, editable: false, width: 90, align: "center"},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminImages&action=pjActionGetImage",
				dataType: "json",
				fields: ['thumb_path', 'title', 'hotspots', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminImages&action=pjActionDeleteImageBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminImages&action=pjActionSaveImage&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminImages&action=pjActionGetImage", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminImages&action=pjActionGetImage", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-status-1", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			return false;
		}).on("click", ".pj-status-0", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$.post("index.php?controller=pjAdminImages&action=pjActionSetActive", {
				id: $(this).closest("tr").data("object")['id']
			}).done(function (data) {
				$grid.datagrid("load", "index.php?controller=pjAdminImages&action=pjActionGetImage");
			});
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminImages&action=pjActionGetImage", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-delete-map", function (e) {
			$dialogDel.data('lang', $(this).attr('lang')).dialog('open');
		}).on("change", "input:radio[name='dialog_hotspot_type']", function (e) {
			$('.thumbWrapper').hide();
			$('.boxWrapper').hide();
			$('.iconWrapper').hide();
			$('.thumbWrapper').find('input').removeClass('required');
			$('.boxWrapper').find('input').removeClass('required');
			
			var hotspot_type = $frmUpdateHotSpot.find('input[name="dialog_hotspot_type"]:checked').val();
			$('.'+hotspot_type+'Wrapper').show();
			if(hotspot_type == 'icon')
			{
				$('.iconWrapper').find('input').addClass('required');
			}
			if(hotspot_type == 'thumb')
			{
				$('.thumbWrapper').find('input').addClass('required');
			}
			if(hotspot_type == 'box')
			{
				$('.boxWrapper').find('input').addClass('required');
				if($('.boxWrapper').find('input').val() == '')
				{
					$('.boxWrapper').find('input').val(100);
				}
			}
		}).on("click", ".pjIgIcon", function (e) {
			var icon = $(this).attr('data-icon');
			$('.pjIgIcon').removeClass('active');
			$(this).addClass('active');
			$('.iconWrapper').find('input').val(icon);
		}).on("change", "input:radio[name='use_tooltip']", function (e) {
			var use_tooltip = $frmUpdateHotSpot.find('input[name="use_tooltip"]:checked').val();
			if(use_tooltip == 'T')
			{
				$('.tooltipWrapper').show();
				$('.pjIIgTooltipDefault').addClass("required");
			}else{
				$('.tooltipWrapper').hide();
				$('.pjIIgTooltip').val("");
				$('.pjIIgTooltipDefault').removeClass("required");
			}
		}).on("change", "#data_type", function (e) {
			var value = $(this).val();
			$('.dataWrapper').hide();
			$('.'+value+'Wrapper').show();
			if(value != 'text')
			{
				$('.pjIIgText').val("");
				$('.pjIIgTextDefault').removeClass("required");
			}else{
				$('.pjIIgTextDefault').addClass("required");
			}
		}).on("click", ".deleteImg", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this);
			var id = $this.attr('data-id');
			$('#dialogLoader').show();
			$.get(["index.php?controller=pjAdminImages&action=pjActionDeleteMultiImage", "&id=", id].join("")).done(function (data) {
				$this.parent().remove();
				$('#dialogLoader').hide();
			}).fail(function () {
				
			});
			return false;
		});
	});
})(jQuery_1_8_2);