(function (window, undefined) {
	var d = window.document;
	JABB.Ajax.xhrFields = {
		withCredentials: true
	};
	function registerML(options) {
		if (!(this instanceof registerML)) {
			return new registerML(options);
		}
		this.options = {};
		this.main_container = null;
		this.error_container = null;
		this.message_container = null;
		this.fee_container = null;
		this.payment_container = null;
		this.day = null;
		this.month = null;
		this.year = null;
		this.init(options);
		return this;
	}
	
	registerML.prototype = {
		loadPaymentForm: function(id)
		{
			var self = this,
				frm = d.forms[self.options.registration_form_name];
			JABB.Ajax.sendRequest(self.options.get_payment_form_url + "&id=" + id + (self.options.session_id != "" ? "&session_id=" + self.options.session_id : "") , function (req) {
				self.payment_container.innerHTML = req.responseText;
				var payment_form = d.forms[self.options.paypal_form_name];
				if (typeof payment_form != 'undefined') {
					payment_form.submit();
				} else {
					window.location.href = self.options.thankyou_page;
				}
			});
		},
			
		submitForm: function(post, btn)
		{
			var self = this;
			self.error_container.style.display = "none";
			self.message_container.innerHTML = '<label class="message info">' + self.options.message.info + '</label>';
			JABB.Ajax.postJSON(self.options.registration_url + (self.options.session_id != "" ? "&session_id=" + self.options.session_id : "") , function (json) {
				var code = json.code;
				if(code == '100')
				{	
					self.resetForm();
					if(self.options.thankyou_page != '')
					{
						window.location.href = self.options.thankyou_page;
					}else{
						self.message_container.innerHTML = '<label class="message info">' + self.options.message.success + '</label>';
					}
				}else if(code == '200'){
					self.resetForm();
					self.message_container.innerHTML = '<label class="message info">' + self.options.message.load + '</label>';
					self.loadPaymentForm(json.id);
				}else{
					self.message_container.innerHTML = '<label class="message error">' + self.options.message.error + '</label>';
					btn.disabled = false;
				}
			}, post);
			self.message_container.style.display = "block";
		},
			
		checkCaptcha: function(btn)
		{
			var self = this,
				frm = d.forms[self.options.registration_form_name],
				captcha = frm.captcha.value;
			
			JABB.Ajax.sendRequest(self.options.check_captcha_url + "&captcha=" + captcha + (self.options.session_id != "" ? "&session_id=" + self.options.session_id : "") , function (req) {
				var code = req.responseText;
				if(code == '100')
				{
					self.submitForm(JABB.Utils.serialize(frm), btn);
				}else{
					self.error_container.innerHTML = '<li>' + self.options.validation.error_captcha_incorrect + '</li>';
					self.error_container.style.display = "block";
					btn.disabled = false;
				}
			});
		},
			
		checkEmail: function(btn)
		{
			var self = this,
				frm = d.forms[self.options.registration_form_name],
				email = frm.email.value;
			
			JABB.Ajax.sendRequest(self.options.check_email_url + "&email=" + email + (self.options.session_id != "" ? "&session_id=" + self.options.session_id : "") , function (req) {
				var code = req.responseText;
				if(code == '100')
				{
					self.checkCaptcha(btn);
				}else{
					self.error_container.innerHTML = '<li>' + self.options.validation.error_email_used + '</li>';
					self.error_container.style.display = "block";
					btn.disabled = false;
				}
			});
		},
		resetForm: function()
		{
			var self = this,
				frm = d.forms[self.options.registration_form_name],
				day = frm.day,
				month = frm.month,
				year = frm.year;
			for (var i = 0, len = frm.elements.length; i < len; i++) 
			{
				if(frm.elements[i].getAttribute("name") != 'pjSelect' && frm.elements[i].getAttribute("name") != 'ml_register_form_register')
				{
					frm.elements[i].value = '';
				}
			}
			
		},
		validateForm: function(btn)
		{
			var self = this,
				re = /([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+)/,
				message = "",
				frm = d.forms[self.options.registration_form_name],
				day = frm.day,
				month = frm.month,
				year = frm.year;
			
			for (var i = 0, len = frm.elements.length; i < len; i++) 
			{
				var cls = frm.elements[i].className;
				if (cls.indexOf("ml-required") !== -1 && frm.elements[i].disabled === false) {
					switch (frm.elements[i].nodeName) {
					case "INPUT":
						switch (frm.elements[i].type) {
						case "checkbox":
						case "radio":
							if (!frm.elements[i].checked && frm.elements[i].getAttribute("lang")) {
								message += "<li>" + frm.elements[i].getAttribute("lang") + "</li>"; 
							}
							break;
						default:
							if (frm.elements[i].value.length === 0 && frm.elements[i].getAttribute("lang")) {
								message += "<li>" + frm.elements[i].getAttribute("lang") + "</li>";
							}else{
								if(frm.elements[i].getAttribute("name") == 'birthday')
								{
									if (self.year == null || self.month == null && self.day == null)
									{
										message += '<li>' + self.options.validation.error_birthday_invalid + '</li>';
									}
								}
							}
							break;
						}
						break;
					case "TEXTAREA":
						if (frm.elements[i].value.length === 0 && frm.elements[i].getAttribute("lang")) {						
							message += "<li>" + frm.elements[i].getAttribute("lang") + "</li>";
						}
						break;
					case "SELECT":
						switch (frm.elements[i].type) {
						case 'select-one':
							if (frm.elements[i].value.length === 0 && frm.elements[i].getAttribute("lang")) {
								message += "<li>" + frm.elements[i].getAttribute("lang") + "</li>"; 
							}
							break;
						case 'select-multiple':
							var has = false;
							for (j = frm.elements[i].options.length - 1; j >= 0; j = j - 1) {
								if (frm.elements[i].options[j].selected) {
									has = true;
									break;
								}
							}
							if (!has && frm.elements[i].getAttribute("lang")) {
								message += "<li>" + frm.elements[i].getAttribute("lang") + "</li>";
							}
							break;
						}
						break;
					default:
						break;
					}
				}
				if (cls.indexOf("email") !== -1) {
					if (frm.elements[i].nodeName === "INPUT" && frm.elements[i].value.length > 0 && frm.elements[i].value.match(re) == null) {
						message += "<li>" + self.options.validation.error_email_invalid + "</li>";
					}
				}
			}

			if (message != '') {
				self.error_container.innerHTML = message;
				self.error_container.style.display = "block";
				btn.disabled = false;
			}else{
				self.checkEmail(btn);
			}
		},
		
		loadFee: function()
		{
			var self = this,
				frm = d.forms[self.options.registration_form_name],
				registration_fee_container = d.getElementById("ml_registration_fee"),
				subscription_fee_container = d.getElementById("ml_subscription_fee"),
				social_signup_container = d.getElementById("pjSocialLoginContainer");
			
			var group_id = frm['group_id'].value;
			
			JABB.Ajax.getJSON(self.options.get_fee_url + "&id=" + group_id + (self.options.session_id != "" ? "&session_id=" + self.options.session_id : "") , function (json) {	
				if(json.id != null)
				{
					if(json.registration_fee != '')
					{
						registration_fee_container.innerHTML = json.registration_fee;
						registration_fee_container.parentNode.style.display = "block";
					}else{
						registration_fee_container.parentNode.style.display = "none";
					}
					if(json.subscription_fee != '')
					{
						subscription_fee_container.innerHTML = json.subscription_fee;
						subscription_fee_container.parentNode.style.display = "block";
					}else{
						subscription_fee_container.parentNode.style.display = "none";
					}
					self.fee_container.style.display = "block";
					social_signup_container.style.display = 'block';
				}else{
					self.fee_container.style.display = "none";
					social_signup_container.style.display = 'none';
				}
			});
		},
		
		bindForm: function()
		{
			var self = this,
				frm = d.forms[self.options.registration_form_name],
				day = frm.day,
				month = frm.month,
				year = frm.year,
				group = frm.group_id;
							
			self.fee_container.style.display = "none";
			
			if (frm && frm[self.options.registration_form_register_name]) {
				JABB.Utils.addEvent(frm[self.options.registration_form_register_name], "click", function (event) {
					var $this = this;
					$this.disabled = true;
					self.validateForm($this);
				});
			}
			
			for (var i = 0; i < frm.elements.length; i++) 
			{
				JABB.Utils.addEvent(frm.elements[i], "keypress", function (e) {
					var code = (e.keyCode ? e.keyCode : e.which);
					if(code == 13) 
					{ 
						if (e && e.preventDefault) {
							e.preventDefault();
						}
						var register_button = frm[self.options.registration_form_register_name];
						register_button.disabled = true;
					    self.validateForm(register_button);
					}
				});
			}
			
			if(group)
			{
				group.onchange = function () {
					self.loadFee();
				}
			}
			
			self.loadFee();
			
			var date_arr = JABB.Utils.getElementsByClass("ml-birthday", d.forms[self.options.registration_form_name], "SELECT");
			for (i = 0, len = date_arr.length; i < len; i++) {
				date_arr[i].onchange = function () {
					if(this.getAttribute("name") == 'day')
					{
						self.day = this.value;
					}
					if(this.getAttribute("name") == 'month')
					{
						self.month = this.value;
					}
					if(this.getAttribute("name") == 'year')
					{
						self.year = this.value;
					}
					d.forms[self.options.registration_form_name]['birthday'].value = self.year + '-' + self.month + '-' + self.day;
				};
			}
			if (day && day.value != '')
			{
				self.day = day.value;
			}
			if (month && month.value != '')
			{
				self.month = month.value;
			}
			if (year && year.value != '')
			{
				self.year = year.value;
			}
			
			var captcha_img = d.getElementById('ml_captcha_image');
			captcha_img.onclick = function(e){
				captcha_img.src = self.options.load_captcha_url + Math.floor(Math.random() * (999999 - 1 + 1));
			}
			
			var google_login_url =  d.getElementById('pjMlGoogleLogin');
			if (google_login_url !== null)
			{
				google_login_url.onclick = function(e){
					if (e && e.preventDefault) {
						e.preventDefault();
					}
					var group_id = frm['group_id'].value;
					var $this = this;
					JABB.Ajax.getJSON(self.options.set_group_id_url + "&id=" + group_id + (self.options.session_id != "" ? "&session_id=" + self.options.session_id : "") , function (json) {	
						var href = $this.getAttribute('href');
						window.location = href;
					});
				}
			}
			
			var facebook_login_url =  d.getElementById('pjMlFacebookLogin');
			if (facebook_login_url !== null)
			{
				facebook_login_url.onclick = function(e){
					if (e && e.preventDefault) {
						e.preventDefault();
					}
					var group_id = frm['group_id'].value;
					var $this = this;
					JABB.Ajax.getJSON(self.options.set_group_id_url + "&id=" + group_id + (self.options.session_id != "" ? "&session_id=" + self.options.session_id : "") , function (json) {	
						var href = $this.getAttribute('href');
						window.location = href;
					});
				}
			}
		},
		loadRegisterForm: function()
		{
			var self = this;
			JABB.Ajax.sendRequest(self.options.load_register_form_url + (self.options.session_id != "" ? "&session_id=" + self.options.session_id : "") , function (req) {
				self.main_container.innerHTML = req.responseText;
				var error_container = JABB.Utils.getElementsByClass("ml-register-error-container", d.forms[self.options.registration_form_name], "UL"),
					message_container = JABB.Utils.getElementsByClass("ml-register-message-container", d.forms[self.options.registration_form_name], "P");
				
				self.error_container = error_container[0];
				self.message_container = message_container[0];
				self.fee_container = d.getElementById("ml_fee_container");
				self.payment_container = d.getElementById("ml_payment_container");
				
				self.bindForm();
				
			});
		},
		init: function (registerObj) {
			var self = this;
			self.options = registerObj;
			self.main_container = d.getElementById(self.options.registration_container);
			self.loadRegisterForm();
		}
	}
	return (window.registerML = registerML);
})(window);